/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionFactory;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassAbstractDelegate;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OClassImpl
extends ODocumentWrapperNoClass
implements OClass {
    private static final long serialVersionUID = 1L;
    private static final int NOT_EXISTENT_CLUSTER_ID = -1;
    private int defaultClusterId = -1;
    final OSchemaShared owner;
    private final Map<String, OProperty> properties = new HashMap<String, OProperty>();
    private String name;
    private Class<?> javaClass;
    private int[] clusterIds;
    private OClassImpl superClass;
    private int[] polymorphicClusterIds;
    private List<OClass> baseClasses;
    private float overSize = 0.0f;
    private String shortName;
    private boolean strictMode = false;
    private boolean abstractClass = false;
    private Map<String, String> customFields;
    private OClusterSelectionStrategy clusterSelection;

    protected OClassImpl(OSchemaShared iOwner) {
        this(iOwner, new ODocument());
    }

    protected OClassImpl(OSchemaShared iOwner, String iName, int[] iClusterIds) {
        this(iOwner);
        this.name = iName;
        this.setClusterIds(iClusterIds);
        this.defaultClusterId = iClusterIds[0];
        if (this.defaultClusterId == -1) {
            this.abstractClass = true;
        }
        if (this.abstractClass) {
            this.setPolymorphicClusterIds(new int[0]);
        } else {
            this.setPolymorphicClusterIds(iClusterIds);
        }
        this.clusterSelection = (OClusterSelectionStrategy)this.owner.getClusterSelectionFactory().newInstanceOfDefaultClass();
    }

    protected OClassImpl(OSchemaShared iOwner, ODocument iDocument) {
        this.document = iDocument;
        this.owner = iOwner;
    }

    public static int[] readableClusters(ODatabaseRecord iDatabase, int[] iClusterIds) {
        ArrayList<Integer> listOfReadableIds = new ArrayList<Integer>();
        boolean all = true;
        for (int clusterId : iClusterIds) {
            try {
                String clusterName = iDatabase.getClusterNameById(clusterId);
                iDatabase.checkSecurity("database.cluster", ORole.PERMISSION_READ, (Object)clusterName);
                listOfReadableIds.add(clusterId);
            }
            catch (OSecurityAccessException securityException) {
                all = false;
            }
        }
        if (all) {
            return iClusterIds;
        }
        int[] readableClusterIds = new int[listOfReadableIds.size()];
        int index = 0;
        Iterator iterator = listOfReadableIds.iterator();
        while (iterator.hasNext()) {
            int clusterId;
            clusterId = (Integer)iterator.next();
            readableClusterIds[index++] = clusterId;
        }
        return readableClusterIds;
    }

    @Override
    public OClusterSelectionStrategy getClusterSelection() {
        this.acquireSchemaReadLock();
        try {
            OClusterSelectionStrategy oClusterSelectionStrategy = this.clusterSelection;
            return oClusterSelectionStrategy;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OClass setClusterSelection(OClusterSelectionStrategy clusterSelection) {
        return this.setClusterSelection(clusterSelection.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setClusterSelection(String value) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            String cmd;
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                cmd = String.format("alter class %s clusterselection %s", this.name, value);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                cmd = String.format("alter class %s clusterselection %s", this.name, value);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
                this.setClusterSelectionInternal(value);
            } else {
                this.setClusterSelectionInternal(value);
            }
            OClassImpl oClassImpl = this;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public <T> T newInstance() throws InstantiationException, IllegalAccessException {
        this.acquireSchemaReadLock();
        try {
            if (this.javaClass == null) {
                throw new IllegalArgumentException("Cannot create an instance of class '" + this.name + "' since no Java class was specified");
            }
            Object obj = this.javaClass.newInstance();
            return (T)obj;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public <RET extends ODocumentWrapper> RET reload() {
        return this.owner.reload();
    }

    @Override
    public String getCustom(String iName) {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields == null) {
                String string = null;
                return string;
            }
            String string = this.customFields.get(iName);
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClassImpl setCustom(String name, String value) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            String cmd;
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                cmd = String.format("alter class %s custom %s=%s", this.getName(), name, value);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                cmd = String.format("alter class %s custom %s=%s", this.getName(), name, value);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
                this.setCustomInternal(name, value);
            } else {
                this.setCustomInternal(name, value);
            }
            OClassImpl oClassImpl = this;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    public Map<String, String> getCustomInternal() {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields != null) {
                Map<String, String> map = Collections.unmodifiableMap(this.customFields);
                return map;
            }
            Map<String, String> map = null;
            return map;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void removeCustom(String name) {
        this.setCustom(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCustom() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class %s custom clear", this.getName());
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class %s custom clear", this.getName());
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
                this.clearCustomInternal();
            } else {
                this.clearCustomInternal();
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public Set<String> getCustomKeys() {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields != null) {
                Set<String> set = Collections.unmodifiableSet(this.customFields.keySet());
                return set;
            }
            HashSet<String> hashSet = new HashSet<String>();
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean hasClusterId(int clusterId) {
        return Arrays.binarySearch(this.clusterIds, clusterId) >= 0;
    }

    @Override
    public OClass getSuperClass() {
        this.acquireSchemaReadLock();
        try {
            OClassImpl oClassImpl = this.superClass;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setSuperClass(OClass superClass) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class %s superclass %s", this.name, superClass != null ? superClass.getName() : null);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class %s superclass %s", this.name, superClass != null ? superClass.getName() : null);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setSuperClassInternal(superClass);
            } else {
                this.setSuperClassInternal(superClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    void setSuperClassInternal(OClass superClass) {
        this.acquireSchemaWriteLock();
        try {
            OClassImpl cls = superClass instanceof OClassAbstractDelegate ? (OClassImpl)((OClassAbstractDelegate)superClass).delegate : (OClassImpl)superClass;
            if (cls != null) {
                cls.addBaseClasses(this);
            } else if (this.superClass != null) {
                this.superClass.removeBaseClassInternal(this);
            }
            this.superClass = cls;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public String getName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClass setName(String name) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class %s name %s", this.name, name);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class %s name %s", this.name, name);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setNameInternal(name);
            } else {
                this.setNameInternal(name);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        this.acquireSchemaReadLock();
        try {
            long size = 0L;
            for (int clusterId : this.clusterIds) {
                size += this.getDatabase().getClusterRecordSizeById(clusterId);
            }
            long l = size;
            return l;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String getShortName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.shortName;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setShortName(String shortName) {
        if (shortName != null && (shortName = shortName.trim()).isEmpty()) {
            shortName = null;
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class %s shortname %s", this.name, shortName);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class %s shortname %s", this.name, shortName);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setShortNameInternal(shortName);
            } else {
                this.setShortNameInternal(shortName);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public String getStreamableName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.shortName != null ? this.shortName : this.name;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Collection<OProperty> declaredProperties() {
        this.acquireSchemaReadLock();
        try {
            Collection<OProperty> collection = Collections.unmodifiableCollection(this.properties.values());
            return collection;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OProperty> properties() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_READ);
        this.acquireSchemaReadLock();
        try {
            ArrayList<OProperty> props = null;
            OClassImpl currentClass = this;
            do {
                if (props == null) {
                    props = new ArrayList<OProperty>();
                }
                props.addAll(currentClass.properties.values());
            } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
            ArrayList<OProperty> arrayList = props;
            return arrayList;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OProperty> getIndexedProperties() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_READ);
        this.acquireSchemaReadLock();
        try {
            List indexedProps = null;
            OClassImpl currentClass = this;
            do {
                for (OProperty p : currentClass.properties.values()) {
                    if (!this.areIndexed(p.getName())) continue;
                    if (indexedProps == null) {
                        indexedProps = new ArrayList();
                    }
                    indexedProps.add(p);
                }
            } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
            List list = indexedProps != null ? indexedProps : Collections.emptyList();
            return list;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty getProperty(String propertyName) {
        this.acquireSchemaReadLock();
        try {
            propertyName = propertyName.toLowerCase();
            OClassImpl currentClass = this;
            do {
                OProperty p;
                if ((p = currentClass.properties.get(propertyName)) == null) continue;
                OProperty oProperty = p;
                return oProperty;
            } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
            OProperty oProperty = null;
            return oProperty;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType) {
        return this.addProperty(iPropertyName, iType, null, null);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass) {
        if (iLinkedClass == null) {
            throw new OSchemaException("Missing linked class");
        }
        return this.addProperty(iPropertyName, iType, null, iLinkedClass);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OType iLinkedType) {
        return this.addProperty(iPropertyName, iType, iLinkedType, null);
    }

    @Override
    public boolean existsProperty(String iPropertyName) {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.properties.containsKey(iPropertyName.toLowerCase());
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropProperty(String propertyName) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a property inside a transaction");
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_DELETE);
        String lowerName = propertyName.toLowerCase();
        this.acquireSchemaWriteLock();
        try {
            if (!this.properties.containsKey(lowerName)) {
                throw new OSchemaException("Property '" + propertyName + "' not found in class " + this.name + "'");
            }
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                database.command(new OCommandSQL("drop property " + this.name + '.' + propertyName)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                OCommandSQL commandSQL = new OCommandSQL("drop property " + this.name + '.' + propertyName);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.dropPropertyInternal(propertyName);
            } else {
                this.dropPropertyInternal(propertyName);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public void fromStream() {
        this.baseClasses = null;
        this.superClass = null;
        this.name = (String)this.document.field("name");
        this.shortName = this.document.containsField("shortName") ? (String)this.document.field("shortName") : null;
        this.defaultClusterId = (Integer)this.document.field("defaultClusterId");
        this.strictMode = this.document.containsField("strictMode") ? (Boolean)this.document.field("strictMode") : false;
        this.abstractClass = this.document.containsField("abstract") ? (Boolean)this.document.field("abstract") : false;
        this.overSize = this.document.field("overSize") != null ? ((Float)this.document.field("overSize")).floatValue() : 0.0f;
        Object cc = this.document.field("clusterIds");
        if (cc instanceof Collection) {
            Collection coll = (Collection)this.document.field("clusterIds");
            this.clusterIds = new int[coll.size()];
            int i = 0;
            for (Integer item : coll) {
                this.clusterIds[i++] = item;
            }
        } else {
            this.clusterIds = (int[])cc;
        }
        Arrays.sort(this.clusterIds);
        if (this.clusterIds.length == 1 && this.clusterIds[0] == -1) {
            this.setPolymorphicClusterIds(new int[0]);
        } else {
            this.setPolymorphicClusterIds(this.clusterIds);
        }
        HashMap<String, OPropertyImpl> newProperties = new HashMap<String, OPropertyImpl>();
        Collection storedProperties = (Collection)this.document.field("properties");
        if (storedProperties != null) {
            for (ODocument p : storedProperties) {
                OPropertyImpl prop = new OPropertyImpl(this, p);
                prop.fromStream();
                if (this.properties.containsKey(prop.getName())) {
                    prop = (OPropertyImpl)this.properties.get(prop.getName().toLowerCase());
                    prop.fromStream(p);
                }
                newProperties.put(prop.getName().toLowerCase(), prop);
            }
        }
        this.properties.clear();
        this.properties.putAll(newProperties);
        this.customFields = (Map)this.document.field("customFields", OType.EMBEDDEDMAP);
        this.clusterSelection = this.owner.getClusterSelectionFactory().getStrategy((String)this.document.field("clusterSelection"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OBeforeSerialization
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("name", this.name);
            this.document.field("shortName", this.shortName);
            this.document.field("defaultClusterId", this.defaultClusterId);
            this.document.field("clusterIds", this.clusterIds);
            this.document.field("clusterSelection", this.clusterSelection.getName());
            this.document.field("overSize", Float.valueOf(this.overSize));
            this.document.field("strictMode", this.strictMode);
            this.document.field("abstract", this.abstractClass);
            LinkedHashSet<ODocument> props = new LinkedHashSet<ODocument>();
            for (OProperty p : this.properties.values()) {
                props.add(((OPropertyImpl)p).toStream());
            }
            this.document.field("properties", props, OType.EMBEDDEDSET);
            this.document.field("superClass", this.superClass != null ? this.superClass.getName() : null);
            this.document.field("customFields", this.customFields != null && this.customFields.size() > 0 ? this.customFields : null, OType.EMBEDDEDMAP);
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.document;
    }

    @Override
    public Class<?> getJavaClass() {
        this.acquireSchemaReadLock();
        try {
            Class<?> clazz = this.javaClass;
            return clazz;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int getClusterForNewInstance() {
        this.acquireSchemaReadLock();
        try {
            int n = this.clusterSelection.getCluster(this);
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int getDefaultClusterId() {
        this.acquireSchemaReadLock();
        try {
            int n = this.defaultClusterId;
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.defaultClusterId = defaultClusterId;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public int[] getClusterIds() {
        this.acquireSchemaReadLock();
        try {
            int[] nArray = this.clusterIds;
            return nArray;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int[] getPolymorphicClusterIds() {
        this.acquireSchemaReadLock();
        try {
            int[] nArray = this.polymorphicClusterIds;
            return nArray;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    private void setPolymorphicClusterIds(int[] iClusterIds) {
        this.polymorphicClusterIds = iClusterIds;
        Arrays.sort(this.polymorphicClusterIds);
    }

    public void renameProperty(String iOldName, String iNewName) {
        OProperty p = this.properties.remove(iOldName);
        if (p != null) {
            this.properties.put(iNewName, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass addClusterId(int clusterId) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class %s addcluster %d", this.name, clusterId);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class %s addcluster %d", this.name, clusterId);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.addClusterIdInternal(clusterId);
            } else {
                this.addClusterIdInternal(clusterId);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass addCluster(String clusterNameOrId) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class %s addcluster %s", this.name, clusterNameOrId);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class %s addcluster %s", this.name, clusterNameOrId);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                int clusterId = this.createClusterIfNeeded(clusterNameOrId);
                this.addClusterIdInternal(clusterId);
            } else {
                int clusterId = this.createClusterIfNeeded(clusterNameOrId);
                this.addClusterIdInternal(clusterId);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass addCluster(String clusterName, OStorage.CLUSTER_TYPE iClusterType) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class %s addcluster %s %s", new Object[]{this.name, clusterName, iClusterType});
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class %s addcluster %s %s", new Object[]{this.name, clusterName, iClusterType});
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                int clusterId = database.getClusterIdByName(clusterName);
                this.addClusterIdInternal(clusterId);
            } else {
                int clusterId = database.getClusterIdByName(clusterName);
                this.addClusterIdInternal(clusterId);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass removeClusterId(int clusterId) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class %s removecluster %d", this.name, clusterId);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class %s removecluster %d", this.name, clusterId);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.removeClusterIdInternal(clusterId);
            } else {
                this.removeClusterIdInternal(clusterId);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public Collection<OClass> getBaseClasses() {
        this.acquireSchemaReadLock();
        try {
            if (this.baseClasses == null || this.baseClasses.size() == 0) {
                List<OClass> list = Collections.emptyList();
                return list;
            }
            Collection<OClass> collection = Collections.unmodifiableCollection(this.baseClasses);
            return collection;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OClass> getAllBaseClasses() {
        this.acquireSchemaReadLock();
        try {
            HashSet<OClass> set = new HashSet<OClass>();
            if (this.baseClasses != null) {
                set.addAll(this.baseClasses);
                for (OClass c : this.baseClasses) {
                    set.addAll(c.getAllBaseClasses());
                }
            }
            HashSet<OClass> hashSet = set;
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    OClass removeBaseClassInternal(OClass baseClass) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.baseClasses == null) {
                OClassImpl oClassImpl = this;
                return oClassImpl;
            }
            if (this.baseClasses.remove(baseClass)) {
                this.removePolymorphicClusterIds((OClassImpl)baseClass);
            }
            OClassImpl oClassImpl = this;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public float getOverSize() {
        this.acquireSchemaReadLock();
        try {
            if (this.overSize > 0.0f) {
                float f = this.overSize;
                return f;
            }
            if (this.superClass != null) {
                float f = this.superClass.getOverSize();
                return f;
            }
            float f = 0.0f;
            return f;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setOverSize(float overSize) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class %s oversize %s", this.name, new Float(overSize).toString());
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class %s oversize %s", this.name, new Float(overSize).toString());
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setOverSizeInternal(overSize);
            } else {
                this.setOverSizeInternal(overSize);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    public float getOverSizeInternal() {
        this.acquireSchemaReadLock();
        try {
            float f = this.overSize;
            return f;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    private void setOverSizeInternal(float overSize) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.overSize = overSize;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public boolean isAbstract() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.abstractClass;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setAbstract(boolean isAbstract) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class %s abstract %s", this.name, isAbstract);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class %s abstract %s", this.name, isAbstract);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
                this.setAbstractInternal(isAbstract);
            } else {
                this.setAbstractInternal(isAbstract);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public boolean isStrictMode() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.strictMode;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setStrictMode(boolean isStrict) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class %s strictmode %s", this.name, isStrict);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class %s strictmode %s", this.name, isStrict);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setStrictModeInternal(isStrict);
            } else {
                this.setStrictModeInternal(isStrict);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public String toString() {
        this.acquireSchemaReadLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        this.acquireSchemaReadLock();
        try {
            int prime = 31;
            int result = super.hashCode();
            int n = result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        this.acquireSchemaReadLock();
        try {
            if (this == obj) {
                boolean bl = true;
                return bl;
            }
            if (obj == null) {
                boolean bl = false;
                return bl;
            }
            if (!OClass.class.isAssignableFrom(obj.getClass())) {
                boolean bl = false;
                return bl;
            }
            OClass other = (OClass)obj;
            if (this.name == null) {
                if (other.getName() != null) {
                    boolean bl = false;
                    return bl;
                }
            } else if (!this.name.equals(other.getName())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int compareTo(OClass o) {
        this.acquireSchemaReadLock();
        try {
            int n = this.name.compareTo(o.getName());
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public long count() {
        return this.count(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(boolean isPolymorphic) {
        this.acquireSchemaReadLock();
        try {
            if (isPolymorphic) {
                long l = this.getDatabase().countClusterElements(OClassImpl.readableClusters(this.getDatabase(), this.polymorphicClusterIds));
                return l;
            }
            long l = this.getDatabase().countClusterElements(OClassImpl.readableClusters(this.getDatabase(), this.clusterIds));
            return l;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate() throws IOException {
        this.getDatabase().checkSecurity("database.class", ORole.PERMISSION_UPDATE);
        if (this.isSubClassOf("ORestricted")) {
            throw new OSecurityException("Class " + this.getName() + " cannot be truncated because has record level security enabled (extends " + "ORestricted" + ")");
        }
        this.acquireSchemaReadLock();
        try {
            for (int id : this.clusterIds) {
                OStorage storage = this.getDatabase().getStorage();
                storage.getClusterById(id).truncate();
                storage.getLevel2Cache().freeCluster(id);
            }
            Object object = this.getClassIndexes().iterator();
            while (object.hasNext()) {
                OIndex index = (OIndex)object.next();
                index.clear();
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubClassOf(String iClassName) {
        this.acquireSchemaReadLock();
        try {
            if (iClassName == null) {
                boolean bl = false;
                return bl;
            }
            OClass cls = this;
            do {
                if (!iClassName.equalsIgnoreCase(cls.getName()) && !iClassName.equalsIgnoreCase(cls.getShortName())) continue;
                boolean bl = true;
                return bl;
            } while ((cls = cls.getSuperClass()) != null);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubClassOf(OClass clazz) {
        this.acquireSchemaReadLock();
        try {
            if (clazz == null) {
                boolean bl = false;
                return bl;
            }
            for (OClass cls = this; cls != null; cls = cls.getSuperClass()) {
                if (!((Object)cls).equals(clazz)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean isSuperClassOf(OClass clazz) {
        return clazz != null && clazz.isSubClassOf(this);
    }

    @Override
    public Object get(OClass.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case NAME: {
                return this.getName();
            }
            case SHORTNAME: {
                return this.getShortName();
            }
            case SUPERCLASS: {
                return this.getSuperClass();
            }
            case OVERSIZE: {
                return Float.valueOf(this.getOverSize());
            }
            case STRICTMODE: {
                return this.isStrictMode();
            }
            case ABSTRACT: {
                return this.isAbstract();
            }
            case CLUSTERSELECTION: {
                return this.getClusterSelection();
            }
            case CUSTOM: {
                return this.getCustomInternal();
            }
        }
        throw new IllegalArgumentException("Cannot find attribute '" + (Object)((Object)iAttribute) + "'");
    }

    @Override
    public OClass set(OClass.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        boolean isNull = stringValue == null || stringValue.equalsIgnoreCase("NULL");
        switch (attribute) {
            case NAME: {
                this.setName(stringValue);
                break;
            }
            case SHORTNAME: {
                this.setShortName(stringValue);
                break;
            }
            case SUPERCLASS: {
                this.setSuperClass(this.getDatabase().getMetadata().getSchema().getClass(stringValue));
                break;
            }
            case OVERSIZE: {
                this.setOverSize(Float.parseFloat(stringValue));
                break;
            }
            case STRICTMODE: {
                this.setStrictMode(Boolean.parseBoolean(stringValue));
                break;
            }
            case ABSTRACT: {
                this.setAbstract(Boolean.parseBoolean(stringValue));
                break;
            }
            case ADDCLUSTER: {
                this.addCluster(stringValue);
                break;
            }
            case REMOVECLUSTER: {
                int clId = this.getClusterId(stringValue);
                if (clId == -1) {
                    throw new IllegalArgumentException("Cluster id '" + stringValue + "' cannot be removed");
                }
                this.removeClusterId(clId);
                break;
            }
            case CLUSTERSELECTION: {
                this.setClusterSelection(stringValue);
                break;
            }
            case CUSTOM: {
                if (isNull || stringValue.equalsIgnoreCase("clear")) {
                    this.clearCustom();
                    break;
                }
                if (stringValue.contains("=")) {
                    List<String> words = OStringSerializerHelper.smartSplit(iValue.toString(), '=', new char[0]);
                    this.setCustom(words.get(0).trim(), words.get(1).trim());
                    break;
                }
                throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl addPropertyInternal(String name, OType type, OType linkedType, OClass linkedClass) {
        if (name == null || name.length() == 0) {
            throw new OSchemaException("Found property name null");
        }
        Character wrongCharacter = OSchemaShared.checkNameIfValid(name);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid property name found. Character '" + wrongCharacter + "' cannot be used in property name.");
        }
        String lowerName = name.toLowerCase();
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.properties.containsKey(lowerName)) {
                throw new OSchemaException("Class " + this.name + " already has property '" + name + "'");
            }
            OPropertyImpl prop = new OPropertyImpl(this, name, type);
            this.properties.put(lowerName, prop);
            if (linkedType != null) {
                prop.setLinkedTypeInternal(linkedType);
            } else if (linkedClass != null) {
                prop.setLinkedClassInternal(linkedClass);
            }
            OPropertyImpl oPropertyImpl = prop;
            return oPropertyImpl;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, String ... fields) {
        return this.createIndex(iName, iType.name(), fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, String ... fields) {
        return this.createIndex(iName, iType, (OProgressListener)null, (ODocument)null, fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, OProgressListener iProgressListener, String ... fields) {
        return this.createIndex(iName, iType.name(), iProgressListener, null, fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OProgressListener iProgressListener, ODocument metadata, String ... fields) {
        return this.createIndex(iName, iType, iProgressListener, metadata, (String)null, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndex<?> createIndex(String name, String type, OProgressListener progressListener, ODocument metadata, String algorithm, String ... fields) {
        if (type == null) {
            throw new IllegalArgumentException("Index type is null");
        }
        type = type.toUpperCase();
        if (fields.length == 0) {
            throw new OIndexException("List of fields to index cannot be empty.");
        }
        this.acquireSchemaReadLock();
        try {
            HashSet<String> existingFieldNames = new HashSet<String>();
            OClassImpl currentClass = this;
            do {
                existingFieldNames.addAll(currentClass.properties.keySet());
            } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
            for (String fieldToIndex : fields) {
                String fieldName = OIndexDefinitionFactory.extractFieldName(fieldToIndex);
                if (fieldName.equals("@rid") || existingFieldNames.contains(fieldName.toLowerCase())) continue;
                throw new OIndexException("Index with name : '" + name + "' cannot be created on class : '" + this.name + "' because field: '" + fieldName + "' is absent in class definition.");
            }
            OIndexDefinition indexDefinition = OIndexDefinitionFactory.createIndexDefinition(this, Arrays.asList(fields), this.extractFieldTypes(fields), null);
            OIndex<?> oIndex = this.getDatabase().getMetadata().getIndexManager().createIndex(name, type, indexDefinition, this.polymorphicClusterIds, progressListener, metadata, algorithm);
            return oIndex;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean areIndexed(String ... fields) {
        return this.areIndexed(Arrays.asList(fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areIndexed(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        this.acquireSchemaReadLock();
        try {
            boolean currentClassResult = indexManager.areIndexed(this.name, fields);
            if (this.superClass != null) {
                boolean bl = currentClassResult || this.superClass.areIndexed(fields);
                return bl;
            }
            boolean bl = currentClassResult;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getInvolvedIndexes(String ... fields) {
        return this.getInvolvedIndexes(Arrays.asList(fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIndex<?>> getInvolvedIndexes(Collection<String> fields) {
        this.acquireSchemaReadLock();
        try {
            HashSet result = new HashSet(this.getClassInvolvedIndexes(fields));
            if (this.superClass != null) {
                result.addAll(this.superClass.getInvolvedIndexes(fields));
            }
            HashSet hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        this.acquireSchemaReadLock();
        try {
            Set<OIndex<?>> set = indexManager.getClassInvolvedIndexes(this.name, fields);
            return set;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String ... fields) {
        return this.getClassInvolvedIndexes(Arrays.asList(fields));
    }

    @Override
    public OIndex<?> getClassIndex(String name) {
        this.acquireSchemaReadLock();
        try {
            OIndex<?> oIndex = this.getDatabase().getMetadata().getIndexManager().getClassIndex(this.name, name);
            return oIndex;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getClassIndexes() {
        this.acquireSchemaReadLock();
        try {
            Set<OIndex<?>> set = this.getDatabase().getMetadata().getIndexManager().getClassIndexes(this.name);
            return set;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void getClassIndexes(Collection<OIndex<?>> indexes) {
        this.acquireSchemaReadLock();
        try {
            this.getDatabase().getMetadata().getIndexManager().getClassIndexes(this.name, indexes);
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getIndexes() {
        this.acquireSchemaReadLock();
        try {
            Set<OIndex<?>> indexes = this.getClassIndexes();
            for (OClass s = this.superClass; s != null; s = s.getSuperClass()) {
                s.getClassIndexes(indexes);
            }
            Set<OIndex<?>> set = indexes;
            return set;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public void acquireSchemaReadLock() {
        this.owner.acquireSchemaReadLock();
    }

    public void releaseSchemaReadLock() {
        this.owner.releaseSchemaReadLock();
    }

    public void acquireSchemaWriteLock() {
        this.owner.acquireSchemaWriteLock();
    }

    public void releaseSchemaWriteLock() {
        this.owner.releaseSchemaWriteLock();
    }

    public void checkEmbedded() {
        if (!(this.getDatabase().getStorage().getUnderlying() instanceof OStorageEmbedded)) {
            throw new OSchemaException("'Internal' schema modification methods can be used only inside of embedded database");
        }
    }

    private void setClusterSelectionInternal(String clusterSelection) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.clusterSelection = (OClusterSelectionStrategy)this.owner.getClusterSelectionFactory().newInstance(clusterSelection);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setCustomInternal(String name, String value) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.customFields == null) {
                this.customFields = new HashMap<String, String>();
            }
            if (value == null || "null".equalsIgnoreCase(value)) {
                this.customFields.remove(name);
            } else {
                this.customFields.put(name, value);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void clearCustomInternal() {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.customFields = null;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNameInternal(String name) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            String oldName = this.name;
            this.owner.changeClassName(this.name, name, this);
            this.name = name;
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (!database.getStorageVersions().classesAreDetectedByClusterId()) {
                for (int clusterId : this.clusterIds) {
                    OClusterPosition[] range = storage.getClusterDataRange(clusterId);
                    OPhysicalPosition[] positions = storage.ceilingPhysicalPositions(clusterId, new OPhysicalPosition(range[0]));
                    do {
                        for (OPhysicalPosition position : positions) {
                            ORecordSerializerSchemaAware2CSV serializer;
                            ORecordId identity = new ORecordId(clusterId, position.clusterPosition);
                            ORawBuffer record = storage.readRecord(identity, null, true, null, false, OStorage.LOCKING_STRATEGY.DEFAULT).getResult();
                            if (record.recordType == 100 && (serializer = (ORecordSerializerSchemaAware2CSV)ORecordSerializerFactory.instance().getFormat("ORecordDocument2csv")).getClassName(OBinaryProtocol.bytes2string(record.buffer)).equalsIgnoreCase(name)) {
                                ODocument document = new ODocument();
                                document.setLazyLoad(false);
                                document.fromStream(record.buffer);
                                document.getRecordVersion().copyFrom(record.version);
                                document.setIdentity(identity);
                                document.setClassName(name);
                                document.setDirty();
                                document.save();
                            }
                            if (positions.length <= 0) continue;
                            positions = storage.higherPhysicalPositions(clusterId, positions[positions.length - 1]);
                        }
                    } while (positions.length > 0);
                }
            }
            this.renameCluster(oldName, this.name);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void renameCluster(String oldName, String newName) {
        ODatabaseRecord database = this.getDatabase();
        if (this.checkClusterRenameOk(database.getStorage().getClusterIdByName(newName), newName)) {
            database.command(new OCommandSQL("alter cluster " + oldName + " name " + newName)).execute(new Object[0]);
        }
    }

    private boolean checkClusterRenameOk(int clusterId, String newName) {
        for (OClass clazz : this.owner.getClasses()) {
            if (clazz.getName().equals(newName) || clazz.getDefaultClusterId() != clusterId && !clazz.hasClusterId(clusterId)) continue;
            return false;
        }
        return true;
    }

    private void setShortNameInternal(String iShortName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            String oldName = null;
            if (this.shortName != null) {
                oldName = this.shortName.toLowerCase();
            }
            this.shortName = iShortName;
            this.owner.changeClassName(oldName, this.shortName, this);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void dropPropertyInternal(String iPropertyName) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a property inside a transaction");
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_DELETE);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            OProperty prop = this.properties.remove(iPropertyName.toLowerCase());
            if (prop == null) {
                throw new OSchemaException("Property '" + iPropertyName + "' not found in class " + this.name + "'");
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private int createClusterIfNeeded(String nameOrId) {
        String[] parts = nameOrId.split(" ");
        int clId = this.getClusterId(parts[0]);
        if (clId == -1) {
            try {
                clId = Integer.parseInt(parts[0]);
                throw new IllegalArgumentException("Cluster id '" + clId + "' cannot be added");
            }
            catch (NumberFormatException e) {
                if (parts.length == 1) {
                    parts = new String[]{parts[0], this.getDatabase().getURL().startsWith("memory".toLowerCase()) ? OStorage.CLUSTER_TYPE.MEMORY.toString() : OStorage.CLUSTER_TYPE.PHYSICAL.toString()};
                }
                clId = this.getDatabase().addCluster(parts[0], OStorage.CLUSTER_TYPE.valueOf(parts[1]), new Object[0]);
            }
        }
        return clId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OClass addClusterIdInternal(int clusterId) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.owner.checkClusterCanBeAdded(clusterId, this);
            for (int currId : this.clusterIds) {
                if (currId != clusterId) continue;
                OClassImpl oClassImpl = this;
                return oClassImpl;
            }
            this.clusterIds = OArrays.copyOf((int[])this.clusterIds, (int)(this.clusterIds.length + 1));
            this.clusterIds[this.clusterIds.length - 1] = clusterId;
            Arrays.sort(this.clusterIds);
            this.addPolymorphicClusterId(clusterId);
            if (this.defaultClusterId == -1) {
                this.defaultClusterId = clusterId;
            }
            this.owner.addClusterForClass(clusterId, this);
            OClassImpl oClassImpl = this;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void addPolymorphicClusterId(int clusterId) {
        if (Arrays.binarySearch(this.polymorphicClusterIds, clusterId) >= 0) {
            return;
        }
        this.polymorphicClusterIds = OArrays.copyOf((int[])this.polymorphicClusterIds, (int)(this.polymorphicClusterIds.length + 1));
        this.polymorphicClusterIds[this.polymorphicClusterIds.length - 1] = clusterId;
        Arrays.sort(this.polymorphicClusterIds);
        this.addClusterIdToIndexes(clusterId);
        if (this.superClass != null) {
            this.superClass.addPolymorphicClusterId(clusterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OClass removeClusterIdInternal(int clusterToRemove) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            boolean found = false;
            for (int clusterId : this.clusterIds) {
                if (clusterId != clusterToRemove) continue;
                found = true;
                break;
            }
            if (found) {
                int[] newClusterIds = new int[this.clusterIds.length - 1];
                int k = 0;
                for (int i = 0; i < this.clusterIds.length; ++i) {
                    if (this.clusterIds[i] == clusterToRemove) continue;
                    newClusterIds[k] = this.clusterIds[i];
                    ++k;
                }
                this.clusterIds = newClusterIds;
                this.removePolymorphicClusterId(clusterToRemove);
            }
            if (this.defaultClusterId == clusterToRemove) {
                this.defaultClusterId = -1;
            }
            this.owner.removeClusterForClass(clusterToRemove, this);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAbstractInternal(boolean isAbstract) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            if (isAbstract) {
                if (this.defaultClusterId != -1) {
                    if (this.count() > 0L) {
                        throw new IllegalStateException("Cannot set the class as abstract because contains records.");
                    }
                    this.tryDropCluster(this.defaultClusterId);
                    for (int clusterId : this.getClusterIds()) {
                        this.tryDropCluster(clusterId);
                        this.removePolymorphicClusterId(clusterId);
                        this.owner.removeClusterForClass(clusterId, this);
                    }
                    this.setClusterIds(new int[]{-1});
                    this.defaultClusterId = -1;
                }
            } else {
                if (!this.abstractClass) {
                    return;
                }
                int clusterId = this.getDatabase().getClusterIdByName(this.name);
                if (clusterId == -1) {
                    clusterId = this.getDatabase().addCluster(this.name, OStorage.CLUSTER_TYPE.PHYSICAL, new Object[0]);
                }
                this.clusterIds[0] = this.defaultClusterId = clusterId;
            }
            this.abstractClass = isAbstract;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setStrictModeInternal(boolean iStrict) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.strictMode = iStrict;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OProperty addProperty(String propertyName, OType type, OType linkedType, OClass linkedClass) {
        if (type == null) {
            throw new OSchemaException("Property type not defined.");
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new OSchemaException("Property name is null or empty");
        }
        if (Character.isDigit(propertyName.charAt(0))) {
            throw new OSchemaException("Found invalid property name. Cannot start with numbers");
        }
        if (this.getDatabase().getTransaction().isActive()) {
            throw new OSchemaException("Cannot create a new property inside a transaction");
        }
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.acquireSchemaWriteLock();
        try {
            StringBuilder cmd = new StringBuilder("create property ");
            cmd.append(this.name);
            cmd.append('.');
            cmd.append(propertyName);
            cmd.append(' ');
            cmd.append(type.name);
            if (linkedType != null) {
                cmd.append(' ');
                cmd.append(linkedType.name);
            } else if (linkedClass != null) {
                cmd.append(' ');
                cmd.append(linkedClass.getName());
            }
            ODatabaseRecord database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                database.command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
                this.reload();
                OProperty oProperty = this.getProperty(propertyName);
                return oProperty;
            }
            if (this.isDistributedCommand()) {
                OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                OPropertyImpl oPropertyImpl = this.addPropertyInternal(propertyName, type, linkedType, linkedClass);
                return oPropertyImpl;
            }
            OPropertyImpl oPropertyImpl = this.addPropertyInternal(propertyName, type, linkedType, linkedClass);
            return oPropertyImpl;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private int getClusterId(String stringValue) {
        int clId;
        try {
            clId = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            clId = this.getDatabase().getClusterIdByName(stringValue);
        }
        return clId;
    }

    private void addClusterIdToIndexes(int iId) {
        if (this.getDatabase().getStorage().getUnderlying() instanceof OStorageEmbedded) {
            String clusterName = this.getDatabase().getClusterNameById(iId);
            ArrayList<String> indexesToAdd = new ArrayList<String>();
            for (OIndex<?> index : this.getIndexes()) {
                indexesToAdd.add(index.getName());
            }
            OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
            for (String indexName : indexesToAdd) {
                indexManager.addClusterToIndex(clusterName, indexName);
            }
        }
    }

    private OClass addBaseClasses(OClass iBaseClass) {
        if (this.baseClasses == null) {
            this.baseClasses = new ArrayList<OClass>();
        }
        if (this.baseClasses.contains(iBaseClass)) {
            return this;
        }
        this.baseClasses.add(iBaseClass);
        for (OClassImpl currentClass = this; currentClass != null; currentClass = (OClassImpl)currentClass.getSuperClass()) {
            currentClass.addPolymorphicClusterIds((OClassImpl)iBaseClass);
        }
        return this;
    }

    private void removePolymorphicClusterIds(OClassImpl iBaseClass) {
        for (int clusterId : iBaseClass.polymorphicClusterIds) {
            this.removePolymorphicClusterId(clusterId);
        }
    }

    private void removePolymorphicClusterId(int clusterId) {
        int index = Arrays.binarySearch(this.polymorphicClusterIds, clusterId);
        if (index == -1) {
            return;
        }
        if (index < this.polymorphicClusterIds.length - 1) {
            System.arraycopy(this.polymorphicClusterIds, index + 1, this.polymorphicClusterIds, index, this.polymorphicClusterIds.length - (index + 1));
        }
        this.polymorphicClusterIds = Arrays.copyOf(this.polymorphicClusterIds, this.polymorphicClusterIds.length - 1);
        this.removeClusterFromIndexes(clusterId);
        if (this.superClass != null) {
            this.superClass.removePolymorphicClusterId(clusterId);
        }
    }

    private void removeClusterFromIndexes(int iId) {
        if (this.getDatabase().getStorage().getUnderlying() instanceof OStorageEmbedded) {
            String clusterName = this.getDatabase().getClusterNameById(iId);
            ArrayList<String> indexesToRemove = new ArrayList<String>();
            for (OIndex<?> index : this.getIndexes()) {
                indexesToRemove.add(index.getName());
            }
            OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
            for (String indexName : indexesToRemove) {
                indexManager.removeClusterFromIndex(clusterName, indexName);
            }
        }
    }

    private void tryDropCluster(int defaultClusterId) {
        if (this.name.toLowerCase().equals(this.getDatabase().getClusterNameById(defaultClusterId)) && this.getDatabase().getClusterRecordSizeById(defaultClusterId) == 0L) {
            this.getDatabase().dropCluster(defaultClusterId, true);
        }
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private void addPolymorphicClusterIds(OClassImpl iBaseClass) {
        for (int i : iBaseClass.polymorphicClusterIds) {
            boolean found = false;
            for (int k : this.polymorphicClusterIds) {
                if (i != k) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.polymorphicClusterIds = OArrays.copyOf((int[])this.polymorphicClusterIds, (int)(this.polymorphicClusterIds.length + 1));
            this.polymorphicClusterIds[this.polymorphicClusterIds.length - 1] = i;
            Arrays.sort(this.polymorphicClusterIds);
        }
    }

    private List<OType> extractFieldTypes(String[] fieldNames) {
        ArrayList<OType> types = new ArrayList<OType>(fieldNames.length);
        for (String fieldName : fieldNames) {
            if (!fieldName.equals("@rid")) {
                types.add(this.getProperty(OIndexDefinitionFactory.extractFieldName(fieldName).toLowerCase()).getType());
                continue;
            }
            types.add(OType.LINK);
        }
        return types;
    }

    private OClass setClusterIds(int[] iClusterIds) {
        this.clusterIds = iClusterIds;
        Arrays.sort(this.clusterIds);
        return this;
    }

    private boolean isDistributedCommand() {
        return this.getDatabase().getStorage() instanceof OAutoshardedStorage && OScenarioThreadLocal.INSTANCE.get() != OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED;
    }
}

