/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.memory;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfilerMBean;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.WeakHashMap;

public class OMemoryWatchDog
extends Thread {
    public static final int CHECK_TIMEOUT = 3000;
    private static long lastGC = 0L;
    protected final ReferenceQueue<Object> monitorQueue = new ReferenceQueue();
    protected SoftReference<Object> monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);
    protected final MemoryMXBean memBean;
    private final Map<ListenerWrapper, Object> listeners = new WeakHashMap<ListenerWrapper, Object>(128);
    private int alertTimes = 0;
    private long autoFreeHeapThreshold;

    public OMemoryWatchDog() {
        super("OrientDB MemoryWatchDog");
        this.memBean = ManagementFactory.getMemoryMXBean();
        String size = OGlobalConfiguration.MEMORY_AUTOFREE_HEAP_THRESHOLD.getValueAsString();
        this.autoFreeHeapThreshold = OFileUtils.getSizeAsNumber((Object)size);
        this.setDaemon(true);
        this.start();
    }

    public static void freeMemoryForOptimization(long iDelayTime) {
        OMemoryWatchDog.freeMemory(iDelayTime, OGlobalConfiguration.JVM_GC_DELAY_FOR_OPTIMIZE.getValueAsLong());
    }

    public static void freeMemoryForResourceCleanup(long iDelayTime) {
        OMemoryWatchDog.freeMemory(iDelayTime, 0L);
    }

    private static void freeMemory(long iDelayTime, long minimalTimeAmount) {
        long dateLastGC = System.currentTimeMillis();
        if (dateLastGC - lastGC > minimalTimeAmount * 1000L) {
            lastGC = dateLastGC;
            System.gc();
            if (iDelayTime > 0L) {
                try {
                    Thread.sleep(iDelayTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Orient.instance().getProfiler().registerHookValue("system.memory.alerts", "Number of alerts received by JVM to free memory resources", OProfilerMBean.METRIC_TYPE.COUNTER, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OMemoryWatchDog.this.alertTimes;
            }
        });
        Orient.instance().getProfiler().registerHookValue("system.memory.lastGC", "Date of last System.gc() invocation", OProfilerMBean.METRIC_TYPE.STAT, new OAbstractProfiler.OProfilerHookValue(){

            public Object getValue() {
                return lastGC;
            }
        });
        long autoFreeCheckEveryMs = OGlobalConfiguration.MEMORY_AUTOFREE_CHECK_EVERY.getValueAsLong();
        Orient.instance().getTimer().schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MemoryUsage heapMemory = OMemoryWatchDog.this.memBean.getHeapMemoryUsage();
                long usedHeap = heapMemory.getUsed();
                long maxHeap = heapMemory.getMax();
                int usedMemoryPer = (int)(usedHeap * 100L / maxHeap);
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Checking if memory is lower than configured (%s): used %s of %s (%d%%)", new Object[]{OFileUtils.getSizeAsString((long)OMemoryWatchDog.this.autoFreeHeapThreshold), OFileUtils.getSizeAsString((long)usedHeap), OFileUtils.getSizeAsString((long)maxHeap), usedMemoryPer});
                }
                if (!OMemoryWatchDog.this.isMemoryAvailable()) {
                    Map map = OMemoryWatchDog.this.listeners;
                    synchronized (map) {
                        for (ListenerWrapper listener : OMemoryWatchDog.this.listeners.keySet()) {
                            try {
                                listener.listener.lowMemory(maxHeap - usedHeap, 100 - usedMemoryPer);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }, autoFreeCheckEveryMs, autoFreeCheckEveryMs);
        while (true) {
            try {
                Reference<Object> res = this.monitorQueue.remove(3000L);
                if (Thread.interrupted()) break;
                if (res == null) continue;
                ++this.alertTimes;
                MemoryUsage heapMemory = this.memBean.getHeapMemoryUsage();
                long usedHeap = heapMemory.getUsed();
                long maxHeap = heapMemory.getMax();
                int usedMemoryPer = (int)(usedHeap * 100L / maxHeap);
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Free memory is low %s of %s (%d%%), calling listeners to free memory...", new Object[]{OFileUtils.getSizeAsString((long)(maxHeap - usedHeap)), OFileUtils.getSizeAsString((long)maxHeap), 100 - usedMemoryPer});
                }
                long timer = Orient.instance().getProfiler().startChrono();
                Map<ListenerWrapper, Object> map = this.listeners;
                synchronized (map) {
                    for (ListenerWrapper listener : this.listeners.keySet()) {
                        try {
                            listener.listener.lowMemory(maxHeap - usedHeap, 100 - usedMemoryPer);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                Orient.instance().getProfiler().stopChrono("OMemoryWatchDog.freeResources", "WatchDog free resources", timer);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception exception) {}
            continue;
            finally {
                this.monitorRef = new SoftReference<Object>(new Object(), this.monitorQueue);
                continue;
            }
            break;
        }
        OLogManager.instance().debug((Object)this, "[OMemoryWatchDog] shutdowning...", new Object[0]);
        Map<ListenerWrapper, Object> map = this.listeners;
        synchronized (map) {
            this.listeners.clear();
        }
        this.monitorRef = null;
    }

    public boolean isMemoryAvailable() {
        if (this.autoFreeHeapThreshold > 0L) {
            return this.getUsedHeapMemory() < this.autoFreeHeapThreshold;
        }
        return (long)this.getUsedHeapMemoryInPercentage() < this.autoFreeHeapThreshold * -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Listener addListener(Listener listener) {
        ListenerWrapper wrapper = new ListenerWrapper(listener);
        Map<ListenerWrapper, Object> map = this.listeners;
        synchronized (map) {
            this.listeners.put(wrapper, listener);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(Listener listener) {
        Map<ListenerWrapper, Object> map = this.listeners;
        synchronized (map) {
            return this.listeners.remove(new ListenerWrapper(listener)) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Listener> getListeners() {
        Map<ListenerWrapper, Object> map = this.listeners;
        synchronized (map) {
            ArrayList<Listener> listenerList = new ArrayList<Listener>();
            for (ListenerWrapper wrapper : this.listeners.keySet()) {
                listenerList.add(wrapper.listener);
            }
            return listenerList;
        }
    }

    public long getUsedHeapMemory() {
        MemoryUsage heapMemory = this.memBean.getHeapMemoryUsage();
        return heapMemory.getUsed();
    }

    public int getUsedHeapMemoryInPercentage() {
        MemoryUsage heapMemory = this.memBean.getHeapMemoryUsage();
        return (int)(heapMemory.getUsed() * 100L / heapMemory.getMax());
    }

    public void sendShutdown() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() {
        super.interrupt();
        ReferenceQueue<Object> referenceQueue = this.monitorQueue;
        synchronized (referenceQueue) {
            this.monitorQueue.notifyAll();
        }
    }

    public static class ListenerWrapper
    implements Listener {
        protected final Listener listener;

        private ListenerWrapper(Listener listener) {
            this.listener = listener;
        }

        public Listener getListener() {
            return this.listener;
        }

        @Override
        public void lowMemory(long iFreeMemory, long iFreeMemoryPercentage) {
            this.listener.lowMemory(iFreeMemory, iFreeMemoryPercentage);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListenerWrapper that = (ListenerWrapper)o;
            return this.listener == that.listener;
        }

        public int hashCode() {
            return this.listener != null ? System.identityHashCode(this.listener) : 0;
        }
    }

    public static interface Listener {
        public void lowMemory(long var1, long var3);
    }
}

