/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.sbtreebonsai.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.types.OModifiableInteger;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeRidBag;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeException;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsaiBucket;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSysBucket;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class OSBTreeBonsaiLocal<K, V>
extends ODurableComponent
implements OSBTreeBonsai<K, V> {
    private static final int PAGE_SIZE = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
    private final float freeSpaceReuseTrigger = OGlobalConfiguration.SBTREEBOSAI_FREE_SPACE_REUSE_TRIGGER.getValueAsFloat();
    private static final OBonsaiBucketPointer SYS_BUCKET = new OBonsaiBucketPointer(0L, 0);
    private OBonsaiBucketPointer rootBucketPointer;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private OStorageLocalAbstract storage;
    private String name;
    private final String dataFileExtension;
    private ODiskCache diskCache;
    private long fileId;
    private OBinarySerializer<K> keySerializer;
    private OBinarySerializer<V> valueSerializer;
    private final boolean durableInNonTxMode;

    public OSBTreeBonsaiLocal(String dataFileExtension, boolean durableInNonTxMode) {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
        this.dataFileExtension = dataFileExtension;
        this.durableInNonTxMode = durableInNonTxMode;
    }

    public void create(String name, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.create(name, keySerializer, valueSerializer, (OStorageLocalAbstract)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying());
    }

    public void create(String name, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OStorageLocalAbstract storageLocal) {
        try {
            this.storage = storageLocal;
            this.diskCache = this.storage.getDiskCache();
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.fileId = this.diskCache.openFile(name + this.dataFileExtension);
            this.name = name;
            this.initAfterCreate();
        }
        catch (IOException e) {
            throw new OSBTreeException("Error creation of sbtree with name" + name, e);
        }
    }

    public void create(long fileId, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.create(fileId, keySerializer, valueSerializer, (OStorageLocalAbstract)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying());
    }

    public void create(long fileId, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OStorageLocalAbstract storageLocal) {
        this.acquireExclusiveLock();
        try {
            this.storage = storageLocal;
            this.diskCache = this.storage.getDiskCache();
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.diskCache.openFile(fileId);
            this.fileId = fileId;
            this.name = this.resolveTreeName(fileId);
            this.initAfterCreate();
        }
        catch (IOException e) {
            throw new OSBTreeException("Error creation of sbtree with name" + this.name, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAfterCreate() {
        this.initDurableComponent(this.storage);
        try {
            this.initSysBucket();
            super.startAtomicOperation();
            AllocationResult allocationResult = this.allocateBucket();
            OCacheEntry rootCacheEntry = allocationResult.getCacheEntry();
            this.rootBucketPointer = allocationResult.getPointer();
            rootCacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(rootCacheEntry, this.rootBucketPointer.getPageOffset(), true, this.keySerializer, this.valueSerializer, this.getTrackMode());
                rootBucket.setTreeSize(0L);
                super.logPageChanges(rootBucket, this.fileId, this.rootBucketPointer.getPageIndex(), true);
            }
            finally {
                rootCacheEntry.releaseExclusiveLock();
                this.diskCache.release(rootCacheEntry);
            }
            super.endAtomicOperation(false);
        }
        catch (Throwable e) {
            try {
                super.endAtomicOperation(true);
            }
            catch (IOException e1) {
                OLogManager.instance().error((Object)this, "Error during sbtree data rollback", (Throwable)e1, new Object[0]);
            }
            throw new OSBTreeException("Error creation of sbtree with name" + this.name, e);
        }
    }

    private void initDurableComponent(OStorageLocalAbstract storageLocal) {
        this.init(storageLocal);
    }

    public String getName() {
        this.acquireSharedLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getFileId() {
        this.acquireSharedLock();
        try {
            long l = this.fileId;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OBonsaiBucketPointer getRootBucketPointer() {
        this.acquireSharedLock();
        try {
            OBonsaiBucketPointer oBonsaiBucketPointer = this.rootBucketPointer;
            return oBonsaiBucketPointer;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OBonsaiCollectionPointer getCollectionPointer() {
        this.acquireSharedLock();
        try {
            OBonsaiCollectionPointer oBonsaiCollectionPointer = new OBonsaiCollectionPointer(this.fileId, this.rootBucketPointer);
            return oBonsaiCollectionPointer;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.acquireSharedLock();
        try {
            Object v;
            BucketSearchResult bucketSearchResult = this.findBucket(key);
            if (bucketSearchResult.itemIndex < 0) {
                V v2 = null;
                return v2;
            }
            OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
            OCacheEntry keyBucketCacheEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
            try {
                OSBTreeBonsaiBucket<K, V> keyBucket = new OSBTreeBonsaiBucket<K, V>(keyBucketCacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, ODurablePage.TrackMode.NONE);
                v = keyBucket.getEntry((int)((BucketSearchResult)bucketSearchResult).itemIndex).value;
                this.diskCache.release(keyBucketCacheEntry);
            }
            catch (Throwable throwable) {
                try {
                    this.diskCache.release(keyBucketCacheEntry);
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OSBTreeException("Error during retrieving  of sbtree with name " + this.name, e);
                }
            }
            return v;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public boolean put(K key, V value) {
        this.acquireExclusiveLock();
        try {
            this.startAtomicOperation();
            this.lockTillAtomicOperationCompletes();
            BucketSearchResult bucketSearchResult = this.findBucket(key);
            OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
            OCacheEntry keyBucketCacheEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
            keyBucketCacheEntry.acquireExclusiveLock();
            OSBTreeBonsaiBucket<K, V> keyBucket = new OSBTreeBonsaiBucket<K, V>(keyBucketCacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
            boolean itemFound = bucketSearchResult.itemIndex >= 0;
            boolean result = true;
            if (itemFound) {
                int updateResult = keyBucket.updateValue(bucketSearchResult.itemIndex, value);
                if (updateResult == 1) {
                    this.logPageChanges(keyBucket, this.fileId, bucketSearchResult.getLastPathItem().getPageIndex(), false);
                    keyBucketCacheEntry.markDirty();
                }
                assert (updateResult == 0 || updateResult == 1);
                result = updateResult != 0;
            } else {
                int insertionIndex = -bucketSearchResult.itemIndex - 1;
                while (!keyBucket.addEntry(insertionIndex, new OSBTreeBonsaiBucket.SBTreeEntry<K, V>(OBonsaiBucketPointer.NULL, OBonsaiBucketPointer.NULL, key, value), true)) {
                    keyBucketCacheEntry.releaseExclusiveLock();
                    this.diskCache.release(keyBucketCacheEntry);
                    bucketSearchResult = this.splitBucket(bucketSearchResult.path, insertionIndex, key);
                    bucketPointer = bucketSearchResult.getLastPathItem();
                    insertionIndex = bucketSearchResult.itemIndex;
                    keyBucketCacheEntry = this.diskCache.load(this.fileId, bucketSearchResult.getLastPathItem().getPageIndex(), false);
                    keyBucketCacheEntry.acquireExclusiveLock();
                    keyBucket = new OSBTreeBonsaiBucket<K, V>(keyBucketCacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
                }
                this.logPageChanges(keyBucket, this.fileId, bucketPointer.getPageIndex(), false);
            }
            keyBucketCacheEntry.releaseExclusiveLock();
            this.diskCache.release(keyBucketCacheEntry);
            if (!itemFound) {
                this.setSize(this.size() + 1L);
            }
            this.endAtomicOperation(false);
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            this.rollback();
            throw new OSBTreeException("Error during index update with key " + key + " and value " + value, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void rollback() {
        try {
            this.endAtomicOperation(true);
        }
        catch (IOException e1) {
            OLogManager.instance().error((Object)this, "Error during sbtree operation  rollback", (Throwable)e1, new Object[0]);
        }
    }

    public void close(boolean flush) {
        this.acquireExclusiveLock();
        try {
            this.diskCache.closeFile(this.fileId, flush);
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during close of index " + this.name, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.acquireExclusiveLock();
        try {
            this.startAtomicOperation();
            LinkedList<OBonsaiBucketPointer> subTreesToDelete = new LinkedList<OBonsaiBucketPointer>();
            OCacheEntry cacheEntry = this.diskCache.load(this.fileId, this.rootBucketPointer.getPageIndex(), false);
            cacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, this.rootBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
                this.addChildrenToQueue(subTreesToDelete, rootBucket);
                rootBucket.shrink(0);
                rootBucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, this.rootBucketPointer.getPageOffset(), true, this.keySerializer, this.valueSerializer, this.getTrackMode());
                rootBucket.setTreeSize(0L);
                this.logPageChanges(rootBucket, this.fileId, this.rootBucketPointer.getPageIndex(), true);
                cacheEntry.markDirty();
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                this.diskCache.release(cacheEntry);
            }
            this.recycleSubTrees(subTreesToDelete);
            this.endAtomicOperation(false);
        }
        catch (Throwable e) {
            this.rollback();
            throw new OSBTreeException("Error during clear of sbtree with name " + this.name, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void addChildrenToQueue(Queue<OBonsaiBucketPointer> subTreesToDelete, OSBTreeBonsaiBucket<K, V> rootBucket) {
        if (!rootBucket.isLeaf()) {
            int size = rootBucket.size();
            if (size > 0) {
                subTreesToDelete.add(rootBucket.getEntry((int)0).leftChild);
            }
            for (int i = 0; i < size; ++i) {
                OSBTreeBonsaiBucket.SBTreeEntry<K, V> entry = rootBucket.getEntry(i);
                subTreesToDelete.add(entry.rightChild);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleSubTrees(Queue<OBonsaiBucketPointer> subTreesToDelete) throws IOException {
        OBonsaiBucketPointer head = OBonsaiBucketPointer.NULL;
        OBonsaiBucketPointer tail = subTreesToDelete.peek();
        int bucketCount = 0;
        while (!subTreesToDelete.isEmpty()) {
            OBonsaiBucketPointer bucketPointer = subTreesToDelete.poll();
            OCacheEntry cacheEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
            cacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
                this.addChildrenToQueue(subTreesToDelete, bucket);
                bucket.setFreeListPointer(head);
                head = bucketPointer;
                this.logPageChanges(bucket, this.fileId, bucketPointer.getPageIndex(), false);
                cacheEntry.markDirty();
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                this.diskCache.release(cacheEntry);
            }
            ++bucketCount;
        }
        if (head.isValid()) {
            OCacheEntry sysCacheEntry = this.diskCache.load(this.fileId, SYS_BUCKET.getPageIndex(), false);
            sysCacheEntry.acquireExclusiveLock();
            try {
                OSysBucket sysBucket = new OSysBucket(sysCacheEntry, this.getTrackMode());
                this.attachFreeListHead(tail, sysBucket.getFreeListHead());
                sysBucket.setFreeListHead(head);
                sysBucket.setFreeListLength(sysBucket.freeListLength() + (long)bucketCount);
                this.logPageChanges(sysBucket, this.fileId, SYS_BUCKET.getPageIndex(), false);
            }
            finally {
                sysCacheEntry.releaseExclusiveLock();
                this.diskCache.release(sysCacheEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachFreeListHead(OBonsaiBucketPointer bucketPointer, OBonsaiBucketPointer freeListHead) throws IOException {
        OCacheEntry cacheEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
        cacheEntry.acquireExclusiveLock();
        try {
            OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
            bucket.setFreeListPointer(freeListHead);
            super.logPageChanges(bucket, this.fileId, bucketPointer.getPageIndex(), false);
            cacheEntry.markDirty();
        }
        finally {
            cacheEntry.releaseExclusiveLock();
            this.diskCache.release(cacheEntry);
        }
    }

    @Override
    public void delete() {
        this.acquireExclusiveLock();
        try {
            this.startAtomicOperation();
            this.lockTillAtomicOperationCompletes();
            LinkedList<OBonsaiBucketPointer> subTreesToDelete = new LinkedList<OBonsaiBucketPointer>();
            subTreesToDelete.add(this.rootBucketPointer);
            this.recycleSubTrees(subTreesToDelete);
            this.endAtomicOperation(false);
        }
        catch (Throwable e) {
            this.rollback();
            throw new OSBTreeException("Error during delete of sbtree with name " + this.name, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(long fileId, OBonsaiBucketPointer rootBucketPointer, OStorageLocalAbstract storageLocal) {
        this.acquireExclusiveLock();
        try {
            this.storage = storageLocal;
            this.rootBucketPointer = rootBucketPointer;
            this.diskCache = this.storage.getDiskCache();
            this.diskCache.openFile(fileId);
            this.fileId = fileId;
            this.name = this.resolveTreeName(fileId);
            OCacheEntry rootCacheEntry = this.diskCache.load(this.fileId, this.rootBucketPointer.getPageIndex(), false);
            rootCacheEntry.acquireSharedLock();
            try {
                OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(rootCacheEntry, this.rootBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, ODurablePage.TrackMode.NONE);
                this.keySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(rootBucket.getKeySerializerId());
                this.valueSerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(rootBucket.getValueSerializerId());
            }
            finally {
                rootCacheEntry.releaseSharedLock();
                this.diskCache.release(rootCacheEntry);
            }
            this.initDurableComponent(storageLocal);
        }
        catch (IOException e) {
            throw new OSBTreeException("Exception during loading of sbtree " + fileId, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private String resolveTreeName(long fileId) {
        String fileName = this.diskCache.fileNameById(fileId);
        return fileName.substring(0, fileName.length() - this.dataFileExtension.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSize(long size) throws IOException {
        OCacheEntry rootCacheEntry = this.diskCache.load(this.fileId, this.rootBucketPointer.getPageIndex(), false);
        rootCacheEntry.acquireExclusiveLock();
        try {
            OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(rootCacheEntry, this.rootBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
            rootBucket.setTreeSize(size);
            this.logPageChanges(rootBucket, this.fileId, this.rootBucketPointer.getPageIndex(), false);
            rootCacheEntry.markDirty();
        }
        finally {
            rootCacheEntry.releaseExclusiveLock();
            this.diskCache.release(rootCacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        this.acquireSharedLock();
        try {
            OCacheEntry rootCacheEntry = this.diskCache.load(this.fileId, this.rootBucketPointer.getPageIndex(), false);
            try {
                OSBTreeBonsaiBucket<K, V> rootBucket = new OSBTreeBonsaiBucket<K, V>(rootCacheEntry, this.rootBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, ODurablePage.TrackMode.NONE);
                long l = rootBucket.getTreeSize();
                this.diskCache.release(rootCacheEntry);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.diskCache.release(rootCacheEntry);
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OSBTreeException("Error during retrieving of size of index " + this.name);
                }
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        this.acquireExclusiveLock();
        try {
            Object removed;
            BucketSearchResult bucketSearchResult = this.findBucket(key);
            if (bucketSearchResult.itemIndex < 0) {
                V v = null;
                return v;
            }
            OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
            OCacheEntry keyBucketCacheEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
            keyBucketCacheEntry.acquireExclusiveLock();
            try {
                this.startAtomicOperation();
                this.lockTillAtomicOperationCompletes();
                OSBTreeBonsaiBucket<K, V> keyBucket = new OSBTreeBonsaiBucket<K, V>(keyBucketCacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
                removed = keyBucket.getEntry((int)((BucketSearchResult)bucketSearchResult).itemIndex).value;
                keyBucket.remove(bucketSearchResult.itemIndex);
                this.logPageChanges(keyBucket, this.fileId, keyBucketCacheEntry.getPageIndex(), false);
                keyBucketCacheEntry.markDirty();
            }
            finally {
                keyBucketCacheEntry.releaseExclusiveLock();
                this.diskCache.release(keyBucketCacheEntry);
            }
            this.setSize(this.size() - 1L);
            this.endAtomicOperation(false);
            Object v = removed;
            return v;
        }
        catch (Throwable e) {
            this.rollback();
            throw new OSBTreeException("Error during removing key " + key + " from sbtree " + this.name, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    protected void endAtomicOperation(boolean rollback) throws IOException {
        if (this.storage.getStorageTransaction() == null && !this.durableInNonTxMode) {
            return;
        }
        super.endAtomicOperation(rollback);
    }

    @Override
    protected void startAtomicOperation() throws IOException {
        if (this.storage.getStorageTransaction() == null && !this.durableInNonTxMode) {
            return;
        }
        super.startAtomicOperation();
    }

    @Override
    protected void logPageChanges(ODurablePage localPage, long fileId, long pageIndex, boolean isNewPage) throws IOException {
        OStorageTransaction transaction = this.storage.getStorageTransaction();
        if (transaction == null && !this.durableInNonTxMode) {
            return;
        }
        super.logPageChanges(localPage, fileId, pageIndex, isNewPage);
    }

    @Override
    protected ODurablePage.TrackMode getTrackMode() {
        OStorageTransaction transaction = this.storage.getStorageTransaction();
        if (transaction == null && !this.durableInNonTxMode) {
            return ODurablePage.TrackMode.NONE;
        }
        return super.getTrackMode();
    }

    @Override
    public Collection<V> getValuesMinor(K key, boolean inclusive, final int maxValuesToFetch) {
        final ArrayList result = new ArrayList();
        this.loadEntriesMinor(key, inclusive, new OTreeInternal.RangeResultListener<K, V>(){

            @Override
            public boolean addResult(Map.Entry<K, V> entry) {
                result.add(entry.getValue());
                return maxValuesToFetch <= -1 || result.size() < maxValuesToFetch;
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEntriesMinor(K key, boolean inclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        this.acquireSharedLock();
        try {
            BucketSearchResult bucketSearchResult = this.findBucket(key);
            OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
            int index = bucketSearchResult.itemIndex >= 0 ? (inclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex - 1) : -bucketSearchResult.itemIndex - 2;
            boolean firstBucket = true;
            do {
                OCacheEntry cacheEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
                try {
                    OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, ODurablePage.TrackMode.NONE);
                    if (!firstBucket) {
                        index = bucket.size() - 1;
                    }
                    for (int i = index; i >= 0; --i) {
                        if (listener.addResult(bucket.getEntry(i))) continue;
                        return;
                    }
                    bucketPointer = bucket.getLeftSibling();
                    firstBucket = false;
                }
                finally {
                    this.diskCache.release(cacheEntry);
                }
            } while (bucketPointer.getPageIndex() >= 0L);
        }
        catch (IOException ioe) {
            throw new OSBTreeException("Error during fetch of minor values for key " + key + " in sbtree " + this.name);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<V> getValuesMajor(K key, boolean inclusive, final int maxValuesToFetch) {
        final ArrayList result = new ArrayList();
        this.loadEntriesMajor(key, inclusive, true, new OTreeInternal.RangeResultListener<K, V>(){

            @Override
            public boolean addResult(Map.Entry<K, V> entry) {
                result.add(entry.getValue());
                return maxValuesToFetch <= -1 || result.size() < maxValuesToFetch;
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEntriesMajor(K key, boolean inclusive, boolean ascSortOrder, OTreeInternal.RangeResultListener<K, V> listener) {
        if (!ascSortOrder) {
            throw new IllegalStateException("Descending sort order is not supported.");
        }
        this.acquireSharedLock();
        try {
            BucketSearchResult bucketSearchResult = this.findBucket(key);
            OBonsaiBucketPointer bucketPointer = bucketSearchResult.getLastPathItem();
            int index = bucketSearchResult.itemIndex >= 0 ? (inclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex + 1) : -bucketSearchResult.itemIndex - 1;
            do {
                OCacheEntry cacheEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
                try {
                    OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, ODurablePage.TrackMode.NONE);
                    int bucketSize = bucket.size();
                    for (int i = index; i < bucketSize; ++i) {
                        if (listener.addResult(bucket.getEntry(i))) continue;
                        return;
                    }
                    bucketPointer = bucket.getRightSibling();
                    index = 0;
                }
                finally {
                    this.diskCache.release(cacheEntry);
                }
            } while (bucketPointer.getPageIndex() >= 0L);
        }
        catch (IOException ioe) {
            throw new OSBTreeException("Error during fetch of major values for key " + key + " in sbtree " + this.name);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public Collection<V> getValuesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, final int maxValuesToFetch) {
        final ArrayList result = new ArrayList();
        this.loadEntriesBetween(keyFrom, fromInclusive, keyTo, toInclusive, new OTreeInternal.RangeResultListener<K, V>(){

            @Override
            public boolean addResult(Map.Entry<K, V> entry) {
                result.add(entry.getValue());
                return maxValuesToFetch <= 0 || result.size() < maxValuesToFetch;
            }
        });
        return result;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public K firstKey() {
        this.acquireSharedLock();
        try {
            path = new LinkedList<PagePathItemUnit>();
            bucketPointer = this.rootBucketPointer;
            cacheEntry = this.diskCache.load(this.fileId, this.rootBucketPointer.getPageIndex(), false);
            itemIndex = 0;
            bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, ODurablePage.TrackMode.NONE);
            while (true) {
                if (!bucket.isLeaf()) break block17;
                if (!bucket.isEmpty()) ** GOTO lbl24
                if (!path.isEmpty()) break block18;
                var6_7 = null;
                this.diskCache.release(cacheEntry);
                break;
            }
            {
                catch (Throwable var7_8) {
                    throw var7_8;
                }
            }
            {
                block20: {
                    block19: {
                        block17: {
                            block18: {
                                return var6_7;
                            }
                            pagePathItemUnit /* !! */  = (PagePathItemUnit)path.removeLast();
                            bucketPointer = PagePathItemUnit.access$400(pagePathItemUnit /* !! */ );
                            itemIndex = PagePathItemUnit.access$500(pagePathItemUnit /* !! */ ) + 1;
                            ** GOTO lbl49
lbl24:
                            // 1 sources

                            pagePathItemUnit /* !! */  = bucket.getKey(0);
                            return pagePathItemUnit /* !! */ ;
                        }
                        if (!bucket.isEmpty() && itemIndex <= bucket.size()) ** GOTO lbl40
                        if (!path.isEmpty()) break block19;
                        pagePathItemUnit /* !! */  = null;
                        this.diskCache.release(cacheEntry);
                        return pagePathItemUnit /* !! */ ;
                    }
                    pagePathItemUnit /* !! */  = (PagePathItemUnit)path.removeLast();
                    bucketPointer = PagePathItemUnit.access$400(pagePathItemUnit /* !! */ );
                    itemIndex = PagePathItemUnit.access$500(pagePathItemUnit /* !! */ ) + 1;
                    break block20;
lbl40:
                    // 1 sources

                    path.add(new PagePathItemUnit(bucketPointer, itemIndex));
                    if (itemIndex < bucket.size()) {
                        entry = bucket.getEntry(itemIndex);
                        bucketPointer = entry.leftChild;
                    } else {
                        entry = bucket.getEntry(itemIndex - 1);
                        bucketPointer = entry.rightChild;
                    }
                    itemIndex = 0;
                }
                cacheEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
                bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, ODurablePage.TrackMode.NONE);
                continue;
            }
            finally {
                this.diskCache.release(cacheEntry);
            }
            catch (IOException e) {
                throw new OSBTreeException("Error during finding first key in sbtree [" + this.name + "]");
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public K lastKey() {
        this.acquireSharedLock();
        try {
            path = new LinkedList<PagePathItemUnit>();
            bucketPointer = this.rootBucketPointer;
            cacheEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
            bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, ODurablePage.TrackMode.NONE);
            itemIndex = bucket.size() - 1;
            while (true) {
                if (!bucket.isLeaf()) break block17;
                if (!bucket.isEmpty()) ** GOTO lbl24
                if (!path.isEmpty()) break block18;
                var6_7 = null;
                this.diskCache.release(cacheEntry);
                break;
            }
            {
                catch (Throwable var7_8) {
                    throw var7_8;
                }
            }
            {
                block19: {
                    block20: {
                        block17: {
                            block18: {
                                return var6_7;
                            }
                            pagePathItemUnit /* !! */  = (PagePathItemUnit)path.removeLast();
                            bucketPointer = PagePathItemUnit.access$400(pagePathItemUnit /* !! */ );
                            itemIndex = PagePathItemUnit.access$500(pagePathItemUnit /* !! */ ) - 1;
                            ** GOTO lbl50
lbl24:
                            // 1 sources

                            pagePathItemUnit /* !! */  = bucket.getKey(bucket.size() - 1);
                            return pagePathItemUnit /* !! */ ;
                        }
                        if (itemIndex >= -1) break block19;
                        if (path.isEmpty()) break block20;
                        pagePathItemUnit /* !! */  = (PagePathItemUnit)path.removeLast();
                        bucketPointer = PagePathItemUnit.access$400(pagePathItemUnit /* !! */ );
                        itemIndex = PagePathItemUnit.access$500(pagePathItemUnit /* !! */ ) - 1;
                        ** GOTO lbl50
                    }
                    pagePathItemUnit /* !! */  = null;
                    this.diskCache.release(cacheEntry);
                    return pagePathItemUnit /* !! */ ;
                }
                path.add(new PagePathItemUnit(bucketPointer, itemIndex));
                if (itemIndex > -1) {
                    entry = bucket.getEntry(itemIndex);
                    bucketPointer = entry.rightChild;
                } else {
                    entry = bucket.getEntry(0);
                    bucketPointer = entry.leftChild;
                }
                itemIndex = OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES + 1;
lbl50:
                // 3 sources

                cacheEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
                bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, ODurablePage.TrackMode.NONE);
                if (itemIndex != OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES + 1) continue;
                itemIndex = bucket.size() - 1;
                continue;
            }
            finally {
                this.diskCache.release(cacheEntry);
            }
            catch (IOException e) {
                throw new OSBTreeException("Error during finding first key in sbtree [" + this.name + "]");
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        block13: {
            this.acquireSharedLock();
            try {
                BucketSearchResult bucketSearchResultFrom = this.findBucket(keyFrom);
                OBonsaiBucketPointer bucketPointerFrom = bucketSearchResultFrom.getLastPathItem();
                int indexFrom = bucketSearchResultFrom.itemIndex >= 0 ? (fromInclusive ? bucketSearchResultFrom.itemIndex : bucketSearchResultFrom.itemIndex + 1) : -bucketSearchResultFrom.itemIndex - 1;
                BucketSearchResult bucketSearchResultTo = this.findBucket(keyTo);
                OBonsaiBucketPointer bucketPointerTo = bucketSearchResultTo.getLastPathItem();
                int indexTo = bucketSearchResultTo.itemIndex >= 0 ? (toInclusive ? bucketSearchResultTo.itemIndex : bucketSearchResultTo.itemIndex - 1) : -bucketSearchResultTo.itemIndex - 2;
                int startIndex = indexFrom;
                OBonsaiBucketPointer bucketPointer = bucketPointerFrom;
                while (true) {
                    block14: {
                        OCacheEntry cacheEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
                        try {
                            OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, ODurablePage.TrackMode.NONE);
                            int endIndex = !bucketPointer.equals(bucketPointerTo) ? bucket.size() - 1 : indexTo;
                            for (int i = startIndex; i <= endIndex; ++i) {
                                if (listener.addResult(bucket.getEntry(i))) {
                                    continue;
                                }
                                break block13;
                            }
                            if (!bucketPointer.equals(bucketPointerTo) && (bucketPointer = bucket.getRightSibling()).getPageIndex() >= 0L) break block14;
                            break;
                        }
                        finally {
                            this.diskCache.release(cacheEntry);
                        }
                    }
                    startIndex = 0;
                }
            }
            catch (IOException ioe) {
                throw new OSBTreeException("Error during fetch of values between key " + keyFrom + " and key " + keyTo + " in sbtree " + this.name);
            }
            finally {
                this.releaseSharedLock();
            }
        }
    }

    public void flush() {
        this.acquireSharedLock();
        try {
            try {
                this.diskCache.flushBuffer();
            }
            catch (IOException e) {
                throw new OSBTreeException("Error during flush of sbtree [" + this.name + "] data");
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitBucket(List<OBonsaiBucketPointer> path, int keyIndex, K keyToInsert) throws IOException {
        OBonsaiBucketPointer bucketPointer = path.get(path.size() - 1);
        OCacheEntry bucketEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
        bucketEntry.acquireExclusiveLock();
        try {
            int startRightIndex;
            OSBTreeBonsaiBucket<K, Object> bucketToSplit = new OSBTreeBonsaiBucket<K, Object>(bucketEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
            boolean splitLeaf = bucketToSplit.isLeaf();
            int bucketSize = bucketToSplit.size();
            int indexToSplit = bucketSize >>> 1;
            K separationKey = bucketToSplit.getKey(indexToSplit);
            ArrayList rightEntries = new ArrayList(indexToSplit);
            for (int i = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getEntry(i));
            }
            if (!bucketPointer.equals(this.rootBucketPointer)) {
                Object parentBucketPointer;
                AllocationResult allocationResult = this.allocateBucket();
                OCacheEntry rightBucketEntry = allocationResult.getCacheEntry();
                OBonsaiBucketPointer rightBucketPointer = allocationResult.getPointer();
                rightBucketEntry.acquireExclusiveLock();
                try {
                    OSBTreeBonsaiBucket newRightBucket = new OSBTreeBonsaiBucket(rightBucketEntry, rightBucketPointer.getPageOffset(), splitLeaf, this.keySerializer, this.valueSerializer, this.getTrackMode());
                    newRightBucket.addAll(rightEntries);
                    bucketToSplit.shrink(indexToSplit);
                    if (splitLeaf) {
                        OBonsaiBucketPointer rightSiblingBucketPointer = bucketToSplit.getRightSibling();
                        newRightBucket.setRightSibling(rightSiblingBucketPointer);
                        newRightBucket.setLeftSibling(bucketPointer);
                        bucketToSplit.setRightSibling(rightBucketPointer);
                        if (rightSiblingBucketPointer.isValid()) {
                            OCacheEntry rightSiblingBucketEntry = this.diskCache.load(this.fileId, rightSiblingBucketPointer.getPageIndex(), false);
                            rightSiblingBucketEntry.acquireExclusiveLock();
                            OSBTreeBonsaiBucket<K, V> rightSiblingBucket = new OSBTreeBonsaiBucket<K, V>(rightSiblingBucketEntry, rightSiblingBucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
                            try {
                                rightSiblingBucket.setLeftSibling(rightBucketPointer);
                                this.logPageChanges(rightSiblingBucket, this.fileId, rightSiblingBucketPointer.getPageIndex(), false);
                            }
                            finally {
                                rightSiblingBucketEntry.releaseExclusiveLock();
                                this.diskCache.release(rightSiblingBucketEntry);
                            }
                        }
                    }
                    parentBucketPointer = path.get(path.size() - 2);
                    OCacheEntry parentCacheEntry = this.diskCache.load(this.fileId, ((OBonsaiBucketPointer)parentBucketPointer).getPageIndex(), false);
                    parentCacheEntry.acquireExclusiveLock();
                    try {
                        OSBTreeBonsaiBucket<K, Object> parentBucket = new OSBTreeBonsaiBucket<K, Object>(parentCacheEntry, ((OBonsaiBucketPointer)parentBucketPointer).getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
                        OSBTreeBonsaiBucket.SBTreeEntry<K, Object> parentEntry = new OSBTreeBonsaiBucket.SBTreeEntry<K, Object>(bucketPointer, rightBucketPointer, separationKey, null);
                        int insertionIndex = parentBucket.find(separationKey);
                        assert (insertionIndex < 0);
                        insertionIndex = -insertionIndex - 1;
                        while (!parentBucket.addEntry(insertionIndex, parentEntry, true)) {
                            parentCacheEntry.releaseExclusiveLock();
                            this.diskCache.release(parentCacheEntry);
                            BucketSearchResult bucketSearchResult = this.splitBucket(path.subList(0, path.size() - 1), insertionIndex, separationKey);
                            parentBucketPointer = bucketSearchResult.getLastPathItem();
                            parentCacheEntry = this.diskCache.load(this.fileId, ((OBonsaiBucketPointer)parentBucketPointer).getPageIndex(), false);
                            parentCacheEntry.acquireExclusiveLock();
                            insertionIndex = bucketSearchResult.itemIndex;
                            parentBucket = new OSBTreeBonsaiBucket<K, V>(parentCacheEntry, ((OBonsaiBucketPointer)parentBucketPointer).getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
                        }
                        this.logPageChanges(parentBucket, this.fileId, ((OBonsaiBucketPointer)parentBucketPointer).getPageIndex(), false);
                    }
                    finally {
                        parentCacheEntry.releaseExclusiveLock();
                        this.diskCache.release(parentCacheEntry);
                    }
                    this.logPageChanges(newRightBucket, this.fileId, rightBucketEntry.getPageIndex(), allocationResult.isNewPage());
                }
                finally {
                    rightBucketEntry.releaseExclusiveLock();
                    this.diskCache.release(rightBucketEntry);
                }
                this.logPageChanges(bucketToSplit, this.fileId, bucketPointer.getPageIndex(), false);
                ArrayList<OBonsaiBucketPointer> resultPath = new ArrayList<OBonsaiBucketPointer>(path.subList(0, path.size() - 1));
                if (this.comparator.compare(keyToInsert, separationKey) < 0) {
                    resultPath.add(bucketPointer);
                    parentBucketPointer = new BucketSearchResult(keyIndex, resultPath);
                    return parentBucketPointer;
                }
                resultPath.add(rightBucketPointer);
                if (splitLeaf) {
                    parentBucketPointer = new BucketSearchResult(keyIndex - indexToSplit, resultPath);
                    return parentBucketPointer;
                }
                parentBucketPointer = new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
                return parentBucketPointer;
            }
            long treeSize = bucketToSplit.getTreeSize();
            ArrayList leftEntries = new ArrayList(indexToSplit);
            for (int i = 0; i < indexToSplit; ++i) {
                leftEntries.add(bucketToSplit.getEntry(i));
            }
            AllocationResult leftAllocationResult = this.allocateBucket();
            OCacheEntry leftBucketEntry = leftAllocationResult.getCacheEntry();
            OBonsaiBucketPointer leftBucketPointer = leftAllocationResult.getPointer();
            AllocationResult rightAllocationResult = this.allocateBucket();
            OCacheEntry rightBucketEntry = rightAllocationResult.getCacheEntry();
            OBonsaiBucketPointer rightBucketPointer = rightAllocationResult.getPointer();
            leftBucketEntry.acquireExclusiveLock();
            try {
                OSBTreeBonsaiBucket newLeftBucket = new OSBTreeBonsaiBucket(leftBucketEntry, leftBucketPointer.getPageOffset(), splitLeaf, this.keySerializer, this.valueSerializer, this.getTrackMode());
                newLeftBucket.addAll(leftEntries);
                if (splitLeaf) {
                    newLeftBucket.setRightSibling(rightBucketPointer);
                }
                this.logPageChanges(newLeftBucket, this.fileId, leftBucketEntry.getPageIndex(), leftAllocationResult.isNewPage());
            }
            finally {
                leftBucketEntry.releaseExclusiveLock();
                this.diskCache.release(leftBucketEntry);
            }
            rightBucketEntry.acquireExclusiveLock();
            try {
                OSBTreeBonsaiBucket newRightBucket = new OSBTreeBonsaiBucket(rightBucketEntry, rightBucketPointer.getPageOffset(), splitLeaf, this.keySerializer, this.valueSerializer, this.getTrackMode());
                newRightBucket.addAll(rightEntries);
                if (splitLeaf) {
                    newRightBucket.setLeftSibling(leftBucketPointer);
                }
                this.logPageChanges(newRightBucket, this.fileId, rightBucketEntry.getPageIndex(), rightAllocationResult.isNewPage());
                rightBucketEntry.markDirty();
            }
            finally {
                rightBucketEntry.releaseExclusiveLock();
                this.diskCache.release(rightBucketEntry);
            }
            bucketToSplit = new OSBTreeBonsaiBucket<K, V>(bucketEntry, bucketPointer.getPageOffset(), false, this.keySerializer, this.valueSerializer, this.getTrackMode());
            bucketToSplit.setTreeSize(treeSize);
            bucketToSplit.addEntry(0, new OSBTreeBonsaiBucket.SBTreeEntry<K, Object>(leftBucketPointer, rightBucketPointer, separationKey, null), true);
            this.logPageChanges(bucketToSplit, this.fileId, bucketPointer.getPageIndex(), false);
            ArrayList<OBonsaiBucketPointer> resultPath = new ArrayList<OBonsaiBucketPointer>(path.subList(0, path.size() - 1));
            if (this.comparator.compare(keyToInsert, separationKey) < 0) {
                resultPath.add(leftBucketPointer);
                BucketSearchResult bucketSearchResult = new BucketSearchResult(keyIndex, resultPath);
                return bucketSearchResult;
            }
            resultPath.add(rightBucketPointer);
            if (splitLeaf) {
                BucketSearchResult bucketSearchResult = new BucketSearchResult(keyIndex - indexToSplit, resultPath);
                return bucketSearchResult;
            }
            BucketSearchResult bucketSearchResult = new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
            return bucketSearchResult;
        }
        finally {
            bucketEntry.releaseExclusiveLock();
            this.diskCache.release(bucketEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key) throws IOException {
        OBonsaiBucketPointer bucketPointer = this.rootBucketPointer;
        ArrayList<OBonsaiBucketPointer> path = new ArrayList<OBonsaiBucketPointer>();
        while (true) {
            OSBTreeBonsaiBucket.SBTreeEntry<K, V> entry;
            path.add(bucketPointer);
            OCacheEntry bucketEntry = this.diskCache.load(this.fileId, bucketPointer.getPageIndex(), false);
            try {
                int insertionIndex;
                OSBTreeBonsaiBucket<K, V> keyBucket = new OSBTreeBonsaiBucket<K, V>(bucketEntry, bucketPointer.getPageOffset(), this.keySerializer, this.valueSerializer, ODurablePage.TrackMode.NONE);
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, path);
                    return bucketSearchResult;
                }
                entry = index >= 0 ? keyBucket.getEntry(index) : ((insertionIndex = -index - 1) >= keyBucket.size() ? keyBucket.getEntry(insertionIndex - 1) : keyBucket.getEntry(insertionIndex));
            }
            finally {
                this.diskCache.release(bucketEntry);
            }
            if (this.comparator.compare(key, entry.key) >= 0) {
                bucketPointer = entry.rightChild;
                continue;
            }
            bucketPointer = entry.leftChild;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSysBucket() throws IOException {
        block5: {
            OCacheEntry sysCacheEntry = this.diskCache.load(this.fileId, SYS_BUCKET.getPageIndex(), false);
            sysCacheEntry.acquireExclusiveLock();
            try {
                OSysBucket sysBucket = new OSysBucket(sysCacheEntry, this.getTrackMode());
                if (!sysBucket.isInitialized()) break block5;
                super.startAtomicOperation();
                try {
                    sysBucket.init();
                    super.logPageChanges(sysBucket, this.fileId, SYS_BUCKET.getPageIndex(), true);
                    sysCacheEntry.markDirty();
                    super.endAtomicOperation(false);
                }
                catch (Throwable e) {
                    super.endAtomicOperation(true);
                    throw new OStorageException(null, e);
                }
            }
            finally {
                sysCacheEntry.releaseExclusiveLock();
                this.diskCache.release(sysCacheEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocationResult allocateBucket() throws IOException {
        OCacheEntry sysCacheEntry = this.diskCache.load(this.fileId, SYS_BUCKET.getPageIndex(), false);
        sysCacheEntry.acquireExclusiveLock();
        try {
            OSysBucket sysBucket = new OSysBucket(sysCacheEntry, this.getTrackMode());
            if (1.0 * (double)sysBucket.freeListLength() / (double)(this.diskCache.getFilledUpTo(this.fileId) * (long)PAGE_SIZE / (long)OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES) >= (double)this.freeSpaceReuseTrigger) {
                AllocationResult allocationResult = this.reuseBucketFromFreeList(sysBucket);
                sysCacheEntry.markDirty();
                AllocationResult allocationResult2 = allocationResult;
                return allocationResult2;
            }
            OBonsaiBucketPointer freeSpacePointer = sysBucket.getFreeSpacePointer();
            if (freeSpacePointer.getPageOffset() + OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES > PAGE_SIZE) {
                OCacheEntry cacheEntry = this.diskCache.allocateNewPage(this.fileId);
                long pageIndex = cacheEntry.getPageIndex();
                sysBucket.setFreeSpacePointer(new OBonsaiBucketPointer(pageIndex, OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES));
                this.logPageChanges(sysBucket, this.fileId, SYS_BUCKET.getPageIndex(), false);
                sysCacheEntry.markDirty();
                AllocationResult allocationResult = new AllocationResult(new OBonsaiBucketPointer(pageIndex, 0), cacheEntry, true);
                return allocationResult;
            }
            sysBucket.setFreeSpacePointer(new OBonsaiBucketPointer(freeSpacePointer.getPageIndex(), freeSpacePointer.getPageOffset() + OSBTreeBonsaiBucket.MAX_BUCKET_SIZE_BYTES));
            OCacheEntry cacheEntry = this.diskCache.load(this.fileId, freeSpacePointer.getPageIndex(), false);
            this.logPageChanges(sysBucket, this.fileId, SYS_BUCKET.getPageIndex(), false);
            AllocationResult allocationResult = new AllocationResult(freeSpacePointer, cacheEntry, false);
            return allocationResult;
        }
        finally {
            sysCacheEntry.releaseExclusiveLock();
            this.diskCache.release(sysCacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocationResult reuseBucketFromFreeList(OSysBucket sysBucket) throws IOException {
        OBonsaiBucketPointer oldFreeListHead = sysBucket.getFreeListHead();
        assert (oldFreeListHead.isValid());
        OCacheEntry cacheEntry = this.diskCache.load(this.fileId, oldFreeListHead.getPageIndex(), false);
        cacheEntry.acquireExclusiveLock();
        try {
            OSBTreeBonsaiBucket<K, V> bucket = new OSBTreeBonsaiBucket<K, V>(cacheEntry, oldFreeListHead.getPageOffset(), this.keySerializer, this.valueSerializer, this.getTrackMode());
            sysBucket.setFreeListHead(bucket.getFreeListPointer());
            sysBucket.setFreeListLength(sysBucket.freeListLength() - 1L);
            this.logPageChanges(bucket, this.fileId, oldFreeListHead.getPageIndex(), false);
            cacheEntry.markDirty();
        }
        finally {
            cacheEntry.releaseExclusiveLock();
        }
        return new AllocationResult(oldFreeListHead, cacheEntry, false);
    }

    @Override
    public int getRealBagSize(Map<K, OSBTreeRidBag.Change> changes) {
        final HashMap<K, OSBTreeRidBag.Change> notAppliedChanges = new HashMap<K, OSBTreeRidBag.Change>(changes);
        final OModifiableInteger size = new OModifiableInteger(0);
        this.loadEntriesMajor(this.firstKey(), true, true, new OTreeInternal.RangeResultListener<K, V>(){

            @Override
            public boolean addResult(Map.Entry<K, V> entry) {
                OSBTreeRidBag.Change change = (OSBTreeRidBag.Change)notAppliedChanges.remove(entry.getKey());
                Integer treeValue = (Integer)entry.getValue();
                int result = change == null ? treeValue.intValue() : change.applyTo(treeValue);
                size.increment(result);
                return true;
            }
        });
        for (OSBTreeRidBag.Change change : notAppliedChanges.values()) {
            size.increment(change.applyTo(0));
        }
        return size.intValue();
    }

    @Override
    public OBinarySerializer<K> getKeySerializer() {
        this.acquireSharedLock();
        try {
            OBinarySerializer<K> oBinarySerializer = this.keySerializer;
            return oBinarySerializer;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OBinarySerializer<V> getValueSerializer() {
        this.acquireSharedLock();
        try {
            OBinarySerializer<V> oBinarySerializer = this.valueSerializer;
            return oBinarySerializer;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static final class PagePathItemUnit {
        private final OBonsaiBucketPointer bucketPointer;
        private final int itemIndex;

        private PagePathItemUnit(OBonsaiBucketPointer bucketPointer, int itemIndex) {
            this.bucketPointer = bucketPointer;
            this.itemIndex = itemIndex;
        }

        static /* synthetic */ OBonsaiBucketPointer access$400(PagePathItemUnit x0) {
            return x0.bucketPointer;
        }

        static /* synthetic */ int access$500(PagePathItemUnit x0) {
            return x0.itemIndex;
        }
    }

    private static class BucketSearchResult {
        private final int itemIndex;
        private final ArrayList<OBonsaiBucketPointer> path;

        private BucketSearchResult(int itemIndex, ArrayList<OBonsaiBucketPointer> path) {
            this.itemIndex = itemIndex;
            this.path = path;
        }

        public OBonsaiBucketPointer getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }
    }

    private static class AllocationResult {
        private final OBonsaiBucketPointer pointer;
        private final OCacheEntry cacheEntry;
        private final boolean newPage;

        private AllocationResult(OBonsaiBucketPointer pointer, OCacheEntry cacheEntry, boolean newPage) {
            this.pointer = pointer;
            this.cacheEntry = cacheEntry;
            this.newPage = newPage;
        }

        private OBonsaiBucketPointer getPointer() {
            return this.pointer;
        }

        private OCacheEntry getCacheEntry() {
            return this.cacheEntry;
        }

        private boolean isNewPage() {
            return this.newPage;
        }
    }
}

