/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.sbtree.local;

import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import java.io.IOException;

public class OSBTreeValuePage
extends ODurablePage {
    private static final int FREE_LIST_NEXT_PAGE_OFFSET = 28;
    private static final int WHOLE_VALUE_SIZE_OFFSET = 36;
    private static final int PAGE_VALUE_SIZE_OFFSET = 40;
    private static final int NEXT_VALUE_PAGE_OFFSET = 44;
    private static final int BINARY_CONTENT_OFFSET = 52;
    public static final int MAX_BINARY_VALUE_SIZE = MAX_PAGE_SIZE_BYTES - 52;

    public OSBTreeValuePage(OCacheEntry cacheEntry, ODurablePage.TrackMode trackMode, boolean isNew) throws IOException {
        super(cacheEntry, trackMode);
        if (isNew) {
            this.setNextFreeListPage(-1L);
            this.setNextPage(-1L);
        }
    }

    public void setNextPage(long nextPage) throws IOException {
        this.setLongValue(44, nextPage);
    }

    public int getSize() {
        return this.getIntValue(36);
    }

    public int fillBinaryContent(byte[] data, int offset) throws IOException {
        this.setIntValue(36, data.length);
        int maxSize = Math.min(data.length - offset, MAX_BINARY_VALUE_SIZE);
        this.setIntValue(40, maxSize);
        byte[] pageValue = new byte[maxSize];
        System.arraycopy(data, offset, pageValue, 0, maxSize);
        this.setBinaryValue(52, pageValue);
        return offset + maxSize;
    }

    public int readBinaryContent(byte[] data, int offset) throws IOException {
        int valueSize = this.getIntValue(40);
        byte[] content = this.getBinaryValue(52, valueSize);
        System.arraycopy(content, 0, data, offset, valueSize);
        return offset + valueSize;
    }

    public long getNextPage() {
        return this.getLongValue(44);
    }

    public void setNextFreeListPage(long pageIndex) throws IOException {
        this.setLongValue(28, pageIndex);
    }

    public long getNextFreeListPage() {
        return this.getLongValue(28);
    }

    public static int calculateAmountOfPage(int contentSize) {
        return (int)Math.ceil(1.0 * (double)contentSize / (double)MAX_BINARY_VALUE_SIZE);
    }
}

