/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.sbtree.local;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.index.sbtree.local.ONullBucket;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeBucket;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeException;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeValue;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeValuePage;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.iterator.OEmptyMapEntryIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OSBTree<K, V>
extends ODurableComponent {
    private static final int MAX_KEY_SIZE = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
    private static final int MAX_EMBEDDED_VALUE_SIZE = OGlobalConfiguration.SBTREE_MAX_EMBEDDED_VALUE_SIZE.getValueAsInteger();
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    private static final long ROOT_INDEX = 0L;
    private static final ODurablePage.TrackMode txTrackMode = ODurablePage.TrackMode.valueOf(OGlobalConfiguration.INDEX_TX_MODE.getValueAsString().toUpperCase());
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final String dataFileExtension;
    private final String nullFileExtension;
    private final boolean durableInNonTxMode;
    private OStorageLocalAbstract storage;
    private String name;
    private ODiskCache diskCache;
    private long fileId;
    private long nullBucketFileId = -1L;
    private int keySize;
    private OBinarySerializer<K> keySerializer;
    private OType[] keyTypes;
    private OBinarySerializer<V> valueSerializer;
    private boolean nullPointerSupport;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTree(String dataFileExtension, int keySize, boolean durableInNonTxMode, String nullFileExtension) {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
        this.acquireExclusiveLock();
        try {
            this.dataFileExtension = dataFileExtension;
            this.keySize = keySize;
            this.nullFileExtension = nullFileExtension;
            this.durableInNonTxMode = durableInNonTxMode;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String name, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, OStorageLocalAbstract storageLocal, boolean nullPointerSupport) {
        this.acquireExclusiveLock();
        try {
            this.storage = storageLocal;
            this.keyTypes = keyTypes;
            this.diskCache = this.storage.getDiskCache();
            this.name = name;
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.nullPointerSupport = nullPointerSupport;
            this.fileId = this.diskCache.openFile(name + this.dataFileExtension);
            if (nullPointerSupport) {
                this.nullBucketFileId = this.diskCache.openFile(name + this.nullFileExtension);
            }
            this.initDurableComponent(storageLocal);
            OCacheEntry rootCacheEntry = this.diskCache.load(this.fileId, 0L, false);
            rootCacheEntry.acquireExclusiveLock();
            try {
                super.startAtomicOperation();
                OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, true, keySerializer, keyTypes, valueSerializer, this.getTrackMode());
                rootBucket.setTreeSize(0L);
                super.logPageChanges(rootBucket, this.fileId, 0L, true);
                rootCacheEntry.markDirty();
            }
            finally {
                rootCacheEntry.releaseExclusiveLock();
                this.diskCache.release(rootCacheEntry);
            }
            super.endAtomicOperation(false);
        }
        catch (Throwable e) {
            try {
                super.endAtomicOperation(true);
            }
            catch (IOException e1) {
                OLogManager.instance().error((Object)this, "Error during sbtree data rollback", (Throwable)e1, new Object[0]);
            }
            throw new OSBTreeException("Error creation of sbtree with name" + name, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public String getName() {
        this.acquireSharedLock();
        try {
            String string = this.name;
            return string;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * Exception decompiling
     */
    public V get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 16[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(K key, V value) {
        this.acquireExclusiveLock();
        OStorageTransaction transaction = this.storage.getStorageTransaction();
        try {
            OCacheEntry cacheEntry;
            this.checkNullSupport(key);
            if (key != null) {
                int keySize = this.keySerializer.getObjectSize(key, (Object[])this.keyTypes);
                int valueSize = this.valueSerializer.getObjectSize((Object)value, new Object[0]);
                if (keySize > MAX_KEY_SIZE) {
                    throw new OSBTreeException("Key size is more than allowed, operation was canceled. Current key size " + keySize + ", allowed  " + MAX_KEY_SIZE);
                }
                boolean createLinkToTheValue = valueSize > MAX_EMBEDDED_VALUE_SIZE;
                key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                this.startAtomicOperation();
                try {
                    int sizeDiff;
                    int insertionIndex;
                    long valueLink = -1L;
                    if (createLinkToTheValue) {
                        valueLink = this.createLinkToTheValue(value);
                    }
                    OSBTreeValue<Object> treeValue = new OSBTreeValue<Object>(createLinkToTheValue, valueLink, (createLinkToTheValue ? null : value));
                    BucketSearchResult bucketSearchResult = this.findBucket(key);
                    OCacheEntry keyBucketCacheEntry = this.diskCache.load(this.fileId, bucketSearchResult.getLastPathItem(), false);
                    keyBucketCacheEntry.acquireExclusiveLock();
                    OSBTreeBucket<Object, Object> keyBucket = new OSBTreeBucket<Object, Object>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
                    if (bucketSearchResult.itemIndex >= 0) {
                        int updateResult = keyBucket.updateValue(bucketSearchResult.itemIndex, treeValue);
                        if (updateResult == 1) {
                            this.logPageChanges(keyBucket, this.fileId, keyBucketCacheEntry.getPageIndex(), false);
                            keyBucketCacheEntry.markDirty();
                        }
                        if (updateResult >= 0) {
                            keyBucketCacheEntry.releaseExclusiveLock();
                            this.diskCache.release(keyBucketCacheEntry);
                            this.endAtomicOperation(false);
                            return;
                        }
                        assert (updateResult == -1);
                        long removedLinkedValue = keyBucket.remove(bucketSearchResult.itemIndex);
                        if (removedLinkedValue >= 0L) {
                            this.removeLinkedValue(removedLinkedValue);
                        }
                        insertionIndex = bucketSearchResult.itemIndex;
                        sizeDiff = 0;
                    } else {
                        insertionIndex = -bucketSearchResult.itemIndex - 1;
                        sizeDiff = 1;
                    }
                    while (!keyBucket.addEntry(insertionIndex, new OSBTreeBucket.SBTreeEntry<Object, Object>(-1L, -1L, key, treeValue), true)) {
                        this.logPageChanges(keyBucket, this.fileId, keyBucketCacheEntry.getPageIndex(), false);
                        keyBucketCacheEntry.releaseExclusiveLock();
                        this.diskCache.release(keyBucketCacheEntry);
                        bucketSearchResult = this.splitBucket(bucketSearchResult.path, insertionIndex, key);
                        insertionIndex = bucketSearchResult.itemIndex;
                        keyBucketCacheEntry = this.diskCache.load(this.fileId, bucketSearchResult.getLastPathItem(), false);
                        keyBucketCacheEntry.acquireExclusiveLock();
                        keyBucket = new OSBTreeBucket<K, V>(keyBucketCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
                    }
                    this.logPageChanges(keyBucket, this.fileId, bucketSearchResult.getLastPathItem(), false);
                    keyBucketCacheEntry.markDirty();
                    keyBucketCacheEntry.releaseExclusiveLock();
                    this.diskCache.release(keyBucketCacheEntry);
                    if (sizeDiff != 0) {
                        this.setSize(this.size() + (long)sizeDiff);
                    }
                    this.endAtomicOperation(false);
                    return;
                }
                catch (Throwable e) {
                    this.rollback(transaction);
                    throw new OSBTreeException(e);
                }
            }
            boolean isNew = false;
            if (this.diskCache.getFilledUpTo(this.nullBucketFileId) == 0L) {
                cacheEntry = this.diskCache.allocateNewPage(this.nullBucketFileId);
                isNew = true;
            } else {
                cacheEntry = this.diskCache.load(this.nullBucketFileId, 0L, false);
            }
            this.startAtomicOperation();
            try {
                int valueSize = this.valueSerializer.getObjectSize((Object)value, new Object[0]);
                boolean createLinkToTheValue = valueSize > MAX_EMBEDDED_VALUE_SIZE;
                long valueLink = -1L;
                if (createLinkToTheValue) {
                    valueLink = this.createLinkToTheValue(value);
                }
                OSBTreeValue<Object> treeValue = new OSBTreeValue<Object>(createLinkToTheValue, valueLink, (createLinkToTheValue ? null : value));
                int sizeDiff = 0;
                cacheEntry.acquireExclusiveLock();
                try {
                    ONullBucket<Object> nullBucket = new ONullBucket<Object>(cacheEntry, this.getTrackMode(), this.valueSerializer, isNew);
                    if (nullBucket.getValue() != null) {
                        sizeDiff = -1;
                    }
                    nullBucket.setValue(treeValue);
                    this.logPageChanges(nullBucket, this.nullBucketFileId, 0L, isNew);
                    cacheEntry.markDirty();
                }
                finally {
                    cacheEntry.releaseExclusiveLock();
                    this.diskCache.release(cacheEntry);
                }
                this.setSize(this.size() + (long)(++sizeDiff));
                this.endAtomicOperation(false);
                return;
            }
            catch (Throwable e) {
                this.rollback(transaction);
                throw new OSBTreeException(e);
            }
        }
        catch (IOException e) {
            this.rollback(transaction);
            throw new OSBTreeException("Error during index update with key " + key + " and value " + value, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void close(boolean flush) {
        this.acquireExclusiveLock();
        try {
            this.diskCache.closeFile(this.fileId, flush);
            if (this.nullPointerSupport) {
                this.diskCache.closeFile(this.nullBucketFileId, flush);
            }
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during close of index " + this.name, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.acquireExclusiveLock();
        OStorageTransaction transaction = this.storage.getStorageTransaction();
        try {
            this.startAtomicOperation();
            this.diskCache.truncateFile(this.fileId);
            if (this.nullPointerSupport) {
                this.diskCache.truncateFile(this.nullBucketFileId);
            }
            OCacheEntry cacheEntry = this.diskCache.load(this.fileId, 0L, false);
            cacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(cacheEntry, true, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
                rootBucket.setTreeSize(0L);
                this.logPageChanges(rootBucket, this.fileId, 0L, true);
                cacheEntry.markDirty();
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                this.diskCache.release(cacheEntry);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.rollback(transaction);
            throw new OSBTreeException("Error during clear of sbtree with name " + this.name, e);
        }
        catch (Throwable e) {
            this.rollback(transaction);
            throw new OSBTreeException(e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void delete() {
        this.acquireExclusiveLock();
        try {
            this.diskCache.deleteFile(this.fileId);
            if (this.nullPointerSupport) {
                this.diskCache.deleteFile(this.nullBucketFileId);
            }
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during delete of sbtree with name " + this.name, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void deleteWithoutLoad(String name, OStorageLocalAbstract storageLocal) {
        this.acquireExclusiveLock();
        try {
            ODiskCache diskCache = storageLocal.getDiskCache();
            long fileId = diskCache.openFile(name + this.dataFileExtension);
            diskCache.deleteFile(fileId);
            long nullFileId = diskCache.openFile(name + this.nullFileExtension);
            diskCache.deleteFile(nullFileId);
        }
        catch (IOException ioe) {
            throw new OSBTreeException("Exception during deletion of sbtree " + name, ioe);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void load(String name, OBinarySerializer<K> keySerializer, OStreamSerializer valueSerializer, OType[] keyTypes, OStorageLocalAbstract storageLocal, boolean nullPointerSupport) {
        this.acquireExclusiveLock();
        try {
            this.storage = storageLocal;
            this.keyTypes = keyTypes;
            this.diskCache = this.storage.getDiskCache();
            this.name = name;
            this.nullPointerSupport = nullPointerSupport;
            this.fileId = this.diskCache.openFile(name + this.dataFileExtension);
            if (nullPointerSupport) {
                this.nullBucketFileId = this.diskCache.openFile(name + this.nullFileExtension);
            }
            this.keySerializer = keySerializer;
            this.valueSerializer = (OBinarySerializer)valueSerializer;
            this.initDurableComponent(storageLocal);
        }
        catch (IOException e) {
            throw new OSBTreeException("Exception during loading of sbtree " + name, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        this.acquireSharedLock();
        try {
            OCacheEntry rootCacheEntry = this.diskCache.load(this.fileId, 0L, false);
            try {
                OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, ODurablePage.TrackMode.NONE);
                long l = rootBucket.getTreeSize();
                this.diskCache.release(rootCacheEntry);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.diskCache.release(rootCacheEntry);
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OSBTreeException("Error during retrieving of size of index " + this.name);
                }
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * Exception decompiling
     */
    public V remove(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 22[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public OSBTreeCursor<K, V> iterateEntriesMinor(K key, boolean inclusive, boolean ascSortOrder) {
        this.acquireSharedLock();
        try {
            if (!ascSortOrder) {
                OSBTreeCursor<K, V> oSBTreeCursor = this.iterateEntriesMinorDesc(key, inclusive);
                return oSBTreeCursor;
            }
            OSBTreeCursor<K, V> oSBTreeCursor = this.iterateEntriesMinorAsc(key, inclusive);
            return oSBTreeCursor;
        }
        catch (IOException ioe) {
            throw new OSBTreeException("Error during iteration of minor values for key " + key + " in sbtree " + this.name);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public OSBTreeCursor<K, V> iterateEntriesMajor(K key, boolean inclusive, boolean ascSortOrder) {
        this.acquireSharedLock();
        try {
            if (ascSortOrder) {
                OSBTreeCursor<K, V> oSBTreeCursor = this.iterateEntriesMajorAsc(key, inclusive);
                return oSBTreeCursor;
            }
            OSBTreeCursor<K, V> oSBTreeCursor = this.iterateEntriesMajorDesc(key, inclusive);
            return oSBTreeCursor;
        }
        catch (IOException ioe) {
            throw new OSBTreeException("Error during iteration of major values for key " + key + " in sbtree " + this.name);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K firstKey() {
        this.acquireSharedLock();
        try {
            K k;
            BucketSearchResult searchResult = this.firstItem();
            if (searchResult == null) {
                K k2 = null;
                return k2;
            }
            OCacheEntry cacheEntry = this.diskCache.load(this.fileId, searchResult.getLastPathItem(), false);
            try {
                OSBTreeBucket<K, V> bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, ODurablePage.TrackMode.NONE);
                k = bucket.getKey(searchResult.itemIndex);
                this.diskCache.release(cacheEntry);
            }
            catch (Throwable throwable) {
                try {
                    this.diskCache.release(cacheEntry);
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OSBTreeException("Error during finding first key in sbtree [" + this.name + "]");
                }
            }
            return k;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K lastKey() {
        this.acquireSharedLock();
        try {
            K k;
            BucketSearchResult searchResult = this.lastItem();
            if (searchResult == null) {
                K k2 = null;
                return k2;
            }
            OCacheEntry cacheEntry = this.diskCache.load(this.fileId, searchResult.getLastPathItem(), false);
            try {
                OSBTreeBucket<K, V> bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, ODurablePage.TrackMode.NONE);
                k = bucket.getKey(searchResult.itemIndex);
                this.diskCache.release(cacheEntry);
            }
            catch (Throwable throwable) {
                try {
                    this.diskCache.release(cacheEntry);
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OSBTreeException("Error during finding last key in sbtree [" + this.name + "]");
                }
            }
            return k;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public OSBTreeKeyCursor<K> keyCursor() {
        this.acquireSharedLock();
        try {
            BucketSearchResult searchResult = this.firstItem();
            if (searchResult == null) {
                OSBTreeKeyCursor oSBTreeKeyCursor = new OSBTreeKeyCursor<K>(){

                    @Override
                    public K next(int prefetchSize) {
                        return null;
                    }
                };
                return oSBTreeKeyCursor;
            }
            OSBTreeFullKeyCursor oSBTreeFullKeyCursor = new OSBTreeFullKeyCursor(searchResult.getLastPathItem());
            return oSBTreeFullKeyCursor;
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during finding first key in sbtree [" + this.name + "]");
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public OSBTreeCursor<K, V> iterateEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, boolean ascSortOrder) {
        this.acquireSharedLock();
        try {
            if (ascSortOrder) {
                OSBTreeCursor<K, V> oSBTreeCursor = this.iterateEntriesBetweenAscOrder(keyFrom, fromInclusive, keyTo, toInclusive);
                return oSBTreeCursor;
            }
            OSBTreeCursor<K, V> oSBTreeCursor = this.iterateEntriesBetweenDescOrder(keyFrom, fromInclusive, keyTo, toInclusive);
            return oSBTreeCursor;
        }
        catch (IOException ioe) {
            throw new OSBTreeException("Error during fetch of values between key " + keyFrom + " and key " + keyTo + " in sbtree " + this.name);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void flush() {
        this.acquireSharedLock();
        try {
            try {
                this.diskCache.flushBuffer();
            }
            catch (IOException e) {
                throw new OSBTreeException("Error during flush of sbtree [" + this.name + "] data");
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    protected void endAtomicOperation(boolean rollback) throws IOException {
        if (this.storage.getStorageTransaction() == null && !this.durableInNonTxMode) {
            return;
        }
        super.endAtomicOperation(rollback);
    }

    @Override
    protected void startAtomicOperation() throws IOException {
        if (this.storage.getStorageTransaction() == null && !this.durableInNonTxMode) {
            return;
        }
        super.startAtomicOperation();
    }

    @Override
    protected void logPageChanges(ODurablePage localPage, long fileId, long pageIndex, boolean isNewPage) throws IOException {
        OStorageTransaction transaction = this.storage.getStorageTransaction();
        if (transaction == null && !this.durableInNonTxMode) {
            return;
        }
        super.logPageChanges(localPage, fileId, pageIndex, isNewPage);
    }

    @Override
    protected ODurablePage.TrackMode getTrackMode() {
        OStorageTransaction transaction = this.storage.getStorageTransaction();
        if (transaction == null && !this.durableInNonTxMode) {
            return ODurablePage.TrackMode.NONE;
        }
        ODurablePage.TrackMode trackMode = super.getTrackMode();
        if (!trackMode.equals((Object)ODurablePage.TrackMode.NONE)) {
            return txTrackMode;
        }
        return trackMode;
    }

    private void initDurableComponent(OStorageLocalAbstract storageLocal) {
        this.init(storageLocal);
    }

    private void checkNullSupport(K key) {
        if (key == null && !this.nullPointerSupport) {
            throw new OSBTreeException("Null keys are not supported.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLinkedValue(long removedLink) throws IOException {
        long nextPage = removedLink;
        do {
            removedLink = nextPage;
            OCacheEntry valueEntry = this.diskCache.load(this.fileId, removedLink, false);
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(valueEntry, this.getTrackMode(), false);
                nextPage = valuePage.getNextPage();
            }
            finally {
                this.diskCache.release(valueEntry);
            }
            this.removeValuePage(removedLink);
        } while (nextPage >= 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeValuePage(long pageIndex) throws IOException {
        long prevFreeListItem;
        OCacheEntry rootCacheEntry = this.diskCache.load(this.fileId, 0L, false);
        rootCacheEntry.acquireExclusiveLock();
        OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
        try {
            prevFreeListItem = rootBucket.getValuesFreeListFirstIndex();
            rootBucket.setValuesFreeListFirstIndex(pageIndex);
            rootCacheEntry.markDirty();
            this.logPageChanges(rootBucket, this.fileId, 0L, false);
        }
        finally {
            rootCacheEntry.releaseExclusiveLock();
            this.diskCache.release(rootCacheEntry);
        }
        OCacheEntry valueEntry = this.diskCache.load(this.fileId, pageIndex, false);
        valueEntry.acquireExclusiveLock();
        try {
            OSBTreeValuePage valuePage = new OSBTreeValuePage(valueEntry, this.getTrackMode(), false);
            valuePage.setNextFreeListPage(prevFreeListItem);
            valueEntry.markDirty();
            this.logPageChanges(valuePage, this.fileId, pageIndex, false);
        }
        finally {
            valueEntry.releaseExclusiveLock();
            this.diskCache.release(valueEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createLinkToTheValue(V value) throws IOException {
        byte[] serializeValue = new byte[this.valueSerializer.getObjectSize(value, new Object[0])];
        this.valueSerializer.serializeNative(value, serializeValue, 0, new Object[0]);
        int amountOfPages = OSBTreeValuePage.calculateAmountOfPage(serializeValue.length);
        int position = 0;
        long freeListPageIndex = this.allocateValuePageFromFreeList();
        OCacheEntry cacheEntry = freeListPageIndex < 0L ? this.diskCache.allocateNewPage(this.fileId) : this.diskCache.load(this.fileId, freeListPageIndex, false);
        long valueLink = cacheEntry.getPageIndex();
        cacheEntry.acquireExclusiveLock();
        try {
            OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, this.getTrackMode(), freeListPageIndex >= 0L);
            position = valuePage.fillBinaryContent(serializeValue, position);
            valuePage.setNextFreeListPage(-1L);
            valuePage.setNextPage(-1L);
            cacheEntry.markDirty();
            if (freeListPageIndex < 0L) {
                this.logPageChanges(valuePage, this.fileId, cacheEntry.getPageIndex(), true);
            } else {
                this.logPageChanges(valuePage, this.fileId, cacheEntry.getPageIndex(), false);
            }
        }
        finally {
            cacheEntry.releaseExclusiveLock();
            this.diskCache.release(cacheEntry);
        }
        long prevPage = valueLink;
        for (int i = 1; i < amountOfPages; ++i) {
            freeListPageIndex = this.allocateValuePageFromFreeList();
            cacheEntry = freeListPageIndex < 0L ? this.diskCache.allocateNewPage(this.fileId) : this.diskCache.load(this.fileId, freeListPageIndex, false);
            cacheEntry.acquireExclusiveLock();
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, this.getTrackMode(), freeListPageIndex >= 0L);
                position = valuePage.fillBinaryContent(serializeValue, position);
                valuePage.setNextFreeListPage(-1L);
                valuePage.setNextPage(-1L);
                cacheEntry.markDirty();
                if (freeListPageIndex < 0L) {
                    this.logPageChanges(valuePage, this.fileId, cacheEntry.getPageIndex(), true);
                } else {
                    this.logPageChanges(valuePage, this.fileId, cacheEntry.getPageIndex(), false);
                }
            }
            finally {
                cacheEntry.releaseExclusiveLock();
                this.diskCache.release(cacheEntry);
            }
            OCacheEntry prevPageCacheEntry = this.diskCache.load(this.fileId, prevPage, false);
            prevPageCacheEntry.acquireExclusiveLock();
            try {
                OSBTreeValuePage valuePage = new OSBTreeValuePage(prevPageCacheEntry, this.getTrackMode(), freeListPageIndex >= 0L);
                valuePage.setNextPage(cacheEntry.getPageIndex());
                prevPageCacheEntry.markDirty();
                this.logPageChanges(valuePage, this.fileId, prevPage, false);
            }
            finally {
                prevPageCacheEntry.releaseExclusiveLock();
                this.diskCache.release(prevPageCacheEntry);
            }
            prevPage = cacheEntry.getPageIndex();
        }
        return valueLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateValuePageFromFreeList() throws IOException {
        long freeListFirstIndex;
        OCacheEntry rootCacheEntry = this.diskCache.load(this.fileId, 0L, false);
        OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, ODurablePage.TrackMode.NONE);
        try {
            freeListFirstIndex = rootBucket.getValuesFreeListFirstIndex();
        }
        finally {
            this.diskCache.release(rootCacheEntry);
        }
        if (freeListFirstIndex >= 0L) {
            OCacheEntry freePageEntry = this.diskCache.load(this.fileId, freeListFirstIndex, false);
            OSBTreeValuePage valuePage = new OSBTreeValuePage(freePageEntry, this.getTrackMode(), false);
            freePageEntry.acquireExclusiveLock();
            try {
                long nextFreeListIndex = valuePage.getNextFreeListPage();
                rootCacheEntry = this.diskCache.load(this.fileId, 0L, false);
                rootCacheEntry.acquireExclusiveLock();
                rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
                try {
                    rootBucket.setValuesFreeListFirstIndex(nextFreeListIndex);
                    rootCacheEntry.markDirty();
                    this.logPageChanges(rootBucket, this.fileId, 0L, false);
                }
                finally {
                    rootCacheEntry.releaseExclusiveLock();
                    this.diskCache.release(rootCacheEntry);
                }
                valuePage.setNextFreeListPage(-1L);
                freePageEntry.markDirty();
                this.logPageChanges(valuePage, this.fileId, freePageEntry.getPageIndex(), false);
            }
            finally {
                freePageEntry.releaseExclusiveLock();
                this.diskCache.release(freePageEntry);
            }
            return freePageEntry.getPageIndex();
        }
        return -1L;
    }

    private void rollback(OStorageTransaction transaction) {
        try {
            this.endAtomicOperation(true);
        }
        catch (IOException e1) {
            OLogManager.instance().error((Object)this, "Error during sbtree operation  rollback", (Throwable)e1, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSize(long size) throws IOException {
        OCacheEntry rootCacheEntry = this.diskCache.load(this.fileId, 0L, false);
        rootCacheEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket<K, V> rootBucket = new OSBTreeBucket<K, V>(rootCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
            rootBucket.setTreeSize(size);
            this.logPageChanges(rootBucket, this.fileId, 0L, false);
            rootCacheEntry.markDirty();
        }
        finally {
            rootCacheEntry.releaseExclusiveLock();
            this.diskCache.release(rootCacheEntry);
        }
    }

    private OSBTreeCursor<K, V> iterateEntriesMinorDesc(K key, boolean inclusive) throws IOException {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorDesc(key, inclusive);
        BucketSearchResult bucketSearchResult = this.findBucket(key);
        long pageIndex = bucketSearchResult.getLastPathItem();
        int index = bucketSearchResult.itemIndex >= 0 ? (inclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex - 1) : -bucketSearchResult.itemIndex - 2;
        return new OSBTreeCursorBackward(pageIndex, index, null, key, false, inclusive);
    }

    private OSBTreeCursor<K, V> iterateEntriesMinorAsc(K key, boolean inclusive) throws IOException {
        BucketSearchResult searchResult;
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorAsc(key, inclusive);
        this.acquireSharedLock();
        try {
            searchResult = this.firstItem();
            if (searchResult == null) {
                OSBTreeCursor oSBTreeCursor = new OSBTreeCursor<K, V>(){

                    @Override
                    public Map.Entry<K, V> next(int prefetchSize) {
                        return null;
                    }
                };
                return oSBTreeCursor;
            }
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during finding first key in sbtree [" + this.name + "]");
        }
        finally {
            this.releaseSharedLock();
        }
        return new OSBTreeCursorForward(searchResult.getLastPathItem(), searchResult.itemIndex, null, key, false, inclusive);
    }

    private K enhanceCompositeKeyMinorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMinorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private OSBTreeCursor<K, V> iterateEntriesMajorAsc(K key, boolean inclusive) throws IOException {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorAsc(key, inclusive);
        BucketSearchResult bucketSearchResult = this.findBucket(key);
        long pageIndex = bucketSearchResult.getLastPathItem();
        int index = bucketSearchResult.itemIndex >= 0 ? (inclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex + 1) : -bucketSearchResult.itemIndex - 1;
        return new OSBTreeCursorForward(pageIndex, index, key, null, inclusive, false);
    }

    private OSBTreeCursor<K, V> iterateEntriesMajorDesc(K key, boolean inclusive) throws IOException {
        BucketSearchResult searchResult;
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorDesc(key, inclusive);
        this.acquireSharedLock();
        try {
            searchResult = this.lastItem();
            if (searchResult == null) {
                OSBTreeCursor oSBTreeCursor = new OSBTreeCursor<K, V>(){

                    @Override
                    public Map.Entry<K, V> next(int prefetchSize) {
                        return null;
                    }
                };
                return oSBTreeCursor;
            }
        }
        catch (IOException e) {
            throw new OSBTreeException("Error during finding last key in sbtree [" + this.name + "]");
        }
        finally {
            this.releaseSharedLock();
        }
        return new OSBTreeCursorBackward(searchResult.getLastPathItem(), searchResult.itemIndex, key, null, inclusive, false);
    }

    private K enhanceCompositeKeyMajorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMajorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult firstItem() throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = this.diskCache.load(this.fileId, bucketIndex, false);
        int itemIndex = 0;
        OSBTreeBucket<K, V> bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, ODurablePage.TrackMode.NONE);
        try {
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (bucket.isEmpty() || itemIndex > bucket.size()) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex + 1;
                    } else {
                        OSBTreeBucket.SBTreeEntry<K, V> entry;
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        if (itemIndex < bucket.size()) {
                            entry = bucket.getEntry(itemIndex);
                            bucketIndex = entry.leftChild;
                        } else {
                            entry = bucket.getEntry(itemIndex - 1);
                            bucketIndex = entry.rightChild;
                        }
                        itemIndex = 0;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex + 1;
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    Object object = path.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            resultPath.add(bucketIndex);
                            object = new BucketSearchResult(0, resultPath);
                            return object;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)object.next();
                        resultPath.add(pathItemUnit.pageIndex);
                    }
                }
                this.diskCache.release(cacheEntry);
                cacheEntry = this.diskCache.load(this.fileId, bucketIndex, false);
                bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, ODurablePage.TrackMode.NONE);
            }
        }
        finally {
            this.diskCache.release(cacheEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult lastItem() throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = this.diskCache.load(this.fileId, bucketIndex, false);
        OSBTreeBucket<K, V> bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, ODurablePage.TrackMode.NONE);
        int itemIndex = bucket.size() - 1;
        try {
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (itemIndex < -1) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex - 1;
                    } else {
                        OSBTreeBucket.SBTreeEntry<K, V> entry;
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        if (itemIndex > -1) {
                            entry = bucket.getEntry(itemIndex);
                            bucketIndex = entry.rightChild;
                        } else {
                            entry = bucket.getEntry(0);
                            bucketIndex = entry.leftChild;
                        }
                        itemIndex = OSBTreeBucket.MAX_PAGE_SIZE_BYTES + 1;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex - 1;
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    Object object = path.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            resultPath.add(bucketIndex);
                            object = new BucketSearchResult(bucket.size() - 1, resultPath);
                            return object;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)object.next();
                        resultPath.add(pathItemUnit.pageIndex);
                    }
                }
                this.diskCache.release(cacheEntry);
                cacheEntry = this.diskCache.load(this.fileId, bucketIndex, false);
                bucket = new OSBTreeBucket<K, V>(cacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, ODurablePage.TrackMode.NONE);
                if (itemIndex != OSBTreeBucket.MAX_PAGE_SIZE_BYTES + 1) continue;
                itemIndex = bucket.size() - 1;
            }
        }
        finally {
            this.diskCache.release(cacheEntry);
        }
    }

    private OSBTreeCursor<K, V> iterateEntriesBetweenAscOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) throws IOException {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenAsc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenAsc(keyTo, toInclusive);
        BucketSearchResult bucketSearchResultFrom = this.findBucket(keyFrom);
        long pageIndexFrom = bucketSearchResultFrom.getLastPathItem();
        int indexFrom = bucketSearchResultFrom.itemIndex >= 0 ? (fromInclusive ? bucketSearchResultFrom.itemIndex : bucketSearchResultFrom.itemIndex + 1) : -bucketSearchResultFrom.itemIndex - 1;
        return new OSBTreeCursorForward(pageIndexFrom, indexFrom, keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private OSBTreeCursor<K, V> iterateEntriesBetweenDescOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) throws IOException {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenDesc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenDesc(keyTo, toInclusive);
        BucketSearchResult bucketSearchResultTo = this.findBucket(keyTo);
        long pageIndexTo = bucketSearchResultTo.getLastPathItem();
        int indexTo = bucketSearchResultTo.itemIndex >= 0 ? (toInclusive ? bucketSearchResultTo.itemIndex : bucketSearchResultTo.itemIndex - 1) : -bucketSearchResultTo.itemIndex - 2;
        return new OSBTreeCursorBackward(pageIndexTo, indexTo, keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private K enhanceToCompositeKeyBetweenAsc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenAsc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private K enhanceToCompositeKeyBetweenDesc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenDesc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitBucket(List<Long> path, int keyIndex, K keyToInsert) throws IOException {
        long pageIndex = path.get(path.size() - 1);
        OCacheEntry bucketEntry = this.diskCache.load(this.fileId, pageIndex, false);
        bucketEntry.acquireExclusiveLock();
        try {
            int startRightIndex;
            OSBTreeBucket<K, V> bucketToSplit = new OSBTreeBucket<K, V>(bucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
            boolean splitLeaf = bucketToSplit.isLeaf();
            int bucketSize = bucketToSplit.size();
            int indexToSplit = bucketSize >>> 1;
            K separationKey = bucketToSplit.getKey(indexToSplit);
            ArrayList<OSBTreeBucket.SBTreeEntry<K, V>> rightEntries = new ArrayList<OSBTreeBucket.SBTreeEntry<K, V>>(indexToSplit);
            for (int i = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getEntry(i));
            }
            if (pageIndex != 0L) {
                BucketSearchResult bucketSearchResult = this.splitNonRootBucket(path, keyIndex, keyToInsert, pageIndex, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries);
                return bucketSearchResult;
            }
            BucketSearchResult bucketSearchResult = this.splitRootBucket(path, keyIndex, keyToInsert, pageIndex, bucketEntry, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries);
            return bucketSearchResult;
        }
        finally {
            bucketEntry.releaseExclusiveLock();
            this.diskCache.release(bucketEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitNonRootBucket(List<Long> path, int keyIndex, K keyToInsert, long pageIndex, OSBTreeBucket<K, V> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<OSBTreeBucket.SBTreeEntry<K, V>> rightEntries) throws IOException {
        OCacheEntry rightBucketEntry = this.diskCache.allocateNewPage(this.fileId);
        rightBucketEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket<K, V> newRightBucket = new OSBTreeBucket<K, V>(rightBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
            newRightBucket.addAll(rightEntries);
            bucketToSplit.shrink(indexToSplit);
            if (splitLeaf) {
                long rightSiblingPageIndex = bucketToSplit.getRightSibling();
                newRightBucket.setRightSibling(rightSiblingPageIndex);
                newRightBucket.setLeftSibling(pageIndex);
                bucketToSplit.setRightSibling(rightBucketEntry.getPageIndex());
                if (rightSiblingPageIndex >= 0L) {
                    OCacheEntry rightSiblingBucketEntry = this.diskCache.load(this.fileId, rightSiblingPageIndex, false);
                    rightSiblingBucketEntry.acquireExclusiveLock();
                    OSBTreeBucket<K, V> rightSiblingBucket = new OSBTreeBucket<K, V>(rightSiblingBucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
                    try {
                        rightSiblingBucket.setLeftSibling(rightBucketEntry.getPageIndex());
                        this.logPageChanges(rightSiblingBucket, this.fileId, rightSiblingPageIndex, false);
                        rightSiblingBucketEntry.markDirty();
                    }
                    finally {
                        rightSiblingBucketEntry.releaseExclusiveLock();
                        this.diskCache.release(rightSiblingBucketEntry);
                    }
                }
            }
            long parentIndex = path.get(path.size() - 2);
            OCacheEntry parentCacheEntry = this.diskCache.load(this.fileId, parentIndex, false);
            parentCacheEntry.acquireExclusiveLock();
            try {
                OSBTreeBucket parentBucket = new OSBTreeBucket(parentCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
                OSBTreeBucket.SBTreeEntry parentEntry = new OSBTreeBucket.SBTreeEntry(pageIndex, rightBucketEntry.getPageIndex(), separationKey, null);
                int insertionIndex = parentBucket.find(separationKey);
                assert (insertionIndex < 0);
                insertionIndex = -insertionIndex - 1;
                while (!parentBucket.addEntry(insertionIndex, parentEntry, true)) {
                    parentCacheEntry.releaseExclusiveLock();
                    this.diskCache.release(parentCacheEntry);
                    BucketSearchResult bucketSearchResult = this.splitBucket(path.subList(0, path.size() - 1), insertionIndex, separationKey);
                    parentIndex = bucketSearchResult.getLastPathItem();
                    parentCacheEntry = this.diskCache.load(this.fileId, parentIndex, false);
                    parentCacheEntry.acquireExclusiveLock();
                    insertionIndex = bucketSearchResult.itemIndex;
                    parentBucket = new OSBTreeBucket<K, V>(parentCacheEntry, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
                }
                this.logPageChanges(parentBucket, this.fileId, parentIndex, false);
            }
            finally {
                parentCacheEntry.releaseExclusiveLock();
                this.diskCache.release(parentCacheEntry);
            }
            this.logPageChanges(newRightBucket, this.fileId, rightBucketEntry.getPageIndex(), true);
        }
        finally {
            rightBucketEntry.markDirty();
            rightBucketEntry.releaseExclusiveLock();
            this.diskCache.release(rightBucketEntry);
        }
        this.logPageChanges(bucketToSplit, this.fileId, pageIndex, false);
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        if (this.comparator.compare(keyToInsert, separationKey) < 0) {
            resultPath.add(pageIndex);
            return new BucketSearchResult(keyIndex, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        if (splitLeaf) {
            return new BucketSearchResult(keyIndex - indexToSplit, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        return new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitRootBucket(List<Long> path, int keyIndex, K keyToInsert, long pageIndex, OCacheEntry bucketEntry, OSBTreeBucket<K, V> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<OSBTreeBucket.SBTreeEntry<K, V>> rightEntries) throws IOException {
        long freeListPage = bucketToSplit.getValuesFreeListFirstIndex();
        long treeSize = bucketToSplit.getTreeSize();
        ArrayList leftEntries = new ArrayList(indexToSplit);
        for (int i = 0; i < indexToSplit; ++i) {
            leftEntries.add(bucketToSplit.getEntry(i));
        }
        OCacheEntry leftBucketEntry = this.diskCache.allocateNewPage(this.fileId);
        OCacheEntry rightBucketEntry = this.diskCache.allocateNewPage(this.fileId);
        leftBucketEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket newLeftBucket = new OSBTreeBucket(leftBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
            newLeftBucket.addAll(leftEntries);
            if (splitLeaf) {
                newLeftBucket.setRightSibling(rightBucketEntry.getPageIndex());
            }
            this.logPageChanges(newLeftBucket, this.fileId, leftBucketEntry.getPageIndex(), true);
        }
        finally {
            leftBucketEntry.releaseExclusiveLock();
            this.diskCache.release(leftBucketEntry);
        }
        rightBucketEntry.acquireExclusiveLock();
        try {
            OSBTreeBucket<K, V> newRightBucket = new OSBTreeBucket<K, V>(rightBucketEntry, splitLeaf, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
            newRightBucket.addAll(rightEntries);
            if (splitLeaf) {
                newRightBucket.setLeftSibling(leftBucketEntry.getPageIndex());
            }
            this.logPageChanges(newRightBucket, this.fileId, rightBucketEntry.getPageIndex(), true);
            rightBucketEntry.markDirty();
        }
        finally {
            rightBucketEntry.releaseExclusiveLock();
            this.diskCache.release(rightBucketEntry);
        }
        bucketToSplit = new OSBTreeBucket<K, V>(bucketEntry, false, this.keySerializer, this.keyTypes, this.valueSerializer, this.getTrackMode());
        bucketToSplit.setTreeSize(treeSize);
        bucketToSplit.setValuesFreeListFirstIndex(freeListPage);
        bucketToSplit.addEntry(0, new OSBTreeBucket.SBTreeEntry(leftBucketEntry.getPageIndex(), rightBucketEntry.getPageIndex(), separationKey, null), true);
        this.logPageChanges(bucketToSplit, this.fileId, pageIndex, false);
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        if (this.comparator.compare(keyToInsert, separationKey) < 0) {
            resultPath.add(leftBucketEntry.getPageIndex());
            return new BucketSearchResult(keyIndex, resultPath);
        }
        resultPath.add(rightBucketEntry.getPageIndex());
        if (splitLeaf) {
            return new BucketSearchResult(keyIndex - indexToSplit, resultPath);
        }
        return new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key) throws IOException {
        long pageIndex = 0L;
        ArrayList<Long> path = new ArrayList<Long>();
        while (true) {
            OSBTreeBucket.SBTreeEntry<K, V> entry;
            path.add(pageIndex);
            OCacheEntry bucketEntry = this.diskCache.load(this.fileId, pageIndex, false);
            try {
                int insertionIndex;
                OSBTreeBucket<K, V> keyBucket = new OSBTreeBucket<K, V>(bucketEntry, this.keySerializer, this.keyTypes, this.valueSerializer, ODurablePage.TrackMode.NONE);
                int index = keyBucket.find(key);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, path);
                    return bucketSearchResult;
                }
                entry = index >= 0 ? keyBucket.getEntry(index) : ((insertionIndex = -index - 1) >= keyBucket.size() ? keyBucket.getEntry(insertionIndex - 1) : keyBucket.getEntry(insertionIndex));
            }
            finally {
                this.diskCache.release(bucketEntry);
            }
            if (this.comparator.compare(key, entry.key) >= 0) {
                pageIndex = entry.rightChild;
                continue;
            }
            pageIndex = entry.leftChild;
        }
    }

    private K enhanceCompositeKey(K key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        if (this.keySize != 1 && compositeKey.getKeys().size() != this.keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = this.keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return (K)fullKey;
        }
        return key;
    }

    private V readValue(OSBTreeValue<V> sbTreeValue) throws IOException {
        if (!sbTreeValue.isLink()) {
            return sbTreeValue.getValue();
        }
        OCacheEntry cacheEntry = this.diskCache.load(this.fileId, sbTreeValue.getLink(), false);
        OSBTreeValuePage valuePage = new OSBTreeValuePage(cacheEntry, ODurablePage.TrackMode.NONE, false);
        int totalSize = valuePage.getSize();
        int currentSize = 0;
        byte[] value = new byte[totalSize];
        while (currentSize < totalSize) {
            currentSize = valuePage.readBinaryContent(value, currentSize);
            long nextPage = valuePage.getNextPage();
            if (nextPage < 0L) continue;
            this.diskCache.release(cacheEntry);
            cacheEntry = this.diskCache.load(this.fileId, nextPage, false);
            valuePage = new OSBTreeValuePage(cacheEntry, ODurablePage.TrackMode.NONE, false);
        }
        this.diskCache.release(cacheEntry);
        return (V)this.valueSerializer.deserializeNative(value, 0);
    }

    private Map.Entry<K, V> convertToMapEntry(OSBTreeBucket.SBTreeEntry<K, V> treeEntry) throws IOException {
        final Object key = treeEntry.key;
        final Object value = this.readValue(treeEntry.value);
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException("setValue");
            }
        };
    }

    private final class OSBTreeCursorBackward
    implements OSBTreeCursor<K, V> {
        private final K fromKey;
        private final K toKey;
        private final boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private long pageIndex;
        private int itemIndex;
        private List<Map.Entry<K, V>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, V>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorBackward(long endPageIndex, int endItemIndex, K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            this.pageIndex = endPageIndex;
            this.itemIndex = endItemIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next(int prefetchSize) {
            if (this.dataCacheIterator == null) {
                return null;
            }
            if (this.dataCacheIterator.hasNext()) {
                return this.dataCacheIterator.next();
            }
            this.dataCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            OSBTree.this.acquireSharedLock();
            try {
                while (this.dataCache.size() < prefetchSize) {
                    if (this.pageIndex >= OSBTree.this.diskCache.getFilledUpTo(OSBTree.this.fileId)) {
                        this.pageIndex = OSBTree.this.diskCache.getFilledUpTo(OSBTree.this.fileId) - 1L;
                    }
                    if (this.pageIndex == -1L) {
                        break;
                    }
                    OCacheEntry cacheEntry = OSBTree.this.diskCache.load(OSBTree.this.fileId, this.pageIndex, false);
                    try {
                        OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, ODurablePage.TrackMode.NONE);
                        if (this.itemIndex >= bucket.size()) {
                            this.itemIndex = bucket.size() - 1;
                        }
                        if (this.itemIndex < 0) {
                            this.pageIndex = bucket.getLeftSibling();
                            this.itemIndex = Integer.MAX_VALUE;
                            continue;
                        }
                        Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(this.itemIndex));
                        --this.itemIndex;
                        if (this.toKey != null && (!this.toKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.toKey) >= 0 : OSBTree.this.comparator.compare(entry.getKey(), this.toKey) > 0)) continue;
                        if (this.fromKey != null && (this.fromKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) < 0 : OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) <= 0)) {
                            this.pageIndex = -1L;
                            break;
                        }
                        this.dataCache.add(entry);
                    }
                    finally {
                        OSBTree.this.diskCache.release(cacheEntry);
                    }
                }
            }
            catch (IOException e) {
                throw new OSBTreeException("Error during element iteration", e);
            }
            finally {
                OSBTree.this.releaseSharedLock();
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            return this.dataCacheIterator.next();
        }
    }

    private final class OSBTreeCursorForward
    implements OSBTreeCursor<K, V> {
        private final K fromKey;
        private final K toKey;
        private final boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private long pageIndex;
        private int itemIndex;
        private List<Map.Entry<K, V>> dataCache = new ArrayList();
        private Iterator<Map.Entry<K, V>> dataCacheIterator = OEmptyMapEntryIterator.INSTANCE;

        private OSBTreeCursorForward(long startPageIndex, int startItemIndex, K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            this.pageIndex = startPageIndex;
            this.itemIndex = startItemIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next(int prefetchSize) {
            if (this.dataCacheIterator == null) {
                return null;
            }
            if (this.dataCacheIterator.hasNext()) {
                return this.dataCacheIterator.next();
            }
            this.dataCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            if (prefetchSize == 0) {
                prefetchSize = 1;
            }
            OSBTree.this.acquireSharedLock();
            try {
                while (this.dataCache.size() < prefetchSize) {
                    if (this.pageIndex == -1L) {
                        break;
                    }
                    if (this.pageIndex >= OSBTree.this.diskCache.getFilledUpTo(OSBTree.this.fileId)) {
                        this.pageIndex = -1L;
                        break;
                    }
                    OCacheEntry cacheEntry = OSBTree.this.diskCache.load(OSBTree.this.fileId, this.pageIndex, false);
                    try {
                        OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, ODurablePage.TrackMode.NONE);
                        if (this.itemIndex >= bucket.size()) {
                            this.pageIndex = bucket.getRightSibling();
                            this.itemIndex = 0;
                            continue;
                        }
                        Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(this.itemIndex));
                        ++this.itemIndex;
                        if (this.fromKey != null && (!this.fromKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) <= 0 : OSBTree.this.comparator.compare(entry.getKey(), this.fromKey) < 0)) continue;
                        if (this.toKey != null && (this.toKeyInclusive ? OSBTree.this.comparator.compare(entry.getKey(), this.toKey) > 0 : OSBTree.this.comparator.compare(entry.getKey(), this.toKey) >= 0)) {
                            this.pageIndex = -1L;
                            break;
                        }
                        this.dataCache.add(entry);
                    }
                    finally {
                        OSBTree.this.diskCache.release(cacheEntry);
                    }
                }
            }
            catch (IOException e) {
                throw new OSBTreeException("Error during element iteration", e);
            }
            finally {
                OSBTree.this.releaseSharedLock();
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return null;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            return this.dataCacheIterator.next();
        }
    }

    public class OSBTreeFullKeyCursor
    implements OSBTreeKeyCursor<K> {
        private long pageIndex;
        private int itemIndex;
        private List<K> keysCache = new ArrayList();
        private Iterator<K> keysIterator = new OEmptyIterator();

        public OSBTreeFullKeyCursor(long startPageIndex) {
            this.pageIndex = startPageIndex;
            this.itemIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K next(int prefetchSize) {
            if (this.keysIterator == null) {
                return null;
            }
            if (this.keysIterator.hasNext()) {
                return this.keysIterator.next();
            }
            this.keysCache.clear();
            if (prefetchSize < 0 || prefetchSize > OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger()) {
                prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            }
            if (prefetchSize == 0) {
                prefetchSize = 1;
            }
            OSBTree.this.acquireSharedLock();
            try {
                while (this.keysCache.size() < prefetchSize) {
                    if (this.pageIndex == -1L) {
                        break;
                    }
                    if (this.pageIndex >= OSBTree.this.diskCache.getFilledUpTo(OSBTree.this.fileId)) {
                        this.pageIndex = -1L;
                        break;
                    }
                    OCacheEntry cacheEntry = OSBTree.this.diskCache.load(OSBTree.this.fileId, this.pageIndex, false);
                    try {
                        OSBTreeBucket bucket = new OSBTreeBucket(cacheEntry, OSBTree.this.keySerializer, OSBTree.this.keyTypes, OSBTree.this.valueSerializer, ODurablePage.TrackMode.NONE);
                        if (this.itemIndex >= bucket.size()) {
                            this.pageIndex = bucket.getRightSibling();
                            this.itemIndex = 0;
                            continue;
                        }
                        Map.Entry entry = OSBTree.this.convertToMapEntry(bucket.getEntry(this.itemIndex));
                        ++this.itemIndex;
                        this.keysCache.add(entry.getKey());
                    }
                    finally {
                        OSBTree.this.diskCache.release(cacheEntry);
                    }
                }
            }
            catch (IOException e) {
                throw new OSBTreeException("Error during element iteration", e);
            }
            finally {
                OSBTree.this.releaseSharedLock();
            }
            if (this.keysCache.isEmpty()) {
                this.keysCache = null;
                return null;
            }
            this.keysIterator = this.keysCache.iterator();
            return this.keysIterator.next();
        }
    }

    private static final class PagePathItemUnit {
        private final long pageIndex;
        private final int itemIndex;

        private PagePathItemUnit(long pageIndex, int itemIndex) {
            this.pageIndex = pageIndex;
            this.itemIndex = itemIndex;
        }
    }

    private static class BucketSearchResult {
        private final int itemIndex;
        private final ArrayList<Long> path;

        private BucketSearchResult(int itemIndex, ArrayList<Long> path) {
            this.itemIndex = itemIndex;
            this.path = path;
        }

        public long getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }
    }

    public static interface OSBTreeKeyCursor<K> {
        public K next(int var1);
    }

    public static interface OSBTreeCursor<K, V> {
        public Map.Entry<K, V> next(int var1);
    }

    private static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

