/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local.cache;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OAllCacheEntriesAreUsedException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.index.hashindex.local.cache.WriteGroup;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODirtyPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;

public class OWOWCache {
    public static final int PAGE_PADDING = 8;
    public static final String NAME_ID_MAP_EXTENSION = ".cm";
    private static final String NAME_ID_MAP = "name_id_map.cm";
    public static final int MIN_CACHE_SIZE = 16;
    public static final long MAGIC_NUMBER = 4207608830L;
    private final ConcurrentSkipListMap<GroupKey, WriteGroup> writeGroups = new ConcurrentSkipListMap();
    private final OBinarySerializer<String> stringSerializer;
    private final Map<Long, OFileClassic> files;
    private final boolean syncOnPageFlush;
    private final int pageSize;
    private final long groupTTL;
    private final OWriteAheadLog writeAheadLog;
    private final AtomicInteger cacheSize = new AtomicInteger();
    private final OLockManager<GroupKey, Thread> lockManager = new OLockManager(true, OGlobalConfiguration.DISK_WRITE_CACHE_FLUSH_LOCK_TIMEOUT.getValueAsInteger());
    private final OStorageLocalAbstract storageLocal;
    private final Object syncObject = new Object();
    private final ScheduledExecutorService commitExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("OrientDB Write Cache Flush Task (" + OWOWCache.this.storageLocal.getName() + ")");
            return thread;
        }
    });
    private Map<String, Long> nameIdMap;
    private RandomAccessFile nameIdMapHolder;
    private volatile int cacheMaxSize;
    private long fileCounter = 0L;
    private GroupKey lastGroupKey = new GroupKey(0L, -1L);
    private File nameIdMapHolderFile;

    public OWOWCache(boolean syncOnPageFlush, int pageSize, long groupTTL, OWriteAheadLog writeAheadLog, long pageFlushInterval, int cacheMaxSize, OStorageLocalAbstract storageLocal, boolean checkMinSize) {
        this.files = new ConcurrentHashMap<Long, OFileClassic>();
        this.syncOnPageFlush = syncOnPageFlush;
        this.pageSize = pageSize;
        this.groupTTL = groupTTL;
        this.writeAheadLog = writeAheadLog;
        this.cacheMaxSize = cacheMaxSize;
        this.storageLocal = storageLocal;
        OBinarySerializerFactory binarySerializerFactory = storageLocal.getComponentsFactory().binarySerializerFactory;
        this.stringSerializer = binarySerializerFactory.getObjectSerializer(OType.STRING);
        if (checkMinSize && this.cacheMaxSize < 16) {
            this.cacheMaxSize = 16;
        }
        if (pageFlushInterval > 0L) {
            this.commitExecutor.scheduleWithFixedDelay(new PeriodicFlushTask(), pageFlushInterval, pageFlushInterval, TimeUnit.MILLISECONDS);
        }
    }

    private static int calculatePageCrc(byte[] pageData) {
        int systemSize = 12;
        CRC32 crc32 = new CRC32();
        crc32.update(pageData, systemSize, pageData.length - systemSize);
        return (int)crc32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long openFile(String fileName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.initNameIdMapping();
            Long fileId = this.nameIdMap.get(fileName);
            OFileClassic fileClassic = fileId == null ? null : this.files.get(fileId);
            if (fileClassic == null) {
                fileId = ++this.fileCounter;
                fileClassic = this.createFile(fileName);
                this.files.put(fileId, fileClassic);
                this.nameIdMap.put(fileName, fileId);
                this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            }
            this.openFile(fileClassic);
            return fileId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void openFile(String fileName, long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            OFileClassic fileClassic;
            this.initNameIdMapping();
            Long existingFileId = this.nameIdMap.get(fileName);
            if (existingFileId != null) {
                if (existingFileId != fileId) throw new OStorageException("File with given name already exists but has different id " + existingFileId + " vs. proposed " + fileId);
                fileClassic = this.files.get(fileId);
            } else {
                if (this.fileCounter < fileId) {
                    this.fileCounter = fileId;
                }
                fileClassic = this.createFile(fileName);
                this.files.put(fileId, fileClassic);
                this.nameIdMap.put(fileName, fileId);
                this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId), true);
            }
            this.openFile(fileClassic);
            return;
        }
    }

    public void lock() throws IOException {
        for (OFileClassic file : this.files.values()) {
            file.lock();
        }
    }

    public void unlock() throws IOException {
        for (OFileClassic file : this.files.values()) {
            file.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.initNameIdMapping();
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic == null) {
                throw new OStorageException("File with id " + fileId + " does not exist.");
            }
            this.openFile(fileClassic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String fileName) {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.nameIdMap != null && this.nameIdMap.containsKey(fileName)) {
                return true;
            }
            File file = new File(this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName));
            return file.exists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(long fileId) {
        Object object = this.syncObject;
        synchronized (object) {
            OFileClassic file = this.files.get(fileId);
            if (file == null) {
                return false;
            }
            return file.exists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future store(long fileId, long pageIndex, OCachePointer dataPointer) {
        Future<?> future = null;
        Object object = this.syncObject;
        synchronized (object) {
            GroupKey groupKey = new GroupKey(fileId, pageIndex >>> 4);
            this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)groupKey, OLockManager.LOCK.EXCLUSIVE);
            try {
                int entryIndex;
                WriteGroup writeGroup = this.writeGroups.get(groupKey);
                if (writeGroup == null) {
                    writeGroup = new WriteGroup(System.currentTimeMillis());
                    this.writeGroups.put(groupKey, writeGroup);
                }
                if (writeGroup.pages[entryIndex = (int)(pageIndex & 0xFL)] == null) {
                    dataPointer.incrementReferrer();
                    writeGroup.pages[entryIndex] = dataPointer;
                    this.cacheSize.incrementAndGet();
                } else if (!writeGroup.pages[entryIndex].equals(dataPointer)) {
                    writeGroup.pages[entryIndex].decrementReferrer();
                    dataPointer.incrementReferrer();
                    writeGroup.pages[entryIndex] = dataPointer;
                }
                writeGroup.recencyBit = true;
            }
            finally {
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)groupKey, OLockManager.LOCK.EXCLUSIVE);
            }
            if (this.cacheSize.get() > this.cacheMaxSize) {
                future = this.commitExecutor.submit(new PeriodicFlushTask());
            }
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OCachePointer load(long fileId, long pageIndex) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            GroupKey groupKey = new GroupKey(fileId, pageIndex >>> 4);
            this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)groupKey, OLockManager.LOCK.SHARED);
            try {
                WriteGroup writeGroup = this.writeGroups.get(groupKey);
                if (writeGroup == null) {
                    OCachePointer pagePointer = this.cacheFileContent(fileId, pageIndex);
                    pagePointer.incrementReferrer();
                    OCachePointer oCachePointer = pagePointer;
                    return oCachePointer;
                }
                int entryIndex = (int)(pageIndex & 0xFL);
                OCachePointer pagePointer = writeGroup.pages[entryIndex];
                if (pagePointer == null) {
                    pagePointer = this.cacheFileContent(fileId, pageIndex);
                }
                pagePointer.incrementReferrer();
                OCachePointer oCachePointer = pagePointer;
                return oCachePointer;
            }
            finally {
                this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)groupKey, OLockManager.LOCK.SHARED);
            }
        }
    }

    public void flush(long fileId) {
        Future<Void> future = this.commitExecutor.submit(new FileFlushTask(fileId));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OException("File flush was interrupted", (Throwable)e);
        }
        catch (Exception e) {
            throw new OException("File flush was abnormally terminated", (Throwable)e);
        }
    }

    public void flush() {
        for (long fileId : this.files.keySet()) {
            this.flush(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFilledUpTo(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            return this.files.get(fileId).getFilledUpTo() / (long)this.pageSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen(long fileId) {
        Object object = this.syncObject;
        synchronized (object) {
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic != null) {
                return fileClassic.isOpen();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long isOpen(String fileName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.initNameIdMapping();
            Long fileId = this.nameIdMap.get(fileName);
            if (fileId == null) {
                return -1L;
            }
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic == null || !fileClassic.isOpen()) {
                return -1L;
            }
            return fileId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftlyClosed(long fileId, boolean softlyClosed) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic != null && fileClassic.isOpen()) {
                fileClassic.setSoftlyClosed(softlyClosed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            for (long fileId : this.files.keySet()) {
                this.setSoftlyClosed(fileId, softlyClosed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasSoftlyClosed(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic == null) {
                return false;
            }
            return fileClassic.wasSoftlyClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            String name = this.doDeleteFile(fileId);
            if (name != null) {
                this.nameIdMap.remove(name);
                this.writeNameIdEntry(new NameFileIdEntry(name, -1L), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateFile(long fileId) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this.removeCachedPages(fileId);
            this.files.get(fileId).shrink(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFile(long fileId, String oldFileName, String newFileName) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.files.containsKey(fileId)) {
                return;
            }
            OFileClassic file = this.files.get(fileId);
            String osFileName = file.getName();
            if (osFileName.startsWith(oldFileName)) {
                File newFile = new File(this.storageLocal.getStoragePath() + File.separator + newFileName + osFileName.substring(osFileName.lastIndexOf(oldFileName) + oldFileName.length()));
                boolean renamed = file.renameTo(newFile);
                while (!renamed) {
                    OMemoryWatchDog.freeMemoryForResourceCleanup(100L);
                    renamed = file.renameTo(newFile);
                }
            }
            this.nameIdMap.remove(oldFileName);
            this.nameIdMap.put(newFileName, fileId);
            this.writeNameIdEntry(new NameFileIdEntry(oldFileName, -1L), false);
            this.writeNameIdEntry(new NameFileIdEntry(newFileName, fileId), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.flush();
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OException("Background data flush task can not be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                Thread.interrupted();
                throw new OException("Data flush thread was interrupted", (Throwable)e);
            }
        }
        Object object = this.syncObject;
        synchronized (object) {
            for (OFileClassic oFileClassic : this.files.values()) {
                if (!oFileClassic.isOpen()) continue;
                oFileClassic.close();
            }
            if (this.nameIdMapHolder != null) {
                this.nameIdMapHolder.setLength(0L);
                for (Map.Entry entry : this.nameIdMap.entrySet()) {
                    this.writeNameIdEntry(new NameFileIdEntry((String)entry.getKey(), (Long)entry.getValue()), false);
                }
                this.nameIdMapHolder.getFD().sync();
                this.nameIdMapHolder.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ODirtyPage> logDirtyPagesTable() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.writeAheadLog == null) {
                return Collections.emptySet();
            }
            HashSet<ODirtyPage> logDirtyPages = new HashSet<ODirtyPage>(this.writeGroups.size() * 16);
            for (Map.Entry<GroupKey, WriteGroup> writeGroupEntry : this.writeGroups.entrySet()) {
                GroupKey groupKey = writeGroupEntry.getKey();
                WriteGroup writeGroup = writeGroupEntry.getValue();
                for (int i = 0; i < 16; ++i) {
                    OCachePointer cachePointer = writeGroup.pages[i];
                    if (cachePointer == null) continue;
                    OLogSequenceNumber lastFlushedLSN = cachePointer.getLastFlushedLsn();
                    String fileName = this.files.get(groupKey.fileId).getName();
                    long pageIndex = (groupKey.groupIndex << 4) + (long)i;
                    ODirtyPage logDirtyPage = new ODirtyPage(fileName, pageIndex, lastFlushedLSN);
                    logDirtyPages.add(logDirtyPage);
                }
            }
            this.writeAheadLog.logDirtyPages(logDirtyPages);
            return logDirtyPages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long fileId, boolean flush) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            if (flush) {
                this.flush(fileId);
            } else {
                this.removeCachedPages(fileId);
            }
            this.files.get(fileId).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        int notificationTimeOut = 5000;
        ArrayList<OPageDataVerificationError> errors = new ArrayList<OPageDataVerificationError>();
        Object object = this.syncObject;
        synchronized (object) {
            for (long fileId : this.files.keySet()) {
                boolean fileIsCorrect;
                OFileClassic fileClassic = this.files.get(fileId);
                try {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Flashing file " + fileClassic.getName() + "... ");
                    }
                    this.flush(fileId);
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Start verification of content of " + fileClassic.getName() + "file ...");
                    }
                    long time = System.currentTimeMillis();
                    long filledUpTo = fileClassic.getFilledUpTo();
                    fileIsCorrect = true;
                    for (long pos = 0L; pos < filledUpTo; pos += (long)this.pageSize) {
                        int calculatedCRC32;
                        int storedCRC32;
                        boolean checkSumIncorrect = false;
                        boolean magicNumberIncorrect = false;
                        byte[] data = new byte[this.pageSize];
                        fileClassic.read(pos, data, data.length);
                        long magicNumber = OLongSerializer.INSTANCE.deserializeNative(data, 0);
                        if (magicNumber != 4207608830L) {
                            magicNumberIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Magic number for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " does not much !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if ((storedCRC32 = OIntegerSerializer.INSTANCE.deserializeNative(data, 8).intValue()) != (calculatedCRC32 = OWOWCache.calculatePageCrc(data))) {
                            checkSumIncorrect = true;
                            if (commandOutputListener != null) {
                                commandOutputListener.onMessage("Error: Checksum for page " + pos / (long)this.pageSize + " in file " + fileClassic.getName() + " is incorrect !!!");
                            }
                            fileIsCorrect = false;
                        }
                        if (magicNumberIncorrect || checkSumIncorrect) {
                            errors.add(new OPageDataVerificationError(magicNumberIncorrect, checkSumIncorrect, pos / (long)this.pageSize, fileClassic.getName()));
                        }
                        if (commandOutputListener == null || System.currentTimeMillis() - time <= 5000L) continue;
                        time = 5000L;
                        commandOutputListener.onMessage(pos / (long)this.pageSize + " pages were processed ...");
                    }
                }
                catch (IOException ioe) {
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Error: Error during processing of file " + fileClassic.getName() + ". " + ioe.getMessage());
                    }
                    fileIsCorrect = false;
                }
                if (!fileIsCorrect) {
                    if (commandOutputListener == null) continue;
                    commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is finished with errors.");
                    continue;
                }
                if (commandOutputListener == null) continue;
                commandOutputListener.onMessage("Verification of file " + fileClassic.getName() + " is successfully finished.");
            }
            return errors.toArray(new OPageDataVerificationError[errors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            for (long fileId : this.files.keySet()) {
                this.doDeleteFile(fileId);
            }
            if (this.nameIdMapHolderFile != null) {
                if (this.nameIdMapHolderFile.exists()) {
                    this.nameIdMapHolder.close();
                    if (!this.nameIdMapHolderFile.delete()) {
                        throw new OStorageException("Can not delete disk cache file which contains name-id mapping.");
                    }
                }
                this.nameIdMapHolder = null;
                this.nameIdMapHolderFile = null;
            }
        }
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OException("Background data flush task can not be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Data flush thread was interrupted", new Object[0]);
                Thread.interrupted();
                throw new OException("Data flush thread was interrupted", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fileNameById(long fileId) {
        Object object = this.syncObject;
        synchronized (object) {
            return this.files.get(fileId).getName();
        }
    }

    private void openFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            if (!fileClassic.isOpen()) {
                fileClassic.open();
            }
        } else {
            fileClassic.create(-1);
            fileClassic.synch();
        }
    }

    private void initNameIdMapping() throws IOException {
        if (this.nameIdMapHolder == null) {
            File storagePath = new File(this.storageLocal.getStoragePath());
            if (!storagePath.exists() && !storagePath.mkdirs()) {
                throw new OStorageException("Can not create directories for the path " + storagePath);
            }
            this.nameIdMapHolderFile = new File(storagePath, NAME_ID_MAP);
            this.nameIdMapHolder = new RandomAccessFile(this.nameIdMapHolderFile, "rw");
            this.readNameIdMap();
        }
    }

    private OFileClassic createFile(String fileName) {
        OFileClassic fileClassic = new OFileClassic();
        String path = this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + fileName);
        fileClassic.init(path, this.storageLocal.getMode());
        return fileClassic;
    }

    private void readNameIdMap() throws IOException {
        NameFileIdEntry nameFileIdEntry;
        this.nameIdMap = new HashMap<String, Long>();
        long localFileCounter = -1L;
        this.nameIdMapHolder.seek(0L);
        while ((nameFileIdEntry = this.readNextNameIdEntry()) != null) {
            if (localFileCounter < nameFileIdEntry.fileId) {
                localFileCounter = nameFileIdEntry.fileId;
            }
            if (nameFileIdEntry.fileId >= 0L) {
                this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
                continue;
            }
            this.nameIdMap.remove(nameFileIdEntry.name);
        }
        if (localFileCounter > 0L) {
            this.fileCounter = localFileCounter;
        }
        for (Map.Entry<String, Long> nameIdEntry : this.nameIdMap.entrySet()) {
            if (this.files.containsKey(nameIdEntry.getValue())) continue;
            OFileClassic fileClassic = this.createFile(nameIdEntry.getKey());
            this.files.put(nameIdEntry.getValue(), fileClassic);
        }
    }

    private NameFileIdEntry readNextNameIdEntry() throws IOException {
        try {
            int nameSize = this.nameIdMapHolder.readInt();
            byte[] serializedName = new byte[nameSize];
            this.nameIdMapHolder.readFully(serializedName);
            String name = (String)this.stringSerializer.deserialize(serializedName, 0);
            long fileId = this.nameIdMapHolder.readLong();
            return new NameFileIdEntry(name, fileId);
        }
        catch (EOFException eof) {
            return null;
        }
    }

    private void writeNameIdEntry(NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        this.nameIdMapHolder.seek(this.nameIdMapHolder.length());
        int nameSize = this.stringSerializer.getObjectSize((Object)nameFileIdEntry.name, new Object[0]);
        byte[] serializedName = new byte[nameSize];
        this.stringSerializer.serialize((Object)nameFileIdEntry.name, serializedName, 0, new Object[0]);
        this.nameIdMapHolder.writeInt(nameSize);
        this.nameIdMapHolder.write(serializedName);
        this.nameIdMapHolder.writeLong(nameFileIdEntry.fileId);
        if (sync) {
            this.nameIdMapHolder.getFD().sync();
        }
    }

    private String doDeleteFile(long fileId) throws IOException {
        if (this.isOpen(fileId)) {
            this.truncateFile(fileId);
        }
        OFileClassic fileClassic = this.files.remove(fileId);
        String name = null;
        if (fileClassic != null) {
            name = fileClassic.getName();
            if (fileClassic.exists()) {
                fileClassic.delete();
            }
        }
        return name;
    }

    private void removeCachedPages(long fileId) {
        Future<Void> future = this.commitExecutor.submit(new RemoveFilePagesTask(fileId));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new OException("File data removal was interrupted", (Throwable)e);
        }
        catch (Exception e) {
            throw new OException("File data removal was abnormally terminated", (Throwable)e);
        }
    }

    private OCachePointer cacheFileContent(long fileId, long pageIndex) throws IOException {
        OCachePointer dataPointer;
        long startPosition = pageIndex * (long)this.pageSize;
        long endPosition = startPosition + (long)this.pageSize;
        byte[] content = new byte[this.pageSize + 16];
        OFileClassic fileClassic = this.files.get(fileId);
        if (fileClassic == null) {
            throw new IllegalArgumentException("File with id " + fileId + " not found in WOW Cache");
        }
        if (fileClassic.getFilledUpTo() >= endPosition) {
            fileClassic.read(startPosition, content, content.length - 16, 8);
            ODirectMemoryPointer pointer = new ODirectMemoryPointer(content);
            OLogSequenceNumber storedLSN = ODurablePage.getLogSequenceNumberFromPage(pointer);
            dataPointer = new OCachePointer(pointer, storedLSN);
        } else {
            fileClassic.allocateSpace((int)(endPosition - fileClassic.getFilledUpTo()));
            ODirectMemoryPointer pointer = new ODirectMemoryPointer(content);
            dataPointer = new OCachePointer(pointer, new OLogSequenceNumber(0L, -1L));
        }
        return dataPointer;
    }

    private void flushPage(long fileId, long pageIndex, ODirectMemoryPointer dataPointer) throws IOException {
        if (this.writeAheadLog != null) {
            OLogSequenceNumber lsn = ODurablePage.getLogSequenceNumberFromPage(dataPointer);
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLSN();
            if (flushedLSN == null || flushedLSN.compareTo(lsn) < 0) {
                this.writeAheadLog.flush();
            }
        }
        byte[] content = dataPointer.get(8L, this.pageSize);
        OLongSerializer.INSTANCE.serializeNative(Long.valueOf(4207608830L), content, 0, new Object[0]);
        int crc32 = OWOWCache.calculatePageCrc(content);
        OIntegerSerializer.INSTANCE.serializeNative(Integer.valueOf(crc32), content, 8, new Object[0]);
        OFileClassic fileClassic = this.files.get(fileId);
        fileClassic.write(pageIndex * (long)this.pageSize, content);
        if (this.syncOnPageFlush) {
            fileClassic.synch();
        }
    }

    private final class RemoveFilePagesTask
    implements Callable<Void> {
        private final long fileId;

        private RemoveFilePagesTask(long fileId) {
            this.fileId = fileId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            GroupKey firstKey = new GroupKey(this.fileId, 0L);
            GroupKey lastKey = new GroupKey(this.fileId, Long.MAX_VALUE);
            NavigableMap subMap = OWOWCache.this.writeGroups.subMap(firstKey, true, lastKey, true);
            Iterator entryIterator = subMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                WriteGroup writeGroup = (WriteGroup)entry.getValue();
                GroupKey groupKey = (GroupKey)entry.getKey();
                OWOWCache.this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)groupKey, OLockManager.LOCK.EXCLUSIVE);
                try {
                    for (OCachePointer pagePointer : writeGroup.pages) {
                        if (pagePointer == null) continue;
                        pagePointer.acquireExclusiveLock();
                        try {
                            pagePointer.decrementReferrer();
                            OWOWCache.this.cacheSize.decrementAndGet();
                        }
                        finally {
                            pagePointer.releaseExclusiveLock();
                        }
                    }
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock((Object)Thread.currentThread(), (Object)groupKey, OLockManager.LOCK.EXCLUSIVE);
                }
            }
            return null;
        }
    }

    private final class FileFlushTask
    implements Callable<Void> {
        private final long fileId;

        private FileFlushTask(long fileId) {
            this.fileId = fileId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            GroupKey firstKey = new GroupKey(this.fileId, 0L);
            GroupKey lastKey = new GroupKey(this.fileId, Long.MAX_VALUE);
            NavigableMap subMap = OWOWCache.this.writeGroups.subMap(firstKey, true, lastKey, true);
            Iterator entryIterator = subMap.entrySet().iterator();
            block7: while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                WriteGroup writeGroup = (WriteGroup)entry.getValue();
                GroupKey groupKey = (GroupKey)entry.getKey();
                OWOWCache.this.lockManager.acquireLock((Object)Thread.currentThread(), (Object)groupKey, OLockManager.LOCK.EXCLUSIVE);
                try {
                    int flushedPages = 0;
                    for (int i = 0; i < 16; ++i) {
                        OCachePointer pagePointer = writeGroup.pages[i];
                        if (pagePointer == null) continue;
                        if (!pagePointer.tryAcquireSharedLock()) continue block7;
                        try {
                            OWOWCache.this.flushPage(groupKey.fileId, (groupKey.groupIndex << 4) + (long)i, pagePointer.getDataPointer());
                            ++flushedPages;
                            continue;
                        }
                        finally {
                            pagePointer.releaseSharedLock();
                        }
                    }
                    for (OCachePointer pagePointer : writeGroup.pages) {
                        if (pagePointer == null) continue;
                        pagePointer.decrementReferrer();
                    }
                    OWOWCache.this.cacheSize.addAndGet(-flushedPages);
                    entryIterator.remove();
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock((Object)Thread.currentThread(), entry.getKey(), OLockManager.LOCK.EXCLUSIVE);
                }
            }
            ((OFileClassic)OWOWCache.this.files.get(this.fileId)).synch();
            return null;
        }
    }

    private final class PeriodicFlushTask
    implements Runnable {
        private PeriodicFlushTask() {
        }

        @Override
        public void run() {
            block10: {
                try {
                    int writeGroupsToFlush;
                    if (OWOWCache.this.writeGroups.isEmpty()) {
                        return;
                    }
                    boolean useForceSync = false;
                    double threshold = (double)OWOWCache.this.cacheSize.get() / (double)OWOWCache.this.cacheMaxSize;
                    if (threshold > 0.8) {
                        writeGroupsToFlush = (int)(0.2 * (double)OWOWCache.this.writeGroups.size());
                        useForceSync = true;
                    } else if (threshold > 0.9) {
                        writeGroupsToFlush = (int)(0.4 * (double)OWOWCache.this.writeGroups.size());
                        useForceSync = true;
                    } else {
                        writeGroupsToFlush = 1;
                    }
                    if (writeGroupsToFlush < 1) {
                        writeGroupsToFlush = 1;
                    }
                    int flushedGroups = 0;
                    if ((flushedGroups = this.flushRing(writeGroupsToFlush, flushedGroups, false)) < writeGroupsToFlush && useForceSync) {
                        flushedGroups = this.flushRing(writeGroupsToFlush, flushedGroups, true);
                    }
                    if (flushedGroups >= writeGroupsToFlush || OWOWCache.this.cacheSize.get() <= OWOWCache.this.cacheMaxSize) break block10;
                    if (OGlobalConfiguration.SERVER_CACHE_INCREASE_ON_DEMAND.getValueAsBoolean()) {
                        long oldCacheMaxSize = OWOWCache.this.cacheMaxSize;
                        OWOWCache.this.cacheMaxSize = (int)Math.ceil((float)OWOWCache.this.cacheMaxSize * (1.0f + OGlobalConfiguration.SERVER_CACHE_INCREASE_STEP.getValueAsFloat()));
                        OLogManager.instance().warn((Object)this, "Write cache size is increased from %d to %d", new Object[]{oldCacheMaxSize, OWOWCache.this.cacheMaxSize});
                        break block10;
                    }
                    throw new OAllCacheEntriesAreUsedException("All records in write cache are used!");
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Exception during data flush.", (Throwable)e, new Object[0]);
                }
            }
        }

        private int flushRing(int writeGroupsToFlush, int flushedGroups, boolean forceFlush) throws IOException {
            NavigableMap subMap = OWOWCache.this.writeGroups.tailMap(OWOWCache.this.lastGroupKey, false);
            if (!subMap.isEmpty()) {
                flushedGroups = this.iterateBySubRing(subMap, writeGroupsToFlush, 0, forceFlush);
                if (flushedGroups < writeGroupsToFlush && !subMap.isEmpty()) {
                    subMap = OWOWCache.this.writeGroups.headMap(subMap.firstKey(), false);
                    flushedGroups = this.iterateBySubRing(subMap, writeGroupsToFlush, flushedGroups, forceFlush);
                }
            } else {
                flushedGroups = this.iterateBySubRing(OWOWCache.this.writeGroups, writeGroupsToFlush, flushedGroups, forceFlush);
            }
            return flushedGroups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int iterateBySubRing(NavigableMap<GroupKey, WriteGroup> subMap, int writeGroupsToFlush, int flushedWriteGroups, boolean forceFlush) throws IOException {
            Iterator entriesIterator = subMap.entrySet().iterator();
            long currentTime = System.currentTimeMillis();
            block7: while (entriesIterator.hasNext() && flushedWriteGroups < writeGroupsToFlush) {
                boolean weakLockMode;
                Map.Entry entry = entriesIterator.next();
                WriteGroup group = (WriteGroup)entry.getValue();
                GroupKey groupKey = (GroupKey)entry.getKey();
                boolean bl = weakLockMode = group.creationTime - currentTime < OWOWCache.this.groupTTL && !forceFlush;
                if (group.recencyBit && weakLockMode) {
                    group.recencyBit = false;
                    continue;
                }
                OWOWCache.this.lockManager.acquireLock((Object)Thread.currentThread(), entry.getKey(), OLockManager.LOCK.EXCLUSIVE);
                try {
                    if (group.recencyBit && weakLockMode) {
                        group.recencyBit = false;
                    } else {
                        group.recencyBit = false;
                        int flushedPages = 0;
                        for (int i = 0; i < 16; ++i) {
                            OCachePointer pagePointer = group.pages[i];
                            if (pagePointer == null) continue;
                            if (!pagePointer.tryAcquireSharedLock()) continue block7;
                            try {
                                OWOWCache.this.flushPage(groupKey.fileId, (groupKey.groupIndex << 4) + (long)i, pagePointer.getDataPointer());
                                ++flushedPages;
                                OLogSequenceNumber flushedLSN = ODurablePage.getLogSequenceNumberFromPage(pagePointer.getDataPointer());
                                pagePointer.setLastFlushedLsn(flushedLSN);
                                continue;
                            }
                            finally {
                                pagePointer.releaseSharedLock();
                            }
                        }
                        for (OCachePointer pagePointer : group.pages) {
                            if (pagePointer == null) continue;
                            pagePointer.decrementReferrer();
                        }
                        entriesIterator.remove();
                        ++flushedWriteGroups;
                        OWOWCache.this.cacheSize.addAndGet(-flushedPages);
                    }
                }
                finally {
                    OWOWCache.this.lockManager.releaseLock((Object)Thread.currentThread(), entry.getKey(), OLockManager.LOCK.EXCLUSIVE);
                    continue;
                }
                OWOWCache.this.lastGroupKey = groupKey;
            }
            return flushedWriteGroups;
        }
    }

    private final class GroupKey
    implements Comparable<GroupKey> {
        private final long fileId;
        private final long groupIndex;

        private GroupKey(long fileId, long groupIndex) {
            this.fileId = fileId;
            this.groupIndex = groupIndex;
        }

        @Override
        public int compareTo(GroupKey other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            if (this.groupIndex > other.groupIndex) {
                return 1;
            }
            if (this.groupIndex < other.groupIndex) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupKey groupKey = (GroupKey)o;
            if (this.fileId != groupKey.fileId) {
                return false;
            }
            return this.groupIndex == groupKey.groupIndex;
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.groupIndex ^ this.groupIndex >>> 32);
            return result;
        }

        public String toString() {
            return "GroupKey{fileId=" + this.fileId + ", groupIndex=" + this.groupIndex + '}';
        }
    }

    private static final class NameFileIdEntry {
        private final String name;
        private final long fileId;

        private NameFileIdEntry(String name, long fileId) {
            this.name = name;
            this.fileId = fileId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameFileIdEntry that = (NameFileIdEntry)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (int)(this.fileId ^ this.fileId >>> 32);
            return result;
        }
    }
}

