/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.index.hashindex.local.ODirectoryFirstPage;
import com.orientechnologies.orient.core.index.hashindex.local.ODirectoryPage;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCacheEntry;
import com.orientechnologies.orient.core.index.hashindex.local.cache.OCachePointer;
import com.orientechnologies.orient.core.index.hashindex.local.cache.ODiskCache;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OStorageTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OHashTableDirectory
extends ODurableComponent {
    public static final int ITEM_SIZE = 8;
    public static final int LEVEL_SIZE = 256;
    public static final int BINARY_LEVEL_SIZE = 2051;
    private final String defaultExtension;
    private final String name;
    private final ODiskCache diskCache;
    private long fileId;
    private OCacheEntry firstEntry;
    private List<OCacheEntry> entries;
    private final boolean durableInNonTxMode;
    private final OStorageLocalAbstract storage;
    private final ODurablePage.TrackMode txTrackMode = ODurablePage.TrackMode.valueOf(OGlobalConfiguration.INDEX_TX_MODE.getValueAsString().toUpperCase());

    public OHashTableDirectory(String defaultExtension, String name, boolean durableInNonTxMode, OStorageLocalAbstract storage) {
        this.defaultExtension = defaultExtension;
        this.name = name;
        this.diskCache = storage.getDiskCache();
        this.durableInNonTxMode = durableInNonTxMode;
        this.storage = storage;
        this.init(storage);
    }

    public void create() throws IOException {
        this.startAtomicOperation();
        this.acquireExclusiveLock();
        try {
            this.fileId = this.diskCache.openFile(this.name + this.defaultExtension);
            this.logFileCreation(this.name + this.defaultExtension, this.fileId);
            this.init();
            this.endAtomicOperation(false);
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    private void init() throws IOException {
        this.startAtomicOperation();
        try {
            this.firstEntry = this.diskCache.load(this.fileId, 0L, true);
            this.diskCache.pinPage(this.firstEntry);
            this.firstEntry.acquireExclusiveLock();
            try {
                ODirectoryFirstPage firstPage = new ODirectoryFirstPage(this.firstEntry, this.getTrackMode(), this.firstEntry);
                firstPage.setTreeSize(0);
                firstPage.setTombstone(-1);
                this.firstEntry.markDirty();
                this.logPageChanges(firstPage, this.firstEntry.getFileId(), this.firstEntry.getPageIndex(), true);
            }
            finally {
                this.firstEntry.releaseExclusiveLock();
                this.diskCache.release(this.firstEntry);
            }
            this.entries = new ArrayList<OCacheEntry>();
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.fileId = this.diskCache.openFile(this.name + this.defaultExtension);
            this.firstEntry = this.diskCache.load(this.fileId, 0L, true);
            this.diskCache.pinPage(this.firstEntry);
            this.diskCache.release(this.firstEntry);
            int filledUpTo = (int)this.diskCache.getFilledUpTo(this.fileId);
            this.entries = new ArrayList<OCacheEntry>(filledUpTo - 1);
            for (int i = 1; i < filledUpTo; ++i) {
                OCacheEntry entry = this.diskCache.load(this.fileId, i, true);
                this.diskCache.pinPage(entry);
                this.diskCache.release(entry);
                this.entries.add(entry);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void close() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.closeFile(this.fileId);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.deleteFile(this.fileId);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void deleteWithoutOpen() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.fileId = this.diskCache.openFile(this.name + this.defaultExtension);
            this.diskCache.deleteFile(this.fileId);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNewNode(byte maxLeftChildDepth, byte maxRightChildDepth, byte nodeLocalDepth, long[] newNode) throws IOException {
        int nodeIndex;
        this.acquireExclusiveLock();
        this.startAtomicOperation();
        try {
            this.diskCache.loadPinnedPage(this.firstEntry);
            this.firstEntry.acquireExclusiveLock();
            try {
                ODirectoryFirstPage firstPage = new ODirectoryFirstPage(this.firstEntry, this.getTrackMode(), this.firstEntry);
                int tombstone = firstPage.getTombstone();
                if (tombstone >= 0) {
                    nodeIndex = tombstone;
                } else {
                    nodeIndex = firstPage.getTreeSize();
                    firstPage.setTreeSize(nodeIndex + 1);
                }
                if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
                    int localNodeIndex = nodeIndex;
                    firstPage.setMaxLeftChildDepth(localNodeIndex, maxLeftChildDepth);
                    firstPage.setMaxRightChildDepth(localNodeIndex, maxRightChildDepth);
                    firstPage.setNodeLocalDepth(localNodeIndex, nodeLocalDepth);
                    if (tombstone >= 0) {
                        firstPage.setTombstone((int)firstPage.getPointer(nodeIndex, 0));
                    }
                    for (int i = 0; i < newNode.length; ++i) {
                        firstPage.setPointer(localNodeIndex, i, newNode[i]);
                    }
                } else {
                    OCacheEntry cacheEntry;
                    int pageIndex = (nodeIndex - ODirectoryFirstPage.NODES_PER_PAGE) / ODirectoryPage.NODES_PER_PAGE;
                    int localLevel = (nodeIndex - ODirectoryFirstPage.NODES_PER_PAGE) % ODirectoryPage.NODES_PER_PAGE;
                    boolean newPage = false;
                    while (this.entries.size() <= pageIndex) {
                        cacheEntry = this.diskCache.load(this.fileId, this.entries.size() + 1, true);
                        this.diskCache.pinPage(cacheEntry);
                        this.diskCache.release(cacheEntry);
                        this.entries.add(cacheEntry);
                        newPage = true;
                    }
                    cacheEntry = this.entries.get(pageIndex);
                    this.diskCache.loadPinnedPage(cacheEntry);
                    cacheEntry.acquireExclusiveLock();
                    try {
                        ODirectoryPage page = new ODirectoryPage(cacheEntry, ODurablePage.TrackMode.NONE, cacheEntry);
                        page.setMaxLeftChildDepth(localLevel, maxLeftChildDepth);
                        page.setMaxRightChildDepth(localLevel, maxRightChildDepth);
                        page.setNodeLocalDepth(localLevel, nodeLocalDepth);
                        if (tombstone >= 0) {
                            firstPage.setTombstone((int)page.getPointer(localLevel, 0));
                        }
                        for (int i = 0; i < newNode.length; ++i) {
                            page.setPointer(localLevel, i, newNode[i]);
                        }
                        cacheEntry.markDirty();
                        this.logPageChanges(page, cacheEntry.getFileId(), this.firstEntry.getPageIndex(), newPage);
                    }
                    finally {
                        cacheEntry.releaseExclusiveLock();
                        this.diskCache.release(cacheEntry);
                    }
                }
                this.logPageChanges(firstPage, this.firstEntry.getFileId(), this.firstEntry.getPageIndex(), false);
            }
            finally {
                this.firstEntry.releaseExclusiveLock();
                this.diskCache.release(this.firstEntry);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
        return nodeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(int nodeIndex) throws IOException {
        this.acquireExclusiveLock();
        this.startAtomicOperation();
        try {
            this.diskCache.loadPinnedPage(this.firstEntry);
            this.firstEntry.acquireExclusiveLock();
            try {
                ODirectoryFirstPage firstPage = new ODirectoryFirstPage(this.firstEntry, ODurablePage.TrackMode.NONE, this.firstEntry);
                if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
                    firstPage.setPointer(nodeIndex, 0, firstPage.getTombstone());
                    firstPage.setTombstone(nodeIndex);
                } else {
                    int pageIndex = (nodeIndex - ODirectoryFirstPage.NODES_PER_PAGE) / ODirectoryPage.NODES_PER_PAGE;
                    int localNodeIndex = (nodeIndex - ODirectoryFirstPage.NODES_PER_PAGE) % ODirectoryPage.NODES_PER_PAGE;
                    OCacheEntry cacheEntry = this.entries.get(pageIndex);
                    this.diskCache.loadPinnedPage(cacheEntry);
                    cacheEntry.acquireExclusiveLock();
                    try {
                        ODirectoryPage page = new ODirectoryPage(cacheEntry, ODurablePage.TrackMode.NONE, cacheEntry);
                        page.setPointer(localNodeIndex, 0, firstPage.getTombstone());
                        firstPage.setTombstone(nodeIndex);
                        cacheEntry.markDirty();
                        this.logPageChanges(page, cacheEntry.getFileId(), cacheEntry.getPageIndex(), false);
                    }
                    finally {
                        cacheEntry.releaseExclusiveLock();
                        this.diskCache.release(cacheEntry);
                    }
                }
                this.logPageChanges(firstPage, this.firstEntry.getFileId(), this.firstEntry.getPageIndex(), false);
            }
            finally {
                this.firstEntry.releaseExclusiveLock();
                this.diskCache.release(this.firstEntry);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getMaxLeftChildDepth(int nodeIndex) throws IOException {
        this.acquireSharedLock();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, false);
            try {
                byte by = page.getMaxLeftChildDepth(this.getLocalNodeIndex(nodeIndex));
                this.releasePage(page, false);
                return by;
            }
            catch (Throwable throwable) {
                this.releasePage(page, false);
                throw throwable;
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxLeftChildDepth(int nodeIndex, byte maxLeftChildDepth) throws IOException {
        this.acquireExclusiveLock();
        this.startAtomicOperation();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, true);
            try {
                page.setMaxLeftChildDepth(this.getLocalNodeIndex(nodeIndex), maxLeftChildDepth);
                OCacheEntry cacheEntry = page.getEntry();
                cacheEntry.markDirty();
                this.logPageChanges(page, cacheEntry.getFileId(), cacheEntry.getPageIndex(), false);
            }
            finally {
                this.releasePage(page, true);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getMaxRightChildDepth(int nodeIndex) throws IOException {
        this.acquireSharedLock();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, false);
            try {
                byte by = page.getMaxRightChildDepth(this.getLocalNodeIndex(nodeIndex));
                this.releasePage(page, false);
                return by;
            }
            catch (Throwable throwable) {
                this.releasePage(page, false);
                throw throwable;
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRightChildDepth(int nodeIndex, byte maxRightChildDepth) throws IOException {
        this.acquireExclusiveLock();
        this.startAtomicOperation();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, true);
            try {
                page.setMaxRightChildDepth(this.getLocalNodeIndex(nodeIndex), maxRightChildDepth);
                OCacheEntry cacheEntry = page.getEntry();
                cacheEntry.markDirty();
                this.logPageChanges(page, cacheEntry.getFileId(), cacheEntry.getPageIndex(), false);
            }
            finally {
                this.releasePage(page, true);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getNodeLocalDepth(int nodeIndex) throws IOException {
        this.acquireSharedLock();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, false);
            try {
                byte by = page.getNodeLocalDepth(this.getLocalNodeIndex(nodeIndex));
                this.releasePage(page, false);
                return by;
            }
            catch (Throwable throwable) {
                this.releasePage(page, false);
                throw throwable;
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeLocalDepth(int nodeIndex, byte localNodeDepth) throws IOException {
        this.acquireExclusiveLock();
        this.startAtomicOperation();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, true);
            try {
                page.setNodeLocalDepth(this.getLocalNodeIndex(nodeIndex), localNodeDepth);
                OCacheEntry cacheEntry = page.getEntry();
                cacheEntry.markDirty();
                this.logPageChanges(page, cacheEntry.getFileId(), cacheEntry.getPageIndex(), false);
            }
            finally {
                this.releasePage(page, true);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getNode(int nodeIndex) throws IOException {
        long[] node = new long[256];
        this.acquireSharedLock();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, false);
            try {
                int localNodeIndex = this.getLocalNodeIndex(nodeIndex);
                for (int i = 0; i < 256; ++i) {
                    node[i] = page.getPointer(localNodeIndex, i);
                }
            }
            finally {
                this.releasePage(page, false);
            }
        }
        finally {
            this.releaseSharedLock();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNode(int nodeIndex, long[] node) throws IOException {
        this.acquireExclusiveLock();
        this.startAtomicOperation();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, true);
            try {
                int localNodeIndex = this.getLocalNodeIndex(nodeIndex);
                for (int i = 0; i < 256; ++i) {
                    page.setPointer(localNodeIndex, i, node[i]);
                }
                OCacheEntry cacheEntry = page.getEntry();
                cacheEntry.markDirty();
                this.logPageChanges(page, cacheEntry.getFileId(), cacheEntry.getPageIndex(), false);
            }
            finally {
                this.releasePage(page, true);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNodePointer(int nodeIndex, int index) throws IOException {
        this.acquireSharedLock();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, false);
            try {
                long l = page.getPointer(this.getLocalNodeIndex(nodeIndex), index);
                this.releasePage(page, false);
                return l;
            }
            catch (Throwable throwable) {
                this.releasePage(page, false);
                throw throwable;
            }
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodePointer(int nodeIndex, int index, long pointer) throws IOException {
        this.acquireExclusiveLock();
        this.startAtomicOperation();
        try {
            ODirectoryPage page = this.loadPage(nodeIndex, true);
            try {
                page.setPointer(this.getLocalNodeIndex(nodeIndex), index, pointer);
                OCacheEntry cacheEntry = page.getEntry();
                cacheEntry.markDirty();
                this.logPageChanges(page, cacheEntry.getFileId(), cacheEntry.getPageIndex(), false);
            }
            finally {
                this.releasePage(page, true);
            }
            this.endAtomicOperation(false);
        }
        catch (IOException e) {
            this.endAtomicOperation(true);
            throw e;
        }
        catch (Throwable e) {
            this.endAtomicOperation(true);
            throw new OStorageException(null, e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void clear() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.diskCache.truncateFile(this.fileId);
            this.init();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void flush() throws IOException {
        this.acquireSharedLock();
        try {
            this.diskCache.flushFile(this.fileId);
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private ODirectoryPage loadPage(int nodeIndex, boolean exclusiveLock) throws IOException {
        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
            this.diskCache.loadPinnedPage(this.firstEntry);
            if (exclusiveLock) {
                this.firstEntry.acquireExclusiveLock();
            }
            return new ODirectoryFirstPage(this.firstEntry, this.getTrackMode(), this.firstEntry);
        }
        int pageIndex = (nodeIndex - ODirectoryFirstPage.NODES_PER_PAGE) / ODirectoryPage.NODES_PER_PAGE;
        OCacheEntry cacheEntry = this.entries.get(pageIndex);
        this.diskCache.loadPinnedPage(cacheEntry);
        if (exclusiveLock) {
            cacheEntry.acquireExclusiveLock();
        }
        return new ODirectoryPage(cacheEntry, this.getTrackMode(), cacheEntry);
    }

    private void releasePage(ODirectoryPage page, boolean exclusiveLock) {
        OCacheEntry cacheEntry = page.getEntry();
        OCachePointer cachePointer = cacheEntry.getCachePointer();
        if (exclusiveLock) {
            cachePointer.releaseExclusiveLock();
        }
        this.diskCache.release(cacheEntry);
    }

    private int getLocalNodeIndex(int nodeIndex) {
        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
            return nodeIndex;
        }
        return (nodeIndex - ODirectoryFirstPage.NODES_PER_PAGE) % ODirectoryPage.NODES_PER_PAGE;
    }

    @Override
    protected ODurablePage.TrackMode getTrackMode() {
        OStorageTransaction transaction = this.storage.getStorageTransaction();
        if (transaction == null && !this.durableInNonTxMode) {
            return ODurablePage.TrackMode.NONE;
        }
        ODurablePage.TrackMode trackMode = super.getTrackMode();
        if (!trackMode.equals((Object)ODurablePage.TrackMode.NONE)) {
            return this.txTrackMode;
        }
        return trackMode;
    }

    @Override
    protected void endAtomicOperation(boolean rollback) throws IOException {
        if (this.storage.getStorageTransaction() == null && !this.durableInNonTxMode) {
            return;
        }
        super.endAtomicOperation(rollback);
    }

    @Override
    protected void startAtomicOperation() throws IOException {
        if (this.storage.getStorageTransaction() == null && !this.durableInNonTxMode) {
            return;
        }
        super.startAtomicOperation();
    }

    @Override
    protected void logFileCreation(String fileName, long fileId) throws IOException {
        if (this.storage.getStorageTransaction() == null && !this.durableInNonTxMode) {
            return;
        }
        super.logFileCreation(fileName, fileId);
    }
}

