/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.engine;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OMemoryHashMapIndexEngine<V>
implements OIndexEngine<V> {
    private final ConcurrentMap<Object, V> concurrentHashMap = new ConcurrentHashMap<Object, V>();
    private volatile ORID identity;

    @Override
    public void init() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void create(String indexName, OIndexDefinition indexDefinition, String clusterIndexName, OStreamSerializer valueSerializer, boolean isAutomatic) {
        ODatabaseRecord database = this.getDatabase();
        ORecordBytes identityRecord = new ORecordBytes();
        database.save(identityRecord, clusterIndexName);
        this.identity = identityRecord.getIdentity();
    }

    @Override
    public void delete() {
    }

    @Override
    public void deleteWithoutLoad(String indexName) {
    }

    @Override
    public void load(ORID indexRid, String indexName, OIndexDefinition indexDefinition, OStreamSerializer valueSerializer, boolean isAutomatic) {
    }

    @Override
    public boolean contains(Object key) {
        return this.concurrentHashMap.containsKey(key);
    }

    @Override
    public boolean remove(Object key) {
        return this.concurrentHashMap.remove(key) != null;
    }

    @Override
    public ORID getIdentity() {
        return this.identity;
    }

    @Override
    public void clear() {
        this.concurrentHashMap.clear();
    }

    @Override
    public OIndexCursor cursor(final OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        return new OIndexAbstractCursor(){
            private Iterator<Map.Entry<Object, V>> entryIterator;
            private Object currentKey;
            private Iterator<OIdentifiable> currentIterator;
            {
                this.entryIterator = OMemoryHashMapIndexEngine.this.concurrentHashMap.entrySet().iterator();
                this.currentIterator = new OEmptyIterator<OIdentifiable>();
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.currentIterator == null) {
                    return null;
                }
                if (this.currentIterator.hasNext()) {
                    return this.nextCursorValue();
                }
                while (this.currentIterator != null && !this.currentIterator.hasNext()) {
                    Map.Entry entry = this.entryIterator.next();
                    this.currentKey = entry.getKey();
                    Object value = entry.getValue();
                    if (valuesTransformer == null) {
                        this.currentIterator = Collections.singletonList((OIdentifiable)value).iterator();
                        continue;
                    }
                    this.currentIterator = valuesTransformer.transformFromValue(value).iterator();
                }
                if (this.currentIterator != null && this.currentIterator.hasNext()) {
                    return this.nextCursorValue();
                }
                this.currentIterator = null;
                return null;
            }

            private Map.Entry<Object, OIdentifiable> nextCursorValue() {
                final OIdentifiable identifiable = this.currentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return currentKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return identifiable;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public OIndexCursor descCursor(OIndexEngine.ValuesTransformer<V> valuesTransformer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        return new OIndexKeyCursor(){
            private Iterator<Object> keysIterator;
            {
                this.keysIterator = OMemoryHashMapIndexEngine.this.concurrentHashMap.keySet().iterator();
            }

            @Override
            public Object next(int prefetchSize) {
                if (!this.keysIterator.hasNext()) {
                    return null;
                }
                return this.keysIterator.next();
            }
        };
    }

    @Override
    public void unload() {
    }

    @Override
    public void startTransaction() {
    }

    @Override
    public void stopTransaction() {
    }

    @Override
    public void afterTxRollback() {
    }

    @Override
    public void afterTxCommit() {
    }

    @Override
    public void closeDb() {
    }

    @Override
    public void close() {
    }

    @Override
    public void beforeTxBegin() {
    }

    @Override
    public V get(Object key) {
        return this.concurrentHashMap.get(key);
    }

    @Override
    public void put(Object key, V value) {
        this.concurrentHashMap.put(key, value);
    }

    @Override
    public Object getFirstKey() {
        throw new UnsupportedOperationException("getFirstKey");
    }

    @Override
    public Object getLastKey() {
        throw new UnsupportedOperationException("getLastKey");
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("iterateEntriesBetween");
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("iterateEntriesMajor");
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer<V> transformer) {
        throw new UnsupportedOperationException("iterateEntriesMinor");
    }

    @Override
    public long size(OIndexEngine.ValuesTransformer<V> transformer) {
        if (transformer == null) {
            return this.concurrentHashMap.size();
        }
        long counter = 0L;
        for (Object value : this.concurrentHashMap.values()) {
            counter += (long)transformer.transformFromValue(value).size();
        }
        return counter;
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return false;
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

