/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OAbstractIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ORuntimeKeyIndexDefinition<T>
extends OAbstractIndexDefinition {
    private OBinarySerializer<T> serializer;

    public ORuntimeKeyIndexDefinition(byte iId) {
        this.serializer = OBinarySerializerFactory.getInstance().getObjectSerializer(iId);
        if (this.serializer == null) {
            throw new OConfigurationException("Runtime index definition cannot find binary serializer with id=" + iId + ". Assure to plug custom serializer into the server.");
        }
    }

    public ORuntimeKeyIndexDefinition() {
    }

    @Override
    public List<String> getFields() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getFieldsToIndex() {
        return Collections.emptyList();
    }

    @Override
    public String getClassName() {
        return null;
    }

    @Override
    public Comparable<?> createValue(List<?> params) {
        return (Comparable)params.get(0);
    }

    @Override
    public Comparable<?> createValue(Object ... params) {
        return this.createValue((List)Arrays.asList(params));
    }

    @Override
    public int getParamCount() {
        return 1;
    }

    @Override
    public OType[] getTypes() {
        return null;
    }

    @Override
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("keySerializerId", this.serializer.getId());
            this.document.field("collate", this.collate.getName());
            this.document.field("nullValuesIgnored", this.isNullValuesIgnored());
            ODocument oDocument = this.document;
            return oDocument;
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    @Override
    protected void fromStream() {
        byte keySerializerId = ((Number)this.document.field("keySerializerId")).byteValue();
        this.serializer = OBinarySerializerFactory.getInstance().getObjectSerializer(keySerializerId);
        if (this.serializer == null) {
            throw new OConfigurationException("Runtime index definition cannot find binary serializer with id=" + keySerializerId + ". Assure to plug custom serializer into the server.");
        }
        String collateField = (String)this.document.field("collate");
        if (collateField == null) {
            collateField = "default";
        }
        this.setNullValuesIgnored(!Boolean.FALSE.equals(this.document.field("nullValuesIgnored")));
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        throw new OIndexException("This method is not supported in given index definition.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ORuntimeKeyIndexDefinition that = (ORuntimeKeyIndexDefinition)o;
        return this.serializer.equals(that.serializer);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.serializer.getId();
        return result;
    }

    @Override
    public String toString() {
        return "ORuntimeKeyIndexDefinition{serializer=" + this.serializer.getId() + '}';
    }

    @Override
    public String toCreateIndexDDL(String indexName, String indexType) {
        StringBuilder ddl = new StringBuilder("create index ");
        ddl.append(indexName).append(' ').append(indexType).append(' ');
        ddl.append("runtime ").append(this.serializer.getId());
        return ddl.toString();
    }

    public OBinarySerializer<T> getSerializer() {
        return this.serializer;
    }

    @Override
    public boolean isAutomatic() {
        return this.getClassName() != null;
    }
}

