/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerListRID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerSBTreeIndexRIDContainer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class OIndexMultiValues
extends OIndexAbstract<Set<OIdentifiable>> {
    public OIndexMultiValues(String type, String algorithm, OIndexEngine<Set<OIdentifiable>> indexEngine, String valueContainerAlgorithm) {
        super(type, algorithm, indexEngine, valueContainerAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIdentifiable> get(Object key) {
        this.checkForRebuild();
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            Set values = (Set)this.indexEngine.get(key);
            if (values == null) {
                Set<OIdentifiable> set = Collections.emptySet();
                return set;
            }
            HashSet<OIdentifiable> hashSet = new HashSet<OIdentifiable>(values);
            return hashSet;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(Object key) {
        this.checkForRebuild();
        key = this.getCollatingValue(key);
        this.acquireSharedLock();
        try {
            Set values = (Set)this.indexEngine.get(key);
            if (values == null) {
                long l = 0L;
                return l;
            }
            long l = values.size();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OIndexMultiValues put(Object key, OIdentifiable iSingleValue) {
        this.checkForRebuild();
        key = this.getCollatingValue(key);
        this.modificationLock.requestModificationLock();
        try {
            OIndexMultiValues oIndexMultiValues;
            this.checkForKeyType(key);
            this.acquireExclusiveLock();
            try {
                Set values = (Set)this.indexEngine.get(key);
                if (values == null) {
                    if ("SBTREEBONSAISET".equals(this.valueContainerAlgorithm)) {
                        values = new OIndexRIDContainer(this.getName());
                    } else {
                        values = new OMVRBTreeRIDSet(OGlobalConfiguration.MVRBTREE_RID_BINARY_THRESHOLD.getValueAsInteger());
                        ((OMVRBTreeRIDSet)values).setAutoConvertToRecord(false);
                    }
                }
                if (!iSingleValue.getIdentity().isValid()) {
                    ((ORecord)iSingleValue).save();
                }
                values.add(iSingleValue.getIdentity());
                this.indexEngine.put(key, values);
                oIndexMultiValues = this;
            }
            catch (Throwable throwable) {
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return oIndexMultiValues;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    protected void putInSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        Object snapshotValue = snapshot.get(key = this.getCollatingValue(key));
        Object values = snapshotValue == null ? (Set)this.indexEngine.get(key) : (snapshotValue.equals(OIndexAbstract.RemovedValue.INSTANCE) ? null : (Set)snapshotValue);
        if (values == null) {
            if ("SBTREEBONSAISET".equals(this.valueContainerAlgorithm)) {
                values = new OIndexRIDContainer(this.getName());
            } else {
                values = new OMVRBTreeRIDSet(OGlobalConfiguration.MVRBTREE_RID_BINARY_THRESHOLD.getValueAsInteger());
                ((OMVRBTreeRIDSet)values).setAutoConvertToRecord(false);
            }
            snapshot.put(key, values);
        }
        values.add(value.getIdentity());
        snapshot.put(key, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, OIdentifiable value) {
        this.checkForRebuild();
        key = this.getCollatingValue(key);
        this.modificationLock.requestModificationLock();
        try {
            block13: {
                Set values;
                block12: {
                    boolean bl;
                    this.acquireExclusiveLock();
                    try {
                        values = (Set)this.indexEngine.get(key);
                        if (values != null) break block12;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        this.releaseExclusiveLock();
                        throw throwable;
                    }
                    this.releaseExclusiveLock();
                    return bl;
                }
                if (!values.remove(value)) break block13;
                if (values.isEmpty()) {
                    this.indexEngine.remove(key);
                } else {
                    this.indexEngine.put(key, values);
                }
                boolean bl = true;
                this.releaseExclusiveLock();
                return bl;
            }
            boolean bl = false;
            this.releaseExclusiveLock();
            return bl;
        }
        finally {
            this.modificationLock.releaseModificationLock();
        }
    }

    @Override
    protected void removeFromSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        Object snapshotValue = snapshot.get(key = this.getCollatingValue(key));
        Object values = snapshotValue == null ? (Set)this.indexEngine.get(key) : (snapshotValue.equals(OIndexAbstract.RemovedValue.INSTANCE) ? null : (Set)snapshotValue);
        if (values == null) {
            return;
        }
        if (values.remove(value)) {
            if (values.isEmpty()) {
                snapshot.put(key, OIndexAbstract.RemovedValue.INSTANCE);
            } else {
                snapshot.put(key, values);
            }
        }
    }

    @Override
    protected void commitSnapshot(Map<Object, Object> snapshot) {
        for (Map.Entry<Object, Object> snapshotEntry : snapshot.entrySet()) {
            Object key = snapshotEntry.getKey();
            Object value = snapshotEntry.getValue();
            this.checkForKeyType(key);
            if (value.equals(OIndexAbstract.RemovedValue.INSTANCE)) {
                this.indexEngine.remove(key);
                continue;
            }
            this.indexEngine.put(key, (Set)value);
        }
    }

    public OIndexMultiValues create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OIndexMultiValues)super.create(name, indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    @Override
    protected OStreamSerializer determineValueSerializer() {
        if ("SBTREEBONSAISET".equals(this.valueContainerAlgorithm)) {
            return OStreamSerializerSBTreeIndexRIDContainer.INSTANCE;
        }
        return OStreamSerializerListRID.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        this.checkForRebuild();
        fromKey = this.getCollatingValue(fromKey);
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.iterateEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        this.checkForRebuild();
        fromKey = this.getCollatingValue(fromKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.iterateEntriesMajor(fromKey, fromInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        this.checkForRebuild();
        toKey = this.getCollatingValue(toKey);
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.iterateEntriesMinor(toKey, toInclusive, ascOrder, MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        this.checkForRebuild();
        final ArrayList sortedKeys = new ArrayList(keys);
        Object comparator = ascSortOrder ? ODefaultComparator.INSTANCE : Collections.reverseOrder(ODefaultComparator.INSTANCE);
        Collections.sort(sortedKeys, comparator);
        return new OIndexAbstractCursor(){
            private Iterator<?> keysIterator;
            private Iterator<OIdentifiable> currentIterator;
            private Object currentKey;
            {
                this.keysIterator = sortedKeys.iterator();
                this.currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;
            }

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (this.currentIterator == null) {
                    return null;
                }
                Object key = null;
                if (!this.currentIterator.hasNext()) {
                    Collection result = null;
                    while (this.keysIterator.hasNext() && (result == null || result.isEmpty())) {
                        key = this.keysIterator.next();
                        key = OIndexMultiValues.this.getCollatingValue(key);
                        OIndexMultiValues.this.acquireSharedLock();
                        try {
                            result = (Collection)OIndexMultiValues.this.indexEngine.get(key);
                        }
                        finally {
                            OIndexMultiValues.this.releaseSharedLock();
                        }
                    }
                    if (result == null) {
                        this.currentIterator = null;
                        return null;
                    }
                    this.currentKey = key;
                    this.currentIterator = result.iterator();
                }
                final OIdentifiable resultValue = this.currentIterator.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return currentKey;
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return resultValue;
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    @Override
    public long getSize() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            long l = this.indexEngine.size(MultiValuesTransformer.INSTANCE);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public long getKeySize() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            long l = this.indexEngine.size(null);
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor cursor() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.cursor(MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public OIndexCursor descCursor() {
        this.checkForRebuild();
        this.acquireSharedLock();
        try {
            OIndexCursor oIndexCursor = this.indexEngine.descCursor(MultiValuesTransformer.INSTANCE);
            return oIndexCursor;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    private static final class MultiValuesTransformer
    implements OIndexEngine.ValuesTransformer<Set<OIdentifiable>> {
        private static final MultiValuesTransformer INSTANCE = new MultiValuesTransformer();

        private MultiValuesTransformer() {
        }

        @Override
        public Collection<OIdentifiable> transformFromValue(Set<OIdentifiable> value) {
            return value;
        }
    }
}

