/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Set;

public interface OIndexInternal<T>
extends OIndex<T>,
ODatabaseListener {
    public static final String CONFIG_KEYTYPE = "keyType";
    public static final String CONFIG_AUTOMATIC = "automatic";
    public static final String CONFIG_TYPE = "type";
    public static final String ALGORITHM = "algorithm";
    public static final String VALUE_CONTAINER_ALGORITHM = "valueContainerAlgorithm";
    public static final String CONFIG_NAME = "name";
    public static final String INDEX_DEFINITION = "indexDefinition";
    public static final String INDEX_DEFINITION_CLASS = "indexDefinitionClass";
    public static final String METADATA = "metadata";

    public boolean loadFromConfiguration(ODocument var1);

    public ODocument updateConfiguration();

    public OIndex<T> addCluster(String var1);

    public OIndex<T> removeCluster(String var1);

    public boolean canBeUsedInEqualityOperators();

    public boolean hasRangeQuerySupport();

    public void freeze(boolean var1);

    public void release();

    public void acquireModificationLock();

    public void releaseModificationLock();

    public IndexMetadata loadMetadata(ODocument var1);

    public void setRebuildingFlag();

    public void close();

    public String getAlgorithm();

    public void preCommit();

    public void addTxOperation(ODocument var1);

    public void commit();

    public void postCommit();

    public static final class IndexMetadata {
        private final String name;
        private final OIndexDefinition indexDefinition;
        private final Set<String> clustersToIndex;
        private final String type;
        private final String algorithm;
        private final String valueContainerAlgorithm;

        public IndexMetadata(String name, OIndexDefinition indexDefinition, Set<String> clustersToIndex, String type, String algorithm, String valueContainerAlgorithm) {
            this.name = name;
            this.indexDefinition = indexDefinition;
            this.clustersToIndex = clustersToIndex;
            this.type = type;
            this.algorithm = algorithm;
            this.valueContainerAlgorithm = valueContainerAlgorithm;
        }

        public String getName() {
            return this.name;
        }

        public OIndexDefinition getIndexDefinition() {
            return this.indexDefinition;
        }

        public Set<String> getClustersToIndex() {
            return this.clustersToIndex;
        }

        public String getType() {
            return this.type;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexMetadata that = (IndexMetadata)o;
            if (this.algorithm != null ? !this.algorithm.equals(that.algorithm) : that.algorithm != null) {
                return false;
            }
            if (!this.clustersToIndex.equals(that.clustersToIndex)) {
                return false;
            }
            if (this.indexDefinition != null ? !this.indexDefinition.equals(that.indexDefinition) : that.indexDefinition != null) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.indexDefinition != null ? this.indexDefinition.hashCode() : 0);
            result = 31 * result + this.clustersToIndex.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
            return result;
        }

        public String getValueContainerAlgorithm() {
            return this.valueContainerAlgorithm;
        }
    }
}

