/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndexCursor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class OIndexAbstractCursor
implements OIndexCursor {
    protected int prefetchSize = -1;

    @Override
    public Set<OIdentifiable> toValues() {
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        Map.Entry<Object, OIdentifiable> entry = this.nextEntry();
        while (entry != null) {
            result.add(entry.getValue());
            entry = this.nextEntry();
        }
        return result;
    }

    @Override
    public Set<Map.Entry<Object, OIdentifiable>> toEntries() {
        HashSet<Map.Entry<Object, OIdentifiable>> result = new HashSet<Map.Entry<Object, OIdentifiable>>();
        Map.Entry<Object, OIdentifiable> entry = this.nextEntry();
        while (entry != null) {
            result.add(entry);
            entry = this.nextEntry();
        }
        return result;
    }

    @Override
    public Set<Object> toKeys() {
        HashSet<Object> result = new HashSet<Object>();
        Map.Entry<Object, OIdentifiable> entry = this.nextEntry();
        while (entry != null) {
            result.add(entry.getKey());
            entry = this.nextEntry();
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public OIdentifiable next() {
        Map.Entry<Object, OIdentifiable> entry = this.nextEntry();
        return entry != null ? entry.getValue() : null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    @Override
    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }
}

