/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OFastConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OClassIndexManager
extends ODocumentHookAbstract {
    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.TARGET_NODE;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        this.checkIndexes(iDocument, ORecordHook.TYPE.BEFORE_CREATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeReplicaAdd(ODocument iDocument) {
        this.checkIndexes(iDocument, ORecordHook.TYPE.BEFORE_CREATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterCreate(ODocument iDocument) {
        this.addIndexesEntries(iDocument);
    }

    @Override
    public void onRecordAfterReplicaAdd(ODocument iDocument) {
        this.addIndexesEntries(iDocument);
    }

    private void addIndexesEntries(ODocument document) {
        ORecord<Object> rid = (document = OClassIndexManager.checkForLoading(document)).getIdentity().isPersistent() ? document.placeholder() : document;
        OClass cls = document.getSchemaClass();
        if (cls != null) {
            Set<OIndex<?>> indexes = cls.getIndexes();
            for (OIndex oIndex : indexes) {
                OIndexDefinition indexDefinition = oIndex.getDefinition();
                Object key = indexDefinition.getDocumentValueToIndex(document);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (indexDefinition.isNullValuesIgnored() && keyItem == null) continue;
                        oIndex.put(keyItem, rid);
                    }
                    continue;
                }
                if (indexDefinition.isNullValuesIgnored() && key == null) continue;
                oIndex.put(key, rid);
            }
        }
    }

    @Override
    public void onRecordCreateFailed(ODocument iDocument) {
    }

    @Override
    public void onRecordReplicaAddFailed(ODocument iDocument) {
    }

    @Override
    public void onRecordCreateReplicated(ODocument iDocument) {
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        this.checkIndexes(iDocument, ORecordHook.TYPE.BEFORE_UPDATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeReplicaUpdate(ODocument iDocument) {
        this.checkIndexes(iDocument, ORecordHook.TYPE.BEFORE_UPDATE);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterUpdate(ODocument iDocument) {
        this.updateIndexEntries(iDocument);
    }

    @Override
    public void onRecordAfterReplicaUpdate(ODocument iDocument) {
        this.updateIndexEntries(iDocument);
    }

    private void updateIndexEntries(ODocument iDocument) {
        HashSet<String> dirtyFields;
        OClass cls = (iDocument = OClassIndexManager.checkForLoading(iDocument)).getSchemaClass();
        if (cls == null) {
            return;
        }
        Set<OIndex<?>> indexes = cls.getIndexes();
        if (!indexes.isEmpty() && !(dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()))).isEmpty()) {
            for (OIndex oIndex : indexes) {
                if (oIndex.getDefinition() instanceof OCompositeIndexDefinition) {
                    OClassIndexManager.processCompositeIndexUpdate(oIndex, dirtyFields, iDocument);
                    continue;
                }
                OClassIndexManager.processSingleIndexUpdate(oIndex, dirtyFields, iDocument);
            }
        }
        if (iDocument.isTrackingChanges()) {
            iDocument.setTrackingChanges(false);
            iDocument.setTrackingChanges(true);
        }
    }

    @Override
    public void onRecordUpdateFailed(ODocument iDocument) {
    }

    @Override
    public void onRecordUpdateReplicated(ODocument iDocument) {
    }

    @Override
    public void onRecordReplicaUpdateFailed(ODocument iDocument) {
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        ORecordVersion version = iDocument.getRecordVersion();
        if (iDocument.fields() == 0) {
            iDocument.reload();
            if (version.getCounter() > -1 && iDocument.getRecordVersion().compareTo(version) != 0) {
                if (OFastConcurrentModificationException.enabled()) {
                    throw OFastConcurrentModificationException.instance();
                }
                throw new OConcurrentModificationException(iDocument.getIdentity(), iDocument.getRecordVersion(), version, 2);
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeReplicaDelete(ODocument iDocument) {
        OClassIndexManager.checkForLoading(iDocument);
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public void onRecordAfterDelete(ODocument iDocument) {
        this.deleteIndexEntries(iDocument);
    }

    @Override
    public void onRecordAfterReplicaDelete(ODocument iDocument) {
        this.deleteIndexEntries(iDocument);
    }

    private void deleteIndexEntries(ODocument iDocument) {
        OClass cls = iDocument.getSchemaClass();
        if (cls == null) {
            return;
        }
        ArrayList indexes = new ArrayList(cls.getIndexes());
        if (!indexes.isEmpty()) {
            HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()));
            if (!dirtyFields.isEmpty()) {
                Iterator indexIterator = indexes.iterator();
                while (indexIterator.hasNext()) {
                    OIndex oIndex = (OIndex)indexIterator.next();
                    boolean result = oIndex.getDefinition() instanceof OCompositeIndexDefinition ? OClassIndexManager.processCompositeIndexDelete(oIndex, dirtyFields, iDocument) : OClassIndexManager.processSingleIndexDelete(oIndex, dirtyFields, iDocument);
                    if (!result) continue;
                    indexIterator.remove();
                }
            }
            for (OIndex oIndex : indexes) {
                Object key = oIndex.getDefinition().getDocumentValueToIndex(iDocument);
                OClassIndexManager.deleteIndexKey(oIndex, iDocument, key);
            }
        }
        if (iDocument.isTrackingChanges()) {
            iDocument.setTrackingChanges(false);
            iDocument.setTrackingChanges(true);
        }
    }

    @Override
    public void onRecordDeleteFailed(ODocument iDocument) {
    }

    @Override
    public void onRecordDeleteReplicated(ODocument iDocument) {
    }

    @Override
    public void onRecordReplicaDeleteFailed(ODocument iDocument) {
    }

    private static void processCompositeIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        String multiValueField = indexDefinition.getMultiValueField();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField == null) {
                Object origValue = indexDefinition.createValue(origValues);
                Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                if (!indexDefinition.isNullValuesIgnored() || origValue != null) {
                    index.remove(origValue, iRecord);
                }
                if (!indexDefinition.isNullValuesIgnored() || newValue != null) {
                    index.put(newValue, iRecord.placeholder());
                }
            } else {
                OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine == null) {
                    if (dirtyFields.contains(multiValueField)) {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                    } else {
                        origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                    }
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                } else if (dirtyFields.size() == 1) {
                    HashMap<OCompositeKey, Integer> keysToAdd = new HashMap<OCompositeKey, Integer>();
                    HashMap<OCompositeKey, Integer> keysToRemove = new HashMap<OCompositeKey, Integer>();
                    for (OMultiValueChangeEvent<Object, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                        indexDefinition.processChangeEvent(changeEvent, keysToAdd, keysToRemove, origValues.toArray());
                    }
                    for (OMultiValueChangeEvent<Object, Object> keyToRemove : keysToRemove.keySet()) {
                        index.remove(keyToRemove, iRecord);
                    }
                    for (OMultiValueChangeEvent<Object, Object> keyToAdd : keysToAdd.keySet()) {
                        index.put(keyToAdd, iRecord.placeholder());
                    }
                } else {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                    Object origValue = indexDefinition.createValue(origValues);
                    Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
                    OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
                }
            }
            return;
        }
    }

    private static void processSingleIndexUpdate(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return;
        }
        String indexField = indexFields.get(0);
        if (!dirtyFields.contains(indexField)) {
            return;
        }
        OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
        if (multiValueChangeTimeLine != null) {
            OIndexDefinitionMultiValue indexDefinitionMultiValue = (OIndexDefinitionMultiValue)indexDefinition;
            HashMap<Object, Integer> keysToAdd = new HashMap<Object, Integer>();
            HashMap<Object, Integer> keysToRemove = new HashMap<Object, Integer>();
            for (OMultiValueChangeEvent<Object, Object> changeEvent : multiValueChangeTimeLine.getMultiValueChangeEvents()) {
                indexDefinitionMultiValue.processChangeEvent(changeEvent, keysToAdd, keysToRemove);
            }
            for (OMultiValueChangeEvent<Object, Object> keyToRemove : keysToRemove.keySet()) {
                index.remove(keyToRemove, iRecord);
            }
            for (OMultiValueChangeEvent<Object, Object> keyToAdd : keysToAdd.keySet()) {
                index.put(keyToAdd, iRecord.placeholder());
            }
        } else {
            Object origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            Object newValue = indexDefinition.getDocumentValueToIndex(iRecord);
            OClassIndexManager.processIndexUpdateFieldAssignment(index, iRecord, origValue, newValue);
        }
    }

    private static void processIndexUpdateFieldAssignment(OIndex<?> index, ODocument iRecord, Object origValue, Object newValue) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (origValue instanceof Collection && newValue instanceof Collection) {
            HashSet valuesToRemove = new HashSet((Collection)origValue);
            HashSet valuesToAdd = new HashSet((Collection)newValue);
            valuesToRemove.removeAll((Collection)newValue);
            valuesToAdd.removeAll((Collection)origValue);
            for (Object valueToRemove : valuesToRemove) {
                if (indexDefinition.isNullValuesIgnored() && valueToRemove == null) continue;
                index.remove(valueToRemove, iRecord);
            }
            for (Object valueToAdd : valuesToAdd) {
                if (indexDefinition.isNullValuesIgnored() && valueToAdd == null) continue;
                index.put(valueToAdd, iRecord);
            }
        } else {
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            if (newValue instanceof Collection) {
                for (Object newValueItem : (Collection)newValue) {
                    index.put(newValueItem, iRecord.placeholder());
                }
            } else if (!indexDefinition.isNullValuesIgnored() || newValue != null) {
                index.put(newValue, iRecord.placeholder());
            }
        }
    }

    private static boolean processCompositeIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OCompositeIndexDefinition indexDefinition = (OCompositeIndexDefinition)index.getDefinition();
        String multiValueField = indexDefinition.getMultiValueField();
        List<String> indexFields = indexDefinition.getFields();
        for (String indexField : indexFields) {
            if (!dirtyFields.contains(indexField)) continue;
            ArrayList<Object> origValues = new ArrayList<Object>(indexFields.size());
            for (String field : indexFields) {
                if (field.equals(multiValueField)) continue;
                if (dirtyFields.contains(field)) {
                    origValues.add(iRecord.getOriginalValue(field));
                    continue;
                }
                origValues.add(iRecord.field(field));
            }
            if (multiValueField != null) {
                OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(multiValueField);
                if (multiValueChangeTimeLine != null) {
                    OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(multiValueField);
                    Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), restoredMultiValue);
                } else if (dirtyFields.contains(multiValueField)) {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.getOriginalValue(multiValueField));
                } else {
                    origValues.add(indexDefinition.getMultiValueDefinitionIndex(), iRecord.field(multiValueField));
                }
            }
            Object origValue = indexDefinition.createValue(origValues);
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private static void deleteIndexKey(OIndex<?> index, ODocument iRecord, Object origValue) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (origValue instanceof Collection) {
            for (Object valueItem : (Collection)origValue) {
                if (indexDefinition.isNullValuesIgnored() && valueItem == null) continue;
                index.remove(valueItem, iRecord);
            }
        } else if (!indexDefinition.isNullValuesIgnored() || origValue != null) {
            index.remove(origValue, iRecord);
        }
    }

    private static boolean processSingleIndexDelete(OIndex<?> index, Set<String> dirtyFields, ODocument iRecord) {
        OIndexDefinition indexDefinition = index.getDefinition();
        List<String> indexFields = indexDefinition.getFields();
        if (indexFields.isEmpty()) {
            return false;
        }
        String indexField = indexFields.iterator().next();
        if (dirtyFields.contains(indexField)) {
            Object origValue;
            OMultiValueChangeTimeLine<Object, Object> multiValueChangeTimeLine = iRecord.getCollectionTimeLine(indexField);
            if (multiValueChangeTimeLine != null) {
                OTrackedMultiValue fieldValue = (OTrackedMultiValue)iRecord.field(indexField);
                Object restoredMultiValue = fieldValue.returnOriginalState(multiValueChangeTimeLine.getMultiValueChangeEvents());
                origValue = indexDefinition.createValue(restoredMultiValue);
            } else {
                origValue = indexDefinition.createValue(iRecord.getOriginalValue(indexField));
            }
            OClassIndexManager.deleteIndexKey(index, iRecord, origValue);
            return true;
        }
        return false;
    }

    private void checkIndexes(ODocument document, ORecordHook.TYPE hookType) {
        OClass cls = (document = OClassIndexManager.checkForLoading(document)).getSchemaClass();
        if (cls != null) {
            Set<OIndex<?>> indexes = cls.getIndexes();
            switch (hookType) {
                case BEFORE_CREATE: {
                    OClassIndexManager.checkIndexedPropertiesOnCreation(document, indexes);
                    break;
                }
                case BEFORE_UPDATE: {
                    OClassIndexManager.checkIndexedPropertiesOnUpdate(document, indexes);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid hook type: " + (Object)((Object)hookType));
                }
            }
        }
    }

    private static void checkIndexedPropertiesOnCreation(ODocument iRecord, Collection<OIndex<?>> iIndexes) {
        for (OIndex<?> index : iIndexes) {
            OIndexDefinition indexDefinition = index.getDefinition();
            Object key = index.getDefinition().getDocumentValueToIndex(iRecord);
            if (key instanceof Collection) {
                for (Object keyItem : (Collection)key) {
                    if (indexDefinition.isNullValuesIgnored() && keyItem == null) continue;
                    index.checkEntry(iRecord, keyItem);
                }
                continue;
            }
            if (indexDefinition.isNullValuesIgnored() && key == null) continue;
            index.checkEntry(iRecord, key);
        }
    }

    private static void checkIndexedPropertiesOnUpdate(ODocument iRecord, Collection<OIndex<?>> iIndexes) {
        HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iRecord.getDirtyFields()));
        if (dirtyFields.isEmpty()) {
            return;
        }
        block0: for (OIndex<?> index : iIndexes) {
            OIndexDefinition indexDefinition = index.getDefinition();
            List<String> indexFields = indexDefinition.getFields();
            for (String indexField : indexFields) {
                if (!dirtyFields.contains(indexField)) continue;
                Object key = index.getDefinition().getDocumentValueToIndex(iRecord);
                if (key instanceof Collection) {
                    for (Object keyItem : (Collection)key) {
                        if (indexDefinition.isNullValuesIgnored() && keyItem == null) continue;
                        index.checkEntry(iRecord, keyItem);
                    }
                    continue block0;
                }
                if (indexDefinition.isNullValuesIgnored() && key == null) continue block0;
                index.checkEntry(iRecord, key);
                continue block0;
            }
        }
    }

    private static ODocument checkForLoading(ODocument iRecord) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                return (ODocument)iRecord.load();
            }
            catch (ORecordNotFoundException e) {
                throw new OIndexException("Error during loading of record with id : " + iRecord.getIdentity());
            }
        }
        return iRecord;
    }
}

