/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.id;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.util.MersenneTwister;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;

public class ONodeId
extends Number
implements Comparable<ONodeId> {
    private static final int CHUNKS_SIZE = 6;
    public static final int NODE_SIZE_BYTES = 24;
    public static final int NODE_SIZE_BITS = 192;
    public static final int SERIALIZED_SIZE = 25;
    private static final long LONG_INT_MASK = 0xFFFFFFFFL;
    private static final int UNSIGNED_INT_MAX_VALUE = -1;
    public static final ONodeId MAX_VALUE = new ONodeId(new int[]{-1, -1, -1, -1, -1, -1}, 1);
    public static final ONodeId MIN_VALUE = new ONodeId(new int[]{-1, -1, -1, -1, -1, -1}, -1);
    public static final ONodeId ZERO = new ONodeId(new int[6], 0);
    public static final ONodeId ONE = new ONodeId(new int[]{0, 0, 0, 0, 0, 1}, 1);
    public static final ONodeId TWO = new ONodeId(new int[]{0, 0, 0, 0, 0, 2}, 1);
    private static final MersenneTwister random = new MersenneTwister();
    private static final SecureRandom secureRandom = new SecureRandom();
    private final int[] chunks;
    private final int signum;

    private ONodeId(int[] chunks, int signum) {
        this.chunks = chunks;
        this.signum = signum;
    }

    @Override
    public int compareTo(ONodeId o) {
        if (this.signum > o.signum) {
            return 1;
        }
        if (this.signum < o.signum) {
            return -1;
        }
        if (this.signum == 0 && o.signum == 0) {
            return 0;
        }
        int result = ONodeId.compareChunks(this.chunks, o.chunks);
        if (this.signum < 0) {
            return -result;
        }
        return result;
    }

    public ONodeId add(ONodeId idToAdd) {
        if (idToAdd.signum == 0) {
            return new ONodeId(this.chunks, this.signum);
        }
        if (this.signum == 0) {
            return new ONodeId(idToAdd.chunks, idToAdd.signum);
        }
        if (this.signum == idToAdd.signum) {
            int[] result = ONodeId.addArrays(this.chunks, idToAdd.chunks);
            if (Arrays.equals(ONodeId.ZERO.chunks, result)) {
                return ZERO;
            }
            return new ONodeId(result, this.signum);
        }
        int cmp = ONodeId.compareChunks(this.chunks, idToAdd.chunks);
        if (cmp == 0) {
            return ZERO;
        }
        int[] result = cmp > 0 ? ONodeId.substructArrays(this.chunks, idToAdd.chunks) : ONodeId.substructArrays(idToAdd.chunks, this.chunks);
        return new ONodeId(result, cmp == this.signum ? 1 : -1);
    }

    public ONodeId subtract(ONodeId idToSubtract) {
        if (idToSubtract.signum == 0) {
            return this;
        }
        if (this.signum == 0) {
            return new ONodeId(idToSubtract.chunks, -idToSubtract.signum);
        }
        if (this.signum != idToSubtract.signum) {
            int[] result = ONodeId.addArrays(this.chunks, idToSubtract.chunks);
            if (Arrays.equals(ONodeId.ZERO.chunks, result)) {
                return ZERO;
            }
            return new ONodeId(result, this.signum);
        }
        int cmp = ONodeId.compareChunks(this.chunks, idToSubtract.chunks);
        if (cmp == 0) {
            return ZERO;
        }
        int[] result = cmp > 0 ? ONodeId.substructArrays(this.chunks, idToSubtract.chunks) : ONodeId.substructArrays(idToSubtract.chunks, this.chunks);
        return new ONodeId(result, cmp == this.signum ? 1 : -1);
    }

    public ONodeId multiply(int value) {
        if (value == 0) {
            return ZERO;
        }
        int[] result = new int[6];
        long carry = 0L;
        for (int j = 5; j >= 0; --j) {
            long product = ((long)this.chunks[j] & 0xFFFFFFFFL) * ((long)value & 0xFFFFFFFFL) + carry;
            result[j] = (int)product;
            carry = product >>> 32;
        }
        return new ONodeId(result, this.signum);
    }

    public ONodeId shiftLeft(int shift) {
        int nInts = shift >>> 5;
        if (nInts == 6) {
            return ZERO;
        }
        int nBits = shift & 0x1F;
        int[] result = new int[6];
        if (nBits != 0) {
            int nBits2 = 32 - nBits;
            int i = nInts;
            int j = 0;
            while (i < 5) {
                result[j++] = this.chunks[i++] << nBits | this.chunks[i] >>> nBits2;
            }
            result[j] = this.chunks[i] << nBits;
        } else {
            System.arraycopy(this.chunks, nInts, result, 0, 6 - nInts);
        }
        if (Arrays.equals(ONodeId.ZERO.chunks, result)) {
            return ZERO;
        }
        return new ONodeId(result, this.signum);
    }

    public ONodeId shiftRight(int shift) {
        int nInts = shift >>> 5;
        if (nInts == 6) {
            return ZERO;
        }
        int nBits = shift & 0x1F;
        int[] result = new int[6];
        if (nBits != 0) {
            int nBits2 = 32 - nBits;
            int i = 0;
            int j = nInts;
            result[j++] = this.chunks[i] >>> nBits;
            while (j < 6) {
                result[j++] = this.chunks[i++] << nBits2 | this.chunks[i] >>> nBits;
            }
        } else {
            System.arraycopy(this.chunks, 0, result, nInts, 6 - nInts);
        }
        if (Arrays.equals(ONodeId.ZERO.chunks, result)) {
            return ZERO;
        }
        return new ONodeId(result, this.signum);
    }

    public static ONodeId generateUniqueId() {
        long clusterPosition = random.nextLong(Long.MAX_VALUE);
        int[] chunks = new int[6];
        byte[] uuid = new byte[16];
        secureRandom.nextBytes(uuid);
        chunks[0] = (int)(clusterPosition >>> 32);
        chunks[1] = (int)clusterPosition;
        chunks[2] = OIntegerSerializer.INSTANCE.deserialize(uuid, 0);
        chunks[3] = OIntegerSerializer.INSTANCE.deserialize(uuid, 4);
        chunks[4] = OIntegerSerializer.INSTANCE.deserialize(uuid, 8);
        chunks[5] = OIntegerSerializer.INSTANCE.deserialize(uuid, 12);
        return new ONodeId(chunks, 1);
    }

    private static int[] addArrays(int[] chunksToAddOne, int[] chunksToAddTwo) {
        int[] result = new int[6];
        int index = 6;
        long sum = 0L;
        while (index > 0) {
            sum = ((long)chunksToAddTwo[--index] & 0xFFFFFFFFL) + ((long)chunksToAddOne[index] & 0xFFFFFFFFL) + (sum >>> 32);
            result[index] = (int)sum;
        }
        return result;
    }

    private static int compareChunks(int[] chunksOne, int[] chunksTwo) {
        for (int i = 0; i < 6; ++i) {
            long chunk = (long)chunksOne[i] & 0xFFFFFFFFL;
            long otherChunk = (long)chunksTwo[i] & 0xFFFFFFFFL;
            if (chunk == otherChunk) continue;
            if (chunk > otherChunk) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private static int[] substructArrays(int[] chunksOne, int[] chunksTwo) {
        int[] result = new int[6];
        int index = 6;
        long difference = 0L;
        while (index > 0) {
            difference = ((long)chunksOne[--index] & 0xFFFFFFFFL) - ((long)chunksTwo[index] & 0xFFFFFFFFL) + (difference >> 32);
            result[index] = (int)difference;
        }
        return result;
    }

    private static void multiplyAndAdd(int[] chunks, int multiplier, int summand) {
        long carry = 0L;
        for (int j = 5; j >= 0; --j) {
            long product = ((long)chunks[j] & 0xFFFFFFFFL) * ((long)multiplier & 0xFFFFFFFFL) + carry;
            chunks[j] = (int)product;
            carry = product >>> 32;
        }
        if (summand == 0) {
            return;
        }
        long sum = ((long)chunks[5] & 0xFFFFFFFFL) + ((long)summand & 0xFFFFFFFFL);
        chunks[5] = (int)sum;
        for (int j = 4; j >= 0 && sum > 0L; --j) {
            sum = ((long)chunks[j] & 0xFFFFFFFFL) + (sum >>> 32);
            chunks[j] = (int)sum;
        }
    }

    @Override
    public int intValue() {
        int reslut = this.chunks[5];
        if (this.signum < 0) {
            return -reslut;
        }
        return reslut;
    }

    @Override
    public long longValue() {
        long reslut = (((long)this.chunks[4] & 0xFFFFFFFFL) << 32) + ((long)this.chunks[5] & 0xFFFFFFFFL) & Long.MAX_VALUE;
        if (this.signum < 0) {
            return -reslut;
        }
        return reslut;
    }

    public long longValueHigh() {
        long reslut = (((long)this.chunks[0] & 0xFFFFFFFFL) << 32) + ((long)this.chunks[1] & 0xFFFFFFFFL) & Long.MAX_VALUE;
        if (this.signum < 0) {
            return -reslut;
        }
        return reslut;
    }

    @Override
    public float floatValue() {
        return Float.parseFloat(this.toString());
    }

    @Override
    public double doubleValue() {
        return Double.parseDouble(this.toString());
    }

    public byte[] toStream() {
        byte[] bytes = new byte[25];
        int pos = 0;
        for (int i = 0; i < 6; ++i) {
            OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(this.chunks[i]), bytes, pos, new Object[0]);
            pos += 4;
        }
        bytes[pos] = (byte)this.signum;
        return bytes;
    }

    public byte[] chunksToByteArray() {
        byte[] bytes = new byte[24];
        int pos = 0;
        for (int i = 0; i < 6; ++i) {
            OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(this.chunks[i]), bytes, pos, new Object[0]);
            pos += 4;
        }
        return bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ONodeId oNodeId = (ONodeId)o;
        if (this.signum != oNodeId.signum) {
            return false;
        }
        return Arrays.equals(this.chunks, oNodeId.chunks);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.chunks);
        result = 31 * result + this.signum;
        return result;
    }

    public String toString() {
        return new BigInteger(this.signum, this.chunksToByteArray()).toString();
    }

    public static ONodeId valueOf(long value) {
        int signum;
        ONodeId constant = ONodeId.findInConstantPool(value);
        if (constant != null) {
            return constant;
        }
        if (value > 0L) {
            signum = 1;
        } else {
            signum = -1;
            value = -value;
        }
        int[] chunks = new int[6];
        chunks[5] = (int)(value & 0xFFFFFFFFL);
        chunks[4] = (int)(value >>> 32);
        return new ONodeId(chunks, signum);
    }

    public static ONodeId parseString(String value) {
        int signum;
        int pos;
        int intChunkLength = 9;
        int longChunkLength = 18;
        if (value.charAt(0) == '-') {
            pos = 1;
            signum = -1;
        } else {
            pos = 0;
            signum = 1;
        }
        while (pos < value.length() && Character.digit(value.charAt(pos), 10) == 0) {
            ++pos;
        }
        if (pos == value.length()) {
            return ZERO;
        }
        int chunkToRead = Math.min(pos + 18, value.length());
        long initialValue = Long.parseLong(value.substring(pos, chunkToRead));
        pos = chunkToRead;
        int[] result = new int[6];
        result[5] = (int)initialValue;
        result[4] = (int)(initialValue >>> 32);
        while (pos < value.length()) {
            chunkToRead = Math.min(pos + 9, value.length());
            int parsedValue = Integer.parseInt(value.substring(pos, chunkToRead));
            int multiplier = chunkToRead == 9 ? 1000000000 : (int)Math.pow(10.0, chunkToRead - pos);
            ONodeId.multiplyAndAdd(result, multiplier, parsedValue);
            pos = chunkToRead;
        }
        return new ONodeId(result, signum);
    }

    public static ONodeId fromStream(byte[] content, int start) {
        int[] chunks = new int[6];
        int pos = start;
        for (int i = 0; i < 6; ++i) {
            chunks[i] = OIntegerSerializer.INSTANCE.deserialize(content, pos);
            pos += 4;
        }
        byte signum = content[pos];
        return new ONodeId(chunks, signum);
    }

    public static ONodeId parseHexSting(String value) {
        int signum;
        int pos;
        if (value.charAt(0) == '-') {
            pos = 1;
            signum = -1;
        } else {
            pos = 0;
            signum = 1;
        }
        int[] chunks = new int[6];
        for (int i = 0; i < 6; ++i) {
            String chunk = value.substring(pos, pos + 8);
            chunks[i] = (int)Long.parseLong(chunk, 16);
            pos += 8;
        }
        if (Arrays.equals(ONodeId.ZERO.chunks, chunks)) {
            return ZERO;
        }
        return new ONodeId(chunks, signum);
    }

    public String toHexString() {
        StringBuilder builder = new StringBuilder();
        if (this.signum < 0) {
            builder.append("-");
        }
        for (int chunk : this.chunks) {
            builder.append(String.format("%1$08x", chunk));
        }
        return builder.toString();
    }

    private static ONodeId findInConstantPool(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == 1L) {
            return ONE;
        }
        if (value == 2L) {
            return TWO;
        }
        return null;
    }

    static {
        random.setSeed(OLongSerializer.INSTANCE.deserialize(secureRandom.generateSeed(8), 0).longValue());
    }
}

