/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.id;

import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.ONodeId;

public final class OClusterPositionNodeId
extends OClusterPosition {
    private static final ONodeId INVALID_NODE_ID = ONodeId.valueOf(-1L);
    private final ONodeId nodeId;

    public ONodeId getNodeId() {
        return this.nodeId;
    }

    public OClusterPositionNodeId(ONodeId nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public OClusterPosition inc() {
        return new OClusterPositionNodeId(this.nodeId.add(ONodeId.ONE));
    }

    @Override
    public OClusterPosition dec() {
        return new OClusterPositionNodeId(this.nodeId.subtract(ONodeId.ONE));
    }

    @Override
    public boolean isValid() {
        return !this.nodeId.equals(INVALID_NODE_ID);
    }

    @Override
    public boolean isPersistent() {
        return this.nodeId.compareTo(INVALID_NODE_ID) > 0;
    }

    @Override
    public boolean isNew() {
        return this.nodeId.compareTo(ONodeId.ZERO) < 0;
    }

    @Override
    public boolean isTemporary() {
        return this.nodeId.compareTo(INVALID_NODE_ID) < 0;
    }

    @Override
    public byte[] toStream() {
        return this.nodeId.toStream();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OClusterPositionNodeId that = (OClusterPositionNodeId)o;
        return this.nodeId.equals(that.nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public String toString() {
        return this.nodeId.toString();
    }

    @Override
    public int compareTo(OClusterPosition o) {
        OClusterPositionNodeId clusterPositionNodeId = (OClusterPositionNodeId)o;
        return this.nodeId.compareTo(clusterPositionNodeId.getNodeId());
    }

    @Override
    public int intValue() {
        return this.nodeId.intValue();
    }

    @Override
    public long longValue() {
        return this.nodeId.longValue();
    }

    @Override
    public long longValueHigh() {
        return this.nodeId.longValueHigh();
    }

    @Override
    public float floatValue() {
        return this.nodeId.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.nodeId.doubleValue();
    }
}

