/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.id;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.id.OClusterPosition;
import com.orientechnologies.orient.core.id.OClusterPositionLong;
import com.orientechnologies.orient.core.id.OClusterPositionNodeId;
import com.orientechnologies.orient.core.id.ONodeId;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;

public abstract class OClusterPositionFactory {
    public static final OClusterPositionFactory INSTANCE = OGlobalConfiguration.USE_NODE_ID_CLUSTER_POSITION.getValueAsBoolean() ? new OClusterPositionFactoryNodeId() : new OClusterPositionFactoryLong();

    public abstract OClusterPosition generateUniqueClusterPosition();

    public abstract OClusterPosition valueOf(long var1);

    public abstract OClusterPosition valueOf(String var1);

    public abstract OClusterPosition fromStream(byte[] var1, int var2);

    public abstract int getSerializedSize();

    public OClusterPosition fromStream(byte[] content) {
        return this.fromStream(content, 0);
    }

    public OClusterPosition fromStream(InputStream in) throws IOException {
        int bytesToRead;
        int contentLength = 0;
        int clusterSize = INSTANCE.getSerializedSize();
        byte[] clusterContent = new byte[clusterSize];
        while ((bytesToRead = in.read(clusterContent, contentLength, clusterSize - contentLength)) >= 0 && (contentLength += bytesToRead) < clusterSize) {
        }
        return this.fromStream(clusterContent);
    }

    public OClusterPosition fromStream(ObjectInput in) throws IOException {
        int bytesToRead;
        int contentLength = 0;
        int clusterSize = INSTANCE.getSerializedSize();
        byte[] clusterContent = new byte[clusterSize];
        while ((bytesToRead = in.read(clusterContent, contentLength, clusterSize - contentLength)) >= 0 && (contentLength += bytesToRead) < clusterSize) {
        }
        return this.fromStream(clusterContent);
    }

    public OClusterPosition fromStream(DataInput in) throws IOException {
        int clusterSize = INSTANCE.getSerializedSize();
        byte[] clusterContent = new byte[clusterSize];
        in.readFully(clusterContent);
        return this.fromStream(clusterContent);
    }

    public abstract OClusterPosition getMaxValue();

    public static final class OClusterPositionFactoryNodeId
    extends OClusterPositionFactory {
        @Override
        public OClusterPosition generateUniqueClusterPosition() {
            return new OClusterPositionNodeId(ONodeId.generateUniqueId());
        }

        @Override
        public OClusterPosition valueOf(long value) {
            return new OClusterPositionNodeId(ONodeId.valueOf(value));
        }

        @Override
        public OClusterPosition valueOf(String value) {
            return new OClusterPositionNodeId(ONodeId.parseString(value));
        }

        @Override
        public OClusterPosition fromStream(byte[] content, int start) {
            return new OClusterPositionNodeId(ONodeId.fromStream(content, start));
        }

        @Override
        public int getSerializedSize() {
            return 25;
        }

        @Override
        public OClusterPosition getMaxValue() {
            return new OClusterPositionNodeId(ONodeId.MAX_VALUE);
        }
    }

    public static final class OClusterPositionFactoryLong
    extends OClusterPositionFactory {
        @Override
        public OClusterPosition generateUniqueClusterPosition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OClusterPosition valueOf(long value) {
            return new OClusterPositionLong(value);
        }

        @Override
        public OClusterPosition valueOf(String value) {
            return new OClusterPositionLong(Long.valueOf(value));
        }

        @Override
        public OClusterPosition fromStream(byte[] content, int start) {
            return new OClusterPositionLong(OLongSerializer.INSTANCE.deserialize(content, start));
        }

        @Override
        public int getSerializedSize() {
            return 8;
        }

        @Override
        public OClusterPosition getMaxValue() {
            return new OClusterPositionLong(Long.MAX_VALUE);
        }
    }
}

