/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag.embedded;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBagDelegate;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;

public class OEmbeddedRidBag
implements ORidBagDelegate {
    private byte[] serializedContent = null;
    private boolean contentWasChanged = false;
    private boolean deserialized = true;
    private Object[] entries = new Object[0];
    private int entriesLength = 0;
    private boolean convertToRecord = true;
    private int size = 0;
    private transient ORecord<?> owner;
    private Set<OMultiValueChangeListener<OIdentifiable, OIdentifiable>> changeListeners = Collections.newSetFromMap(new WeakHashMap());

    @Override
    public void setOwner(ORecord<?> owner) {
        if (owner != null && this.owner != null && !this.owner.equals(owner)) {
            throw new IllegalStateException("This data structure is owned by document " + owner + " if you want to use it in other document create new rid bag instance and copy content of current one.");
        }
        this.owner = owner;
    }

    @Override
    public ORecord<?> getOwner() {
        return this.owner;
    }

    @Override
    public void addAll(Collection<OIdentifiable> values) {
        for (OIdentifiable value : values) {
            this.add(value);
        }
    }

    @Override
    public void add(OIdentifiable identifiable) {
        this.addEntry(identifiable);
        ++this.size;
        this.contentWasChanged = true;
        this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.ADD, identifiable, identifiable));
    }

    private void addEntry(OIdentifiable identifiable) {
        if (this.entries.length == this.entriesLength) {
            if (this.entriesLength == 0) {
                this.entries = new Object[4];
            } else {
                Object[] oldEntries = this.entries;
                this.entries = new Object[this.entries.length << 1];
                System.arraycopy(oldEntries, 0, this.entries, 0, oldEntries.length);
            }
        }
        this.entries[this.entriesLength] = identifiable;
        ++this.entriesLength;
    }

    @Override
    public void remove(OIdentifiable identifiable) {
        this.doDeserialization();
        if (this.removeEntry(identifiable)) {
            --this.size;
            this.contentWasChanged = true;
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, identifiable, null, identifiable));
        }
    }

    private boolean removeEntry(OIdentifiable identifiable) {
        int i;
        for (i = 0; i < this.entriesLength; ++i) {
            Object entry = this.entries[i];
            if (!entry.equals(identifiable)) continue;
            this.entries[i] = Tombstone.TOMBSTONE;
            break;
        }
        return i < this.entriesLength;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        this.doDeserialization();
        return new EntriesIterator(this.convertToRecord);
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        this.doDeserialization();
        return new EntriesIterator(false);
    }

    @Override
    public void convertLinks2Records() {
        this.doDeserialization();
        for (int i = 0; i < this.entriesLength; ++i) {
            Object entry = this.entries[i];
            if (!(entry instanceof OIdentifiable)) continue;
            OIdentifiable identifiable = (OIdentifiable)entry;
            this.entries[i] = identifiable.getRecord();
        }
    }

    @Override
    public boolean convertRecords2Links() {
        for (int i = 0; i < this.entriesLength; ++i) {
            OIdentifiable identifiable;
            Object entry = this.entries[i];
            if (!(entry instanceof OIdentifiable) || !((identifiable = (OIdentifiable)entry) instanceof ORecord)) continue;
            ORecord record = (ORecord)identifiable;
            if (record.isDirty() || record.getIdentity().isNew()) {
                record.save();
            }
            this.entries[i] = record.getIdentity();
        }
        return true;
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.convertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.convertToRecord = convertToRecord;
    }

    @Override
    public boolean detach() {
        return this.convertRecords2Links();
    }

    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        if (!this.deserialized) {
            return "[size=" + this.size + "]";
        }
        if (this.size < 10) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<OIdentifiable> it = this.iterator();
            while (it.hasNext()) {
                try {
                    OIdentifiable e = it.next();
                    sb.append(e.getIdentity());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            return sb.append(']').toString();
        }
        return "[size=" + this.size + "]";
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        this.changeListeners.remove(changeListener);
    }

    @Override
    public Object returnOriginalState(List<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> multiValueChangeEvents) {
        OEmbeddedRidBag reverted = new OEmbeddedRidBag();
        for (OIdentifiable identifiable : this) {
            reverted.add(identifiable);
        }
        ListIterator<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block5: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block5;
                }
                case REMOVE: {
                    reverted.add(event.getOldValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    @Override
    public int getSerializedSize() {
        int size = !this.deserialized ? this.serializedContent.length : 4;
        return size += this.size * OLinkSerializer.RID_SIZE;
    }

    @Override
    public int getSerializedSize(byte[] stream, int offset) {
        return OIntegerSerializer.INSTANCE.deserialize(stream, offset) * OLinkSerializer.RID_SIZE + 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int serialize(byte[] stream, int offset, UUID ownerUuid) {
        for (int i = 0; i < this.entriesLength; ++i) {
            ORecord record;
            OIdentifiable identifiable;
            Object entry = this.entries[i];
            if (!(entry instanceof OIdentifiable) || !((identifiable = (OIdentifiable)entry) instanceof ORecord) || !(record = (ORecord)identifiable).isDirty() && !record.getIdentity().isNew()) continue;
            record.save();
        }
        if (!this.deserialized) {
            System.arraycopy(this.serializedContent, 0, stream, offset, this.serializedContent.length);
            if (!this.contentWasChanged) return offset += this.serializedContent.length;
            OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(this.size), stream, offset, new Object[0]);
            offset += this.serializedContent.length;
        } else {
            OIntegerSerializer.INSTANCE.serialize(Integer.valueOf(this.size), stream, offset, new Object[0]);
            offset += 4;
        }
        for (Object entry : this.entries) {
            if (!(entry instanceof OIdentifiable)) continue;
            OLinkSerializer.INSTANCE.serialize((OIdentifiable)entry, stream, offset, new Object[0]);
            offset += OLinkSerializer.RID_SIZE;
        }
        return offset;
    }

    @Override
    public int deserialize(byte[] stream, int offset) {
        int contentSize = this.getSerializedSize(stream, offset);
        this.size = OIntegerSerializer.INSTANCE.deserialize(stream, offset);
        this.serializedContent = new byte[contentSize];
        System.arraycopy(stream, offset, this.serializedContent, 0, contentSize);
        this.deserialized = false;
        return offset + contentSize;
    }

    private void doDeserialization() {
        if (this.deserialized) {
            return;
        }
        int offset = 0;
        int entriesSize = OIntegerSerializer.INSTANCE.deserialize(this.serializedContent, offset);
        offset += 4;
        for (int i = 0; i < entriesSize; ++i) {
            ORecordId rid = OLinkSerializer.INSTANCE.deserialize(this.serializedContent, offset);
            offset += OLinkSerializer.RID_SIZE;
            ORecordId identifiable = rid.isTemporary() ? rid.getRecord() : rid;
            this.addEntry(identifiable);
        }
        this.deserialized = true;
    }

    @Override
    public Class<?> getGenericClass() {
        return OIdentifiable.class;
    }

    @Override
    public Set<OMultiValueChangeListener<OIdentifiable, OIdentifiable>> getChangeListeners() {
        return Collections.unmodifiableSet(this.changeListeners);
    }

    @Override
    public void requestDelete() {
    }

    protected void fireCollectionChangedEvent(OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event) {
        for (OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener : this.changeListeners) {
            if (changeListener == null) continue;
            changeListener.onAfterRecordChanged(event);
        }
    }

    private static enum Tombstone {
        TOMBSTONE;

    }

    private final class EntriesIterator
    implements Iterator<OIdentifiable>,
    OResettable,
    OSizeable {
        private int currentIndex = -1;
        private int nextIndex = -1;
        private boolean currentRemoved;
        private final boolean convertToRecord;

        private EntriesIterator(boolean convertToRecord) {
            this.reset();
            this.convertToRecord = convertToRecord;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex > -1;
        }

        @Override
        public OIdentifiable next() {
            this.currentRemoved = false;
            this.currentIndex = this.nextIndex;
            if (this.currentIndex == -1) {
                throw new NoSuchElementException();
            }
            OIdentifiable nextValue = (OIdentifiable)OEmbeddedRidBag.this.entries[this.currentIndex];
            this.nextIndex = this.nextIndex();
            if (this.convertToRecord) {
                return nextValue.getRecord();
            }
            return nextValue;
        }

        @Override
        public void remove() {
            if (this.currentRemoved) {
                throw new IllegalStateException("Current element has already been removed");
            }
            if (this.currentIndex == -1) {
                throw new IllegalStateException("Next method was not called for given iterator");
            }
            this.currentRemoved = true;
            OIdentifiable nextValue = (OIdentifiable)OEmbeddedRidBag.this.entries[this.currentIndex];
            ((OEmbeddedRidBag)OEmbeddedRidBag.this).entries[this.currentIndex] = Tombstone.TOMBSTONE;
            OEmbeddedRidBag.this.size--;
            OEmbeddedRidBag.this.contentWasChanged = true;
            OEmbeddedRidBag.this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, nextValue, null, nextValue));
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.currentRemoved = false;
            this.nextIndex = this.nextIndex();
        }

        private int nextIndex() {
            for (int i = this.currentIndex + 1; i < OEmbeddedRidBag.this.entriesLength; ++i) {
                Object entry = OEmbeddedRidBag.this.entries[i];
                if (!(entry instanceof OIdentifiable)) continue;
                return i;
            }
            return -1;
        }

        public int size() {
            return OEmbeddedRidBag.this.size;
        }
    }
}

