/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OTransactionBlockedException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.Iterator;

public class ODatabaseRecordTx
extends ODatabaseRecordAbstract {
    public static final String TYPE = "record";
    private OTransaction currentTx;

    public ODatabaseRecordTx(String iURL, byte iRecordType) {
        super(iURL, iRecordType);
        this.init();
    }

    public ODatabaseRecord begin() {
        return this.begin(OTransaction.TXTYPE.OPTIMISTIC);
    }

    public ODatabaseRecord begin(OTransaction.TXTYPE iType) {
        this.setCurrentDatabaseinThreadLocal();
        if (this.currentTx.isActive()) {
            if (iType == OTransaction.TXTYPE.OPTIMISTIC && this.currentTx instanceof OTransactionOptimistic) {
                this.currentTx.begin();
                return this;
            }
            this.currentTx.rollback(true, 0);
        }
        for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).browseListeners()) {
            try {
                listener.onBeforeTxBegin(this.underlying);
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error before tx begin", t, new Object[0]);
            }
        }
        switch (iType) {
            case NOTX: {
                this.setDefaultTransactionMode();
                break;
            }
            case OPTIMISTIC: {
                this.currentTx = new OTransactionOptimistic(this);
                break;
            }
            case PESSIMISTIC: {
                throw new UnsupportedOperationException("Pessimistic transaction");
            }
        }
        this.currentTx.begin();
        return this;
    }

    public ODatabaseRecord begin(OTransaction iTx) {
        if (this.currentTx.isActive() && iTx.equals(this.currentTx)) {
            this.currentTx.begin();
            return this;
        }
        this.currentTx.rollback(true, 0);
        for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).browseListeners()) {
            try {
                listener.onBeforeTxBegin(this.underlying);
            }
            catch (Throwable t) {
                OLogManager.instance().error((Object)this, "Error before the transaction begin", t, OTransactionBlockedException.class, new Object[0]);
            }
        }
        this.currentTx = iTx;
        this.currentTx.begin();
        return this;
    }

    public ODatabaseRecord commit() {
        return this.commit(false);
    }

    public ODatabaseRecord commit(boolean force) throws OTransactionException {
        if (!this.currentTx.isActive()) {
            return this;
        }
        if (!force && this.currentTx.amountOfNestedTxs() > 1) {
            this.currentTx.commit();
            return this;
        }
        this.setCurrentDatabaseinThreadLocal();
        for (Iterator listener : ((ODatabaseRaw)this.underlying).browseListeners()) {
            try {
                listener.onBeforeTxCommit(this);
            }
            catch (Throwable t) {
                this.rollback(force);
                OLogManager.instance().debug((Object)this, "Cannot commit the transaction: caught exception on execution of %s.onBeforeTxCommit()", t, OTransactionBlockedException.class, new Object[]{listener.getClass()});
            }
        }
        try {
            this.currentTx.commit(force);
        }
        catch (RuntimeException e) {
            for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).browseListeners()) {
                try {
                    listener.onBeforeTxRollback(this.underlying);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error before tx rollback", t, new Object[0]);
                }
            }
            this.currentTx.rollback(false, 0);
            for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).browseListeners()) {
                try {
                    listener.onAfterTxRollback(this.underlying);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error after tx rollback", t, new Object[0]);
                }
            }
            throw e;
        }
        for (Iterator listener : ((ODatabaseRaw)this.underlying).browseListeners()) {
            try {
                listener.onAfterTxCommit(this.underlying);
            }
            catch (Throwable t) {
                OLogManager.instance().debug((Object)this, "Error after the transaction has been committed. The transaction remains valid. The exception caught was on execution of %s.onAfterTxCommit()", t, OTransactionBlockedException.class, new Object[]{listener.getClass()});
            }
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.commit(true);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Exception during commit of active transaction.", (Throwable)e, new Object[0]);
        }
        super.close();
    }

    public ODatabaseRecord rollback() {
        return this.rollback(false);
    }

    public ODatabaseRecord rollback(boolean force) throws OTransactionException {
        if (this.currentTx.isActive()) {
            if (!force && this.currentTx.amountOfNestedTxs() > 1) {
                this.currentTx.rollback();
                return this;
            }
            for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).browseListeners()) {
                try {
                    listener.onBeforeTxRollback(this.underlying);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error before tx rollback", t, new Object[0]);
                }
            }
            this.currentTx.rollback(force, -1);
            for (ODatabaseListener listener : ((ODatabaseRaw)this.underlying).browseListeners()) {
                try {
                    listener.onAfterTxRollback(this.underlying);
                }
                catch (Throwable t) {
                    OLogManager.instance().error((Object)this, "Error after tx rollback", t, new Object[0]);
                }
            }
        }
        return this;
    }

    @Override
    public OTransaction getTransaction() {
        return this.currentTx;
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan) {
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, false, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord) {
        return (RET)this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, null, false, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId) {
        return (RET)this.currentTx.loadRecord(iRecordId, null, null, false, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan) {
        return (RET)this.currentTx.loadRecord(iRecordId, null, iFetchPlan, false, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return (RET)this.currentTx.loadRecord(iRecordId, null, iFetchPlan, iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord) {
        return this.reload(iRecord, (String)null, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord, String iFetchPlan) {
        return this.reload(iRecord, iFetchPlan, false);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        ORecordInternal<?> record = this.currentTx.loadRecord(iRecord.getIdentity(), iRecord, iFetchPlan, iIgnoreCache, false, OStorage.LOCKING_STRATEGY.DEFAULT);
        if (record != null && iRecord != record) {
            iRecord.fromStream(record.toStream());
            iRecord.getRecordVersion().copyFrom(record.getRecordVersion());
        }
        return (RET)record;
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        return this.save(iContent, (String)null, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent) {
        return this.save(iContent, (String)null, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<ORecordVersion>)null);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, String iClusterName) {
        return this.save(iContent, iClusterName, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<ORecordVersion>)null);
    }

    @Override
    public boolean updatedReplica(ORecordInternal<?> iContent) {
        return this.currentTx.updateReplica(iContent);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iContent, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        this.currentTx.saveRecord(iContent, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
        return (RET)iContent;
    }

    public ODatabaseRecord delete(ORID iRecord) {
        Object rec = iRecord.getRecord();
        if (rec != null) {
            rec.delete();
        }
        return this;
    }

    public ODatabaseRecord delete(ORecordInternal<?> iRecord) {
        this.currentTx.deleteRecord(iRecord, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS);
        return this;
    }

    @Override
    public boolean hide(ORID rid) {
        if (this.currentTx.isActive()) {
            throw new ODatabaseException("This operation can be executed only in non tx mode");
        }
        return super.hide(rid);
    }

    @Override
    public ODatabaseRecord delete(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        this.currentTx.deleteRecord(iRecord, iMode);
        return this;
    }

    public void executeRollback(OTransaction iTransaction) {
    }

    @Override
    public ORecordInternal<?> getRecordByUserObject(Object iUserObject, boolean iCreateIfNotAvailable) {
        return (ORecordInternal)iUserObject;
    }

    @Override
    public void registerUserObject(Object iObject, ORecordInternal<?> iRecord) {
    }

    @Override
    public void registerUserObjectAfterLinkSave(ORecordInternal<?> iRecord) {
    }

    @Override
    public Object getUserObjectByRecord(OIdentifiable record, String iFetchPlan) {
        return record;
    }

    @Override
    public boolean existsUserObjectByRID(ORID iRID) {
        return true;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setDefaultTransactionMode() {
        if (!(this.currentTx instanceof OTransactionNoTx)) {
            this.currentTx = new OTransactionNoTx(this);
        }
    }

    protected void checkTransaction() {
        if (this.currentTx == null || this.currentTx.getStatus() == OTransaction.TXSTATUS.INVALID) {
            throw new OTransactionException("Transaction not started");
        }
    }

    private void init() {
        this.currentTx = new OTransactionNoTx(this);
    }
}

