/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandExecutorUtility;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class OCommandExecutorScript
extends OCommandExecutorAbstract {
    protected OCommandScript request;

    public OCommandExecutorScript parse(OCommandRequest iRequest) {
        this.request = (OCommandScript)iRequest;
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        return this.executeInContext(this.context, iArgs);
    }

    public Object executeInContext(OCommandContext iContext, Map<Object, Object> iArgs) {
        String language = this.request.getLanguage();
        this.parserText = this.request.getText();
        if (language.equalsIgnoreCase("SQL")) {
            return this.executeSQL();
        }
        return this.executeJsr223Script(language, iContext, iArgs);
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    protected Object executeJsr223Script(String language, OCommandContext iContext, Map<Object, Object> iArgs) {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && !(db instanceof ODatabaseRecordTx)) {
            db = (ODatabaseRecord)db.getUnderlying();
        }
        OScriptManager scriptManager = Orient.instance().getScriptManager();
        CompiledScript compiledScript = this.request.getCompiledScript();
        if (compiledScript == null) {
            ScriptEngine scriptEngine = scriptManager.getEngine(language);
            if (!(scriptEngine instanceof Compilable)) {
                throw new OCommandExecutionException("Language '" + language + "' does not support compilation");
            }
            String lib = scriptManager.getLibrary(db, language);
            if (lib == null) {
                lib = "";
            }
            this.parserText = lib + this.parserText;
            Compilable c = (Compilable)((Object)scriptEngine);
            try {
                compiledScript = c.compile(this.parserText);
            }
            catch (ScriptException e) {
                scriptManager.getErrorMessage(e, this.parserText);
            }
            this.request.setCompiledScript(compiledScript);
        }
        Bindings binding = scriptManager.bind(compiledScript.getEngine().getBindings(100), (ODatabaseRecordTx)db, iContext, iArgs);
        try {
            Object ob = compiledScript.eval(binding);
            Object object = OCommandExecutorUtility.transformResult(ob);
            return object;
        }
        catch (ScriptException e) {
            throw new OCommandScriptException("Error on execution of the script", this.request.getText(), e.getColumnNumber(), e);
        }
        finally {
            scriptManager.unbind(binding);
        }
    }

    protected Object executeSQL() {
        ODatabaseRecord db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null && !(db instanceof ODatabaseRecordTx)) {
            db = (ODatabaseRecord)db.getUnderlying();
        }
        try {
            return this.executeSQLScript(db, this.parserText);
        }
        catch (IOException e) {
            throw new OCommandExecutionException("Error on executing command: " + this.parserText, e);
        }
    }

    protected void throwSyntaxErrorException(String iText) {
        throw new OCommandScriptException("Error on execution of the script: " + iText, this.request.getText(), 0);
    }

    protected Object executeSQLScript(ODatabaseRecord db, String iText) throws IOException {
        Cloneable lastResult = null;
        int maxRetry = 1;
        this.context.setVariable("transactionRetries", 0);
        for (int retry = 0; retry < maxRetry; ++retry) {
            String lastLine;
            int line;
            int txBegunAtLine = -1;
            int txBegunAtPart = -1;
            lastResult = null;
            BufferedReader reader = new BufferedReader(new StringReader(iText));
            int linePart = 0;
            boolean txBegun = false;
            for (line = 0; line < txBegunAtLine; ++line) {
                lastLine = reader.readLine();
            }
            while ((lastLine = reader.readLine()) != null) {
                lastLine = lastLine.trim();
                List<String> lineParts = OStringSerializerHelper.smartSplit(lastLine, ';', new char[0]);
                for (linePart = line == txBegunAtLine ? txBegunAtPart : 0; linePart < lineParts.size(); ++linePart) {
                    String lastCommand = lineParts.get(linePart);
                    if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "let ")) {
                        int equalsPos = lastCommand.indexOf(61);
                        String variable = lastCommand.substring("let ".length(), equalsPos).trim();
                        String cmd = lastCommand.substring(equalsPos + 1).trim();
                        lastResult = (Cloneable)db.command(new OCommandSQL(cmd).setContext(this.getContext())).execute(new Object[0]);
                        this.getContext().setVariable(variable, lastResult);
                        continue;
                    }
                    if (lastCommand.equalsIgnoreCase("begin")) {
                        if (txBegun) {
                            throw new OCommandSQLParsingException("Transaction already begun");
                        }
                        txBegun = true;
                        txBegunAtLine = line;
                        txBegunAtPart = linePart;
                        db.begin();
                        continue;
                    }
                    if (lastCommand.equalsIgnoreCase("rollback")) {
                        if (!txBegun) {
                            throw new OCommandSQLParsingException("Transaction not begun");
                        }
                        db.rollback();
                        txBegun = false;
                        txBegunAtLine = -1;
                        txBegunAtPart = -1;
                        continue;
                    }
                    if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "commit")) {
                        String next;
                        if (txBegunAtLine < 0) {
                            throw new OCommandSQLParsingException("Transaction not begun");
                        }
                        if (lastCommand.length() > "commit ".length() && OStringSerializerHelper.startsWithIgnoreCase(next = lastCommand.substring("commit ".length()).trim(), "retry ")) {
                            next = next.substring("retry ".length()).trim();
                            maxRetry = Integer.parseInt(next) + 1;
                        }
                        try {
                            db.commit();
                        }
                        catch (OConcurrentModificationException e) {
                            this.context.setVariable("transactionRetries", retry);
                            break;
                        }
                        txBegun = false;
                        txBegunAtLine = -1;
                        txBegunAtPart = -1;
                        continue;
                    }
                    if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "sleep ")) {
                        String sleepTimeInMs = lastCommand.substring("sleep ".length()).trim();
                        try {
                            Thread.sleep(Integer.parseInt(sleepTimeInMs));
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    if (OStringSerializerHelper.startsWithIgnoreCase(lastCommand, "return ")) {
                        Cloneable result;
                        String variable = lastCommand.substring("return ".length()).trim();
                        if (variable.equalsIgnoreCase("NULL")) {
                            lastResult = null;
                        } else if (variable.startsWith("$")) {
                            lastResult = this.getContext().getVariable(variable);
                        } else if (variable.startsWith("[") && variable.endsWith("]")) {
                            ArrayList<String> items = new ArrayList<String>();
                            OStringSerializerHelper.getCollection(variable, 0, items);
                            result = new ArrayList(items.size());
                            for (int i = 0; i < items.size(); ++i) {
                                String item = (String)items.get(i);
                                Object res = item.startsWith("$") ? this.getContext().getVariable(item) : item;
                                if (OMultiValue.isMultiValue((Object)res) && OMultiValue.getSize((Object)res) == 1) {
                                    res = OMultiValue.getFirstValue((Object)res);
                                }
                                result.add(res);
                            }
                            lastResult = result;
                        } else if (variable.startsWith("{") && variable.endsWith("}")) {
                            Map<String, String> map = OStringSerializerHelper.getMap(variable);
                            result = new HashMap(map.size());
                            for (Map.Entry<String, String> entry : map.entrySet()) {
                                String stringValue;
                                String stringKey = entry.getKey();
                                if (stringKey == null) continue;
                                Object key = (stringKey = stringKey.trim()).startsWith("$") ? this.getContext().getVariable(stringKey) : stringKey;
                                if (OMultiValue.isMultiValue((Object)key) && OMultiValue.getSize((Object)key) == 1) {
                                    key = OMultiValue.getFirstValue((Object)key);
                                }
                                if ((stringValue = entry.getValue()) == null) continue;
                                Object value = (stringValue = stringValue.trim()).toString().startsWith("$") ? this.getContext().getVariable(stringValue) : stringValue;
                                if (OMultiValue.isMultiValue((Object)value) && OMultiValue.getSize((Object)value) == 1) {
                                    value = OMultiValue.getFirstValue((Object)value);
                                }
                                result.put(key, value);
                            }
                            lastResult = result;
                        } else {
                            lastResult = variable;
                        }
                        return lastResult;
                    }
                    if (lastCommand == null || lastCommand.length() <= 0) continue;
                    lastResult = (Cloneable)db.command(new OCommandSQL(lastCommand).setContext(this.getContext())).execute(new Object[0]);
                }
                ++line;
            }
        }
        return lastResult;
    }
}

