/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.orient.core.cache.OAbstractMapCache;
import com.orientechnologies.orient.core.cache.OCache;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class OUnboundedWeakCache
extends OAbstractMapCache<WeakHashMap<ORID, WeakReference<ORecordInternal<?>>>>
implements OCache {
    public OUnboundedWeakCache() {
        super(new WeakHashMap());
    }

    @Override
    public int limit() {
        return Integer.MAX_VALUE;
    }

    @Override
    public ORecordInternal<?> get(ORID id) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal<?> oRecordInternal = this.get((WeakReference)((WeakHashMap)this.cache).get(id));
            return oRecordInternal;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public ORecordInternal<?> put(ORecordInternal<?> record) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal<?> oRecordInternal = this.get(((WeakHashMap)this.cache).put(record.getIdentity(), new WeakReference(record)));
            return oRecordInternal;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public ORecordInternal<?> remove(ORID id) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal<?> oRecordInternal = this.get((WeakReference)((WeakHashMap)this.cache).remove(id));
            return oRecordInternal;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    private ORecordInternal<?> get(WeakReference<ORecordInternal<?>> value) {
        if (value == null) {
            return null;
        }
        return (ORecordInternal)value.get();
    }
}

