/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.cache.OCache;
import com.orientechnologies.orient.core.cache.OCacheLevelTwoLocator;
import com.orientechnologies.orient.core.cache.ODefaultCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.lang.reflect.Constructor;

public class OCacheLevelTwoLocatorLocal
implements OCacheLevelTwoLocator {
    @Override
    public OCache primaryCache(String storageName) {
        String cacheClassName = OGlobalConfiguration.CACHE_LEVEL2_IMPL.getValueAsString();
        try {
            Class<?> cacheClass = this.findByCanonicalName(cacheClassName);
            this.checkThatImplementsCacheInterface(cacheClass);
            Constructor<?> cons = this.getPublicConstructorWithLimitParameter(cacheClass);
            return (OCache)cons.newInstance(storageName, OGlobalConfiguration.CACHE_LEVEL2_SIZE.getValueAsInteger());
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Cannot initialize cache with implementation class [%s]. %s. Using default implementation [%s]", new Object[]{cacheClassName, e.getMessage(), ODefaultCache.class.getCanonicalName()});
            return new ODefaultCache(null, OGlobalConfiguration.CACHE_LEVEL2_SIZE.getValueAsInteger());
        }
    }

    private void checkThatImplementsCacheInterface(Class<?> cacheClass) {
        if (!OCache.class.isAssignableFrom(cacheClass)) {
            throw new IllegalArgumentException("Class " + cacheClass.getCanonicalName() + " doesn't implement " + OCache.class.getCanonicalName() + " interface");
        }
    }

    private Class<?> findByCanonicalName(String cacheClassName) {
        try {
            return Class.forName(cacheClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found", e);
        }
    }

    private Constructor<?> getPublicConstructorWithLimitParameter(Class<?> cacheClass) {
        try {
            return cacheClass.getConstructor(String.class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class has no public constructor with parameter of type [" + String.class + "," + Integer.TYPE + "]", e);
        }
    }
}

