/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.orient.core.cache.OCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.id.ORID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class OAbstractMapCache<T extends Map<ORID, ?>>
implements OCache {
    protected final OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), 0, true);
    protected final T cache;
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public OAbstractMapCache(T cache) {
        this.cache = cache;
    }

    @Override
    public void startup() {
        this.enable();
    }

    @Override
    public void shutdown() {
        this.disable();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public boolean enable() {
        return this.enabled.compareAndSet(false, true);
    }

    @Override
    public boolean disable() {
        this.clear();
        return this.enabled.compareAndSet(true, false);
    }

    @Override
    public void clear() {
        if (!this.isEnabled()) {
            return;
        }
        this.lock.acquireExclusiveLock();
        try {
            this.cache.clear();
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public int size() {
        this.lock.acquireSharedLock();
        try {
            int n = this.cache.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public Collection<ORID> keys() {
        this.lock.acquireExclusiveLock();
        try {
            ArrayList<ORID> arrayList = new ArrayList<ORID>(this.cache.keySet());
            return arrayList;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void lock(ORID id) {
        this.lock.acquireExclusiveLock();
    }

    @Override
    public void unlock(ORID id) {
        this.lock.releaseExclusiveLock();
    }
}

