/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tarantool.TarantoolConnection16;
import org.tarantool.TarantoolConnection16Impl;
import org.tarantool.TarantoolException;

public class TarantoolClient
extends DB {
    public static final String HOST_PROPERTY = "tarantool.host";
    public static final String PORT_PROPERTY = "tarantool.port";
    public static final String SPACE_PROPERTY = "tarantool.space";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 3301;
    public static final int DEFAULT_SPACE = 1024;
    private static final Logger logger = Logger.getLogger(TarantoolClient.class.getName());
    private TarantoolConnection16 connection;
    private int spaceNo;

    public void init() throws DBException {
        String host;
        Properties props = this.getProperties();
        int port = 3301;
        String portString = props.getProperty(PORT_PROPERTY);
        if (portString != null) {
            port = Integer.parseInt(portString);
        }
        if ((host = props.getProperty(HOST_PROPERTY)) == null) {
            host = DEFAULT_HOST;
        }
        this.spaceNo = 1024;
        String spaceString = props.getProperty(SPACE_PROPERTY);
        if (spaceString != null) {
            this.spaceNo = Integer.parseInt(spaceString);
        }
        try {
            this.connection = new TarantoolConnection16Impl(host, port);
        }
        catch (Exception exc) {
            logger.log(Level.SEVERE, "Can't initialize Tarantool connection", exc);
            return;
        }
    }

    public void cleanup() throws DBException {
        this.connection.close();
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        int j = 0;
        String[] tuple = new String[1 + 2 * values.size()];
        tuple[0] = key;
        for (Map.Entry<String, ByteIterator> i : values.entrySet()) {
            tuple[j + 1] = i.getKey();
            tuple[j + 2] = i.getValue().toString();
            j += 2;
        }
        try {
            this.connection.replace(this.spaceNo, (Object)tuple);
        }
        catch (TarantoolException exc) {
            logger.log(Level.SEVERE, "Can't insert element", exc);
            return 1;
        }
        return 0;
    }

    private HashMap<String, ByteIterator> tuple_convert_filter(List<String> input, Set<String> fields) {
        HashMap<String, ByteIterator> result = new HashMap<String, ByteIterator>();
        if (input == null) {
            return result;
        }
        for (int i = 1; i < input.toArray().length; i += 2) {
            if (fields != null && !fields.contains(input.get(i))) continue;
            result.put(input.get(i), (ByteIterator)new StringByteIterator(input.get(i + 1)));
        }
        return result;
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        try {
            List response = this.connection.select(this.spaceNo, 0, Arrays.asList(key), 0, 1, 0);
            result = this.tuple_convert_filter(response, fields);
            return 0;
        }
        catch (TarantoolException exc) {
            logger.log(Level.SEVERE, "Can't select element", exc);
            return 1;
        }
        catch (NullPointerException exc) {
            return 1;
        }
    }

    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        List response;
        try {
            response = this.connection.select(this.spaceNo, 0, Arrays.asList(startkey), 0, recordcount, 6);
        }
        catch (TarantoolException exc) {
            logger.log(Level.SEVERE, "Can't select range elements", exc);
            return 1;
        }
        catch (NullPointerException exc) {
            return 1;
        }
        for (List i : response) {
            HashMap<String, ByteIterator> temp = this.tuple_convert_filter(i, fields);
            if (temp.isEmpty()) continue;
            result.add((HashMap)temp.clone());
        }
        return 0;
    }

    public int delete(String table, String key) {
        try {
            this.connection.delete(this.spaceNo, Arrays.asList(key));
        }
        catch (TarantoolException exc) {
            logger.log(Level.SEVERE, "Can't delete element", exc);
            return 1;
        }
        catch (NullPointerException e) {
            return 1;
        }
        return 0;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        int j = 0;
        String[] tuple = new String[1 + 2 * values.size()];
        tuple[0] = key;
        for (Map.Entry<String, ByteIterator> i : values.entrySet()) {
            tuple[j + 1] = i.getKey();
            tuple[j + 2] = i.getValue().toString();
            j += 2;
        }
        try {
            this.connection.replace(this.spaceNo, (Object)tuple);
        }
        catch (TarantoolException exc) {
            logger.log(Level.SEVERE, "Can't replace element", exc);
            return 1;
        }
        return 0;
    }
}

