/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.timeout;

import com.datastax.shaded.netty.channel.ChannelFuture;
import com.datastax.shaded.netty.channel.ChannelFutureListener;
import com.datastax.shaded.netty.channel.ChannelHandler;
import com.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.shaded.netty.channel.Channels;
import com.datastax.shaded.netty.channel.MessageEvent;
import com.datastax.shaded.netty.channel.SimpleChannelDownstreamHandler;
import com.datastax.shaded.netty.handler.timeout.WriteTimeoutException;
import com.datastax.shaded.netty.util.ExternalResourceReleasable;
import com.datastax.shaded.netty.util.Timeout;
import com.datastax.shaded.netty.util.Timer;
import com.datastax.shaded.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class WriteTimeoutHandler
extends SimpleChannelDownstreamHandler
implements ExternalResourceReleasable {
    static final WriteTimeoutException EXCEPTION = new WriteTimeoutException();
    private final Timer timer;
    private final long timeoutMillis;

    public WriteTimeoutHandler(Timer timer, int timeoutSeconds) {
        this(timer, timeoutSeconds, TimeUnit.SECONDS);
    }

    public WriteTimeoutHandler(Timer timer, long timeout, TimeUnit unit) {
        if (timer == null) {
            throw new NullPointerException("timer");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.timer = timer;
        this.timeoutMillis = timeout <= 0L ? 0L : Math.max(unit.toMillis(timeout), 1L);
    }

    public void releaseExternalResources() {
        this.timer.stop();
    }

    protected long getTimeoutMillis(MessageEvent e) {
        return this.timeoutMillis;
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        long timeoutMillis = this.getTimeoutMillis(e);
        if (timeoutMillis > 0L) {
            ChannelFuture future = e.getFuture();
            Timeout timeout = this.timer.newTimeout(new WriteTimeoutTask(ctx, future), timeoutMillis, TimeUnit.MILLISECONDS);
            future.addListener(new TimeoutCanceller(timeout));
        }
        super.writeRequested(ctx, e);
    }

    protected void writeTimedOut(ChannelHandlerContext ctx) throws Exception {
        Channels.fireExceptionCaught(ctx, (Throwable)EXCEPTION);
    }

    private static final class TimeoutCanceller
    implements ChannelFutureListener {
        private final Timeout timeout;

        TimeoutCanceller(Timeout timeout) {
            this.timeout = timeout;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            this.timeout.cancel();
        }
    }

    private final class WriteTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;
        private final ChannelFuture future;

        WriteTimeoutTask(ChannelHandlerContext ctx, ChannelFuture future) {
            this.ctx = ctx;
            this.future = future;
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            if (!this.ctx.getChannel().isOpen()) {
                return;
            }
            if (this.future.setFailure(EXCEPTION)) {
                this.fireWriteTimeOut(this.ctx);
            }
        }

        private void fireWriteTimeOut(final ChannelHandlerContext ctx) {
            ctx.getPipeline().execute(new Runnable(){

                public void run() {
                    try {
                        WriteTimeoutHandler.this.writeTimedOut(ctx);
                    }
                    catch (Throwable t) {
                        Channels.fireExceptionCaught(ctx, t);
                    }
                }
            });
        }
    }
}

