/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.channel.socket.nio;

import com.datastax.shaded.netty.channel.ChannelException;
import com.datastax.shaded.netty.channel.ChannelFactory;
import com.datastax.shaded.netty.channel.ChannelFuture;
import com.datastax.shaded.netty.channel.ChannelPipeline;
import com.datastax.shaded.netty.channel.ChannelSink;
import com.datastax.shaded.netty.channel.Channels;
import com.datastax.shaded.netty.channel.socket.nio.NioSocketChannel;
import com.datastax.shaded.netty.channel.socket.nio.NioWorker;
import com.datastax.shaded.netty.logging.InternalLogger;
import com.datastax.shaded.netty.logging.InternalLoggerFactory;
import com.datastax.shaded.netty.util.Timeout;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;

final class NioClientSocketChannel
extends NioSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioClientSocketChannel.class);
    volatile ChannelFuture connectFuture;
    volatile boolean boundManually;
    long connectDeadlineNanos;
    volatile SocketAddress requestedRemoteAddress;
    volatile Timeout timoutTimer;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SocketChannel newSocket() {
        SocketChannel socket;
        try {
            socket = SocketChannel.open();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", e);
        }
        boolean success = false;
        try {
            try {
                socket.configureBlocking(false);
                return socket;
            }
            catch (IOException e) {
                throw new ChannelException("Failed to enter non-blocking mode.", e);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (success) throw throwable;
            try {
                socket.close();
                throw throwable;
            }
            catch (IOException e) {
                if (!logger.isWarnEnabled()) throw throwable;
                logger.warn("Failed to close a partially initialized socket.", e);
            }
            throw throwable;
        }
    }

    NioClientSocketChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, NioWorker worker) {
        super(null, factory, pipeline, sink, NioClientSocketChannel.newSocket(), worker);
        Channels.fireChannelOpen(this);
    }
}

