/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BusyConnectionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;

class StreamIdGenerator {
    static final int MAX_STREAM_PER_CONNECTION = 128;
    private static final long MAX_UNSIGNED_LONG = -1L;
    private final AtomicLongArray bits = new AtomicLongArray(2);
    private final AtomicInteger marked = new AtomicInteger(0);

    public StreamIdGenerator() {
        this.bits.set(0, -1L);
        this.bits.set(1, -1L);
    }

    public int next() throws BusyConnectionException {
        int id = this.atomicGetAndSetFirstAvailable(0);
        if (id >= 0) {
            return id;
        }
        id = this.atomicGetAndSetFirstAvailable(1);
        if (id >= 0) {
            return 64 + id;
        }
        throw new BusyConnectionException();
    }

    public void release(int streamId) {
        if (streamId < 64) {
            this.atomicClear(0, streamId);
        } else {
            this.atomicClear(1, streamId - 64);
        }
    }

    public void mark(int streamId) {
        this.marked.incrementAndGet();
    }

    public void unmark(int streamId) {
        this.marked.decrementAndGet();
    }

    public int maxAvailableStreams() {
        return 128 - this.marked.get();
    }

    public int atomicGetAndSetFirstAvailable(int idx) {
        int id;
        long l;
        do {
            if ((l = this.bits.get(idx)) != 0L) continue;
            return -1;
        } while (!this.bits.compareAndSet(idx, l, l ^ StreamIdGenerator.mask(id = Long.numberOfTrailingZeros(l))));
        return id;
    }

    public void atomicClear(int idx, int toClear) {
        long l;
        while (!this.bits.compareAndSet(idx, l = this.bits.get(idx), l | StreamIdGenerator.mask(toClear))) {
        }
    }

    private static long mask(int id) {
        return 1L << id;
    }
}

