/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionMulti;

public final class OptionAnyProbabilities
extends OptionMulti {
    final CollectRatios ratios = new CollectRatios();

    public OptionAnyProbabilities(String name, String description) {
        super(name, description, false);
    }

    @Override
    public List<? extends Option> options() {
        return Arrays.asList(this.ratios);
    }

    Map<String, Double> ratios() {
        return this.ratios.options;
    }

    private static final class CollectRatios
    extends Option {
        Map<String, Double> options = new LinkedHashMap<String, Double>();

        private CollectRatios() {
        }

        @Override
        boolean accept(String param) {
            String[] args = param.split("=");
            if (args.length == 2 && args[1].length() > 0 && args[0].length() > 0) {
                if (this.options.put(args[0], Double.parseDouble(args[1])) != null) {
                    throw new IllegalArgumentException(args[0] + " set twice");
                }
                return true;
            }
            return false;
        }

        @Override
        boolean happy() {
            return !this.options.isEmpty();
        }

        @Override
        String shortDisplay() {
            return null;
        }

        @Override
        String longDisplay() {
            return null;
        }

        @Override
        List<String> multiLineDisplay() {
            return Collections.emptyList();
        }

        @Override
        boolean setByUser() {
            return !this.options.isEmpty();
        }

        @Override
        boolean present() {
            return this.setByUser();
        }
    }
}

