/*++

  Copyright (c) 1998 Microsoft Corporation
  
    ISAPI shell
    
      Module Name: isapireq.hxx
      
        ISAPI request processing header
        
--*/

#ifndef _ISAPIREQ_HXX_
#define _ISAPIREQ_HXX_

#include <windows.h>
#include <httpext.h>

//
// The types of requests we expect to get
//

typedef enum
{
    IRT_NONE = 0,
	IRT_CMD_FETCH,
	IRT_CMD_RESET,
    IRT_GET_STATIC,
    IRT_GET_DYNAMIC,
	IRT_GET_DYNAMIC_AD,
    IRT_POST

}   ISAPIRequestType;


typedef struct 
{

	DWORD	init;
    CHAR	serverSoftware[64];
    size_t  serverSoftLen;
    CHAR	scriptName[128];
    size_t  scriptNameLen;
	CHAR	dirRoot[128];

} Constant_Vars;

//
//	definition of DATA_BUF
//

typedef struct _DATA_BUF
{

	// buf that stores data
	char	*buf;

	// in case this structure is part of a linked list
    struct _DATA_BUF		*next;

} DATA_BUF, *PDATA_BUF;




//
// The ISAPIRequest class. We keep track of the request here
//

typedef struct _ISAPIRequest
{
    
	EXTENSION_CONTROL_BLOCK *_ecb;

 
    // The query string sent from the client
    char                    *_queryString;

    // to be reported with every response
    CHAR _remoteAddr[16];

    // What type of work are we supposed to do?
    ISAPIRequestType        _type;

	// for transmit file
    HANDLE                  _reqFileHandle;
    DWORD                   _reqFileSize;
    char                    _headerStringBuffer[1024];
	DWORD					_headerStringLength;
	HSE_TF_INFO             _transmitFileInfo;
   
    //Is there a keep-alive request?
    
    BOOL    _keepAlive;

	// file transmit for RootAd
	PDATA_BUF  _pDataBuf;
	BOOL	_useFileBuf;
	char	*_fileBuf;
	DWORD	_offSet; // it is also the length of the buffer
	int		_matchIndex;	

	//cookie

    char   _cookie[128];

	// File Overlapped Event Handle

	HANDLE  hFileEvent;
 
    
    // the ISAPI ECB
    
	//  EXTENSION_CONTROL_BLOCK *ecb;
    
    // in case this structure is part of a linked list
    
    struct _ISAPIRequest		*next;
    
} ISAPIRequest, *PISAPIRequest;


// function definitions for ISAPI stack
BOOL
InitializeISAPIStack(
	);
 
void 
ClearISAPIStack(
	);

PISAPIRequest 	
AllocISAPIRequest(
	);

void			
FreeISAPIRequest(
	PISAPIRequest pReq
	);

// function definitions for DATA_BUF stack
BOOL
InitializeDataStack(
	);
 
void 
ClearDataStack(
	);

PDATA_BUF 	
AllocDataBuf(
	);

void			
FreeDataBuf(
	PDATA_BUF pDataBuf
	);

// API definitions
BOOL
InitRequest(
	PISAPIRequest pReq,
	EXTENSION_CONTROL_BLOCK *ecb
	);

DWORD
ExecuteRequest(
	PISAPIRequest pReq
	);

DWORD
ExecuteGetFile(
	PISAPIRequest	pReq
	);

DWORD
ExecuteGetFileAD(
	PISAPIRequest	pReq
	);

DWORD
ExecutePostLog(
	PISAPIRequest	pReq
	);

DWORD sendTextOutput(
	PISAPIRequest	pReq,
	char *text
	);

BOOL 
sendOutputHeader(
	PISAPIRequest	pReq,
	DWORD innerContentLength
	);

BOOL 
sendOutputFooter(
	PISAPIRequest	pReq
	);

HANDLE
CallCreateFile(
	PISAPIRequest	pReq,
	CHAR *virtPath
	);

BOOL 
startTransmitFile(
	PISAPIRequest	pReq
	);

void WINAPI 
TransmitFileCompletionCallback(
	EXTENSION_CONTROL_BLOCK *ecb,
	VOID *context,
    DWORD cbIO,
    DWORD error
    );

bool parseCookieString(
	PISAPIRequest pReq, 
	int* pUserID, 
	int* pLastAd) ;

void CustomAdScan(
	PISAPIRequest pReq,
	int Ad_Id
	);


bool strMatchOr(char *p2, char *p1, char x, char y);


bool parsePostInput(char * pPostInput,
        long numBytes,
		char* pUrlroot, 
		int* pDirNum, 
		int* pClassNum, 
		int* pFileNum, 
		int* pClientNum
		); 

BOOL 
startTransmitFileAd(
	PISAPIRequest	pReq
	);


DWORD ExcuteCmdFetch(PISAPIRequest pReq);

DWORD ExcuteCmdReset(PISAPIRequest pReq);

DWORD transmitLogFile(PISAPIRequest pReq);
DWORD transmitAndWriteFile(PISAPIRequest pReq, int lastAdId);

int intToChars(char *pBuf, unsigned int inData);

void composeHeaderString( PISAPIRequest *pReq, DWORD InnerContentLen =0);


#endif // _ISAPIREQ_HXX_
