/*
     Copyright (c) 1998 Microsoft Corporation

     ISAPI Request Class

     Module Name: frootad.cxx


--*/

#include "define.h"
#include "frootad.hxx"
#include <malloc.h>
#include <stdlib.h>
#include <windows.h>


RootAd::RootAd()
{
	pUserPfBuf =NULL;			// pointer to a buffer for holding user personality file
	for( int i=0; i<360; i++)
		pCustomAdBuf[i] = NULL;			// pointer to a buffer for holding custom AD file
	userBufSize = 0;
	numberOfAd = 360;
	customBufSize = numberOfAd*sizeof(CustomAd); // 360*16;

}


bool RootAd::initialize(char* pUserFile, char* pCustomFile)
{
	char *pTem;
	int  size = sizeof(CustomAd);
	int i;

	HANDLE h = CreateFile(
                    pUserFile,
                    GENERIC_READ,
                    FILE_SHARE_READ,
                    NULL,
                    OPEN_EXISTING,
                    FILE_ATTRIBUTE_NORMAL,
                    NULL
    	            );
    if (h == INVALID_HANDLE_VALUE) {
        return FALSE;
    }

    // get the user file size
    int fileSize = GetFileSize(h, NULL);

	userBufSize = fileSize/15;
	// calculate the buffer size
	int bufSize = sizeof(int)*userBufSize;

    pUserPfBuf = (unsigned int *) VirtualAlloc(
                                    NULL,
                                    bufSize,
                                    MEM_RESERVE | MEM_COMMIT,
                                    PAGE_READWRITE
                                    );
	
	if(pUserPfBuf != NULL)
	{
			 
		// load the User personality file content into pUserPfBuf
		if(!parseUserRd(h) )
		{
            VirtualFree(
              pUserPfBuf,
              NULL,
              MEM_DECOMMIT | MEM_RELEASE
                );

			pUserPfBuf = NULL;
			CloseHandle(h);
			return FALSE;
		}

	}
	else
	{
		
		CloseHandle(h);
		return FALSE;
	}
	

	// close User personality file
	CloseHandle(h);

	// open Custom AD  file

	h = CreateFile(
                    pCustomFile,
                    GENERIC_READ,
                    FILE_SHARE_READ,
                    NULL,
                    OPEN_EXISTING,
                    FILE_ATTRIBUTE_NORMAL,
                    NULL
    	            );
	if (h == INVALID_HANDLE_VALUE) {
		return FALSE;
	}

    pTem = (char *) VirtualAlloc(
                        NULL,
                        customBufSize,
                        MEM_RESERVE | MEM_COMMIT,
                        PAGE_READWRITE
                        );

	if( pTem != NULL )
	{
		fileSize = customBufSize;

		for( i =0; i<360; i++)
		{
			pCustomAdBuf[i] = (pCustomAd)(pTem + i*size);
		}


		// load the User personality file content into pUserPfBuf
		if(!parseCustomRd(h) )
		{
            VirtualFree(
                pTem,
                NULL,
                MEM_DECOMMIT | MEM_RELEASE
            );

			pTem = NULL;
			CloseHandle(h);
			return FALSE;
		}

	}else
	{
		
		CloseHandle(h);
		return FALSE;
	}


	// close Custom AD file
	CloseHandle(h);

	return TRUE;

}

RootAd::~RootAd(){
	if( pCustomAdBuf != NULL) {
        VirtualFree(
            pCustomAdBuf[0],
            NULL,
            MEM_DECOMMIT | MEM_RELEASE
        );
    } 

	if( pUserPfBuf != NULL) {
        VirtualFree(
            pUserPfBuf,
            NULL,
            MEM_DECOMMIT | MEM_RELEASE
        );
    }
}

unsigned int RootAd::hexToInt(char* p, int len)
{
	unsigned int uiResult =0;

	for(int i =0; i<len; i++)
	{
		if((*p >= '0') && (*p <= '9'))
		{
			uiResult = (uiResult << 4 )+ *p - '0';
		}

		if((*p >= 'A') && (*p <= 'F'))
		{
			uiResult = (uiResult << 4 )+ *p - 'A' +10;
		}
		p++;
	}

	return uiResult;
}

bool RootAd::parseUserRd( HANDLE h)    // read the user file into the buffer
{
	char userRd[15];
	DWORD  ByteToRead = 15;
	DWORD  ByteToReadIn =0;
	int	 i =0;

	OVERLAPPED overLap;

	overLap.Internal = 0;
	overLap.InternalHigh = 0; 
	overLap.Offset = 0; 
	overLap.OffsetHigh =0; 
	overLap.hEvent = NULL; 
	

	while( i < userBufSize )
	{
		if(ReadFile(h,userRd, ByteToRead, &ByteToReadIn, &overLap))
		{
			pUserPfBuf[i++] = hexToInt((char*)&userRd[6],8);
		}
		else
		{ 
			return FALSE;
		}

		overLap.Offset += ByteToRead;
	}

	return TRUE;
}


bool RootAd::parseCustomRd( HANDLE h)    // read the user file into the buffer
{
	char userRd[39];
	DWORD  ByteToRead = 39;
	DWORD  ByteToReadIn =0;
	int i =0;
	OVERLAPPED overLap;

	overLap.Internal = 0;
	overLap.InternalHigh = 0; 
	overLap.Offset = 0; 
	overLap.OffsetHigh =0; 
	overLap.hEvent = NULL; 

	while( i < numberOfAd  )
	{
		// ByteToRead = 39;

		if(ReadFile(h,userRd, ByteToRead, &ByteToReadIn, &overLap))
		{
			pCustomAdBuf[i]->AdDemographics = hexToInt((char*)&userRd[6],8);

			pCustomAdBuf[i]->Weightings = hexToInt((char*)&userRd[15],8);

			pCustomAdBuf[i]->MinMvalue = atoi((char*)&userRd[24]);

			pCustomAdBuf[i]->ExTime = atoi((char*)&userRd[28]);

		}else
		{ 
			return FALSE;
		}
		i++;

		overLap.Offset += ByteToRead;
	}

	return TRUE;
}
