//
//  twc.c
//
//  Author: Tai-Yi Huang (tyhuang)      June, 2000
//
//

#include "define.h"

ULONG               NumberOfFileBuffers;

VOID ProcessErrorExit(PCHAR Str, PCHAR FunStr) {

    printf ("%s:%s Error: %ld\n", Str, FunStr, GetLastError());

    exit(1);
}

VOID PrintUsage(PCHAR Prog) {

    printf("%s: -b NumberOfCadBuffers\n\n", Prog);

    printf("\te.g. %s -b 1024\n", Prog);
    printf("\tregister 1024 CAD buffers\n\n");

    ProcessErrorExit("PrintUsage", "Unknown parameters");
}


VOID ProcessArgs(__int32 argc, PCHAR argv[]) {

    if (argc != 3) {

        PrintUsage(argv[0]);
    }

    NumberOfFileBuffers = atoi(argv[2]);
}

__cdecl main (__int32 argc, PCHAR argv[]) {

    // process the input parameters

    ProcessArgs(argc, argv);

    InitTwc();
    InitSpec();

    while (TRUE) {

        Sleep(600000);
    }

    return 0;
}


VOID InitTwc() {

    ULONG               NumberOfProcessors;
    SYSTEM_INFO         SysInfo;

    // Open Kernel SWC device

    TwcOpenSwcDevice();

    // Query the NumberOfProcessors

    GetSystemInfo(&SysInfo);
    NumberOfProcessors = SysInfo.dwNumberOfProcessors;

    TwcRegisterCallback(ProcessRequest);

    if (TwcCreateThreads(NumberOfProcessors, NumberOfFileBuffers))
    {
        exit(-1);
    }

}

