//
//  utility.c
//
//  Author: Tai-Yi Huang (tyhuang)      June, 2000
//
//

#include "define.h"

ROOT_AD     RootAd;

ULONG hexToInt(PCHAR p, ULONG len) {

    ULONG uiResult =0;
    ULONG i;

    for(i =0; i<len; i++)
    {
        if((*p >= '0') && (*p <= '9'))
        {
            uiResult = (uiResult << 4 )+ *p - '0';
        }

        if((*p >= 'A') && (*p <= 'F'))
        {
            uiResult = (uiResult << 4 )+ *p - 'A' +10;
        }
        p++;
    }

    return uiResult;
}

DWORD ParseCustomAds(HANDLE FileHandle) {

    char            userRd[39];
    DWORD           ByteToRead = 39;
    DWORD           ByteToReadIn =0;
    ULONG           i =0;
    OVERLAPPED      overLap;

    overLap.Internal = 0;
    overLap.InternalHigh = 0;
    overLap.Offset = 0;
    overLap.OffsetHigh =0;
    overLap.hEvent = NULL;

    while( i < RootAd.NumberAds  )
    {
        // ByteToRead = 39;

        if(ReadFile(FileHandle,userRd, ByteToRead, &ByteToReadIn, &overLap))
        {
            RootAd.pCustomAdBuf[i]->AdDemographics = hexToInt((char*)&userRd[6],8);

            RootAd.pCustomAdBuf[i]->Weightings = hexToInt((char*)&userRd[15],8);

            RootAd.pCustomAdBuf[i]->MinMvalue = atoi((char*)&userRd[24]);

            RootAd.pCustomAdBuf[i]->ExTime = atoi((char*)&userRd[28]);

        }
        else
        {
            return(STATUS_ERROR) ;
        }
        i++;

        overLap.Offset += ByteToRead;
    }

    return(STATUS_SUCCESS);
}

DWORD ParseUserPersonality(HANDLE FileHandle) {

    CHAR    UserRd[15];
    ULONG   BytesToRead = 15;
    ULONG   BytesToReadIn =0;
    ULONG   i =0;

    OVERLAPPED overLap;

    overLap.Internal = 0;
    overLap.InternalHigh = 0;
    overLap.Offset = 0;
    overLap.OffsetHigh =0;
    overLap.hEvent = NULL;

    while( i < RootAd.UserBufSize ) {

        if (ReadFile(FileHandle, UserRd, BytesToRead, &BytesToReadIn, &overLap)) {

            RootAd.pUserPfBuf[i++] = hexToInt((PCHAR)&UserRd[6],8);

            //fprintf(stdout, "ParseUserPersonality: i = %d UserBuf %d UserRd %s\n", i-1, RootAd.pUserPfBuf[i-1], UserRd);

        } else {

            return(STATUS_ERROR);
        }

        overLap.Offset += BytesToRead;
    }

    return(STATUS_SUCCESS);
}



VOID InitializeCustomAd() {

    ULONG       i;
    HANDLE      FileHandle;
    ULONG       FileSize;
    ULONG       BufSize;
    PCHAR       StrPtr;


    // before doing everything, cleanup the previous structures

    if (NULL != RootAd.pUserPfBuf) {

        VirtualFree(
            RootAd.pUserPfBuf,
            0,
            MEM_DECOMMIT | MEM_RELEASE
            );

        VirtualFree(
            RootAd.pCustomAdBuf,
            0,
            MEM_DECOMMIT | MEM_RELEASE
            );
    }

    // first, setup data structures

    RootAd.pUserPfBuf = NULL;

    for (i = 0; i < 360; i++) {

        RootAd.pCustomAdBuf[i] = NULL;
    }

    RootAd.UserBufSize = 0;
    RootAd.NumberAds = 360;
    RootAd.CustomBufSize = RootAd.NumberAds * sizeof(CUSTOM_AD);

    // second, -----------  open user personality files  -----------

    FileHandle = CreateFile(
                    "data\\User.Personality",
                    GENERIC_READ,
                    FILE_SHARE_READ,
                    NULL,
                    OPEN_EXISTING,
                    FILE_ATTRIBUTE_NORMAL,
                    NULL
                    );

    if (INVALID_HANDLE_VALUE == FileHandle) {

        ProcessErrorExit("InitializeCustomAd", "Open User.Personality failed");
    }

    // get the userfile size

    FileSize = GetFileSize(FileHandle, NULL);

    //fprintf(stdout, "User.Personality Size = %d\n", FileSize);

    // calculate the buffer size

    RootAd.UserBufSize = (FileSize/15);

    BufSize = RootAd.UserBufSize * sizeof(ULONG);

    RootAd.pUserPfBuf = (ULONG *) VirtualAlloc(
                                    NULL,
                                    BufSize,
                                    MEM_RESERVE | MEM_COMMIT,
                                    PAGE_READWRITE
                                    );

    if (NULL == RootAd.pUserPfBuf) {

        CloseHandle(FileHandle);
        ProcessErrorExit("InitializeCustomAd", "VirtualAlloc for pUserPfBuf fail");
    }

    // load the User personality file content into pUserPfBuf

    if (STATUS_SUCCESS != ParseUserPersonality(FileHandle)) {

        CloseHandle(FileHandle);
        ProcessErrorExit("InitializeCustomAd", "ParseUserPersonality return false");
    }

    // close User personality file

    CloseHandle(FileHandle);

    // third, -----------  open CustomAd file  -----------

    FileHandle = CreateFile(
                    "data\\Custom.Ads",
                    GENERIC_READ,
                    FILE_SHARE_READ,
                    NULL,
                    OPEN_EXISTING,
                    FILE_ATTRIBUTE_NORMAL,
                    NULL
                    );

    if (INVALID_HANDLE_VALUE == FileHandle) {

        ProcessErrorExit("InitializeCustomAd", "Open Custom.Ads failed");
    }

    StrPtr = (PCHAR) VirtualAlloc(
                        NULL,
                        RootAd.CustomBufSize,
                        MEM_RESERVE | MEM_COMMIT,
                        PAGE_READWRITE
                        );

    if (NULL == StrPtr) {

        CloseHandle(FileHandle);
        ProcessErrorExit("InitializeCustomAd", "VirtualAlloc customAd failed");
    }

    for (i=0;i<360;i++) {

        RootAd.pCustomAdBuf[i] = (PCUSTOM_AD)(StrPtr + i * sizeof(CUSTOM_AD));
    }

    if (STATUS_SUCCESS != ParseCustomAds(FileHandle)) {

        CloseHandle(FileHandle);
        ProcessErrorExit("InitializeCustomAd", "ParseCustomAds failed");
    }

    CloseHandle(FileHandle);
}
