//
//  dynamic.h
//
//  Author: Tai-Yi Huang (tyhuang)  June, 2000
//

#ifndef _W_DYNAMIC_H
#define _W_DYNAMIC_H

#define GENDER_MASK         (0x30000000)
#define AGE_GROUP_MASK      (0x0f000000)
#define REGION_MASK         (0x00f00000)
#define INTEREST1_MASK      (0x000ffc00)
#define INTEREST2_MASK      (0x000003ff)
#define WT_MASK             (0x0f)

#define MAXSTRING           (64)


VOID    InitSpec();
VOID    InitStringTable();
VOID    ProcessRequest(HANDLE Request);
VOID    SpecFailRequest(HANDLE Request, PCHAR ErrorString);
VOID    SpecSimpleDynamic(HANDLE Request);
VOID    SpecCommandReset(HANDLE Request);
VOID    SpecCommandFetch(HANDLE Request);
VOID    SpecPostDynamic(HANDLE Request);
VOID    SpecCadDynamic(HANDLE Request);
VOID    SpecSendCadDynamicResponse(HANDLE Request, ULONG AdIndex, ULONG AdWeight, BOOLEAN Expired);
VOID    SpecSendCadDynamicFile(HANDLE Request, ULONG AdIndex, ULONG AdWeight, BOOLEAN Expired);
ULONG   SpecFillPreBodyData(HANDLE Request, PCHAR QueryString, ULONG QueryStringSize, PCHAR StrPtr);
ULONG   SpecPrepareCookieString(PCHAR StrPtr, ULONG AdIndex, ULONG AdWeight, BOOLEAN Expired);
ULONG   ConvertNumberToString(PCHAR StrPtr, ULONG Number, ULONG DigitFields, BOOLEAN RecordingZero);

__inline PCHAR SpecQueryQueryString(HANDLE Request, PCHAR Str, PULONG QueryStringSize) {

    PCHAR   HttpRequestStr = TwcQueryHttpRequest(Request);
    PCHAR   FilePtr, HttpPtr;

    FilePtr = strstr(HttpRequestStr, Str);
    HttpPtr = strstr(HttpRequestStr, "HTTP");

    *QueryStringSize = (ULONG) (HttpPtr - FilePtr - 1);

    return FilePtr;
}

#endif // _W_DYNAMIC_H

