//
//  dynamic.c
//
//  Author: Tai-Yi Huang (tyhuang)      June, 2000
//
//

#include "define.h"
#include <winsock.h>

// global variables for SPEC library

#define PRE_BODY_DATA_FORMAT \
            "<html>\n" \
            "<head><title>SPECweb99 Dynamic GET & POST Test</title></head>\n" \
            "<body>\n" \
            "<p>SERVER_SOFTWARE = %s\n" \
            "<p>REMOTE_ADDR =                \n" \
            "<p>SCRIPT_NAME = %s\n" \
            "<p>QUERY_STRING = " 

CHAR    PreBodyData[256];
ULONG   PreBodyDataSize;
CHAR    ScriptName[64];
CHAR    ServerSoftware[64];
ULONG   RemoteAddrOffset;

CHAR    PreBodyDataTail[] = 
            "\n<pre>\n";
ULONG   PreBodyDataTailSize = 7;

CHAR    ContentTail[] =
            "</pre>\n"
            "</body>\n"
            "</html>\n";
ULONG   ContentTailSize;

// For CAD dynamics

ULONG   CharJump[MAXCHAR];
ULONG   MatchJump[MAXSTRING];
CHAR    *TheString = "<!WEB99CAD><IMG SRC=\"/file_set/dirNNNNN/classX_Y\"><!/WEB99CAD>";
ULONG   TheStringLength;


HANDLE      PostLogFlushThreadHandle;
LOG_INFO    PostLogInfo; 
ULONG       SEND_POSTLOG_FILE = 1;

//
// This preinitialized array defines the strings to be used for
// inet address string.  The index of each row corresponds to the value for a byte
// in an IP address.  The first three bytes of each row are the
// char/string value for the byte, and the fourth byte in each row is
// the length of the string required for the byte.  This approach
// allows a fast implementation with no jumps.
//

BYTE NToACharStrings[][4] = {
    '0', 'x', 'x', 1,
    '1', 'x', 'x', 1,
    '2', 'x', 'x', 1,
    '3', 'x', 'x', 1,
    '4', 'x', 'x', 1,
    '5', 'x', 'x', 1,
    '6', 'x', 'x', 1,
    '7', 'x', 'x', 1,
    '8', 'x', 'x', 1,
    '9', 'x', 'x', 1,
    '1', '0', 'x', 2,
    '1', '1', 'x', 2,
    '1', '2', 'x', 2,
    '1', '3', 'x', 2,
    '1', '4', 'x', 2,
    '1', '5', 'x', 2,
    '1', '6', 'x', 2,
    '1', '7', 'x', 2,
    '1', '8', 'x', 2,
    '1', '9', 'x', 2,
    '2', '0', 'x', 2,
    '2', '1', 'x', 2,
    '2', '2', 'x', 2,
    '2', '3', 'x', 2,
    '2', '4', 'x', 2,
    '2', '5', 'x', 2,
    '2', '6', 'x', 2,
    '2', '7', 'x', 2,
    '2', '8', 'x', 2,
    '2', '9', 'x', 2,
    '3', '0', 'x', 2,
    '3', '1', 'x', 2,
    '3', '2', 'x', 2,
    '3', '3', 'x', 2,
    '3', '4', 'x', 2,
    '3', '5', 'x', 2,
    '3', '6', 'x', 2,
    '3', '7', 'x', 2,
    '3', '8', 'x', 2,
    '3', '9', 'x', 2,
    '4', '0', 'x', 2,
    '4', '1', 'x', 2,
    '4', '2', 'x', 2,
    '4', '3', 'x', 2,
    '4', '4', 'x', 2,
    '4', '5', 'x', 2,
    '4', '6', 'x', 2,
    '4', '7', 'x', 2,
    '4', '8', 'x', 2,
    '4', '9', 'x', 2,
    '5', '0', 'x', 2,
    '5', '1', 'x', 2,
    '5', '2', 'x', 2,
    '5', '3', 'x', 2,
    '5', '4', 'x', 2,
    '5', '5', 'x', 2,
    '5', '6', 'x', 2,
    '5', '7', 'x', 2,
    '5', '8', 'x', 2,
    '5', '9', 'x', 2,
    '6', '0', 'x', 2,
    '6', '1', 'x', 2,
    '6', '2', 'x', 2,
    '6', '3', 'x', 2,
    '6', '4', 'x', 2,
    '6', '5', 'x', 2,
    '6', '6', 'x', 2,
    '6', '7', 'x', 2,
    '6', '8', 'x', 2,
    '6', '9', 'x', 2,
    '7', '0', 'x', 2,
    '7', '1', 'x', 2,
    '7', '2', 'x', 2,
    '7', '3', 'x', 2,
    '7', '4', 'x', 2,
    '7', '5', 'x', 2,
    '7', '6', 'x', 2,
    '7', '7', 'x', 2,
    '7', '8', 'x', 2,
    '7', '9', 'x', 2,
    '8', '0', 'x', 2,
    '8', '1', 'x', 2,
    '8', '2', 'x', 2,
    '8', '3', 'x', 2,
    '8', '4', 'x', 2,
    '8', '5', 'x', 2,
    '8', '6', 'x', 2,
    '8', '7', 'x', 2,
    '8', '8', 'x', 2,
    '8', '9', 'x', 2,
    '9', '0', 'x', 2,
    '9', '1', 'x', 2,
    '9', '2', 'x', 2,
    '9', '3', 'x', 2,
    '9', '4', 'x', 2,
    '9', '5', 'x', 2,
    '9', '6', 'x', 2,
    '9', '7', 'x', 2,
    '9', '8', 'x', 2,
    '9', '9', 'x', 2,
    '1', '0', '0', 3,
    '1', '0', '1', 3,
    '1', '0', '2', 3,
    '1', '0', '3', 3,
    '1', '0', '4', 3,
    '1', '0', '5', 3,
    '1', '0', '6', 3,
    '1', '0', '7', 3,
    '1', '0', '8', 3,
    '1', '0', '9', 3,
    '1', '1', '0', 3,
    '1', '1', '1', 3,
    '1', '1', '2', 3,
    '1', '1', '3', 3,
    '1', '1', '4', 3,
    '1', '1', '5', 3,
    '1', '1', '6', 3,
    '1', '1', '7', 3,
    '1', '1', '8', 3,
    '1', '1', '9', 3,
    '1', '2', '0', 3,
    '1', '2', '1', 3,
    '1', '2', '2', 3,
    '1', '2', '3', 3,
    '1', '2', '4', 3,
    '1', '2', '5', 3,
    '1', '2', '6', 3,
    '1', '2', '7', 3,
    '1', '2', '8', 3,
    '1', '2', '9', 3,
    '1', '3', '0', 3,
    '1', '3', '1', 3,
    '1', '3', '2', 3,
    '1', '3', '3', 3,
    '1', '3', '4', 3,
    '1', '3', '5', 3,
    '1', '3', '6', 3,
    '1', '3', '7', 3,
    '1', '3', '8', 3,
    '1', '3', '9', 3,
    '1', '4', '0', 3,
    '1', '4', '1', 3,
    '1', '4', '2', 3,
    '1', '4', '3', 3,
    '1', '4', '4', 3,
    '1', '4', '5', 3,
    '1', '4', '6', 3,
    '1', '4', '7', 3,
    '1', '4', '8', 3,
    '1', '4', '9', 3,
    '1', '5', '0', 3,
    '1', '5', '1', 3,
    '1', '5', '2', 3,
    '1', '5', '3', 3,
    '1', '5', '4', 3,
    '1', '5', '5', 3,
    '1', '5', '6', 3,
    '1', '5', '7', 3,
    '1', '5', '8', 3,
    '1', '5', '9', 3,
    '1', '6', '0', 3,
    '1', '6', '1', 3,
    '1', '6', '2', 3,
    '1', '6', '3', 3,
    '1', '6', '4', 3,
    '1', '6', '5', 3,
    '1', '6', '6', 3,
    '1', '6', '7', 3,
    '1', '6', '8', 3,
    '1', '6', '9', 3,
    '1', '7', '0', 3,
    '1', '7', '1', 3,
    '1', '7', '2', 3,
    '1', '7', '3', 3,
    '1', '7', '4', 3,
    '1', '7', '5', 3,
    '1', '7', '6', 3,
    '1', '7', '7', 3,
    '1', '7', '8', 3,
    '1', '7', '9', 3,
    '1', '8', '0', 3,
    '1', '8', '1', 3,
    '1', '8', '2', 3,
    '1', '8', '3', 3,
    '1', '8', '4', 3,
    '1', '8', '5', 3,
    '1', '8', '6', 3,
    '1', '8', '7', 3,
    '1', '8', '8', 3,
    '1', '8', '9', 3,
    '1', '9', '0', 3,
    '1', '9', '1', 3,
    '1', '9', '2', 3,
    '1', '9', '3', 3,
    '1', '9', '4', 3,
    '1', '9', '5', 3,
    '1', '9', '6', 3,
    '1', '9', '7', 3,
    '1', '9', '8', 3,
    '1', '9', '9', 3,
    '2', '0', '0', 3,
    '2', '0', '1', 3,
    '2', '0', '2', 3,
    '2', '0', '3', 3,
    '2', '0', '4', 3,
    '2', '0', '5', 3,
    '2', '0', '6', 3,
    '2', '0', '7', 3,
    '2', '0', '8', 3,
    '2', '0', '9', 3,
    '2', '1', '0', 3,
    '2', '1', '1', 3,
    '2', '1', '2', 3,
    '2', '1', '3', 3,
    '2', '1', '4', 3,
    '2', '1', '5', 3,
    '2', '1', '6', 3,
    '2', '1', '7', 3,
    '2', '1', '8', 3,
    '2', '1', '9', 3,
    '2', '2', '0', 3,
    '2', '2', '1', 3,
    '2', '2', '2', 3,
    '2', '2', '3', 3,
    '2', '2', '4', 3,
    '2', '2', '5', 3,
    '2', '2', '6', 3,
    '2', '2', '7', 3,
    '2', '2', '8', 3,
    '2', '2', '9', 3,
    '2', '3', '0', 3,
    '2', '3', '1', 3,
    '2', '3', '2', 3,
    '2', '3', '3', 3,
    '2', '3', '4', 3,
    '2', '3', '5', 3,
    '2', '3', '6', 3,
    '2', '3', '7', 3,
    '2', '3', '8', 3,
    '2', '3', '9', 3,
    '2', '4', '0', 3,
    '2', '4', '1', 3,
    '2', '4', '2', 3,
    '2', '4', '3', 3,
    '2', '4', '4', 3,
    '2', '4', '5', 3,
    '2', '4', '6', 3,
    '2', '4', '7', 3,
    '2', '4', '8', 3,
    '2', '4', '9', 3,
    '2', '5', '0', 3,
    '2', '5', '1', 3,
    '2', '5', '2', 3,
    '2', '5', '3', 3,
    '2', '5', '4', 3,
    '2', '5', '5', 3
};



/**************************************************************************************************/

VOID InitSpec() {

    QueryServerSoftware(ServerSoftware);

    QueryScriptName(ScriptName);

    sprintf(PreBodyData, PRE_BODY_DATA_FORMAT, ServerSoftware, ScriptName);

    PreBodyDataSize = strlen(PreBodyData);

    RemoteAddrOffset = (ULONG) (strstr(PreBodyData, "REMOTE_ADDR = ") - PreBodyData) + 14;

    ContentTailSize = strlen(ContentTail);

    PostLogFlushThreadHandle = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) PostLogFlushThread, NULL, 0, NULL);

    CloseHandle(PostLogFlushThreadHandle);

    InitStringTable();

    // Initialize PostLogInfo structure

    PostLogInfo.LogFileHandle = NULL;
    PostLogInfo.LogEntryCounter = 0;
    PostLogInfo.FreeBufferList = NULL;
    PostLogInfo.DirtyBufferList = NULL;
    InitializeRWLock(PostLogInfo.Lock);
    InitializeRWLock(PostLogInfo.ShLock);
}

VOID InitStringTable() {

    ULONG j;
    ULONG k;
    ULONG t;
    ULONG tt;
    ULONG q;
    ULONG qq;
    ULONG Back[MAXSTRING];

    TheStringLength = strlen(TheString);

    for(k=0; k < MAXCHAR; k++) {

        CharJump[k] = TheStringLength;
    }

    for(k=1; k <= TheStringLength; k++) {

        CharJump[TheString[k-1]] = TheStringLength - k;
    }

    for(k=1; k <= TheStringLength; k++) {

        MatchJump[k-1] = 2 * TheStringLength - k;
    }


    j = TheStringLength;
    t = TheStringLength + 1;

    while(j > 0) {

        Back[j-1] = t;

        while((t <= TheStringLength) && (TheString[j-1] != TheString[t-1])) {

                MatchJump[t-1] = min(MatchJump[t-1], TheStringLength - j);

                t = Back[t-1];
        }

        j--;
        t--;
    }

    q = t;
    t = TheStringLength + 1 - q;
    qq = 1;
    tt = 0;

    for(j=1; j <= t; j++) {

        Back[j-1] = tt;

        while((tt >= 1) && (TheString[j-1] != TheString[tt-1])) {

            tt = Back[tt-1];
        }

        tt++;
    }


    while(q < TheStringLength) {

        for(k=qq; k<=q; k++) {

            MatchJump[k-1] = min( MatchJump[k-1], TheStringLength + q - k );
        }

        qq = q + 1;
        q = q + t - Back[t-1];
        t = Back[t-1];
    }
}

__inline ULONG MatchString(PCHAR Buffer, ULONG Size) {

    ULONG j;
    ULONG k;

    for (k=TheStringLength - 1; k < Size; k += max(CharJump[Buffer[k]], MatchJump[j])) {

        for (j=TheStringLength - 1; ((j >= 0) && (Buffer[k] == TheString[j])); j--)  {

            k--;
        }

        if (j == -1) {

            return(k + 1);
        }
    }

    return(-1);
}

VOID ScanAndReplaceString(PCHAR Buffer, ULONG Size, ULONG DirNumber, ULONG x, ULONG y) {

    ULONG     BufferIndex;
    ULONG     MatchedBufferIndex;
    ULONG     AlterIndex;

    BufferIndex = 0;
    MatchedBufferIndex = MatchString(Buffer, Size);

    while (-1 != MatchedBufferIndex) {

        AlterIndex = MatchedBufferIndex + BufferIndex + 34;

        ConvertNumberToString(&Buffer[AlterIndex], DirNumber, 5, TRUE);

        AlterIndex = MatchedBufferIndex + BufferIndex + 39;

        Buffer[AlterIndex] = '/';

        AlterIndex = MatchedBufferIndex + BufferIndex + 45;

        Buffer[AlterIndex] = (CHAR)('0' + x);

        AlterIndex = MatchedBufferIndex + BufferIndex + 47;

        Buffer[AlterIndex] = (CHAR)('0' + y);

        BufferIndex += TheStringLength + MatchedBufferIndex;

        MatchedBufferIndex = MatchString(&Buffer[BufferIndex], Size-BufferIndex);
    }
}

VOID ProcessRequest(HANDLE Request) {

    SPEC_REQ_TYPE           ReqType;

    ReqType = SpecDetermineReqType(Request);

    switch (ReqType) {

        case SPEC_SIMPLE_DYNAMIC:
                SpecSimpleDynamic(Request);
                break;

        case SPEC_COMMAND_RESET:
                SpecCommandReset(Request);
                break;

        case SPEC_COMMAND_FETCH:
                SpecCommandFetch(Request);
                break;

        case SPEC_POST_DYNAMIC:
                SpecPostDynamic(Request);
                break;

        case SPEC_CAD_DYNAMIC:
                SpecCadDynamic(Request);
                break;

        default:    
                SpecFailRequest(Request, "Error Request");
                break;
    }
}

VOID SpecFailRequest(HANDLE Request, PCHAR ErrorString) {

    PCHAR   RequestBuffer, StrPtr;
    ULONG   CookieStringSize, PreBodySize, ContentSize;

    // ----------------  Send a SPEC99 response with ErrorString message  ----------------

    StrPtr = RequestBuffer = TwcQueryRequestBuffer(Request);

    CookieStringSize = 0;

    PreBodySize = SpecFillPreBodyData(Request, NULL, 0, StrPtr);

    StrPtr += PreBodySize;

    memcpy(StrPtr, ErrorString, strlen(ErrorString));

    ContentSize = strlen(ErrorString);

    StrPtr += ContentSize;

    memcpy(StrPtr, ContentTail, ContentTailSize);

    TwcSendMessage(Request, CookieStringSize, PreBodySize, ContentSize, ContentTailSize);
}

VOID SpecCadDynamic(HANDLE Request) {

    BOOLEAN     Class1OrClass2, Expired = TRUE;
    ULONG       userIndex, lastAdId;
    PCHAR       QueryString;
    ULONG       UserDemographics;
    ULONG       CombinedDemographics;
    ULONG       CurrentTime;
    ULONG       Ad_index, Ad_weight;
    ULONG       QueryStringSize;
    
    Class1OrClass2 = DetermineIfClass1Or2(Request);

    SpecParseCookieString(Request, &userIndex, &lastAdId);

    if (Class1OrClass2) {

        QueryString = SpecQueryQueryString(Request, "/file_set", &QueryStringSize);

        TwcReadFile(Request, QueryString, QueryStringSize);

        // at this moment we can access the file content through Request structure
    }

    // find matching record in user personality

    userIndex = userIndex -10000; //10001;

    if (((userIndex > RootAd.UserBufSize) || (userIndex < 0))) {

        // no match record is found

        if (Class1OrClass2) {

            ScanAndReplaceString(TwcGetFileBuffer(Request), TwcGetFileBufferSize(Request), lastAdId/36, (lastAdId%36)/9, lastAdId%9);

            SpecSendCadDynamicResponse(Request, -1, 0, TRUE);

            return;

        } else {

            SpecSendCadDynamicFile(Request, -1, 0, TRUE);

            return;
        }
    }

    // A matching personal record is found

    UserDemographics = RootAd.pUserPfBuf[userIndex];
    CombinedDemographics = 0;

    // get current time

    GetTimeInfo((time_t*)&CurrentTime);

    Ad_index = lastAdId + 1;
    Ad_weight = 0;

    if( Ad_index > 359 )    Ad_index = 0;

    while (Ad_index != lastAdId) {

        // calculate the weight value

        CombinedDemographics = ( (RootAd.pCustomAdBuf[Ad_index]->AdDemographics)&UserDemographics);
        Ad_weight = 0;

        if(CombinedDemographics&GENDER_MASK )
            Ad_weight = Ad_weight + (((RootAd.pCustomAdBuf[Ad_index]->Weightings)>>16)&WT_MASK );

        if(CombinedDemographics&AGE_GROUP_MASK )
            Ad_weight = Ad_weight + (((RootAd.pCustomAdBuf[Ad_index]->Weightings)>>12)&WT_MASK );

        if(CombinedDemographics&REGION_MASK )
            Ad_weight = Ad_weight + (((RootAd.pCustomAdBuf[Ad_index]->Weightings)>>8)&WT_MASK );

        if(CombinedDemographics&INTEREST1_MASK )
            Ad_weight = Ad_weight + (((RootAd.pCustomAdBuf[Ad_index]->Weightings)>>4)&WT_MASK );

        if(CombinedDemographics&INTEREST2_MASK )
            Ad_weight = Ad_weight + ((RootAd.pCustomAdBuf[Ad_index]->Weightings)&WT_MASK );

        if(Ad_weight >= (RootAd.pCustomAdBuf[Ad_index]->MinMvalue)) {

            if( CurrentTime > ( RootAd.pCustomAdBuf[Ad_index]->ExTime)) {

                Expired = TRUE;

            } else {

                Expired = FALSE;
            }

            if (Class1OrClass2) {

                ScanAndReplaceString(TwcGetFileBuffer(Request), TwcGetFileBufferSize(Request), Ad_index/36, (Ad_index%36)/9, Ad_index%9);

                SpecSendCadDynamicResponse(Request, Ad_index, Ad_weight, Expired);

                return;

            } else {

                SpecSendCadDynamicFile(Request, Ad_index, Ad_weight, Expired);

                return;
            }
        }

        Ad_index++;

        if( Ad_index > 359 )    Ad_index = 0;

    }

    if (Class1OrClass2) {

        ScanAndReplaceString(TwcGetFileBuffer(Request), TwcGetFileBufferSize(Request), lastAdId/36, (lastAdId%36)/9, lastAdId%9);

        SpecSendCadDynamicResponse(Request, Ad_index, Ad_weight, Expired);

    } else {

        SpecSendCadDynamicFile(Request, Ad_index, Ad_weight, Expired);
    }
}

VOID SpecCommandFetch(HANDLE Request) {

    PCHAR           RequestBuffer, StrPtr;
    ULONG           CookieStringSize, PreBodySize, ContentSize;

    AcquireRWLockExclusive(PostLogInfo.Lock);

    // First, flush any dirty buffer to the disk

    if (STATUS_ERROR == FlushCachedDataExclusive()) {

        ProcessErrorExit("SpecCommandFetch", "FlushCachedData fail");
    }

    // Cleanup the PostLog file

    if (!CloseHandle(PostLogInfo.LogFileHandle)) {

        ProcessErrorExit("SpecCommandFetch", "CloseHandle fail");
    }

    PostLogInfo.LogFileHandle = NULL;

    PostLogInfo.LogEntryCounter = 0;

    if (PostLogInfo.FirstBuffer != PostLogInfo.CurrentBuffer) {

        PostLogInfo.FirstBuffer->Next = PostLogInfo.FreeBufferList;
        PostLogInfo.FreeBufferList = PostLogInfo.FirstBuffer;
    }

    PostLogInfo.FirstBuffer = NULL;

    ReleaseRWLockExclusive(PostLogInfo.Lock);

    printf("PostLog closed\n");

    // file in the request buffer in the order of: cookie, prebody, content, tail

    StrPtr = RequestBuffer = TwcQueryRequestBuffer(Request);

    CookieStringSize = 0;

    PreBodySize = SpecFillPreBodyData(Request, "command/Fetch", 13, StrPtr);
    StrPtr += PreBodySize;

    if (SEND_POSTLOG_FILE) {

        memcpy(StrPtr, "PostLog", 7);
        StrPtr += 7;
        ContentSize = 7;

    } else {

        ContentSize = 0;
    }

    memcpy(StrPtr, ContentTail, ContentTailSize);

    if (SEND_POSTLOG_FILE) {

        TwcSendLargeFile(Request, CookieStringSize, PreBodySize, ContentSize, ContentTailSize);

    } else {

        TwcSendMessage(Request, CookieStringSize, PreBodySize, ContentSize, ContentTailSize);
    }
}

VOID SpecSendCadDynamicResponse(HANDLE Request, ULONG AdIndex, ULONG AdWeight, BOOLEAN Expired) {

    PCHAR       StrPtr, RequestBuffer, QueryString;
    ULONG       CookieStringSize, PreBodySize;
    ULONG       QueryStringSize;

    // file in the request buffer in the order of: cookie, prebody, content, tail

    StrPtr = RequestBuffer = TwcQueryRequestBuffer(Request);

    CookieStringSize = SpecPrepareCookieString(StrPtr, AdIndex, AdWeight, Expired);
    StrPtr += CookieStringSize;

    QueryString = SpecQueryQueryString(Request, "/file_set", &QueryStringSize);

    PreBodySize = SpecFillPreBodyData(Request, QueryString, QueryStringSize, StrPtr);
    StrPtr += PreBodySize;

    memcpy(StrPtr, ContentTail, ContentTailSize);

    TwcSendBuffer(Request, CookieStringSize, PreBodySize, TwcGetFileBufferSize(Request), ContentTailSize);
}

ULONG ConvertNumberToString(PCHAR StrPtr, ULONG Number, ULONG DigitFields, BOOLEAN RecordingZero) {

    PCHAR       StartPtr = StrPtr;
    ULONG       DivNumber;
    ULONG       i, A;

    DivNumber = 1;

    for (i=0;i<(DigitFields-1);i++) DivNumber *= 10;

    for (i=0;i<DigitFields;i++) {

        A = Number / DivNumber;

        if (A == 0) {

            if (RecordingZero || DivNumber == 1) {

                *StrPtr++ = (CHAR)('0');
            }

        } else {

            *StrPtr++ = (CHAR)('0' + A);
            RecordingZero = TRUE;
        }

        Number -= DivNumber * A;
        DivNumber /= 10;
    }
    
    return (ULONG)(StrPtr - StartPtr);
}

ULONG SpecPrepareCookieString(PCHAR StrPtr, ULONG AdIndex, ULONG AdWeight, BOOLEAN Expired) {

    PCHAR   StartPtr;
    ULONG   DigitSize;

    StartPtr = StrPtr;

    memcpy(StrPtr, "Set-Cookie: found_cookie=Ad_id=", 31);
    StrPtr += 31;

    DigitSize = ConvertNumberToString(StrPtr, AdIndex, 5, FALSE);
    StrPtr += DigitSize;

    memcpy(StrPtr, "&Ad_weight=", 11);
    StrPtr += 11;

    DigitSize = ConvertNumberToString(StrPtr, AdWeight, 5, FALSE);
    StrPtr += DigitSize;

    memcpy(StrPtr, "&Expired=", 9);
    StrPtr += 9;

    DigitSize = ConvertNumberToString(StrPtr, Expired, 1, TRUE);
    StrPtr += DigitSize;

    memcpy(StrPtr, "\r\n\r\n", 4);
    StrPtr += 4;

    return (ULONG)(StrPtr - StartPtr);
}

VOID SpecSendCadDynamicFile(HANDLE Request, ULONG AdIndex, ULONG AdWeight, BOOLEAN Expired) {

    PCHAR       StrPtr, RequestBuffer, QueryString;
    ULONG       CookieStringSize, PreBodySize, ContentSize;
    ULONG       QueryStringSize;

    // file in the request buffer in the order of: cookie, prebody, content, tail

    StrPtr = RequestBuffer = TwcQueryRequestBuffer(Request);

    CookieStringSize = SpecPrepareCookieString(StrPtr, AdIndex, AdWeight, Expired);
    StrPtr += CookieStringSize;

    QueryString = SpecQueryQueryString(Request, "/file_set", &QueryStringSize);

    PreBodySize = SpecFillPreBodyData(Request, QueryString, QueryStringSize, StrPtr);
    StrPtr += PreBodySize;

    ContentSize = QueryStringSize;
    memcpy(StrPtr, QueryString, ContentSize);
    StrPtr += ContentSize;

    memcpy(StrPtr, ContentTail, ContentTailSize);

    TwcSendFile(Request, CookieStringSize, PreBodySize, ContentSize, ContentTailSize);
}

VOID SpecPostDynamic(HANDLE Request) {

    CHAR            UrlRoot[32];
    PCHAR           QueryString;
    ULONG           DirNum, ClassNum, FileNum, ClientNum, UserId, LastAd;
    LOG_RECORD      PostLogRecord;
    PCHAR           RequestBuffer, StrPtr;
    ULONG           CookieStringSize, PreBodySize, ContentSize;

    SpecParsePostInput(Request, UrlRoot, &DirNum, &ClassNum, &FileNum, &ClientNum, &QueryString);

    //printf("SpecPostDynamic: Query %08x UrlRoot %s DirNum %d ClassNum %d FileNum %d ClientNum %d\n", QueryString, UrlRoot, DirNum, ClassNum, FileNum, ClientNum);

    SpecParseCookieString(Request, &UserId, &LastAd);

    // Setup the PostLogRecord

    GetTimeInfo((time_t*)&(PostLogRecord.TimeStamp));

    //PostLogRecord.TimeStamp = (ULONG)SystemTime.dwLowDateTime;
    PostLogRecord.Pid = (ULONG)TwcQueryCurrentThreadId(Request);
    PostLogRecord.DirNum = DirNum;
    PostLogRecord.ClassNum = ClassNum;
    PostLogRecord.FileNum = FileNum;
    PostLogRecord.ClientNum = ClientNum;
    PostLogRecord.MyCookie = UserId;

    StrPtr = PostLogRecord.FileName;
    memcpy(StrPtr, UrlRoot, strlen(UrlRoot));
    StrPtr += strlen(UrlRoot);
    memcpy(StrPtr, "dir", 3);
    StrPtr += 3;
    StrPtr += ConvertNumberToString(StrPtr, DirNum, 5, TRUE);
    memcpy(StrPtr, "/class", 6);
    StrPtr += 6;
    StrPtr += ConvertNumberToString(StrPtr, ClassNum, 1, TRUE);
    memcpy(StrPtr++, "_", 1);
    StrPtr += ConvertNumberToString(StrPtr, FileNum, 1, TRUE);
    memcpy(StrPtr, "\0", 1);

    // Put the LogRecord into the PostLog buffer

    if ((STATUS_SUCCESS != WritePostLogShared(&PostLogRecord)) &&
        (STATUS_SUCCESS != WritePostLogExclusive(&PostLogRecord))) {

        ProcessErrorExit("SpecPostDynamic", "WaitLog fail");
    }

    // file in the request buffer in the order of: cookie, prebody, content, tail

    StrPtr = RequestBuffer = TwcQueryRequestBuffer(Request);

    memcpy(StrPtr, "Set-Cookie: my_cookie=", 22);
    StrPtr += 22;
    StrPtr += ConvertNumberToString(StrPtr, UserId, 5, FALSE);
    memcpy(StrPtr, "\r\n\r\n", 4);
    StrPtr += 4;
    CookieStringSize = (ULONG)(StrPtr - RequestBuffer);

    PreBodySize = SpecFillPreBodyData(Request, QueryString, strlen(QueryString), StrPtr);
    StrPtr += PreBodySize;

    ContentSize = strlen(PostLogRecord.FileName);
    memcpy(StrPtr, PostLogRecord.FileName, ContentSize);
    StrPtr += ContentSize;

    memcpy(StrPtr, ContentTail, ContentTailSize);

    TwcSendFile(Request, CookieStringSize, PreBodySize, ContentSize, ContentTailSize);
}


VOID SpecCommandReset(HANDLE Request) {

    CHAR        CmdLine[64];
    ULONG       CopySize, i;
    PCHAR       RequestBuffer, StrPtr, StrPtr2, StrPtr3, StrPtr4;
    ULONG       CookieStringSize, PreBodySize, ContentSize;
    PCHAR       pMaxLoad, pPtTime, pMaxThread, pExList, pUrlRoot, pHttpProtocol;
    PCHAR       QueryString;
    ULONG       QueryStringSize;

    STARTUPINFO         si1, si2;
    PROCESS_INFORMATION piP1, piP2;

    // first parse the HttpRequest to obtain parameters for cafgen.exe and pfgen99.exe

    StrPtr = TwcQueryHttpRequest(Request);

    // set pMaxLoad pointer to point the begining of max load data
    
    pMaxLoad = strstr(StrPtr, "maxload=");

    // set pPtTime pointer to point the begining of point time data

    pPtTime = strstr(pMaxLoad, "pttime=");

    // set pMaxThread 

    pMaxThread = strstr(pPtTime, "maxthread");

    // set pExList

    pExList = strstr(pMaxThread, "exp=");

    // set pUrlRoot

    pUrlRoot = strstr(pExList, "urlroot");

    // set pHttpProtocol

    pHttpProtocol = strstr(pUrlRoot, "HTTP/");

    //printf("StrPtr %08x pMaxLoad %08x pPtTime %08x pMaxThread %08x pExList %08x pUrlRoot %08x pProtocol %08x\n", StrPtr, pMaxLoad, pPtTime, pMaxThread, pExList, pUrlRoot, pHttpProtocol);

    StrPtr = CmdLine;

    memcpy(StrPtr, "Upfgen99 -n ",12);
    StrPtr += 12;

    // copy MaxLoad

    CopySize = pPtTime - pMaxLoad - 1 - strlen("maxload=");
    memcpy(StrPtr, pMaxLoad + strlen("maxload="), CopySize);
    StrPtr += CopySize;

    // copy MaxThreads

    memcpy(StrPtr, " -t ", 4);
    StrPtr += 4;

    CopySize = pExList - pMaxThread - 1 - strlen("maxthread=");
    memcpy(StrPtr, pMaxThread + strlen("maxthread="), CopySize);
    StrPtr += CopySize;

    // copy RootDir

    memcpy(StrPtr, " -C ", 4);
    StrPtr += 4;

    memcpy(StrPtr, "data\0", 5);

    // -----------------   execute upfgen.exe  ------------------------

    ZeroMemory(&si1, sizeof(si1));
    si1.cb = sizeof(si1);

    printf("Upfgen99.exe CmdLine %s\n", CmdLine);

    if (!CreateProcess("Upfgen99.exe", CmdLine, NULL, NULL, FALSE, CREATE_NO_WINDOW, NULL, NULL, &si1, &piP1)) {

        ProcessErrorExit("SpecCommandReset", "Upfgen99.exe fail");

    } else {

        CloseHandle(piP1.hThread);
        WaitForSingleObject(piP1.hProcess, INFINITE);
        CloseHandle(piP1.hProcess);
    }

    // compose commandline for cadgen.exe

    StrPtr = CmdLine;
    memcpy(StrPtr, "Cadgen99 -C", 11);
    StrPtr += 11;

    // copy RootDir

    memcpy(StrPtr, " data", 5);
    StrPtr += 5;

    // copy pPtTime

    memcpy(StrPtr, " -e ", 4);
    StrPtr += 4;

    CopySize = pMaxThread - pPtTime - 1 - strlen("pttime=");
    memcpy(StrPtr, pPtTime + strlen("pttime="), CopySize);
    StrPtr += CopySize;

    // copy MaxThread

    memcpy(StrPtr, " -t ", 4);
    StrPtr += 4;

    CopySize = pExList - pMaxThread - 1 - strlen("maxthread=");
    memcpy(StrPtr, pMaxThread + strlen("maxthread="), CopySize);
    StrPtr += CopySize;

    // copy expiredlist

    memcpy(StrPtr, " ", 1);
    StrPtr++;

    CopySize = pUrlRoot - pExList - 1 - strlen("exp=");

    StrPtr2 = pExList + strlen("exp=");
    StrPtr3 = StrPtr2 + CopySize;
    
    while (StrPtr2 < StrPtr3) {

        i = 0;
        StrPtr4 = StrPtr2;

        while ((*StrPtr2++ != ',') && (StrPtr2 <= StrPtr3))   i++;

        memcpy(StrPtr, StrPtr4, i);

        StrPtr += i;

        if (StrPtr2 < StrPtr3) {

            memcpy(StrPtr, " ", 1);
            StrPtr++;

        } else {

            break;
        }
    }

    memcpy(StrPtr, "\0", 1);

    // ------------------------  execute cadgen99.exe  ------------------------

    ZeroMemory(&si2, sizeof(si2));
    si2.cb = sizeof(si2);

    printf("Cadgen99.exe CmdLine %s\n", CmdLine);

    if (!CreateProcess("Cadgen99.exe", CmdLine, NULL, NULL, FALSE, CREATE_NO_WINDOW, NULL, NULL, &si2, &piP2)) {

        ProcessErrorExit("SpecCommandReset", "Cadgen99.exe failed");

    } else {

        CloseHandle(piP2.hThread);
        WaitForSingleObject(piP2.hProcess, INFINITE);
        CloseHandle(piP2.hProcess);
    }

    // ------------------------  Setup CustomAd structure

    InitializeCustomAd();

    // ------------------------  Setup PostLog structure  ------------------------

    // first, check if file has been closed and cleanup

    if (NULL != PostLogInfo.LogFileHandle) {

        if (!CloseHandle(PostLogInfo.LogFileHandle)) {

            ProcessErrorExit("SpecCommandReset", "ClosePostLog failed");
        }

        PostLogInfo.LogFileHandle = NULL;

        printf("PostLog closed\n");
    }

    AcquireRWLockExclusive(PostLogInfo.Lock);
    InitializePostLogInfo();
    ReleaseRWLockExclusive(PostLogInfo.Lock);

    // ------------------------  Send a SPEC99 response with "" message  ------------------------

    // file in the request buffer in the order of: cookie, prebody, content, tail

    StrPtr = RequestBuffer = TwcQueryRequestBuffer(Request);

    CookieStringSize = 0;

    QueryString = SpecQueryQueryString(Request, "command", &QueryStringSize);

    PreBodySize = SpecFillPreBodyData(Request, QueryString, QueryStringSize, StrPtr);

    StrPtr += PreBodySize;

    ContentSize = 0;

    memcpy(StrPtr, ContentTail, ContentTailSize);

    TwcSendMessage(Request, CookieStringSize, PreBodySize, ContentSize, ContentTailSize);
}

VOID SpecSimpleDynamic(HANDLE Request) {

    PCHAR       QueryString;
    ULONG       QueryStringSize;
    PCHAR       RequestBuffer, StrPtr;
    ULONG       CookieStringSize, PreBodySize, ContentSize;

    StrPtr = RequestBuffer = TwcQueryRequestBuffer(Request);

    // file in the request buffer in the order of: cookie, prebody, content, tail

    CookieStringSize = 0;

    QueryString = SpecQueryQueryString(Request, "/file_set", &QueryStringSize);

    PreBodySize = SpecFillPreBodyData(Request, QueryString, QueryStringSize, StrPtr);
    StrPtr += PreBodySize;

    ContentSize = QueryStringSize;
    memcpy(StrPtr, QueryString, QueryStringSize);
    StrPtr += ContentSize;

    memcpy(StrPtr, ContentTail, ContentTailSize);

    TwcSendFile(Request, CookieStringSize, PreBodySize, ContentSize, ContentTailSize);
}

ULONG SpecFillPreBodyData(HANDLE Request, PCHAR QueryString, ULONG QueryStringSize, PCHAR StrPtr) {

    ULONG       Addr;
    CHAR        IpAddr[16];
    ULONG       PreBodySize;
    PUCHAR      p,b;

    //fprintf(stdout, "Request %08x QueryStr %08x Size %08x StrPtr %08x\n", Request, QueryString, QueryStringSize, StrPtr);

    Addr = TwcQueryIpAddress(Request);

    p = (PUCHAR)&Addr;

    b = IpAddr;

    *b = NToACharStrings[*p][0];
    *(b+1) = NToACharStrings[*p][1];
    *(b+2) = NToACharStrings[*p][2];
    b += NToACharStrings[*p][3];
    *b++ = '.';

    p++;
    *b = NToACharStrings[*p][0];
    *(b+1) = NToACharStrings[*p][1];
    *(b+2) = NToACharStrings[*p][2];
    b += NToACharStrings[*p][3];
    *b++ = '.';

    p++;
    *b = NToACharStrings[*p][0];
    *(b+1) = NToACharStrings[*p][1];
    *(b+2) = NToACharStrings[*p][2];
    b += NToACharStrings[*p][3];
    *b++ = '.';

    p++;
    *b = NToACharStrings[*p][0];
    *(b+1) = NToACharStrings[*p][1];
    *(b+2) = NToACharStrings[*p][2];
    b += NToACharStrings[*p][3];
    *b = '\0';

    memcpy(StrPtr, PreBodyData, PreBodyDataSize);
    memcpy(StrPtr + RemoteAddrOffset, IpAddr, strlen(IpAddr));

    if (0 < QueryStringSize) {

        memcpy(StrPtr + PreBodyDataSize, QueryString, QueryStringSize);
    }
    memcpy(StrPtr + PreBodyDataSize + QueryStringSize, PreBodyDataTail, PreBodyDataTailSize);

    PreBodySize = PreBodyDataSize + QueryStringSize + PreBodyDataTailSize;

    return PreBodySize;
}


