/*+***************************************************************************
 *                                                                           *
 * COPYRIGHT (c) COMPAQ COMPUTER CORPORATION, 1998                           *
 * ALL RIGHTS RESERVED.                                                      *
 *                                                                           *
 * UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS                      *
 * OF THE UNITED STATES.                                                     *
 *                                                                           *
 * Permission to use, copy, modify, and  distribute this software  for any   *
 * purpose with or without fee is hereby granted, provided  that the above   *
 * copyright notice and  this permission notice  appear in all copies, and   *
 * that the name of Compaq Computer Corporation not be used in advertising   *
 * or publicity  pertaining to  distribution of  the document or  software   *
 * without specific, written prior permission.                               *
 *                                                                           *
 * DISCLAIMER OF WARRANTY AND LIMITATION OF LIABILITY                        *
 *                                                                           *
 * THE SOFTWARE  IS PROVIDED "AS IS" AND COMPAQ COMPUTER CORP. DISCLAIMS ALL *
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES *
 * OF  MERCHANTABILITY  AND  FITNESS.  IN  NO EVENT  SHALL  COMPAQ  COMPUTER *
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL *
 * DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR *
 * PROFITS, WHETHER  IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS *
 * ACTION, ARISING OUT  OF OR  IN CONNECTION WITH  THE USE OR PERFORMANCE OF *
 * THIS SOFTWARE.                                                            *
 *                                                                           *
 *****************************************************************************/
 

/*+***************************************************************************
Examples of how to do GETs and POSTS


GET /specweb99/isapi/specweb99-zisapi.so?/specweb99/file_set/dir00000/class0_0 HTTP/1.1
Cookie: my_cookie=user_id=10001&last_ad=23

POST /specweb99/isapi/specweb99-newzisapi.so HTTP/1.1
Cookie: my_cookie=10001
Host: bbb116
Content-Length: 61

urlroot=/specweb99/file_set/&dir=00000&class=0&num=0&client=1


****************************************************************************/

/*+***************************************************************************

$Revision: 1.18 $

****************************************************************************/


#include <specweb99-common.h>

static int Inited = FALSE;
static spec_data_t Context, *pContext;
global_spec_data_t gConstants;

#ifdef DEBUG
static FILE *LogFd = 0 ;
#endif

int set_nonblock_flag(int desc, int value);


#ifdef _WIN32 
_declspec (thread) int tls_i = 1;

static CRITICAL_SECTION startupCriticalSection;
static CRITICAL_SECTION postLogCriticalSection;
#ifdef DEBUG
static CRITICAL_SECTION debugLogCriticalSection;
#endif


BOOL APIENTRY
DllMain(HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpRes)
{
  switch( ul_reason_for_call )
  {
  case DLL_PROCESS_ATTACH:
#ifdef DEBUG_ENTRY
    DebugBreak( );
#endif
    InitializeCriticalSection( &startupCriticalSection );
    return TRUE;
    break;
  case DLL_THREAD_ATTACH:
    break;
  case DLL_THREAD_DETACH:
    break;
  case DLL_PROCESS_DETACH:
    DeleteCriticalSection( &startupCriticalSection );
    break;
  }
  return TRUE;
}

#endif

int 
Specweb99main(WebInputs_t *WebInputs) {

#ifdef TRANSMIT_FILE
  int TempLen;
  int RetVal;
#endif

  int Request;		/* Type of request (i.e. GET, POST, FETCH, etc. */

  int len;
  char *errorstr;
  char *FileStart;

  /* Assign some handy pointers*/
  pContext = &Context;

  pContext->BufCurLen = 0;
 
  /* If 1st time through, set up the "static" variables kept in the 
     Context structure */
  if (!Inited) {

#ifdef _WIN32
    EnterCriticalSection( &startupCriticalSection );
    if (!Inited) {
      InitializeCriticalSection (&postLogCriticalSection);
#ifdef DEBUG
      InitializeCriticalSection (&debugLogCriticalSection);
#endif
#endif


      if (-1 == Initialize(WebInputs, pContext)) {
	return FinishHtmlAndSendBuffer(WebInputs, pContext);
      }
      Inited = TRUE;
      gConstants.VersionStr = VERSION;
      
#ifdef _WIN32

    } /* if (!Inited); */
    LeaveCriticalSection( &startupCriticalSection );
#endif
    
  }
 
  GetQuery(WebInputs, pContext);

   /* Make the start of the Html page */
  /*
  pContext->BufCurLen += 
    sprintf(&pContext->Buffer[pContext->BufCurLen], BOILERPLATE_START, 
	    pContext->ServerSoftware, pContext->RemoteAddr,
	    pContext->ScriptName, pContext->QueryString);
	    */

  memcpy(&pContext->Buffer[pContext->BufCurLen], HTML_START1,
	 sizeof(HTML_START1)-1);
  pContext->BufCurLen += sizeof(HTML_START1)-1;
  len = strlen(gConstants.ServerSoftware);
  memcpy(&pContext->Buffer[pContext->BufCurLen], gConstants.ServerSoftware, len );
  pContext->BufCurLen += len;


  memcpy(&pContext->Buffer[pContext->BufCurLen], HTML_START2,
	 sizeof(HTML_START2)-1);
  pContext->BufCurLen += sizeof(HTML_START2)-1;
  len = strlen(pContext->RemoteAddr);
  memcpy(&pContext->Buffer[pContext->BufCurLen], pContext->RemoteAddr, len );
  pContext->BufCurLen += len;

  memcpy(&pContext->Buffer[pContext->BufCurLen], HTML_START3,
	 sizeof(HTML_START3)-1);
  pContext->BufCurLen += sizeof(HTML_START3)-1;
  len = strlen(gConstants.ScriptName);
  memcpy(&pContext->Buffer[pContext->BufCurLen], gConstants.ScriptName, len );
  pContext->BufCurLen += len;

  memcpy(&pContext->Buffer[pContext->BufCurLen], HTML_START4,
	 sizeof(HTML_START4)-1);
  pContext->BufCurLen += sizeof(HTML_START4)-1;
  len = strlen(pContext->QueryString);
  memcpy(&pContext->Buffer[pContext->BufCurLen], pContext->QueryString, len );
  pContext->BufCurLen += len;

  memcpy(&pContext->Buffer[pContext->BufCurLen], HTML_START5,
	 sizeof(HTML_START5)-1);
  pContext->BufCurLen += sizeof(HTML_START5)-1;


  pContext->Buffer[pContext->BufCurLen] = '\0';


  /* Parse the command */
  if (!strncmp("GET", pContext->QueryMethod, 3)) {
    if ('\0' == pContext->QueryString[0]) {
      pContext->BufCurLen += sprintf(&pContext->Buffer[pContext->BufCurLen], 
				     "No query string was set\n");
      return FinishHtmlAndSendBuffer(WebInputs, pContext);
    }
    /* See if it's not a command */
    else if (strncmp("command/", pContext->QueryString, 8)) {
      Request = GET;

      strcpy(&pContext->FileName[gConstants.LenTopDir], pContext->QueryString);


#ifdef TRANSMIT_FILE
      if ( '\0' == pContext->CookieStr[0] ) {
	/* For CAD GET, do the regular stuff, otherwise to xmit_file */

	RetVal =  TransmitFile(WebInputs, pContext);
	if (MY_TRANSMIT_FILE_ERROR == RetVal) {
	  pContext->BufCurLen += 
	    ReadFileIntoBuffer(pContext->FileName, 
			       &pContext->Buffer[pContext->BufCurLen], 
			       BUFLEN - pContext->BufCurLen);
	  
	  return FinishHtmlAndSendBuffer(WebInputs, pContext);
	}
	else return RetVal;
	
      }
      else {
	
#endif
	FileStart = &pContext->Buffer[pContext->BufCurLen];

	pContext->BufCurLen += 
	  ReadFileIntoBuffer(pContext->FileName, 
			     &pContext->Buffer[pContext->BufCurLen], 
			     BUFLEN - pContext->BufCurLen);
	
	if ( '\0' != pContext->CookieStr[0] ) {
	  pContext->BufCurLen += 
	    CustomAdRotation(pContext, &pContext->Buffer[pContext->BufCurLen]);
	  if (-1 == CustomAdTextReplace(pContext->CadStr, 
					FileStart))
	    pContext->BufCurLen+= sprintf(&pContext->Buffer[pContext->BufCurLen],
					  "Error in Include Files routine\n");
	}
#ifdef TRANSMIT_FILE
      }
#endif

      return FinishHtmlAndSendBuffer(WebInputs, pContext);
	

    }

    /* We've already determined that it's "command/" */
    else if (!strncmp (&pContext->QueryString[8], "Reset", 5) ) {
      Request = RESET;
      pContext->BufCurLen += DoReset(&pContext->QueryString[14], pContext, 
		     &pContext->Buffer[pContext->BufCurLen]);
      return FinishHtmlAndSendBuffer(WebInputs, pContext);
    }
    else if (!strncmp (&pContext->QueryString[8], "Fetch", 5) ) {
      Request = FETCH;
      /* First flush  post.log*/
      return (ReturnPostLog (gConstants.LogFile, pContext->Buffer, WebInputs));
    }
    /* This is not required in the spec */
    else if (!strncmp(&pContext->QueryString[8], "Version", 7) ) {
      pContext->BufCurLen += sprintf (&pContext->Buffer[pContext->BufCurLen],
				      "Version = %s", gConstants.VersionStr);
      return FinishHtmlAndSendBuffer(WebInputs, pContext);
    }
  } /* End of it's a GET */


  else if (!strncmp("POST", pContext->QueryMethod, 4)) {
    Request = POST;
    
    GetPostData(WebInputs, pContext);


    if (0 == DoPost(pContext, &pContext->Buffer[pContext->BufCurLen])) {
#ifdef TRANSMIT_FILE
      /*      return TransmitFile(WebInputs, pContext); */
      RetVal =  TransmitFile(WebInputs, pContext);
      if (MY_TRANSMIT_FILE_ERROR == RetVal) {
	pContext->BufCurLen += 
	  ReadFileIntoBuffer(pContext->FileName, 
			     &pContext->Buffer[pContext->BufCurLen], 
			     BUFLEN - pContext->BufCurLen);
	
	return FinishHtmlAndSendBuffer(WebInputs, pContext);
      }
      else return RetVal;
#else
      pContext->BufCurLen += 
	ReadFileIntoBuffer(pContext->FileName, 
			   &pContext->Buffer[pContext->BufCurLen], 
			   BUFLEN - pContext->BufCurLen);
      
#endif
    }
    return FinishHtmlAndSendBuffer(WebInputs, pContext);
  }
  return -999;
}


/* 
 * FUNCTION:	int CustomAdRotation(spec_data_t *pContext, char *Buf);
 *
 * PURPOSE:	Implements the custom ad rotation scheme.  In this scheme
 *		the cookie from the current request is matched against
 *		cookies in last 30 seconds of the post log, returning
 *		the number of matches found.
 *		
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		char       *Buf         Buffer for strings to return to client
 *		int	   Cookie       Cookie to search for
 *              int        *pFound      place to record # of found matches
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	If everthing works, nothing is ever written to Buf.  It
 *		is only there for returning error strings.
 */

int 
CustomAdRotation( spec_data_t *pContext, char *Buf) {

  int CurrTime;


  char FileName[PATH_MAX];
  struct stat FStats;
  int UserCt;
  int MyUserId;
  int LastAd;
  char *Ptr;
  int AdIndex;
  int ComboDemog;
  int Weight;
  int Expire;
  /* Check to see if there's a new User.Personality file */
  sprintf(FileName, "%s/%s", gConstants.TopDir, USER_PERS_FILE);
  if (-1 == stat( FileName, &FStats) )
    return sprintf(Buf, "Error stating %s: %s", FileName, strerror(errno));
  if (FStats.st_mtime > gConstants.LastAdReadTime) {

    gConstants.LastAdReadTime = FStats.st_mtime;

    /* Ruth - put a critical section around this!!!! */
    /* Get User Personality data - but first malloc a structure to hold it*/
    UserCt = FStats.st_size / USER_PERS_RECLEN;
    if (0 == (gConstants.UDemog = 
	      (int *)realloc(gConstants.UDemog, UserCt * sizeof(int))))
      return sprintf(Buf, "Error re-allocing UDemog: %s", strerror(errno));
    if (-1 == ReadCustomData(FileName, 0, gConstants.UDemog, USER_PERS))
      return sprintf(Buf, "Error reading user pers. data: %s", strerror(errno));

#ifdef DEBUG
    DebugLog("FLen = %d, UserCt = %d, StructSize = %d\n",
	     FStats.st_size, UserCt, sizeof(*gConstants.UDemog));
#endif

    /* Get Custom Ad data */
    sprintf(FileName, "%s/%s", gConstants.TopDir, CUSTOM_AD_FILE);
    if (-1 == ReadCustomData(FileName, gConstants.Ads, 0, CUSTOM_AD)) {
      return sprintf(Buf, "Error in ReadCustomAds: %s", strerror(errno));
    }

  }

  
  /* Parse the incoming Cookie data */
  /* Format of input: user_id=<x>&last_ad=<y> */
  MyUserId = strtol(pContext->CookieStr + 8, &Ptr, 10) - 10000;
  LastAd = atol(Ptr + 9);

  /* Find the user profile */
  AdIndex = LastAd + 1;
  
  for (AdIndex = LastAd + 1; AdIndex != LastAd; AdIndex ++) {
    if (MAX_ADS <= AdIndex)
      AdIndex = 0;
    Weight = 0;
    ComboDemog = gConstants.UDemog[MyUserId] & gConstants.Ads[AdIndex].Dems;
    if (ComboDemog & GENDER_MASK) 
      Weight += gConstants.Ads[AdIndex].GenWt;
    if (ComboDemog & AGE_MASK) 
      Weight += gConstants.Ads[AdIndex].AgeWt;
    if (ComboDemog & REGION_MASK) 
      Weight += gConstants.Ads[AdIndex].RegWt;
    if (ComboDemog & INTEREST1_MASK) 
      Weight += gConstants.Ads[AdIndex].Int1Wt;
    if (ComboDemog & INTEREST2_MASK) 
      Weight += gConstants.Ads[AdIndex].Int2Wt;
      /*
#ifdef DEBUG
    DebugLog("%03d/%03d  UserD = %08x AdD = %08x ComboD = %08x",
	     MyUserId, AdIndex,
	     gConstants.UDemog[MyUserId], gConstants.Ads[AdIndex].Dems,
	     ComboDemog);
    DebugLog("   %02d:%02d:%02d:%02d:%02d Total=%3d Match=%3d\n",
	     gConstants.Ads[AdIndex].GenWt,
	     gConstants.Ads[AdIndex].AgeWt,
	     gConstants.Ads[AdIndex].RegWt,
	     gConstants.Ads[AdIndex].Int1Wt,
	     gConstants.Ads[AdIndex].Int2Wt,
	     Weight, gConstants.Ads[AdIndex].MinimumMatchWeight);
#endif
*/      
    if (Weight >= gConstants.Ads[AdIndex].MinimumMatchWeight)
      break;
  }

  CurrTime = time(NULL); 
  if (CurrTime > gConstants.Ads[AdIndex].Expire)
	Expire = 1;
  else
	Expire = 0;
    
#ifdef DEBUG
  DebugLog("Cookie in = %s\n", pContext->CookieStr);
#endif

  /* Place the found ad information in the Cookie_Str and also
     make a replacement filename out of information in the AdIndex */
  sprintf(pContext->CookieStr, "found_cookie=Ad_id=%d&Ad_weight=%d&Expired=%d\r\n\r\n",
	  AdIndex,Weight,Expire);
  sprintf(pContext->CadStr, "/file_set/dir%05d/class%d_%d", 
	  AdIndex / 36, ((AdIndex % 36) / 9), AdIndex % 9);


#ifdef DEBUG
  DebugLog("Cookie out = %s\n", pContext->CookieStr);
#endif
  return 0;
}

#ifdef DEBUG
/* 
 * FUNCTION:	void DebugLog (char *Format, ...) 
 *
 * PURPOSE:	Writes debug records to a log file
 *
 * ARGUMENTS:	same as printf
 *
 * RETURNS:	None.
 *
 * COMMENTS:	Log file name is <top_dir>/weblog_<pid>
 *
 */

void
DebugLog (char *Format, ...) {

  va_list VarArgs;


  if (LogFd == 0 ) {
    char FileName[256];
    sprintf(FileName, "%s/weblog_%d", DEFAULT_TOP_DIR, getpid());
    LogFd = fopen(FileName, "w");
  }


  /* Expand the format string and arg uments */
  if( NULL != Format ) {
    va_start( VarArgs , Format);
#ifdef _WIN32
    EnterCriticalSection( &debugLogCriticalSection );
#endif
    vfprintf( LogFd, Format, VarArgs );
    va_end( VarArgs );
    fflush(LogFd);
#ifdef _WIN32
    LeaveCriticalSection( &debugLogCriticalSection );
#endif
  }

  
}

#endif

/* 
 * FUNCTION:	int DoPost( spec_data_t *pContext, char *Buf)
int DoPost( spec_data_t *pContext, char *Buf);
 *
 * PURPOSE:	Implement dynamic POST.  Parses the input data, fetches
 *		the file requested, into the buffer then writes the logfile.
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		char       *Buf         Buffer for strings to return to client
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	None.
 *		
 */

int
DoPost( spec_data_t *pContext, char *Buf) {

  char UrlRoot[PATH_MAX];
  post_struct_t PostData;
  int Error = 0;
  char *pChar, *pCmd, *Ptr;
  int done;



  pChar = pCmd = pContext->Inbuf;
  Error = 5;
  done = 0;


  /* Parse the incoming Cookie data to get my_cookie   */
  /* value (user_id) to return with Set-cookie         */
  /* Format of input: user_id=<x>&last_ad=<y>          */
  PostData.Cookie = strtol(pContext->CookieStr + 8, &Ptr, 10);

  memcpy(pContext->CookieStr, "my_cookie=", 10);
  Ptr  = pContext->CookieStr + 10;
  Ptr += MyItoaPos(PostData.Cookie, Ptr, 10);  
  memcpy(Ptr, "\r\n\r\n\0", 5);
  
  
#ifdef DEBUG
  DebugLog("Forming PostData.Cookie: CookieStr = %s, Cookie = %d\n",
	   pContext->CookieStr, PostData.Cookie);
#endif


  while( !done) {
    if ('&' == *pChar  || 0 == *pChar) {
      if (!strncmp(pCmd, "urlroot=", 8)) {      
	strncpy(UrlRoot, pCmd+8, pChar - (pCmd+8));
	UrlRoot[pChar - (pCmd+8)] = '\0';
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "dir=", 4)) {
	PostData.Dir = atoi(pCmd + 4);
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "class=", 6)) {
	PostData.Class = atoi(pCmd + 6);
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "num=", 4)) {
	PostData.Num = atoi(pCmd + 4);
	pCmd = pChar + 1;
	Error--;
      }
      else if (!strncmp(pCmd, "client=", 7)) {
	PostData.Client = atoi(pCmd + 7);
	pCmd = pChar + 1;
	Error--;
      }
    }
    if (0 == *pChar) 
      done = 1;
    else
      pChar++;
  }
  if (Error) {
    pContext->BufCurLen += 
      sprintf (Buf, "Incorrect POST Input: '%s', UrlRoot = %s,dir='%d',"
	       " class='%d', num='%d', client='%d', #input=%d\n",
	       pContext->Inbuf, UrlRoot, PostData.Dir, PostData.Class, 
	       PostData.Num, 
	       PostData.Client, Error);
    return -1;
  }
  
  sprintf(pContext->FileName, "%s%sdir%05d/class%d_%d", gConstants.TopDir, 
	  UrlRoot, PostData.Dir,
	  PostData.Class, PostData.Num);
  
  
  if (WriteLog(pContext, &PostData, pContext->FileName) == -1) {
    pContext->BufCurLen += 
      sprintf(Buf, "Error writing log file '%s': %s\n", 
	      gConstants.LogFile, strerror(errno));
    return -1;
  }

  return 0;
}


/* 
 * FUNCTION:	int DoReset(spec_data_t *pContext, char *Buf)
 *
 * PURPOSE:	Resets the post log to 0 records.  If no post.log exists
 *		creates a new one.
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		char       *Buf         Buffer for strings to return to client
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	If everthing works, nothing is ever written to Buf.  It
 *		is only there for returning error strings.
 */

int
DoReset( char *ResetString, spec_data_t *pContext, char *Buf) {
  /* Reset will truncate the file, we unlink and then open a new file with a
     count of 0.  */
  FILE *Fd;
  char ProgramPath[PATH_MAX];
  char *pStr;
  char *MaxLoadStr = NULL;
  char *PtTimeStr = NULL;
  char *ThreadStr = NULL;
  char *ExpiredStr  = NULL;
  char *ExpiredStr2 = NULL;
  char *RootStr = NULL;
  char *Arg[10];
  int ArgCnt;
  int len = 0;
  int retval;
  int i;

  /* The cookie code checks mod-time from stat to figure out if a new
     file has been created.  This only has 1-second granularity, so if multiple
     resets happen in a second, the mtime looks identical -- with this sleep,
     that never happens */
  sleep(1);


  /* Place each ampersand separated argument into the Arg list */
  Arg[0] = ResetString;
  for (ArgCnt = 0, pStr = ResetString; *pStr != '\0'; pStr++) {
    if ('&' == *pStr) {
      *pStr = '\0';
      ArgCnt++;
      Arg[ArgCnt] = pStr + 1;
    } 
    else if ( ',' == *pStr) {
      *pStr = '\0';
      ArgCnt++;
      Arg[ArgCnt] = pStr + 1;
    }
  }
    
  /* Now find all the strings we expect and make sure they're all present */
  for (i = 0; i <= ArgCnt; i++) {
    if ( 0 != strstr(Arg[i], "maxload=")) {
      MaxLoadStr = Arg[i] + strlen("maxload=");
    }
    else if ( 0 != strstr(Arg[i], "pttime="))
      PtTimeStr = Arg[i] + strlen("pttime=");
    else if ( 0 != strstr(Arg[i], "maxthread="))
      ThreadStr = Arg[i] + strlen("maxthread=");
    else if ( 0 != strstr(Arg[i], "exp=")) {
      ExpiredStr = Arg[i] + strlen("exp=");
      ExpiredStr2 = Arg[i+1];
    }
    else if ( 0 != strstr(Arg[i], "urlroot=")) {
      /* Skip the '//servername/' part */
      RootStr = strstr(Arg[i], "//") + 2;
      RootStr = strchr(RootStr, '/') + 1;
    }
  }
  if (!PtTimeStr || !MaxLoadStr || !ThreadStr || !ExpiredStr || !RootStr) 
    return sprintf(Buf,
		   "Missing an arg: Found maxload=%s pttime=%s maxthread=%s exp=%s,%s, urlroot=%s",
		   MaxLoadStr, PtTimeStr, ThreadStr, ExpiredStr, 
		   ExpiredStr2, RootStr);


  /* Run program to make user personality file */
  sprintf(ProgramPath, "%s/%s", gConstants.TopDir, USER_PERS_CREATE);
  if (-1 == (retval = 
	     RunProgram(ProgramPath, USER_PERS_CREATE, "-C", gConstants.TopDir, 
			"-n", MaxLoadStr, "-t", ThreadStr, NULL)))
    return sprintf(Buf, "Error running %s - Error %d: %s\n",
		   ProgramPath, errno, strerror(errno));

  len += sprintf(&Buf[len], "%s returned with value %d\n", USER_PERS_CREATE,
		 retval);
 

  /* Run program to make custom ad file */
  sprintf(ProgramPath, "%s/%s", gConstants.TopDir, CUSTOM_AD_CREATE);


  if (-1 == (retval = RunProgram(ProgramPath, CUSTOM_AD_CREATE, "-C",
				 gConstants.TopDir, "-e", PtTimeStr, "-t", 
				 ThreadStr, ExpiredStr, ExpiredStr2, NULL)))
    return sprintf(Buf, "Error running %s - Error %d: %s\n",
		   ProgramPath, errno, strerror(errno));

  len += sprintf(&Buf[len], "%s returned with value %d\n", CUSTOM_AD_CREATE,
		 retval);

  unlink(gConstants.LogFile);

  if ((Fd = fopen(gConstants.LogFile, "w"))) {
    fprintf(Fd, "%10d\n", 0);
    fclose(Fd);
    /*    return 0; */
    len += sprintf(&Buf[len], "Post Log (%s) was reset\n", 
		   gConstants.LogFile);

  }
  else {
    return sprintf(Buf, "Error creating log file %s: %s\n",gConstants.LogFile,
		   strerror(errno));
    
  }

  return(len + sprintf(&Buf[len], "Reset was successful"));
    
}

/* 
 * FUNCTION:	int CustomAdTextReplace(char *Name, char *FileLoc, char *Text)
 *
 * PURPOSE:	Scans the Text buffer for WEB99CAD tags, and replaces the
 *		placeholders with real file names based on the 
 * ARGUMENTS:	char       *ReplacementStr
 *					The filename we insert when a tag
 *					is found
 *		char	   *Text        Pointer to text buffer to search
 * RETURNS:	0 on success, -1 on error
 *
 * COMMENTS:	Name should be preloaded with the path to the file_set.
 *              The filenames inside the tag specify file_set and further.
 *		
 */


int 
CustomAdTextReplace(char *ReplacementStr, char *Text) {

  char *pInc;

  pInc = Text;
  /* Scan through for the tag indicating replacement */
  while (NULL != (pInc = strstr(pInc, CAD_SCAN_STR))) {
    pInc += CAD_REPLACE_LOC;
    memcpy(pInc, ReplacementStr, strlen(ReplacementStr) );
  }
  return 0;
}

int
ReadCustomData( char *Path, ad_struct_t *AdPtr, int *UserDems, int DataType) {

  FILE *Fd;
  char Record[64];
  
  int RecCt;

  int Id;
  int Dem;
  int AdWt;
  int AdMatch;
  int Expiration;

  if (NULL == (Fd = fopen(Path, "r"))) {
    return -1;
  }

#ifdef DEBUG
  DebugLog("Reading %s file into memory\n", Path);
#endif

  RecCt = 0;
  while (0 != fgets(Record, 64, Fd) ) {
    switch (DataType) {
    case CUSTOM_AD:
      sscanf(Record, "%d %x %x %d %d", &Id, &Dem, &AdWt, &AdMatch, 
	     &Expiration);
      if (Id != RecCt) 
	return -1;
      AdPtr[Id].Dems = Dem;
      AdPtr[Id].GenWt  = (0x000f0000 & AdWt) >> 16;
      AdPtr[Id].AgeWt  = (0x0000f000 & AdWt) >> 12;
      AdPtr[Id].RegWt  = (0x00000f00 & AdWt) >> 8;
      AdPtr[Id].Int1Wt = (0x000000f0 & AdWt) >> 4;
      AdPtr[Id].Int2Wt = 0x0000000f & AdWt;
      AdPtr[Id].Expire = Expiration;
      AdPtr[Id].MinimumMatchWeight = AdMatch;
      break;
    case USER_PERS:
      sscanf(Record, "%d %x", &Id, &Dem);
      if (Id != RecCt)
	return -1;
      UserDems[Id] = Dem;
      break;
    }
    RecCt++;
  }
  fclose(Fd);
return 0;
}
    

/* 
 * FUNCTION:	int ReadFileIntoBuffer(char *FileNMame, char *Buf, 
 *			               int BufSize)
 *
 * PURPOSE:	Reads a file into the provided buffer.
 *
 * ARGUMENTS:	char	   *FileName    Name of file to get
 *		char       *Buf         Buffer for strings to return to client
 *		int	   BufSize      Size of input buffer
 *
 * RETURNS:	Number of bytes written to buffer
 *
 * COMMENTS:	If the file is too big for the buffer an error is returned.
 *		
 */
int 
ReadFileIntoBuffer(char *FileName, char *Buf, int BufSize) {

  int Desc;
  int Len = 0;
  struct stat Stat;
  int ReadLen;

  if ( (Desc = open(FileName, O_RDONLY, NULL)) == -1)
    return sprintf(Buf, "Error opening file '%s': %s", FileName, 
		   strerror(errno));


  fstat (Desc, &Stat);

  if (Stat.st_size > BufSize)
    Len = sprintf(Buf, "File %s is too long for buffer\n", FileName);
  else {
    while (Len < Stat.st_size) {
      /* Loop on read until the whole file is in the Buffer */
      ReadLen = read (Desc, (void *) &Buf[Len], BufSize);
      if (ReadLen > 0) {
	Len += ReadLen;
	continue;
      }
      else if (ReadLen < 0 ) {
	/* On read error, get out of the loop */
	Len = sprintf(Buf, "Error reading file '%s': %s", FileName,
		      strerror(errno));
	break;
      }
      else {
	/* Also exit on zero-length read, although this is impossible,
	   I think */
	Len = sprintf(Buf, "Unexpected EOF reading file %s",FileName );
	break;
      }
    }
  }
  close(Desc);
  Buf[Len] = '\0';
  return Len;
  
}

/* 
 * FUNCTION:	int RunProgram(char *Path, ...)
 *
 * PURPOSE:     Runs the specified program in a forked process. 
 *		Returns to the caller only after the other program finishes.
 *
 * ARGUMENTS:	char       *Path        Path of the program to run
 *		...			The same arguments that execv expects
 *
 * RETURNS:	0 if all goes well, -1 if it doesn't
 *
 * COMMENTS:	Zeus processes ignore (SIG_IGN) the signal SIGCHLD,
 *		so we turn it on momentarily to wait for the child
 *		to finish .
 *		
 */

#ifdef _WIN32
int 
RunProgram (char *Path, ...){
  va_list ap;
  char Command[1024], *ptr;
  int argno=0;


  strcpy(Command, Path);

  va_start(ap, Path);
  

  /* Skip the 1st vararg, since the program name
     is already in the path */
  va_arg(ap, char *);

  while ( (ptr = va_arg(ap, char *)) != (char *) 0) {
    strcat(Command, " ");
    strcat (Command, ptr);
  }

  va_end(ap);
  return system(Command);
}

#else
int
RunProgram(char *Path, ...){
  va_list ap;
  char *Args[100];
  int argno = 0;
  int Status;
  int ChildPid;

  
  char Buf[400];

  if ( -1 == (ChildPid = fork())) {
    return -1;
  }

  if (0 == ChildPid) {
    int Ret;
    va_start(ap, Path);
    while ((Args[argno++] = va_arg(ap, char *)) != (char *) 0)
      ;
    va_end(ap);
    Ret = execv(Path, Args);

    /* If the execv works this return shouldn't get executed */
    return Ret;
  }
  else {
    int Ret;
    
    struct sigaction NewSa;
    struct sigaction OldSa;

    NewSa.sa_handler = SIG_DFL;
    NewSa.sa_mask = 0;
    NewSa.sa_flags = SA_RESETHAND;

    /* Need to enable SIGCHLD for this to work */
    sigaction(SIGCHLD, &NewSa, &OldSa);
    Ret = waitpid( ChildPid, &Status, 0);
    sigaction(SIGCHLD, &OldSa, &NewSa);

    if (Ret == -1) 
      return Ret;
    else
      return 0;
  }
}

#endif  

/* 
 * FUNCTION:	int WriteLog(spec_data_t *pContext, post_struct_t *pPost,
 *			     int *File)
 *
 * PURPOSE:	Assembles the post data into a string and writes it to the
 *		end of the post log.  Increments the record count at the
 *		top of the log.
 *		
 *		
 *
 * ARGUMENTS:	spec_data_t *pContext	Context structure
 *		post_struct_t *pPost    Sturcture with parsed POST input
 *              char       *File	File accessed
 *
 * RETURNS:	Number of bytes written to post log (not including record count)
 *		or -1 if the write had an error
 *     
 *
 * COMMENTS:	The post log is locked during the file operations in order
 *		to keep the log consistent.
 *		
 */
int
WriteLog (spec_data_t *pContext, post_struct_t *pPost, char *File) {
  int Len;
  int Time;
  int Desc;
  char Tmp[PATH_MAX];
  char Count[11];

  if ((Desc = open (gConstants.LogFile, O_RDWR)) == -1) 
    return -1;

  Time = time(NULL);

#ifdef _WIN32
  EnterCriticalSection (&postLogCriticalSection);
#else
  flock(Desc, LOCK_EX);
#endif

  /* Read the current count and increment it */
  read( Desc, (void *) Tmp, 10);
  Tmp[10] = '\0';
  sprintf(Count, "%10d", atoi(Tmp) + 1);
  lseek( Desc, 0, SEEK_SET);
  write( Desc, Count, 10);

  /* Go to the end of file, and add a POST record */
  lseek (Desc, 0, SEEK_END);
  Len = sprintf(Tmp, "%10d %10d %10d %5d %2d %2d %10d %-60.60s %10d %10d\n",
	  atoi(Count),  Time, gConstants.Pid, pPost->Dir, pPost->Class, 
	  pPost->Num, pPost->Client, File, gConstants.Pid, pPost->Cookie);
  Len = write(Desc, Tmp, Len);

#ifdef _WIN32
  LeaveCriticalSection (&postLogCriticalSection);
#else
  flock(Desc, LOCK_UN);
#endif

  close(Desc);
  return Len;

}

/*
  Convert an int to an ASCII string, returning the string length
*/

int MyItoaPos( int val, char *buf, int radix) {

  char *p;                /* pointer to traverse string */
  char *firstdig;         /* pointer to first digit */
  char temp;              /* temp char */
  unsigned digval;        /* value of digit */
  int len;
  
  p = buf;
  
  firstdig = p;           /* save pointer to first digit */
  
  do {
    digval = (unsigned) (val % radix);
    val /= radix;       /* get next digit */
    
    /* convert to ascii and store */
    if (digval > 9)
      *p++ = (char) (digval - 10 + 'a');  /* a letter */
    else
      *p++ = (char) (digval + '0');       /* a digit */
  } while (val > 0);
  
  /* We now have the digit of the number in the buffer, but in reverse
     order.  Thus we reverse them now. */
  
  len = p - firstdig;


  *p-- = '\0';            /* terminate string; p points to last digit */
  


  do {
    temp = *p;
    *p = *firstdig;
    *firstdig = temp;   /* swap *p and *firstdig */
    --p;
    ++firstdig;         /* advance to next two digits */
  } while (firstdig < p); /* repeat until halfway */

  return len;
}


int
set_nonblock_flag(int desc, int value) {
  int oldflags = fcntl (desc, F_GETFL, 0);
  if (oldflags == -1) 
    return -1;
  if (value !=  0)
    oldflags |= O_NONBLOCK;
  else
    oldflags &= ~O_NONBLOCK;
  return fcntl(desc, F_SETFL, oldflags);
}
