/*****************************************************************************
 *                                                                           *
 * COPYRIGHT (c) INTERNATIONAL BUSINESS MACHINES CORPORARTION, 2000          *
 * ALL RIGHTS RESERVED.                                                      *
 *                                                                           *
 * UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS                      *
 * OF THE UNITED STATES.                                                     *
 *                                                                           *
 * Permission to use, copy, modify, and  distribute this software  for any   *
 * purpose with or without fee is hereby granted, provided  that the above   *
 * copyright notice and  this permission notice  appear in all copies, and   *
 * that the name of IBM not be used in advertising or publicity pertaining   *
 * to  distribution of  the document or  software without specific, written  *
 * prior permission.                                                         *
 *                                                                           *
 * DISCLAIMER OF WARRANTY AND LIMITATION OF LIABILITY                        *
 *                                                                           *
 * THE SOFTWARE  IS PROVIDED  "AS IS"  AND  IBM  CORPORATION.  DISCLAIMS ALL *
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES *
 * OF  MERCHANTABILITY  AND  FITNESS.  IN  NO EVENT  SHALL  IBM BE LIABLE    *
 * FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL  DAMAGES OR ANY       *
 * DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR PROFITS, WHETHER *
 * IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING   *
 * DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR PROFITS, WHETHER *
 * IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING   *
 * OUT  OF OR  IN CONNECTION WITH  THE USE OR PERFORMANCE OF THIS SOFTWARE   *
 *                                                                           *
 *****************************************************************************/

/*
 * COPYRIGHT (c) COMPAQ COMPUTER CORPORATION, 1998                           *
 * ALL RIGHTS RESERVED.                                                      *
 *                                                                           *
 * UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS                      *
 * OF THE UNITED STATES.                                                     *
 *                                                                           *
 * Permission to use, copy, modify, and  distribute this software  for any   *
 * purpose with or without fee is hereby granted, provided  that the above   *
 * copyright notice and  this permission notice  appear in all copies, and   *
 * that the name of Compaq Computer Corporation not be used in advertising   *
 * or publicity  pertaining to  distribution of  the document or  software   *
 * without specific, written prior permission.                               *
 *                                                                           *
 * DISCLAIMER OF WARRANTY AND LIMITATION OF LIABILITY                        *
 *                                                                           *
 * THE SOFTWARE  IS PROVIDED "AS IS" AND COMPAQ COMPUTER CORP. DISCLAIMS ALL *
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES *
 * OF  MERCHANTABILITY  AND  FITNESS.  IN  NO EVENT  SHALL  COMPAQ  COMPUTER *
 * CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL *
 * DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING  FROM LOSS OF USE,  DATA OR *
 * PROFITS, WHETHER  IN AN ACTION OF CONTRACT,  NEGLIGENCE OR OTHER TORTIOUS *
 * ACTION, ARISING OUT  OF OR  IN CONNECTION WITH  THE USE OR PERFORMANCE OF *
 * THIS SOFTWARE.                                                            *
 *                                                                           *
 *****************************************************************************/

/*

Revision history:

09/2000 Ported to Tru64 UNIX and support added for multiple runners. 
	By: P.G. Smith




/*

    CGI in C for straight DYNAMIC GET for SPECweb99:

    In rc file set:

DYN_GET_SCRIPT=http://les385/specweb99/cgi-bin/dyn_get_script.cgi?/specweb99

    Example Request issued by Client:

GET
/specweb99/cgi-bin/dyn_get_script.cgi?/specweb99/file_set/dir00000/class0_0

*/

#include "fcgi_stdio.h"

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <time.h>

#include <sys/wait.h>
pid_t pid;
int status;

extern void specweb99_cgi_get();
int pipefd_stdout[2];


#define BUFLEN 128*1024*10

void DoOutput(char *Buf, int Len);
int ReadFile(char *FileName, char *Buf, int BufSize);

main () {
  char Buffer[BUFLEN];
  FILE *fp;


  int FCGI_fd;
  int count, fd, i, fcgi_count;
  int read_length;
  char Fcgi_fname[256];
  char Fcgi_instances[8];

  char *cwd = getcwd(NULL, 256);
  sprintf(Fcgi_fname, "%s/FCGI_Instances", cwd);
  if (-1 != (FCGI_fd = open (Fcgi_fname, O_RDONLY, 0))) {
        i = read (FCGI_fd, Fcgi_instances, sizeof(Fcgi_instances)-1);
        close (FCGI_fd);
        Fcgi_instances[i] = '\0';
        fcgi_count = atoi(Fcgi_instances);
  }
  else {
	exit(1);
  }
  
  if ( fcgi_count > 0) {
    for(i = 1; i < fcgi_count; i++) {
        if (fork() == 0) break;
    }
  }

  /* close all file descriptors but stdin, stdout, and stderr */
  count = 1;
  for( fd=3 ; fd<FOPEN_MAX ; fd++ ) {
        if( close(fd) >= 0 ) {
        count++;
        }
  }

  i = 0;
  fcgi_count = 0;
    while(FCGI_Accept() >= 0) {
	if (pipe(pipefd_stdout) == -1) {
	    perror("pipe");
	    fprintf(stderr, "Error!  Can't pipe() pipefd_stdout\n");
	    exit(1);
	}

	if ((pid = fork()) == -1) {
	    perror("fork");
	    exit(1);
	} else if (pid == 0) {	/* child */
	char args[8];
	    close(pipefd_stdout[0]);

	    /* redirect stdout (fd1) and strerr (fd2) */
	    dup2(pipefd_stdout[1], 1);
	    dup2(pipefd_stdout[1], 2);

	    specweb99_cgi_get();

	    exit(0);

	} else {	/* parent */ /* one cgi request at a time if wait */

	    close(pipefd_stdout[1]); 

	    read_length = 0;
	    while (1) {
		count = read(pipefd_stdout[0], &Buffer[read_length], 16384);
		if (count <= 0) break;
		read_length += count;
	    } 
	    close(pipefd_stdout[0]); 

	    /* forward it to web server */
	    fwrite(Buffer, sizeof(char), read_length, stdout);
	    /*write(fileno(stdout), Buffer, read_length);*/

	    waitpid(pid, &status, 0);
	}
    }
}


