-- This CLP file was created using DB2LOOK Version "9.7" 
-- Timestamp: Fri 04 Jun 2010 12:25:28 AM CDT
-- Database Name: SPECDB         
-- Database Manager Version: DB2/LINUXX8664 Version 9.7.1  
-- Database Codepage: 1208
-- Database Collating Sequence is: IDENTITY


CONNECT TO SPECDB;



------------------------------------------------
-- DDL Statements for table "DB2INST1"."M_BOM"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_BOM"  (
		  "B_COMP_ID" CHAR(20) NOT NULL , 
		  "B_ASSEMBLY_ID" CHAR(20) NOT NULL , 
		  "B_LINE_NO" INTEGER , 
		  "B_QTY" INTEGER , 
		  "B_OPS" INTEGER , 
		  "B_ENG_CHANGE" CHAR(10) , 
		  "B_OPS_DESC" VARCHAR(100) , 
		  "B_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."M_BOM"

CREATE UNIQUE INDEX "DB2INST1"."M_BOM_IDX" ON "DB2INST1"."M_BOM" 
		("B_ASSEMBLY_ID" ASC,
		 "B_COMP_ID" ASC,
		 "B_LINE_NO" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."M_WORKORDER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_WORKORDER"  (
		  "WO_NUMBER" INTEGER NOT NULL , 
		  "WO_LOCATION" INTEGER NOT NULL , 
		  "WO_O_ID" INTEGER , 
		  "WO_OL_ID" INTEGER , 
		  "WO_STATUS" INTEGER , 
		  "WO_ASSEMBLY_ID" CHAR(20) , 
		  "WO_ORIG_QTY" INTEGER , 
		  "WO_COMP_QTY" INTEGER , 
		  "WO_DUE_DATE" TIMESTAMP , 
		  "WO_START_DATE" TIMESTAMP , 
		  "WO_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."M_WORKORDER"

CREATE UNIQUE INDEX "DB2INST1"."M_WO_IDX" ON "DB2INST1"."M_WORKORDER" 
		("WO_LOCATION" ASC,
		 "WO_NUMBER" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST1"."M_WORKORDER"

CREATE INDEX "DB2INST1"."M_WO_OOL_IDX" ON "DB2INST1"."M_WORKORDER" 
		("WO_LOCATION" ASC,
		 "WO_O_ID" ASC,
		 "WO_OL_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."O_CUSTINVENTORY"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_CUSTINVENTORY"  (
		  "CI_ID" INTEGER NOT NULL , 
		  "CI_CUSTOMERID" INTEGER NOT NULL , 
		  "CI_ITEMID" CHAR(20) , 
		  "CI_QUANTITY" INTEGER , 
		  "CI_VALUE" DECIMAL(12,2) , 
		  "CI_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 








-- DDL Statements for indexes on Table "DB2INST1"."O_CUSTINVENTORY"

CREATE UNIQUE INDEX "DB2INST1"."O_CI_IDX" ON "DB2INST1"."O_CUSTINVENTORY" 
		("CI_CUSTOMERID" ASC,
		 "CI_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."O_CUSTOMER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_CUSTOMER"  (
		  "C_ID" INTEGER NOT NULL , 
		  "C_FIRST" CHAR(16) , 
		  "C_LAST" CHAR(16) , 
		  "C_STREET1" CHAR(20) , 
		  "C_STREET2" CHAR(20) , 
		  "C_CITY" CHAR(20) , 
		  "C_STATE" CHAR(2) , 
		  "C_COUNTRY" CHAR(10) , 
		  "C_ZIP" CHAR(9) , 
		  "C_PHONE" CHAR(16) , 
		  "C_CONTACT" CHAR(25) , 
		  "C_SINCE" DATE , 
		  "C_BALANCE" DECIMAL(12,2) , 
		  "C_CREDIT" CHAR(2) , 
		  "C_CREDIT_LIMIT" DECIMAL(12,2) , 
		  "C_YTD_PAYMENT" DECIMAL(12,2) , 
		  "C_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."O_CUSTOMER"

CREATE UNIQUE INDEX "DB2INST1"."O_C_IDX" ON "DB2INST1"."O_CUSTOMER" 
		("C_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."O_ORDERS"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_ORDERS"  (
		  "O_ID" INTEGER NOT NULL , 
		  "O_C_ID" INTEGER , 
		  "O_OL_CNT" INTEGER , 
		  "O_DISCOUNT" DECIMAL(4,2) , 
		  "O_TOTAL" DECIMAL(12,2) , 
		  "O_STATUS" INTEGER , 
		  "O_ENTRY_DATE" TIMESTAMP , 
		  "O_SHIP_DATE" DATE , 
		  "O_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 








-- DDL Statements for indexes on Table "DB2INST1"."O_ORDERS"

CREATE INDEX "DB2INST1"."O_OC_IDX" ON "DB2INST1"."O_ORDERS" 
		("O_C_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST1"."O_ORDERS"

CREATE UNIQUE INDEX "DB2INST1"."O_ORDS_IDX" ON "DB2INST1"."O_ORDERS" 
		("O_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."O_ORDERLINE"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_ORDERLINE"  (
		  "OL_ID" INTEGER NOT NULL , 
		  "OL_O_ID" INTEGER NOT NULL , 
		  "OL_I_ID" CHAR(20) , 
		  "OL_QTY" INTEGER , 
		  "OL_TOTAL_VALUE" DECIMAL(12,2) , 
		  "OL_MSRP" DECIMAL(12,2) , 
		  "OL_STATUS" INTEGER , 
		  "OL_SHIP_DATE" TIMESTAMP , 
		  "OL_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 








-- DDL Statements for indexes on Table "DB2INST1"."O_ORDERLINE"

CREATE UNIQUE INDEX "DB2INST1"."O_ORDL_IDX" ON "DB2INST1"."O_ORDERLINE" 
		("OL_O_ID" ASC,
		 "OL_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."O_ITEM"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."O_ITEM"  (
		  "I_ID" CHAR(20) NOT NULL , 
		  "I_NAME" CHAR(35) , 
		  "I_DESC" VARCHAR(100) , 
		  "I_PRICE" DECIMAL(12,2) , 
		  "I_DISCOUNT" DECIMAL(6,4) , 
		  "I_CATEGORY" INTEGER NOT NULL , 
		  "I_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."O_ITEM"

CREATE INDEX "DB2INST1"."O_ICAT_IDX" ON "DB2INST1"."O_ITEM" 
		("I_CATEGORY" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST1"."O_ITEM"

CREATE UNIQUE INDEX "DB2INST1"."O_I_IDX" ON "DB2INST1"."O_ITEM" 
		("I_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_COMPONENT"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_COMPONENT"  (
		  "COMP_ID" CHAR(20) NOT NULL , 
		  "COMP_SITE_ID" INTEGER NOT NULL , 
		  "COMP_NAME" CHAR(10) , 
		  "COMP_DESC" VARCHAR(100) , 
		  "COMP_UNIT" CHAR(10) , 
		  "COMP_COST" DECIMAL(12,2) , 
		  "QTY_ON_ORDER" INTEGER , 
		  "QTY_DEMANDED" INTEGER , 
		  "LEAD_TIME" INTEGER , 
		  "CONTAINER_SIZE" INTEGER , 
		  "COMP_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."S_COMPONENT"

CREATE UNIQUE INDEX "DB2INST1"."S_COMP_IDX" ON "DB2INST1"."S_COMPONENT" 
		("COMP_SITE_ID" ASC,
		 "COMP_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_SUPP_COMPONENT"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_SUPP_COMPONENT"  (
		  "SC_P_ID" CHAR(20) NOT NULL , 
		  "SC_SUPP_ID" INTEGER NOT NULL , 
		  "SC_PRICE" DECIMAL(12,2) , 
		  "SC_QTY" INTEGER , 
		  "SC_DISCOUNT" DECIMAL(6,4) , 
		  "SC_DEL_DATE" INTEGER , 
		  "SC_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."S_SUPP_COMPONENT"

CREATE UNIQUE INDEX "DB2INST1"."S_SC_IDX" ON "DB2INST1"."S_SUPP_COMPONENT" 
		("SC_P_ID" ASC,
		 "SC_SUPP_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_SUPPLIER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_SUPPLIER"  (
		  "SUPP_ID" INTEGER NOT NULL , 
		  "SUPP_NAME" CHAR(16) , 
		  "SUPP_STREET1" CHAR(20) , 
		  "SUPP_STREET2" CHAR(20) , 
		  "SUPP_CITY" CHAR(20) , 
		  "SUPP_STATE" CHAR(2) , 
		  "SUPP_COUNTRY" CHAR(10) , 
		  "SUPP_ZIP" CHAR(9) , 
		  "SUPP_PHONE" CHAR(16) , 
		  "SUPP_CONTACT" CHAR(25) , 
		  "SUPP_WS_URL" VARCHAR(128) , 
		  "SUPP_REPLY_URL" VARCHAR(128) , 
		  "SUPP_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."S_SUPPLIER"

CREATE UNIQUE INDEX "DB2INST1"."S_SUPP_IDX" ON "DB2INST1"."S_SUPPLIER" 
		("SUPP_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_PURCH_ORDER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_PURCH_ORDER"  (
		  "PO_NUMBER" INTEGER NOT NULL , 
		  "PO_SITE_ID" INTEGER NOT NULL , 
		  "PO_SUPP_ID" INTEGER , 
		  "PO_POPULAR_SUPP" INTEGER , 
		  "PO_START_DATE" TIMESTAMP , 
		  "PO_SENT_DATE" DATE , 
		  "PO_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."S_PURCH_ORDER"

CREATE INDEX "DB2INST1"."S_PODATE_IDX" ON "DB2INST1"."S_PURCH_ORDER" 
		("PO_SITE_ID" ASC,
		 "PO_START_DATE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;

-- DDL Statements for indexes on Table "DB2INST1"."S_PURCH_ORDER"

CREATE UNIQUE INDEX "DB2INST1"."S_PO_IDX" ON "DB2INST1"."S_PURCH_ORDER" 
		("PO_SITE_ID" ASC,
		 "PO_NUMBER" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_PURCH_ORDERLINE"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_PURCH_ORDERLINE"  (
		  "POL_NUMBER" INTEGER NOT NULL , 
		  "POL_PO_ID" INTEGER NOT NULL , 
		  "POL_LOCATION" INTEGER NOT NULL , 
		  "POL_P_ID" CHAR(20) , 
		  "POL_QTY" INTEGER , 
		  "POL_BALANCE" DECIMAL(12,2) , 
		  "POL_LEADTIME" INTEGER WITH DEFAULT 0 , 
		  "POL_DELDATE" DATE , 
		  "POL_MESSAGE" VARCHAR(100) , 
		  "POL_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."S_PURCH_ORDERLINE"

CREATE UNIQUE INDEX "DB2INST1"."S_POL_IDX" ON "DB2INST1"."S_PURCH_ORDERLINE" 
		("POL_LOCATION" ASC,
		 "POL_PO_ID" ASC,
		 "POL_NUMBER" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."S_RUN_CONFIG"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."S_RUN_CONFIG"  (
		  "NAME" VARCHAR(20) NOT NULL , 
		  "VALUE" INTEGER NOT NULL )   
		 IN "USERSPACE1" ; 





------------------------------------------------
-- DDL Statements for table "DB2INST1"."U_SEQUENCES"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_SEQUENCES"  (
		  "S_ID" VARCHAR(50) NOT NULL , 
		  "S_NEXTNUM" INTEGER )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."U_SEQUENCES"

CREATE UNIQUE INDEX "DB2INST1"."U_S_IDX" ON "DB2INST1"."U_SEQUENCES" 
		("S_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."U_DATASEGMENT"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_DATASEGMENT"  (
		  "DS_ID" VARCHAR(100) NOT NULL , 
		  "DS_BLOB" CLOB(1048576) LOGGED NOT COMPACT )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."U_DATASEGMENT"

CREATE UNIQUE INDEX "DB2INST1"."DS_ID_IDX" ON "DB2INST1"."U_DATASEGMENT" 
		("DS_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."U_LOADER"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_LOADER"  (
		  "L_TXRATE" INTEGER , 
		  "L_ITEMCOUNT" INTEGER , 
		  "L_ITEMS_PER_TXRATE" INTEGER , 
		  "L_DBIR" INTEGER , 
		  "L_PARALLELISM" INTEGER , 
		  "L_IS_FF" INTEGER , 
		  "L_FF_DIR" VARCHAR(1000) , 
		  "L_FF_DEL" VARCHAR(10) , 
		  "L_IS_STANDALONE" INTEGER , 
		  "L_DB_DRIVER_CLASS" VARCHAR(512) , 
		  "L_DB_URL" VARCHAR(512) , 
		  "L_DB_USER" VARCHAR(512) , 
		  "L_DB_PASSWORD" VARCHAR(512) , 
		  "L_ROOT_SEED" DECIMAL(19,0) , 
		  "L_STATUS" INTEGER , 
		  "L_STARTED_AT" TIMESTAMP , 
		  "L_ENDED_AT" TIMESTAMP , 
		  "L_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."U_LOADER"

CREATE UNIQUE INDEX "DB2INST1"."L_TX_IDX" ON "DB2INST1"."U_LOADER" 
		("L_TXRATE" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."U_LOAD_MESSAGE"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_LOAD_MESSAGE"  (
		  "LM_ID" INTEGER , 
		  "LM_TEXT" CLOB(1048576) LOGGED NOT COMPACT )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."U_LOAD_MESSAGE"

CREATE UNIQUE INDEX "DB2INST1"."LM_ID_IDX" ON "DB2INST1"."U_LOAD_MESSAGE" 
		("LM_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."U_LOAD_SECTION"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."U_LOAD_SECTION"  (
		  "LS_ID" INTEGER , 
		  "LS_DOMAIN" VARCHAR(50) , 
		  "LS_TABLENAMES" VARCHAR(200) , 
		  "LS_SECTION_ID" INTEGER , 
		  "LS_START_STEP" INTEGER , 
		  "LS_NUM_STEPS" INTEGER , 
		  "LS_STATE" INTEGER , 
		  "LS_VERSION" INTEGER WITH DEFAULT 0 )   
		 IN "USERSPACE1" ; 






-- DDL Statements for indexes on Table "DB2INST1"."U_LOAD_SECTION"

CREATE UNIQUE INDEX "DB2INST1"."LS_ID_IDX" ON "DB2INST1"."U_LOAD_SECTION" 
		("LS_ID" ASC)
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."M_INVENTORY"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_INVENTORY"  (
		  "IN_P_ID" CHAR(20) NOT NULL , 
		  "IN_QTY" INTEGER , 
		  "IN_ORDERED" INTEGER , 
		  "IN_LOCATION" INTEGER NOT NULL , 
		  "IN_ACC_CODE" INTEGER , 
		  "IN_ACT_DATE" TIMESTAMP , 
		  "IN_VERSION" INTEGER WITH DEFAULT 0 )   
		 PARTITION BY RANGE("IN_P_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0001100000') IN "USERSPACE1", 
		 PART "PART1" ENDING('00001ANTIA0001100000') IN "USERSPACE1", 
		 PART "PART2" ENDING('00001ATION0001100000') IN "USERSPACE1", 
		 PART "PART3" ENDING('00001BARAA0001100000') IN "USERSPACE1", 
		 PART "PART4" ENDING('00001CALLY0001100000') IN "USERSPACE1", 
		 PART "PART5" ENDING('00001EINGA0001100000') IN "USERSPACE1", 
		 PART "PART6" ENDING('00001ESEAA0001100000') IN "USERSPACE1", 
		 PART "PART7" ENDING('00001IRESE0001100000') IN "USERSPACE1", 
		 PART "PART8" ENDING('00001LINES0001100000') IN "USERSPACE1", 
		 PART "PART9" ENDING('00001MITEM0001100000') IN "USERSPACE1", 
		 PART "PART10" ENDING('00001NAILS0001100000') IN "USERSPACE1", 
		 PART "PART11" ENDING('00001OUGHT0001100000') IN "USERSPACE1", 
		 PART "PART12" ENDING('00001PRESA0001100000') IN "USERSPACE1", 
		 PART "PART13" ENDING('00001PRIAA0001100000') IN "USERSPACE1", 
		 PART "PART14" ENDING('00001QUIET0001100000') IN "USERSPACE1", 
		 PART "PART15" ENDING('00001SCREW0001100000') IN "USERSPACE1", 
		 PART "PART16" ENDING('00001SHARE0001100000') IN "USERSPACE1"); 






-- DDL Statements for indexes on Table "DB2INST1"."M_INVENTORY"

CREATE UNIQUE INDEX "DB2INST1"."M_INV_IDX" ON "DB2INST1"."M_INVENTORY" 
		("IN_LOCATION" ASC,
		 "IN_P_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;
------------------------------------------------
-- DDL Statements for table "DB2INST1"."M_PARTS"
------------------------------------------------
 

CREATE TABLE "DB2INST1"."M_PARTS"  (
		  "P_ID" CHAR(20) NOT NULL , 
		  "P_NAME" CHAR(35) , 
		  "P_DESC" VARCHAR(100) , 
		  "P_REV" CHAR(6) , 
		  "P_PLANNER" INTEGER , 
		  "P_TYPE" INTEGER , 
		  "P_IND" INTEGER , 
		  "P_LOMARK" INTEGER , 
		  "P_HIMARK" INTEGER , 
		  "P_VERSION" INTEGER WITH DEFAULT 0 )   
		 PARTITION BY RANGE("P_ID") 
		 (PART "PART0" STARTING('00001ABLEA0000000000') ENDING('00001ABLEA0001100000') IN "USERSPACE1", 
		 PART "PART1" ENDING('00001ANTIA0001100000') IN "USERSPACE1", 
		 PART "PART2" ENDING('00001ATION0001100000') IN "USERSPACE1", 
		 PART "PART3" ENDING('00001BARAA0001100000') IN "USERSPACE1", 
		 PART "PART4" ENDING('00001CALLY0001100000') IN "USERSPACE1", 
		 PART "PART5" ENDING('00001EINGA0001100000') IN "USERSPACE1", 
		 PART "PART6" ENDING('00001ESEAA0001100000') IN "USERSPACE1", 
		 PART "PART7" ENDING('00001IRESE0001100000') IN "USERSPACE1", 
		 PART "PART8" ENDING('00001LINES0001100000') IN "USERSPACE1", 
		 PART "PART9" ENDING('00001MITEM0001100000') IN "USERSPACE1", 
		 PART "PART10" ENDING('00001NAILS0001100000') IN "USERSPACE1", 
		 PART "PART11" ENDING('00001OUGHT0001100000') IN "USERSPACE1", 
		 PART "PART12" ENDING('00001PRESA0001100000') IN "USERSPACE1", 
		 PART "PART13" ENDING('00001PRIAA0001100000') IN "USERSPACE1", 
		 PART "PART14" ENDING('00001QUIET0001100000') IN "USERSPACE1", 
		 PART "PART15" ENDING('00001SCREW0001100000') IN "USERSPACE1", 
		 PART "PART16" ENDING('00001SHARE0001100000') IN "USERSPACE1"); 






-- DDL Statements for indexes on Table "DB2INST1"."M_PARTS"

CREATE UNIQUE INDEX "DB2INST1"."M_PARTS_IDX" ON "DB2INST1"."M_PARTS" 
		("P_ID" ASC)
		PARTITIONED
		
		COMPRESS NO ALLOW REVERSE SCANS;







COMMIT WORK;

CONNECT RESET;

TERMINATE;

