import com.borland.dx.util.*;
import com.borland.dx.sql.dataset.*;
import com.borland.datastore.*;
import com.borland.jb.io.*;
import java.sql.*;
import java.io.*;


public class CreateDb {
  public static void main(String[] args) {
    try
    {
      int blockSize = 2;
      String scale = "20";
      String databaseDir = "e:/specj2001db/";
      String databaseFileName = "specj2001";
//      System.setProperty("ecperf.home", "/ecp_u2_dev");


      FileUtil.makeSubDirs(databaseDir);
      com.borland.jb.io.FileUtil.deleteFiles(databaseDir, databaseFileName+"*");
      DataStore ds = new DataStore();
      ds.setFileName(databaseDir+databaseFileName);
      ds.setUserName("creator");


      ds.setBlockSize(blockSize);
      TxManager tx = new TxManager();
      tx.setLogBlockSize(4);
      tx.setMaxLogSize(TxManager.DEFAULT_LOG_SIZE*15);
      tx.setCheckFrequency(Integer.MAX_VALUE);
      tx.setALogDir("e:/specj2001db/");
//      tx.setSoftCommit(true);
      ds.setTxManager(tx);
      com.borland.jb.io.FileUtil.deleteFiles(tx.getALogDir(), databaseFileName+"*");

      ds.create();

      Class.forName("com.borland.datastore.jdbc.DataStoreDriver");
      Connection con = DriverManager.getConnection("jdbc:borland:dslocal:"+databaseDir+databaseFileName, "test", "test");
      Database db = new Database();
      db.setJdbcConnection(con);

      StatementTokenizer tokenizer = new StatementTokenizer();


      tokenizer = new StatementTokenizer();
      tokenizer.setDatabase(db);
      tokenizer.setSQLFileName("sql/schema_C.sql");
      tokenizer.executeStatements();

      tokenizer = new StatementTokenizer();
      tokenizer.setDatabase(db);
      tokenizer.setSQLFileName("sql/schema_M.sql");
      tokenizer.executeStatements();

      tokenizer = new StatementTokenizer();
      tokenizer.setDatabase(db);
      tokenizer.setSQLFileName("sql/schema_O.sql");
      tokenizer.executeStatements();

      tokenizer = new StatementTokenizer();
      tokenizer.setDatabase(db);
      tokenizer.setSQLFileName("sql/schema_S.sql");
      tokenizer.executeStatements();

      tokenizer = new StatementTokenizer();
      tokenizer.setDatabase(db);
      tokenizer.setSQLFileName("sql/schema_U.sql");
      tokenizer.executeStatements();

/*
      tokenizer = new StatementTokenizer();
      tokenizer.setDatabase(db);
      tokenizer.setSQLFileName("sql/indexes.sql");
      tokenizer.executeStatements();
*/

      db.commit();
      db.closeConnection();
      con.close();
      ds.close();

 /*
      com.sun.ecperf.load.LoadCorp.main(new String[] {scale});
      com.sun.ecperf.load.LoadOrds.main(new String[] {scale});
      com.sun.ecperf.load.LoadMfg.main(new String[] {scale});
      com.sun.ecperf.load.LoadSupp.main(new String[] {scale});
      com.sun.ecperf.load.LoadRules.main(new String[] {scale});
*/


      System.out.println();
      System.out.println();
      System.out.println("Database created in ---------->>> "+databaseDir+databaseFileName);
      System.out.println();
      System.out.println();
    }
    catch (Exception ex)
    {
      ex.printStackTrace();
    }
  }
}
