#!/bin/sh
#
# Script to create oracle database

# Configurable Parameters 
LOG1SZ="300000M"
LOG2SZ="300000M"
LOG3SZ="300000M"
TEMPSZ="100000M"
UNDOSZ="250000M"

if [ $# -ne 1 ]
then
        echo "Usage: createdb.sh <database dir>"
        exit 1
fi

if [ "$ORACLE_HOME" = "" ]
then
        echo "$ORACLE_HOME"
        echo "You must set the ORACLE_HOME environment variable"
        exit 1
fi

if [ "$ORACLE_SID" = "" ]
then
        echo "$ORACLE_SID"
        echo "You must set the ORACLE_SID environment variable"
        exit 1
fi

####################
# Set the database and database directory vars
#####################
DB=${ORACLE_SID}
DB_DIR=$1

####################################
# Check to see that the target database directory
# exists and has write permission.
####################################
if [ ! -d "$DB_DIR" ]
then
        echo "$DB_DIR does not exist. Please create it first."
        exit 1
fi


########################################################
# Go and run the create_init.sh script
# to build the correct pfiles and .ora files for Oracle 
########################################################
if [ ! -f "$ORACLE_HOME/dbs/init${DB}.ora" ]
then
        echo "$ORACLE_HOME/dbs/init${DB}.ora does not exist. Please create it first."
        exit 1
fi

SYS=${DB_DIR}/sys_${DB}
SYS_AUX=${DB_DIR}/sysaux_${DB}

LOG1=${DB_DIR}/log1_${DB}
LOG2=${DB_DIR}/log2_${DB}
LOG3=${DB_DIR}/log3_${DB}

TEMP=${DB_DIR}/temp_${DB}
UNDO=${DB_DIR}/undo_${DB}

# Create database
sqlplus <<EOT
CONNECT / as sysdba
shutdown;
startup nomount

CREATE DATABASE $DB
CONTROLFILE REUSE
LOGFILE GROUP 1 '${LOG1}' SIZE ${LOG1SZ} REUSE,
        GROUP 2 '${LOG2}' SIZE ${LOG2SZ} REUSE,
        GROUP 3 '${LOG3}' SIZE ${LOG3SZ} REUSE
MAXDATAFILES 200
DATAFILE '${SYS}' size 4000M REUSE
SYSAUX DATAFILE '${SYS_AUX}' size 8000M REUSE
BIGFILE DEFAULT TEMPORARY TABLESPACE temp_ts
    TEMPFILE '${TEMP}' SIZE ${TEMPSZ} REUSE
BIGFILE UNDO TABLESPACE undo_ts DATAFILE '${UNDO}'  SIZE ${UNDOSZ} REUSE
    BLOCKSIZE 8k;

exit
EOT


echo "Running catalog scripts ..."
sqlplus <<EOT
CONNECT / as sysdba
@?/rdbms/admin/catalog;
@?/rdbms/admin/catexp.sql
@?/rdbms/admin/catldr.sql
@?/rdbms/admin/catproc.sql
@?/rdbms/admin/catparr.sql
@?/rdbms/admin/utlmontr;
EXIT
EOT

echo "Catalog done."

sqlplus <<EOT
CONNECT / as sysdba
drop user $DB_USER;
CREATE USER $DB_USER IDENTIFIED BY $DB_PASS;
GRANT CONNECT, RESOURCE TO $DB_USER;
GRANT ALL PRIVILEGES TO $DB_USER IDENTIFIED BY $DB_PASS;

ALTER USER $DB_USER
        TEMPORARY TABLESPACE temp_ts;
EXIT
EOT

